/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.ui.enrol.demographics.StagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.AppointmentPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.BRNDetailsPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.PersonalDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.RelativeDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.ResidentPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.ILiteView;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class BasicDetailPanel
implements IViewElementComposite {
    protected IResourceBundleContext enrolRbctx;
    private ResidentPanel residentPanel;
    private BRNDetailsPanel brnDetailsPanel;
    private RelativeDetailPanel relativeDetailsPanel;
    private PersonalDetailPanel personalDetailPanel;
    private AppointmentPanel appointmentPanel;
    protected final ILiteView liteView;
    protected EnrollmentService enrollmentService;
    protected ShadowPanel basicPanel;
    protected IUIPreference uiPref;

    public BasicDetailPanel(IResourceBundleContext enrolRbctx, ILiteView liteView, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.liteView = liteView;
        this.uiPref = uiPref;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create(boolean isBrnReq, boolean isForeign, boolean isHof, boolean isDobReq) {
        this.appointmentPanel = new AppointmentPanel(this.enrolRbctx);
        this.residentPanel = new ResidentPanel(this.enrolRbctx);
        this.personalDetailPanel = new PersonalDetailPanel(this.enrolRbctx, this.uiPref, this.enrollmentService);
        this.brnDetailsPanel = new BRNDetailsPanel(this.enrolRbctx);
        this.relativeDetailsPanel = new RelativeDetailPanel(this.enrolRbctx, this.uiPref, this.enrollmentService);
        this.basicPanel = new ShadowPanel();
        this.basicPanel.setDemographicStage(StagesUC.BASIC_DETAILS);
        this.basicPanel.setBackground(Color.WHITE);
        this.basicPanel.setLayout(new BoxLayout(this.basicPanel, 1));
        this.basicPanel.add(this.appointmentPanel.createNew());
        if (isForeign) {
            this.basicPanel.add(this.residentPanel.createNew());
        }
        if (isBrnReq) {
            this.basicPanel.add(this.brnDetailsPanel.createNew());
            boolean enableBrn = this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isForeignResident();
            this.brnDetailsPanel.setEnabled(enableBrn);
            this.brnDetailsPanel.setMandatory(enableBrn);
        }
        if (isHof) {
            this.basicPanel.add(this.relativeDetailsPanel.createNew());
        }
        if (this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isUpdateUC() && this.enrollmentService.isAadhaarActive() && FieldInfoUtils.isDemographicTabRequired()) {
            this.basicPanel.add(this.personalDetailPanel.createNew(isForeign, isDobReq));
        }
        this.basicPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BasicDetailPanel.this.basicPanel.requestFocusInWindow();
            }
        });
        return this.basicPanel;
    }

    public ResidentPanel getResidentPanel() {
        return this.residentPanel;
    }

    public BRNDetailsPanel getBrnDetailsPanel() {
        return this.brnDetailsPanel;
    }

    public RelativeDetailPanel getRelativeDetailsPanel() {
        return this.relativeDetailsPanel;
    }

    public PersonalDetailPanel getPersonalDetailPanel() {
        return this.personalDetailPanel;
    }

    public AppointmentPanel getAppointmentPanel() {
        return this.appointmentPanel;
    }

    public JComponent getTab() {
        return this.basicPanel;
    }
}

