/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.BasicDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.DemoSections;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.ContactDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.disclosure.DisclosurePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.ForeignPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class DemographicsPanel
implements IViewElementComposite {
    protected DemoSections demoSections;
    protected IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="hID_Foreign_TabPane", using=StandardSwingElementFactory.class)
    protected JTabbedPane tabbedPane;
    protected final ILiteView liteView;
    protected EnrollmentService enrollmentService;
    protected IEventContext evtCtxt;
    protected IUIPreference uiPref;
    protected BasicDetailPanel basicDetailPanel;
    protected ContactDetailPanel contactDetailPanel;
    protected ForeignPanel foreignPanel;
    protected DisclosurePanel disclosurePanel;

    public DemographicsPanel(IResourceBundleContext enrolRbctx, ILiteView liteView, IEventContext eventContext, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.enrollmentService = enrollmentService;
        this.evtCtxt = eventContext;
        this.uiPref = uiPref;
        this.liteView = liteView;
    }

    public JComponent create() {
        JPanel demoPanel = new JPanel();
        this.demoSections = new DemoSections(this.enrolRbctx, this.enrollmentService);
        this.tabbedPane = new JTabbedPane();
        this.initialiseTab();
        this.basicDetailPanel = new BasicDetailPanel(this.enrolRbctx, this.liteView, this.uiPref, this.enrollmentService);
        this.contactDetailPanel = new ContactDetailPanel(this.enrolRbctx, this.evtCtxt, this.uiPref, this.enrollmentService);
        this.contactDetailPanel.create();
        boolean isBRNRequired = this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment() && !this.enrollmentService.isForeignResident();
        this.disclosurePanel = new DisclosurePanel(this.enrolRbctx);
        this.disclosurePanel.create(this.enrollmentService.isForeignResident(), this.enrollmentService.isNRIEnrolment());
        if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isDemographicTabRequired() || FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POF)) {
            this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.BASIC_TAB, new Object[0]), this.basicDetailPanel.create(isBRNRequired, this.enrollmentService.isForeignResident(), this.enrollmentService.isHofEnrollment(), this.enrollmentService.getDemoPersonalDetails().getAgeDob().isDobSelected()));
        } else {
            this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.DISCLOSURE_TAB, new Object[0]), this.disclosurePanel.getTab());
        }
        if (this.enrollmentService.isForeignResident()) {
            this.foreignPanel = new ForeignPanel(this.enrolRbctx);
            this.foreignPanel.create();
        }
        demoPanel.setBackground(Color.white);
        demoPanel.setLayout(new BorderLayout(0, 0));
        demoPanel.add((Component)this.demoSections.create(), "North");
        demoPanel.add((Component)this.tabbedPane, "South");
        this.tabbedPane.addChangeListener(e -> this.adjustTabHeight());
        this.adjustTabHeight();
        return demoPanel;
    }

    private void adjustTabHeight() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            Component tab = this.tabbedPane.getComponentAt(index);
            int maxHeight = tab.getPreferredSize().height;
            this.tabbedPane.setPreferredSize(new Dimension(this.tabbedPane.getPreferredSize().width, maxHeight + 25));
            this.tabbedPane.revalidate();
        }
    }

    private void initialiseTab() {
        this.tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 0;
            }

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                return 0;
            }
        });
        this.tabbedPane.setForeground(Color.white);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public DemoSections getDemoSections() {
        return this.demoSections;
    }

    public BasicDetailPanel getBasicDetailPanel() {
        return this.basicDetailPanel;
    }

    public ContactDetailPanel getContactDetailPanel() {
        return this.contactDetailPanel;
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public ForeignPanel getForeignPanel() {
        return this.foreignPanel;
    }

    public DisclosurePanel getDisclosurePanel() {
        return this.disclosurePanel;
    }

    public String getTab() {
        return this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
    }
}

