/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.swing.MandatoryLabelBuilder;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GenderPanel
implements IViewElementComposite {
    @ExportViewElement(as="Gender", using=StandardSwingElementFactory.class)
    protected JComboBox<Object> genderField;
    @ExportViewElement(as="Confirm Gender", using=StandardSwingElementFactory.class)
    protected JComboBox<Object> confirmGenderField;
    private final IResourceBundleContext enrolRbctx;
    protected IUIPreference uiPref;
    protected DirectTranslitField locGenderField;
    private JLabel heading;
    private JLabel heading1;
    private LocaleLabel heading2;
    private final boolean isNewEnrollment;

    public GenderPanel(IResourceBundleContext enrolRbctx, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.uiPref = uiPref;
        this.isNewEnrollment = enrollmentService.isNewEnrollmentUC();
    }

    public JComponent createNew() {
        JPanel mainPanel = new JPanel();
        this.initialise();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 0, 2, 10);
        gbc.fill = 2;
        mainPanel.add((Component)this.heading, gbc);
        gbc.gridy = 1;
        mainPanel.add(this.genderField, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        mainPanel.add((Component)this.heading1, gbc);
        gbc.gridy = 1;
        mainPanel.add(this.confirmGenderField, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 20, 2, 2);
        mainPanel.add((Component)this.heading2, gbc);
        gbc.gridy = 1;
        mainPanel.add((Component)this.locGenderField, gbc);
        return mainPanel;
    }

    public JComponent createForeign() {
        JPanel mainPanel = new JPanel();
        this.initialise();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 10);
        gbc.fill = 2;
        mainPanel.add((Component)this.heading, gbc);
        gbc.gridy = 1;
        mainPanel.add(this.genderField, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        mainPanel.add((Component)this.heading1, gbc);
        gbc.gridy = 1;
        mainPanel.add(this.confirmGenderField, gbc);
        return mainPanel;
    }

    private void initialise() {
        this.heading = new JLabel();
        this.heading1 = new JLabel();
        this.genderField = new JComboBox<Gender>(new Gender[]{Gender.FEMALE, Gender.MALE, Gender.TRANSGENDER});
        this.confirmGenderField = new JComboBox<Gender>(new Gender[]{Gender.FEMALE, Gender.MALE, Gender.TRANSGENDER});
        this.genderField.insertItemAt(Gender.getDefaultSelect(), 0);
        this.genderField.setSelectedItem(Gender.getDefaultSelect());
        this.confirmGenderField.insertItemAt(Gender.getDefaultSelect(), 0);
        this.locGenderField = new DirectTranslitField();
        this.locGenderField.setResourceBundleContext(this.enrolRbctx);
        this.locGenderField.setLocale(this.enrolRbctx.getLocale().toString());
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.genderField.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.genderField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.genderField.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.genderField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.genderField.setPreferredSize(new Dimension(235, 40));
        this.heading1.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading1.setForeground(Color.decode("#34495E"));
        this.confirmGenderField.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.confirmGenderField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.confirmGenderField.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.confirmGenderField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.confirmGenderField.setEnabled(false);
        this.confirmGenderField.setPreferredSize(new Dimension(235, 40));
        this.setMandatory(this.isNewEnrollment);
        this.locGenderField.setFont(new Font(this.heading2.getFont().getName(), 0, 14));
        this.locGenderField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.locGenderField.setPreferredSize(new Dimension(480, 40));
    }

    public JComboBox<Object> getGenderField() {
        return this.genderField;
    }

    public JComboBox<Object> getConfirmGenderField() {
        return this.confirmGenderField;
    }

    public boolean itemExists(JComboBox<Object> comboBox, Object item) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!comboBox.getItemAt(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    public void setDefault() {
        this.genderField.setSelectedItem(Gender.getDefaultSelect());
        this.confirmGenderField.setSelectedItem(Gender.getDefaultSelect());
        this.confirmGenderField.setEnabled(false);
        this.locGenderField.setText("");
    }

    public void setMandatory(boolean isMandatory) {
        if (isMandatory) {
            this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.GENDER.toString(), new Object[0])));
            this.heading1.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONFIRM_GENDER.toString(), new Object[0])));
            this.heading2 = new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrolMandatory("label-tlit:demotab.gender");
        } else {
            this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.GENDER.toString(), new Object[0]));
            this.heading1.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONFIRM_GENDER.toString(), new Object[0]));
            this.heading2 = new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrol("label-tlit:demotab.gender");
        }
    }
}

