/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.MandatoryLabelBuilder;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.CapitalizeDecorator;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class NamePanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="NameField", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField nameTextField;
    @ExportViewElement(as="LocalNameField", using=StandardSwingElementFactory.class)
    protected AbstractIMTranslitField locFullNameField;
    @ExportViewElement(as="NewNameField", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField newNameTextField;
    @ExportViewElement(as="OverrideCapitalization", using=StandardSwingElementFactory.class)
    protected JCheckBox overrideCapitalization;
    protected AbstractIMTranslitField newLocFullNameField;
    protected IUIPreference uiPref;
    private JLabel heading;
    private JLabel newHeading;
    private LocaleLabel localHead;
    private LocaleLabel newLocalHead;
    protected EnrollmentService enrollmentService;
    private final boolean isMandatory;

    public NamePanel(IResourceBundleContext enrolRbctx, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.uiPref = uiPref;
        this.enrollmentService = enrollmentService;
        this.isMandatory = enrollmentService.isNewEnrollmentUC() || enrollmentService.getFieldsUpdateCount().getName().hasToBeUpdated();
    }

    private void initialise() {
        this.heading = new JLabel();
        this.nameTextField = new PlaceholderTextField();
        this.overrideCapitalization = new JCheckBox("Override Capitalization");
        new CapitalizeDecorator((JTextField)this.nameTextField);
        final InputVerifier nameVerifier = this.nameTextField.getInputVerifier();
        this.nameTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent comp) {
                if (NamePanel.this.overrideCapitalization.isSelected()) {
                    return true;
                }
                return nameVerifier.verify(comp);
            }
        });
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        ilv.applyFullNameILV(this.nameTextField);
        new AutoSuggestDecorator((JTextField)this.nameTextField).name("fullName");
        this.nameTextField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.nameTextField));
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(this.uiPref, this.enrolRbctx.getLocale().toString(), this.enrollmentService);
        this.locFullNameField = imb.createIMField(this.nameTextField, TransliterationHints.NAME, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFullNameILV((JTextField)this.locFullNameField);
        this.locFullNameField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locFullNameField));
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        String text = this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NAME.toString(), new Object[0]);
        this.heading.setText(this.isMandatory ? CommonUtilsUC.setMandatoryText(text) : text);
        this.nameTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.nameTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_NAME.toString(), new Object[0]));
        this.nameTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.nameTextField.setPreferredSize(new Dimension(480, 39));
        this.localHead = this.isMandatory ? new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrolMandatory("label-tlit:demotab.name") : new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrol("label-tlit:demotab.name");
        this.locFullNameField.setFont(new Font(this.localHead.getFont().getName(), 0, 14));
        this.locFullNameField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.locFullNameField.setPreferredSize(new Dimension(480, 39));
        if (this.enrollmentService.isUpdateUC()) {
            this.newHeading = new JLabel();
            this.newNameTextField = new PlaceholderTextField();
            new CapitalizeDecorator((JTextField)this.newNameTextField);
            final InputVerifier newNameVerifier = this.nameTextField.getInputVerifier();
            this.newNameTextField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent comp) {
                    if (NamePanel.this.overrideCapitalization.isSelected()) {
                        return true;
                    }
                    return newNameVerifier.verify(comp);
                }
            });
            ilv.applyFullNameILV(this.newNameTextField);
            new AutoSuggestDecorator((JTextField)this.newNameTextField).name("fullName");
            this.newNameTextField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.newNameTextField));
            this.newLocFullNameField = imb.createIMField(this.newNameTextField, TransliterationHints.NAME, TransliterationHints.PERSIST);
            ilv.applyTransliteratedFullNameILV((JTextField)this.newLocFullNameField);
            this.newLocFullNameField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.newLocFullNameField));
            this.newHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
            this.newHeading.setForeground(Color.decode("#34495E"));
            String headingText = this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NAME_NEW.toString(), new Object[0]);
            this.newHeading.setText(this.isMandatory ? CommonUtilsUC.setMandatoryText(headingText) : headingText);
            this.newNameTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
            this.newNameTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_NAME.toString(), new Object[0]));
            this.newNameTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
            this.newNameTextField.setPreferredSize(new Dimension(480, 39));
            this.newNameTextField.setEnabled(false);
            this.newLocalHead = this.isMandatory ? new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrolMandatory("label-tlit:demotab.name.new") : new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrol("label-tlit:demotab.name.new");
            this.newLocFullNameField.setFont(new Font(this.newLocalHead.getFont().getName(), 0, 14));
            this.newLocFullNameField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
            this.newLocFullNameField.setPreferredSize(new Dimension(480, 39));
            this.newLocFullNameField.setEnabled(false);
        }
    }

    public JComponent createNew() {
        JPanel mainPanel = new JPanel();
        this.initialise();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        this.locFullNameField.addActionListener(e -> mainPanel.requestFocusInWindow());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 15, 2, 15);
        gbc.fill = 2;
        mainPanel.add((Component)this.heading, gbc);
        ++gbc.gridy;
        mainPanel.add((Component)this.nameTextField, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        mainPanel.add((Component)this.localHead, gbc);
        ++gbc.gridy;
        mainPanel.add((Component)this.locFullNameField, gbc);
        if (!this.enrollmentService.isUpdateUC()) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(8, 15, 2, 15);
            mainPanel.add((Component)this.overrideCapitalization, gbc);
        }
        if (this.enrollmentService.isUpdateUC()) {
            this.newLocFullNameField.addActionListener(e -> mainPanel.requestFocusInWindow());
            gbc.gridx = 0;
            ++gbc.gridy;
            int yCoordinate = gbc.gridy++;
            mainPanel.add((Component)this.newHeading, gbc);
            mainPanel.add((Component)this.newNameTextField, gbc);
            ++gbc.gridx;
            gbc.gridy = yCoordinate;
            mainPanel.add((Component)this.newLocalHead, gbc);
            ++gbc.gridy;
            mainPanel.add((Component)this.newLocFullNameField, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(8, 15, 2, 15);
            mainPanel.add((Component)this.overrideCapitalization, gbc);
        }
        return mainPanel;
    }

    public JComponent createNewForeign() {
        JPanel mainPanel = new JPanel();
        this.initialise();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        this.locFullNameField.addActionListener(e -> mainPanel.requestFocusInWindow());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        mainPanel.add((Component)this.heading, gbc);
        ++gbc.gridy;
        mainPanel.add((Component)this.nameTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(8, 15, 2, 15);
        mainPanel.add((Component)this.overrideCapitalization, gbc);
        return mainPanel;
    }

    public JComponent createNewName() {
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.newLocFullNameField.addActionListener(e -> mainPanel.requestFocusInWindow());
        mainPanel.add((Component)this.newHeading, gbc);
        ++gbc.gridy;
        mainPanel.add((Component)this.newNameTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(8, 15, 2, 15);
        mainPanel.add((Component)this.overrideCapitalization, gbc);
        return mainPanel;
    }

    public void setDefault() {
        this.nameTextField.setText("");
        this.locFullNameField.setText("");
        if (this.enrollmentService.isUpdateUC()) {
            this.newNameTextField.setText("");
            this.newLocFullNameField.setText("");
        }
    }

    public void setEnable(boolean enable) {
        this.nameTextField.setEnabled(enable);
        this.nameTextField.setEditable(enable);
        this.locFullNameField.setText("");
    }

    public boolean isOverrideCapitalizationSelected() {
        return this.overrideCapitalization != null && this.overrideCapitalization.isSelected();
    }
}

