/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.AgePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.GenderPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.NamePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PersonalDetailPanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    private NamePanel namePanel;
    private GenderPanel genderPanel;
    protected AgePanel agePanel;
    protected IUIPreference uiPref;
    protected EnrollmentService enrollmentService;

    public PersonalDetailPanel(IResourceBundleContext enrolRbctx, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.uiPref = uiPref;
        this.enrollmentService = enrollmentService;
    }

    public JComponent createNew(boolean isForeign, boolean isVerified) {
        JPanel mainPanel = new JPanel();
        this.namePanel = new NamePanel(this.enrolRbctx, this.uiPref, this.enrollmentService);
        this.genderPanel = new GenderPanel(this.enrolRbctx, this.uiPref, this.enrollmentService);
        this.agePanel = new AgePanel(this.enrolRbctx, this.uiPref, isVerified, this.enrollmentService);
        JLabel title = new JLabel();
        title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        title.setForeground(Color.decode("#297FB8"));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysHeader.PERSONAL.toString(), new Object[0]));
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel headPanel = new JPanel();
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        headPanel.setLayout(new FlowLayout(0));
        headPanel.add(Box.createHorizontalStrut(10));
        headPanel.add(title);
        headPanel.add(label);
        if (this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment())) {
            mainPanel.add(headPanel);
            mainPanel.add(this.namePanel.createNew());
            mainPanel.add(Box.createVerticalStrut(5));
            mainPanel.add(this.agePanel.createNew());
            mainPanel.add(Box.createVerticalStrut(5));
            mainPanel.add(this.genderPanel.createNew());
        } else if (!isForeign) {
            mainPanel.add(headPanel);
            mainPanel.add(this.namePanel.createNew());
            mainPanel.add(Box.createVerticalStrut(5));
            mainPanel.add(this.genderPanel.createNew());
            mainPanel.add(Box.createVerticalStrut(5));
            mainPanel.add(this.agePanel.createNew());
        } else {
            mainPanel.add(headPanel);
            JPanel second = new JPanel();
            if (!this.enrollmentService.isUpdateUC()) {
                second.setLayout(new GridLayout(1, 1, 0, 5));
                second.add(this.namePanel.createNewForeign());
                second.add(this.genderPanel.createForeign());
                mainPanel.add(second);
                mainPanel.add(Box.createVerticalStrut(10));
                mainPanel.add(this.agePanel.createForeign());
            } else {
                second.setLayout(new GridLayout(2, 1, 0, 5));
                second.add(this.namePanel.createNewForeign());
                second.add(this.genderPanel.createForeign());
                second.add(this.namePanel.createNewName());
                second.add(this.agePanel.createForeign());
                mainPanel.add(second);
            }
        }
        label.setPreferredSize(new Dimension(mainPanel.getPreferredSize().width - title.getPreferredSize().width, 1));
        return mainPanel;
    }

    public void setDefault() {
        this.namePanel.setDefault();
        this.genderPanel.setDefault();
        this.agePanel.setDefault();
    }

    public JTextField getNameField() {
        return this.namePanel.nameTextField;
    }

    public JTextField getNewNameField() {
        return this.namePanel.newNameTextField;
    }

    public JTextField getNewLocalNameField() {
        return this.namePanel.newLocFullNameField;
    }

    public JTextField getLocalName() {
        return this.namePanel.locFullNameField;
    }

    public GenderPanel getGenderPanel() {
        return this.genderPanel;
    }

    public DirectTranslitField getLocalGender() {
        return this.genderPanel.locGenderField;
    }

    public JTextField getDobField() {
        return this.agePanel.date;
    }

    public JTextField getAgeField() {
        return this.agePanel.ageTextField;
    }

    public JTextField getConfirmAgeField() {
        return this.agePanel.confirmAgeTextField;
    }

    public DirectTranslitField getLocalAge() {
        return this.agePanel.locAgeDobField;
    }

    public AgePanel getAgePanel() {
        return this.agePanel;
    }

    public NamePanel getNamePanel() {
        return this.namePanel;
    }

    public JTextField getConfirmDobField() {
        return this.agePanel.confirmDate;
    }

    public JRadioButton getDobOpt() {
        return this.agePanel.dobButton;
    }

    public JRadioButton getConfirmDobOpt() {
        return this.agePanel.confirmDobButton;
    }

    public JRadioButton getAgeOpt() {
        return this.agePanel.ageButton;
    }

    public JRadioButton getConfirmAgeOpt() {
        return this.agePanel.confirmAgeButton;
    }
}

