/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.CapitalizeDecorator;
import in.gov.uidai.swing.EidUidFieldBuilder;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class RelativeDetailPanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    protected JLabel titleLabel;
    protected PlaceholderTextField fatherName;
    protected PlaceholderTextField motherName;
    protected PlaceholderTextField otherName;
    protected AbstractIMTranslitField fatherLocalName;
    protected AbstractIMTranslitField motherLocalName;
    protected AbstractIMTranslitField otherLocalName;
    protected JFormattedTextField fatherUID;
    protected JFormattedTextField motherUID;
    protected JFormattedTextField otherUID;
    protected PlaceholderTextField fatherRelationType;
    protected PlaceholderTextField motherRelationType;
    protected PlaceholderTextField guardianRelationType;
    protected IUIPreference uiPref;
    protected EnrollmentService enrollmentService;

    public RelativeDetailPanel(IResourceBundleContext enrolRbctx, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.uiPref = uiPref;
        this.enrollmentService = enrollmentService;
    }

    public JComponent createNew() {
        this.initialise();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        mainPanel.add((Component)this.createTitlePanel(), gbc);
        GridBagConstraints gbcColumn1 = new GridBagConstraints();
        gbcColumn1.fill = 2;
        gbcColumn1.gridx = 0;
        gbcColumn1.gridwidth = 1;
        gbcColumn1.weightx = 0.175;
        gbcColumn1.insets = new Insets(10, 10, 0, 10);
        GridBagConstraints gbcColumn2 = new GridBagConstraints();
        gbcColumn2.fill = 2;
        gbcColumn2.gridx = 1;
        gbcColumn2.gridwidth = 1;
        gbcColumn2.weightx = 0.19;
        gbcColumn2.insets = new Insets(10, 0, 0, 15);
        GridBagConstraints gbcColumn3 = new GridBagConstraints();
        gbcColumn3.fill = 2;
        gbcColumn3.gridx = 2;
        gbcColumn3.gridwidth = 2;
        gbcColumn3.weightx = 0.51;
        gbcColumn3.insets = new Insets(10, 20, 0, 0);
        gbcColumn3.gridy = 1;
        gbcColumn2.gridy = 1;
        gbcColumn1.gridy = 1;
        mainPanel.add((Component)this.createHeadingPanel(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_RELATION_TYPES.toString(), new Object[0])), gbcColumn1);
        mainPanel.add((Component)this.createHeadingPanel(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_RELATION_UIDS.toString(), new Object[0])), gbcColumn2);
        mainPanel.add((Component)this.createHeadingPanel(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_RELATION_NAMES.toString(), new Object[0])), gbcColumn3);
        gbcColumn3.gridy = 2;
        gbcColumn2.gridy = 2;
        gbcColumn1.gridy = 2;
        mainPanel.add((Component)this.fatherRelationType, gbcColumn1);
        mainPanel.add((Component)this.fatherUID, gbcColumn2);
        mainPanel.add((Component)this.fatherName, gbcColumn3);
        gbcColumn3.gridy = 3;
        gbcColumn2.gridy = 3;
        gbcColumn1.gridy = 3;
        mainPanel.add((Component)this.motherRelationType, gbcColumn1);
        mainPanel.add((Component)this.motherUID, gbcColumn2);
        mainPanel.add((Component)this.motherName, gbcColumn3);
        gbcColumn3.gridy = 4;
        gbcColumn2.gridy = 4;
        gbcColumn1.gridy = 4;
        mainPanel.add((Component)this.guardianRelationType, gbcColumn1);
        mainPanel.add((Component)this.otherUID, gbcColumn2);
        mainPanel.add((Component)this.otherName, gbcColumn3);
        return mainPanel;
    }

    void initialise() {
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(this.uiPref, this.enrolRbctx.getLocale().toString(), this.enrollmentService);
        this.titleLabel = new JLabel();
        this.fatherRelationType = new PlaceholderTextField();
        this.initialiseTextField(this.fatherRelationType);
        this.fatherRelationType.setText("Father");
        this.fatherRelationType.setEditable(false);
        this.fatherName = new PlaceholderTextField();
        this.initialiseTextField(this.fatherName, ilv, this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_ENTER_FATHERS_NAME.toString(), new Object[0]));
        this.fatherLocalName = imb.createIMField(this.fatherName, TransliterationHints.NAME, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFullNameILV((JTextField)this.fatherLocalName);
        this.fatherLocalName.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.fatherLocalName));
        this.fatherUID = EidUidFieldBuilder.createUidField();
        this.initialiseUidField(this.fatherUID);
        this.fatherName.setName("Father Name");
        this.fatherUID.setName("Father UID");
        this.motherRelationType = new PlaceholderTextField();
        this.initialiseTextField(this.motherRelationType);
        this.motherRelationType.setText("Mother");
        this.motherRelationType.setEditable(false);
        this.motherName = new PlaceholderTextField();
        this.initialiseTextField(this.motherName, ilv, this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_ENTER_MOTHERS_NAME.toString(), new Object[0]));
        this.motherLocalName = imb.createIMField(this.motherName, TransliterationHints.NAME, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFullNameILV((JTextField)this.motherLocalName);
        this.motherLocalName.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.motherLocalName));
        this.motherUID = EidUidFieldBuilder.createUidField();
        this.initialiseUidField(this.motherUID);
        this.motherName.setName("Mother Name");
        this.motherUID.setName("Mother UID");
        this.guardianRelationType = new PlaceholderTextField();
        this.initialiseTextField(this.guardianRelationType);
        this.guardianRelationType.setText("Legal Guardian");
        this.guardianRelationType.setEditable(false);
        this.otherName = new PlaceholderTextField();
        this.otherName.setEditable(false);
        this.initialiseTextField(this.otherName, ilv, this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_ENTER_GUARDIANS_NAME.toString(), new Object[0]));
        this.otherLocalName = imb.createIMField(this.otherName, TransliterationHints.NAME, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFullNameILV((JTextField)this.otherLocalName);
        this.otherLocalName.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.otherLocalName));
        this.otherUID = EidUidFieldBuilder.createUidField();
        this.otherUID.setEditable(false);
        this.initialiseUidField(this.otherUID);
        this.otherName.setName("Mother Name");
        this.otherUID.setName("Mother UID");
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.titleLabel.setForeground(Color.decode("#297FB8"));
        this.titleLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_RELATIVE_DETAILS.toString(), new Object[0]));
        titlePanel.add(this.titleLabel);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }

    void initialiseTextField(PlaceholderTextField textField, InlineValidations ilv, String placeholderText) {
        new CapitalizeDecorator((JTextField)textField);
        ilv.applyFullNameILV(textField);
        new AutoSuggestDecorator((JTextField)textField).name("fullName");
        textField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)textField));
        textField.setPlaceholder(placeholderText);
        textField.setFont(new Font(textField.getFont().getName(), 0, 14));
        textField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        textField.setPreferredSize(new Dimension(-1, 40));
    }

    void initialiseUidField(JFormattedTextField uidField) {
        uidField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)uidField));
        uidField.setValue(null);
        uidField.setFont(new Font(uidField.getFont().getName(), 0, 14));
        uidField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        uidField.setPreferredSize(new Dimension(-1, 40));
    }

    void initialiseTextField(PlaceholderTextField comboBox) {
        comboBox.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        comboBox.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        comboBox.setPreferredSize(new Dimension(-1, 40));
    }

    void initialiseComboBox(JComboBox<RelationshipType> comboBox) {
        comboBox.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        comboBox.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        comboBox.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        comboBox.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        comboBox.setPreferredSize(new Dimension(-1, 40));
    }

    JLabel createHeadingPanel(String headingText) {
        JLabel headingLabel = new JLabel();
        headingLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        headingLabel.setForeground(Color.decode("#34495E"));
        headingLabel.setText(CommonUtilsUC.setMandatoryText(headingText));
        headingLabel.setHorizontalAlignment(2);
        return headingLabel;
    }

    public void setDefault() {
        this.fatherName.setText("");
        this.motherName.setText("");
        this.fatherUID.setValue(null);
        this.motherUID.setValue(null);
    }

    public void setEditableForParents(boolean editable) {
        this.fatherName.setEditable(editable);
        this.motherName.setEditable(editable);
        this.fatherUID.setEditable(editable);
        this.motherUID.setEditable(editable);
    }

    public void setEnable(boolean enable) {
        this.fatherName.setEditable(enable);
        this.motherName.setEditable(enable);
        this.otherName.setEditable(enable);
        this.fatherUID.setEditable(enable);
        this.motherUID.setEditable(enable);
        this.otherName.setEditable(enable);
    }

    public PlaceholderTextField getFatherName() {
        return this.fatherName;
    }

    public PlaceholderTextField getMotherName() {
        return this.motherName;
    }

    public PlaceholderTextField getOtherName() {
        return this.otherName;
    }

    public AbstractIMTranslitField getFatherLocalName() {
        return this.fatherLocalName;
    }

    public AbstractIMTranslitField getMotherLocalName() {
        return this.motherLocalName;
    }

    public AbstractIMTranslitField getOtherLocalName() {
        return this.otherLocalName;
    }

    public JFormattedTextField getFatherUID() {
        return this.fatherUID;
    }

    public JFormattedTextField getMotherUID() {
        return this.motherUID;
    }

    public JFormattedTextField getOtherUID() {
        return this.otherUID;
    }

    public PlaceholderTextField getFatherRelationType() {
        return this.fatherRelationType;
    }

    public PlaceholderTextField getmotherRelationType() {
        return this.motherRelationType;
    }
}

