/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.RadioButtonCustom;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class ResidentPanel
implements IViewElementComposite {
    protected RadioButtonCustom foreignButton;
    protected RadioButtonCustom indianButton;
    protected JComboBox<Country> nationalityList;
    protected JComboBox<NationalityTypes> foreignType;
    protected RadioButtonCustom nriButtton;
    protected JButton refresh;
    private final IResourceBundleContext enrolRbctx;
    private JLabel title;
    private JLabel heading;
    private JLabel heading1;
    private JLabel heading2;

    public ResidentPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent createNew() {
        this.initialise();
        JPanel residentPanel = new JPanel();
        residentPanel.setBackground(new Color(255, 255, 255));
        residentPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 20, 0, 20);
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.weightx = 2.0;
        residentPanel.add((Component)this.createTitlePanel(), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.25;
        gbc.insets = new Insets(2, 20, 0, 10);
        residentPanel.add((Component)this.heading2, gbc);
        gbc.gridy = 2;
        residentPanel.add(this.foreignType, gbc);
        ++gbc.gridx;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 0, 0, 10);
        residentPanel.add((Component)this.heading1, gbc);
        gbc.gridy = 2;
        residentPanel.add(this.nationalityList, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(2, 0, 0, 500);
        residentPanel.add((Component)this.refresh, gbc);
        label.setPreferredSize(new Dimension(residentPanel.getPreferredSize().width - this.title.getPreferredSize().width, 1));
        return residentPanel;
    }

    private void initialise() {
        this.title = new JLabel();
        this.heading = new JLabel();
        this.indianButton = new RadioButtonCustom();
        this.nriButtton = new RadioButtonCustom();
        this.foreignButton = new RadioButtonCustom();
        this.heading1 = new JLabel();
        this.heading2 = new JLabel();
        this.nationalityList = new JComboBox();
        this.foreignType = new JComboBox();
        this.refresh = new JButton();
        this.indianButton.setEnabled(false);
        this.nriButtton.setEnabled(false);
        this.foreignButton.setEnabled(false);
        this.nationalityList.setEnabled(false);
        this.title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.title.setForeground(Color.decode("#297FB8"));
        this.title.setText(this.enrolRbctx.getMessage((Object)LabelKeysHeader.RESIDENT_DETAILS, new Object[0]));
        this.refresh.setText("\ue627");
        this.refresh.setFont(new Font("Material Icons", 0, 25));
        this.refresh.setForeground(Color.decode("#34495E"));
        this.refresh.setHorizontalAlignment(0);
        this.refresh.setToolTipText("Sync the list");
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.RESIDENT_TYPE, new Object[0])));
        this.indianButton.setBackground(Color.decode("#297FB8"));
        this.indianButton.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.INDIAN_RESIDENT, new Object[0]));
        this.indianButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.nriButtton.setBackground(Color.decode("#297FB8"));
        this.nriButtton.setForeground(Color.decode("#34495E"));
        this.nriButtton.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NON_RESIDENT_INDIAN, new Object[0]));
        this.nriButtton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.foreignButton.setBackground(Color.decode("#297FB8"));
        this.foreignButton.setForeground(Color.decode("#34495E"));
        this.foreignButton.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.FOREIGN_NATIONAL_RESIDENT, new Object[0]));
        this.foreignButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading2.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading2.setForeground(Color.decode("#34495E"));
        this.heading2.setText(CommonUtilsUC.setMandatoryText("Type of Foreigner"));
        this.foreignType.setActionCommand("ForeignType");
        this.foreignType.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.foreignType.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.foreignType.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.foreignType.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.foreignType.setPreferredSize(new Dimension(235, 40));
        this.heading1.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading1.setForeground(Color.decode("#34495E"));
        this.heading1.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NATIONALITY, new Object[0])));
        this.nationalityList.setActionCommand("Nationality");
        this.nationalityList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.nationalityList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.nationalityList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.nationalityList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.nationalityList.setPreferredSize(new Dimension(235, 40));
    }

    private void handleToggleButtons() {
        new ToggleButtonAssociation(this.indianButton).deselect(this.nriButtton).deselect(this.foreignButton);
        new ToggleButtonAssociation(this.nriButtton).deselect(this.indianButton).deselect(this.foreignButton);
        new ToggleButtonAssociation(this.foreignButton).deselect(this.indianButton).deselect(this.nriButtton);
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(this.title);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }

    public JRadioButton getForeignButton() {
        return this.foreignButton;
    }

    public JRadioButton getNriButtton() {
        return this.nriButtton;
    }

    public JRadioButton getIndianButton() {
        return this.indianButton;
    }

    public JComboBox<Country> getNationalityList() {
        return this.nationalityList;
    }

    public JButton getRefresh() {
        return this.refresh;
    }

    public JComboBox<NationalityTypes> getForeignType() {
        return this.foreignType;
    }

    public boolean nationalityExists(JComboBox<NationalityTypes> comboBox, Object item) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!comboBox.getItemAt(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    public boolean countryExists(JComboBox<Country> comboBox, Object item) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!comboBox.getItemAt(i).equals(item)) continue;
            return true;
        }
        return false;
    }
}

