/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.common;

import com.google.common.base.Strings;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.ErrorDetail;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.util.UidSwingUtilities;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtilsUC {
    public static Font semiBoldFont;
    public static Font regularFont;
    private static final Logger LOGGER;

    public static JComponent createDivider() {
        TransparentBox divider = new TransparentBox();
        divider.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        return divider;
    }

    public static JLabel getDownArrowLabel(JComponent comp) {
        JLabel arrowLabel = new JLabel();
        arrowLabel.setBorder(null);
        arrowLabel.setBackground(comp.getBackground());
        arrowLabel.setOpaque(true);
        arrowLabel.setIcon(UidSwingUtilities.loadIcon((String)"res/ecmp/images/dropDownArrow.png"));
        return arrowLabel;
    }

    public static ImageIcon getImageIcon(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new ImageIcon(Objects.requireNonNull(cl.getResource(path)));
    }

    public static String setMandatoryText(String text) {
        return "<html><p>" + text + "<span style=\"color: #E84C3D\">*</span></p></html>";
    }

    public static String splitName(String fullName, String lang) {
        String regEx = lang.equalsIgnoreCase("eng") ? "[a-zA-Z]+" : "[^a-zA-Z]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(fullName);
        StringBuilder name = new StringBuilder();
        while (matcher.find()) {
            name.append(matcher.group()).append(" ");
        }
        return name.toString().trim();
    }

    public static void setFontsAndIcon() {
        try {
            ClassLoader cldr = Thread.currentThread().getContextClassLoader();
            InputStream regularFontFile = cldr.getResourceAsStream("res/ecmp/ucFont/Poppins-Regular.ttf");
            InputStream semiBoldFontFile = cldr.getResourceAsStream("res/ecmp/ucFont/Poppins-SemiBold.ttf");
            InputStream materialIconFontFile = cldr.getResourceAsStream("res/ecmp/ucFont/MaterialIcons-Regular.ttf");
            assert (materialIconFontFile != null);
            Font materialIconFont = Font.createFont(0, materialIconFontFile);
            assert (regularFontFile != null);
            regularFont = Font.createFont(0, regularFontFile);
            assert (semiBoldFontFile != null);
            semiBoldFont = Font.createFont(0, semiBoldFontFile);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(materialIconFont);
            ge.registerFont(regularFont);
            ge.registerFont(semiBoldFont);
        }
        catch (Exception e) {
            LOGGER.error("Exception : ", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_FNT_001.getReason()), ErrorCodes.UC_FNT_001.getErrorCode(), new String[0]);
        }
    }

    public static int getHeight() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return gd.getDisplayMode().getHeight();
    }

    public static int getWidth() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        return gd.getDisplayMode().getWidth();
    }

    public static LocaleLabel createLocalUC(IResourceBundleContext resBundleCtxt, String text) {
        LocaleLabel result = new LocaleLabel(resBundleCtxt, text);
        Font font = result.getFont();
        result.setFont(new Font(font.getName(), 1, 14));
        result.setText(result.getText());
        result.setHorizontalTextPosition(2);
        result.setVerticalAlignment(0);
        return result;
    }

    public static String getTranslation(IResourceBundleContext enrolRbctx, String text) {
        return TransliterationManager.getInst().getTransliterationProvider(enrolRbctx.getLocale().toString()).transliterate(text, enrolRbctx.getLocale().toString(), new TransliterationHints[0]).trim();
    }

    public static String capitalizeWords(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String cleanInput = input.replaceAll("[^A-Za-z ]", "");
        String[] words = cleanInput.split("\\s+");
        StringBuilder capitalizedWords = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            capitalizedWords.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return capitalizedWords.toString().trim();
    }

    public static String getErrorMessage(ErrorDetail errorDetail) {
        if (!Strings.isNullOrEmpty((String)errorDetail.getMessage())) {
            return errorDetail.getMessage();
        }
        if (!Strings.isNullOrEmpty((String)errorDetail.getMessageEnglish())) {
            return errorDetail.getMessageEnglish();
        }
        return errorDetail.getMessageLocal();
    }

    public static String getErrorMessage(UosResponse uosResponse) {
        if (uosResponse.getErrorDetail() != null) {
            return CommonUtilsUC.getErrorMessage(uosResponse.getErrorDetail());
        }
        if (!Strings.isNullOrEmpty((String)uosResponse.getError()) && !Strings.isNullOrEmpty((String)uosResponse.getErrorDescription())) {
            if (uosResponse.getError().contains("invalid_token")) {
                return ErrorCodes.UC_OP_002.getReason();
            }
            return uosResponse.getErrorDescription();
        }
        return "";
    }

    public static String getErrorCode(UosResponse uosResponse, String defaultCode) {
        if (!Strings.isNullOrEmpty((String)uosResponse.getErrorCode())) {
            return uosResponse.getErrorCode();
        }
        if (!Strings.isNullOrEmpty((String)uosResponse.getError()) && !Strings.isNullOrEmpty((String)uosResponse.getErrorDescription())) {
            if (uosResponse.getError().contains("invalid_token")) {
                return ErrorCodes.UC_OP_002.getErrorCode();
            }
            return defaultCode;
        }
        return defaultCode;
    }

    public static boolean isAgeFiveOrLess(String dob) {
        LocalDate fifthBirthday;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate birthDate = LocalDate.parse(dob, formatter);
        LocalDate today = LocalDate.now();
        return !today.isAfter(fifthBirthday = birthDate.plusYears(5L));
    }

    public static boolean isGpsValid(IOucDataStore oucDataStore) {
        long gpsRestInterval = TimeUnit.HOURS.toMillis(12L);
        try {
            GpsInfo gpsInfo = oucDataStore.getGpsInfo();
            long gpsCaptureTime = gpsInfo.getCaptureTime();
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - gpsCaptureTime;
            if (elapsedTime > gpsRestInterval) {
                gpsInfo.setAltitude(Float.valueOf(0.0f));
                gpsInfo.setLongitude(Float.valueOf(0.0f));
                gpsInfo.setLatitude(Float.valueOf(0.0f));
                oucDataStore.setGpsInfo(gpsInfo);
            }
            return oucDataStore.getGpsInfo().getLongitude().floatValue() > 0.0f && oucDataStore.getGpsInfo().getLatitude().floatValue() > 0.0f;
        }
        catch (StationInfoStoreException | IOException e) {
            LOGGER.warn("Unable to get the GPS");
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_117.getErrorCode(), new String[0]);
            return false;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(CommonUtilsUC.class);
    }
}

