/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.common;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.references.ReferenceStagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReferenceSections
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    private Map<ReferenceStagesUC, JLabel> tabs;
    private Map<ReferenceStagesUC, JPanel> panels;
    private final EnrollmentService enrollmentService;

    public ReferenceSections(IResourceBundleContext enrolRbctx, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        JPanel mainPanel = new JPanel();
        JPanel documentUploadPanel = new JPanel();
        JPanel documentVerifyPanel = new JPanel();
        JLabel documentUploadIcon = new JLabel();
        JLabel documentVerifyIcon = new JLabel();
        this.tabs = new HashMap<ReferenceStagesUC, JLabel>();
        this.panels = new HashMap<ReferenceStagesUC, JPanel>();
        this.tabs.putIfAbsent(ReferenceStagesUC.DOCUMENT_UPLOAD, documentUploadIcon);
        this.panels.putIfAbsent(ReferenceStagesUC.DOCUMENT_UPLOAD, documentUploadPanel);
        this.tabs.putIfAbsent(ReferenceStagesUC.DOCUMENT_VERIFY, documentVerifyIcon);
        this.panels.putIfAbsent(ReferenceStagesUC.DOCUMENT_VERIFY, documentVerifyPanel);
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel firstPanel = new JPanel();
        firstPanel.setBackground(Color.white);
        firstPanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 18.0f));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysTab.REF, new Object[0]));
        title.setVerticalAlignment(1);
        firstPanel.add(title);
        mainPanel.add(firstPanel);
        JPanel secondPanel = new JPanel();
        secondPanel.setLayout(new BoxLayout(secondPanel, 0));
        AtomicInteger stepNumber = new AtomicInteger(1);
        TreeSet<ReferenceStagesUC> sortedTab = new TreeSet<ReferenceStagesUC>(Comparator.comparingInt(Enum::ordinal));
        sortedTab.addAll(this.tabs.keySet());
        sortedTab.forEach(referenceStagesUC -> {
            switch (referenceStagesUC) {
                case DOCUMENT_UPLOAD: {
                    secondPanel.add(this.createSectionPanel(documentUploadPanel, "STEP " + stepNumber.getAndIncrement(), this.enrolRbctx.getMessage((Object)LabelKeysTab.DOCUMENT_UPLOAD_TAB, new Object[0]), documentUploadIcon));
                    secondPanel.add(Box.createRigidArea(new Dimension(25, 0)));
                    break;
                }
                case DOCUMENT_VERIFY: {
                    secondPanel.add(this.createSectionPanel(documentVerifyPanel, "STEP " + stepNumber.getAndIncrement(), this.enrolRbctx.getMessage((Object)LabelKeysTab.DOCUMENT_VERIFY_TAB, new Object[0]), documentVerifyIcon));
                }
            }
        });
        mainPanel.add(secondPanel);
        return mainPanel;
    }

    private JPanel createSectionPanel(JPanel panel, String stepCount, String head, JLabel icon) {
        panel.setBackground(new Color(255, 255, 255));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panel1 = new JPanel();
        panel1.setBackground(Color.decode("#BEC3C7"));
        panel1.setPreferredSize(new Dimension(panel1.getPreferredSize().width, 5));
        panel.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        JLabel step = new JLabel();
        step.setForeground(Color.decode("#7E8C8D"));
        step.setText(stepCount);
        step.setVerticalAlignment(1);
        panel2.add(step);
        panel.add(panel2);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 0));
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout());
        JLabel heading = new JLabel();
        heading.setBackground(Color.WHITE);
        heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 16.0f));
        heading.setForeground(Color.decode("#2D3E50"));
        heading.setText(head);
        heading.setVerticalAlignment(1);
        panel4.add(heading);
        panel3.add(panel4);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new BorderLayout());
        icon.setText("\ue86c");
        icon.setFont(new Font("Material Icons", 0, 23));
        icon.setForeground(Color.decode("#BEC3C7"));
        icon.setHorizontalAlignment(4);
        panel5.add(icon);
        panel3.add(panel5);
        panel.add(panel3);
        return panel;
    }

    public void setValid(Map<ReferenceStagesUC, Boolean> tabState) {
        tabState.forEach((pair, aBoolean) -> {
            if (aBoolean.booleanValue()) {
                this.tabs.get(pair).setForeground(Color.decode("#27AE61"));
                this.panels.get(pair).getComponent(0).setBackground(Color.decode("#27AE61"));
            } else {
                this.tabs.get(pair).setForeground(Color.decode("#BEC3C7"));
                this.panels.get(pair).getComponent(0).setBackground(Color.decode("#BEC3C7"));
            }
        });
    }

    public void currentTab(ReferenceStagesUC stages) {
        this.panels.get((Object)stages).getComponent(0).setBackground(Color.decode("#297FB8"));
    }
}

