/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.demographics.StagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.AddressPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.CareOfPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.DistrictPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.EmailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.HousePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.LandmarkPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.LocalityPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.MobilePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.PincodePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.PostOfficePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.StatePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.StreetPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.VillagePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.ZipcodePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ContactDetailPanel
implements IViewElementComposite {
    private IResourceBundleContext enrolRbctx;
    private IEventContext eventContext;
    JLabel title;
    protected CareOfPanel careofPanel;
    protected AddressPanel addressone;
    protected AddressPanel addresstwo;
    protected AddressPanel addressthree;
    protected HousePanel housePanel;
    protected StreetPanel streetPanel;
    protected LocalityPanel localityPanel;
    protected VillagePanel villagePanel;
    protected DistrictPanel districtPanel;
    protected PostOfficePanel postOfficePanel;
    protected StatePanel statePanel;
    protected PincodePanel pincodePanel;
    protected ZipcodePanel zipCodePanel;
    protected LandmarkPanel landmarkPanel;
    protected EmailPanel emailPanel;
    protected MobilePanel mobilePanel;
    protected IUIPreference uiPref;
    private EnrollmentService enrollmentService;
    protected ShadowPanel contactPanel;

    public ContactDetailPanel(IResourceBundleContext enrolRbctx, IEventContext eventContex, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.eventContext = eventContex;
        this.uiPref = uiPref;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        this.title = new JLabel();
        this.title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.title.setForeground(new Color(41, 127, 184));
        this.title.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONTACT.toString(), new Object[0]));
        this.contactPanel = new ShadowPanel();
        this.contactPanel.setDemographicStage(StagesUC.CONTACT_DETAILS);
        this.contactPanel.setBackground(Color.WHITE);
        this.contactPanel.setLayout((LayoutManager)new AbsoluteLayout());
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(this.uiPref, this.enrolRbctx.getLocale().toString(), this.enrollmentService);
        this.contactPanel.add((Component)this.title, new AbsoluteConstraints(40, 23, 111, 20));
        this.contactPanel.add((Component)CommonUtilsUC.createDivider(), new AbsoluteConstraints(170, 23, 810, 10));
        if (this.enrollmentService.doesNriHaveForeignAddress()) {
            this.addressone = new AddressPanel(this.enrolRbctx, imb);
            this.addresstwo = new AddressPanel(this.enrolRbctx, imb);
            this.addressthree = new AddressPanel(this.enrolRbctx, imb);
            this.zipCodePanel = new ZipcodePanel(this.enrolRbctx, imb);
        } else {
            this.careofPanel = new CareOfPanel(this.enrolRbctx, imb);
            this.housePanel = new HousePanel(this.enrolRbctx, imb);
            this.streetPanel = new StreetPanel(this.enrolRbctx, imb);
            this.localityPanel = new LocalityPanel(this.enrolRbctx, imb);
            this.landmarkPanel = new LandmarkPanel(this.enrolRbctx, imb);
            this.villagePanel = new VillagePanel(this.enrolRbctx, imb, this.enrollmentService.isNewEnrollmentUC());
            this.districtPanel = new DistrictPanel(this.enrolRbctx, imb, this.enrollmentService.isNewEnrollmentUC());
            this.postOfficePanel = new PostOfficePanel(this.eventContext, this.enrolRbctx, imb, this.enrollmentService.isNewEnrollmentUC());
            this.statePanel = new StatePanel(this.enrolRbctx, imb, this.enrollmentService.isNewEnrollmentUC());
            this.pincodePanel = new PincodePanel(this.eventContext, this.enrolRbctx, this.enrollmentService.isNewEnrollmentUC());
        }
        this.emailPanel = new EmailPanel(this.eventContext, this.enrolRbctx, this.enrollmentService);
        this.mobilePanel = new MobilePanel(this.eventContext, this.enrolRbctx, this.enrollmentService);
        this.contactPanel.setBackground(new Color(255, 255, 255));
        if (this.enrollmentService.isForeignResident()) {
            this.contactPanel.add((Component)this.careofPanel.create(), new AbsoluteConstraints(20, 45, 490, 77));
            this.contactPanel.add((Component)this.housePanel.create(), new AbsoluteConstraints(519, 45, 490, 77));
            this.contactPanel.add((Component)this.streetPanel.create(), new AbsoluteConstraints(20, 120, 490, 77));
            this.contactPanel.add((Component)this.localityPanel.create(), new AbsoluteConstraints(519, 120, 490, 77));
            this.contactPanel.add((Component)this.villagePanel.create(), new AbsoluteConstraints(20, 199, 490, 77));
            this.contactPanel.add((Component)this.districtPanel.create(), new AbsoluteConstraints(519, 276, 270, 77));
            this.contactPanel.add((Component)this.postOfficePanel.create(), new AbsoluteConstraints(790, 276, 220, 77));
            this.contactPanel.add((Component)this.statePanel.create(), new AbsoluteConstraints(20, 276, 270, 77));
            this.contactPanel.add((Component)this.pincodePanel.create(), new AbsoluteConstraints(290, 276, 220, 77));
            this.contactPanel.add((Component)this.landmarkPanel.create(), new AbsoluteConstraints(519, 199, 490, 77));
            this.contactPanel.add((Component)this.emailPanel.create(!this.enrollmentService.getDemoContactDetails().getEmail().email().isEmpty()), new AbsoluteConstraints(20, 353, 490, 100));
            this.contactPanel.add((Component)this.mobilePanel.create(), new AbsoluteConstraints(519, 353, 490, 100));
        } else if (this.enrollmentService.isNRIEnrolment() && this.enrollmentService.doesNriHaveForeignAddress()) {
            this.contactPanel.add((Component)this.addressone.create(1, true), new AbsoluteConstraints(20, 45, 1009, 77));
            this.contactPanel.add((Component)this.addresstwo.create(2, true), new AbsoluteConstraints(20, 120, 1009, 77));
            this.contactPanel.add((Component)this.addressthree.create(3, false), new AbsoluteConstraints(20, 199, 1009, 77));
            this.contactPanel.add((Component)this.zipCodePanel.create(), new AbsoluteConstraints(20, 276, 1000, 77));
            this.contactPanel.add((Component)this.emailPanel.create(true), new AbsoluteConstraints(20, 353, 490, 100));
            this.contactPanel.add((Component)this.mobilePanel.create(), new AbsoluteConstraints(519, 353, 490, 100));
        } else {
            this.contactPanel.add((Component)this.careofPanel.createEnrolment(), new AbsoluteConstraints(30, 43, 1000, 70));
            this.contactPanel.add((Component)this.housePanel.createEnrolment(), new AbsoluteConstraints(30, 113, 1000, 70));
            this.contactPanel.add((Component)this.streetPanel.createEnrolment(), new AbsoluteConstraints(30, 183, 1000, 70));
            this.contactPanel.add((Component)this.localityPanel.createEnrolment(), new AbsoluteConstraints(30, 253, 1000, 70));
            this.contactPanel.add((Component)this.villagePanel.createEnrolment(), new AbsoluteConstraints(30, 393, 1000, 70));
            this.contactPanel.add((Component)this.districtPanel.create(), new AbsoluteConstraints(30, 463, 270, 70));
            this.contactPanel.add((Component)this.districtPanel.createEnrolment(), new AbsoluteConstraints(549, 463, 270, 70));
            this.contactPanel.add((Component)this.postOfficePanel.create(), new AbsoluteConstraints(300, 463, 220, 70));
            this.contactPanel.add((Component)this.postOfficePanel.createEnrolment(), new AbsoluteConstraints(810, 463, 220, 70));
            this.contactPanel.add((Component)this.statePanel.create(), new AbsoluteConstraints(30, 533, 270, 70));
            this.contactPanel.add((Component)this.statePanel.createEnrolment(), new AbsoluteConstraints(549, 533, 270, 70));
            this.contactPanel.add((Component)this.pincodePanel.create(), new AbsoluteConstraints(300, 533, 220, 70));
            this.contactPanel.add((Component)this.pincodePanel.createEnrolment(), new AbsoluteConstraints(810, 533, 220, 70));
            this.contactPanel.add((Component)this.landmarkPanel.createEnrolment(), new AbsoluteConstraints(30, 323, 1000, 70));
            this.contactPanel.add((Component)this.emailPanel.create(!this.enrollmentService.getDemoContactDetails().getEmail().email().isEmpty()), new AbsoluteConstraints(30, 603, 490, 95));
            this.contactPanel.add((Component)this.mobilePanel.create(), new AbsoluteConstraints(549, 603, 490, 95));
        }
        this.contactPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContactDetailPanel.this.contactPanel.requestFocusInWindow();
            }
        });
        return this.contactPanel;
    }

    public void setAddressFields(Address address) {
        this.getCareofPanel().getCareofTextField().setText(address.getCareOfNameForDisplay());
        this.getCareofPanel().getLocCareOf().setText(address.getCareOfNameLocaleForDisplay());
        this.getStreetPanel().getStreetTextField().setText(address.getDisplayStreet());
        this.getStreetPanel().getLocalStreet().setText(address.getDisplayStreetLocal());
        this.getHousePanel().getHouseTextField().setText(address.getDisplayBuilding());
        this.getHousePanel().getLocalHouse().setText(address.getDisplayBuildingLocal());
        this.getLandmarkPanel().getLandmark().setText(address.getDisplayLandmark());
        this.getLandmarkPanel().getLocalLandmark().setText(address.getDisplayLandmarkLocal());
        this.getLocalityPanel().getLocalityTextField().setText(address.getDisplayLocality());
        this.getLocalityPanel().getLocalLocality().setText(address.getDisplayLocalityLocal());
        this.getStatePanel().getStateTextField().setText(address.getDisplayState());
        this.getStatePanel().getLocStateField().setText(address.getDisplayStateLocal());
        this.getPincodePanel().getPincodeTextField().setText(address.getDisplayPinCodeValue());
        this.getPincodePanel().locPinField.setResourceBundleContext(this.enrolRbctx);
        this.getPincodePanel().locPinField.setText(address.getDisplayPinCodeLocal());
        this.getDistrictPanel().getDistrictTextField().setText(address.getDisplayDistrict());
        this.getDistrictPanel().getLocDistrictField().setText(address.getDisplayDistrictLocal());
        boolean isAddressUpdate = this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated();
        List postOfficeList = address.getPinCodeDetail().getPostOfficeList();
        if (this.isPostOfficeAvailable(postOfficeList)) {
            boolean isAppointment;
            boolean bl = isAppointment = !Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId());
            if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment()) {
                if (Strings.isNullOrEmpty((String)address.getDisplayPoName())) {
                    this.getPostOfficePanel().getPostOfficeTextField().setOptions(postOfficeList);
                    this.getPostOfficePanel().getPostOfficeTextField().setText(((PostOffice)postOfficeList.get(0)).getName());
                } else {
                    this.getPostOfficePanel().getPostOfficeTextField().setText(address.getDisplayPoName());
                }
            } else if (!this.enrollmentService.isUpdateUC() || this.enrollmentService.isHofEnrollment()) {
                // empty if block
            }
            if (this.enrollmentService.isUpdateUC()) {
                if (isAddressUpdate) {
                    this.getPostOfficePanel().getPostOfficeTextField().setOptions(postOfficeList);
                    this.getPostOfficePanel().getPostOfficeTextField().setText(((PostOffice)postOfficeList.get(0)).getName());
                } else {
                    this.getPostOfficePanel().getPostOfficeTextField().setText(address.getDisplayPoName());
                }
            }
            if (isAppointment) {
                if (!Strings.isNullOrEmpty((String)address.getDisplayPoName())) {
                    this.getPostOfficePanel().getPostOfficeTextField().setText(address.getDisplayPoName());
                } else {
                    this.getPostOfficePanel().getPostOfficeTextField().setText(address.getDisplayPoName());
                }
            }
        } else {
            this.getPostOfficePanel().getPostOfficeTextField().setText(address.getDisplayPoName());
        }
        if (Strings.isNullOrEmpty((String)address.getDisplayPoNameLocal())) {
            this.getPostOfficePanel().locPostOffField.setText(address.getDisplayPoName());
            address.setPostOfficeLocal(this.getPostOfficePanel().locPostOffField.getText());
        } else {
            this.getPostOfficePanel().locPostOffField.setText(address.getDisplayPoNameLocal());
        }
        this.getVillagePanel().getVillageTextField().setText(address.getDisplayVTC());
        this.getVillagePanel().getLocVtcField().setText(address.getDisplayVTCLocal());
        if (!this.enrollmentService.isHofEnrollment() && isAddressUpdate) {
            ArrayList<PostalAddress> postalAddresses = this.makePostalAddresses(address);
            this.getPincodePanel().getPincodeTextField().setOptions(postalAddresses);
            this.getPincodePanel().getPincodeTextField().setSelectedOption(postalAddresses.get(0));
        }
        address.setCareOfName(this.getCareofPanel().getCareofTextField().getText());
    }

    private boolean isPostOfficeAvailable(List postOfficeList) {
        return postOfficeList != null && !postOfficeList.isEmpty();
    }

    public void setNRIForeignAddressFields(ForeignNRI foreignNRIAddress) {
        this.getAddressPanelOne().getaddressTextField().setText(foreignNRIAddress.getDisplayAddressOne());
        this.getAddressPanelTwo().getaddressTextField().setText(foreignNRIAddress.getDisplayAddressTwo());
        this.getAddressPanelThree().getaddressTextField().setText(foreignNRIAddress.getDisplayAddressThree());
        boolean isAddressUpdate = this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated();
        this.getZipCodePanel().getzipcodeTextField().setText(foreignNRIAddress.getDisplayZipCode());
        if (foreignNRIAddress.getExistingCountry() != null) {
            Optional<CountryList> country;
            if (!isAddressUpdate) {
                this.getZipCodePanel().getCountryListComboBox().removeAllItems();
            }
            if ((country = Arrays.stream(this.enrollmentService.getOnlineDocumentService().getCountryList()).filter(countryList -> countryList.getCountryCode().equalsIgnoreCase(foreignNRIAddress.getExistingCountry().getCountryCode())).findFirst()).isPresent()) {
                CountryList countryList2 = country.get();
                Country existingCountry = new Country(countryList2.getCountryName(), countryList2.getCountryCode());
                this.getZipCodePanel().getCountryListComboBox().addItem(existingCountry);
                this.getZipCodePanel().getCountryListComboBox().setSelectedItem(existingCountry);
            }
        }
    }

    private ArrayList<PostalAddress> makePostalAddresses(Address address) {
        final PostalAddress pa = new PostalAddress();
        PostalAddressElement district = new PostalAddressElement();
        district.setAddressValue(address.getDistrict());
        district.setAddressCode(address.getDistrictCode());
        pa.setDistrict(district);
        PostalAddressElement subDistrict = new PostalAddressElement();
        subDistrict.setAddressValue(address.getSubDistrict());
        subDistrict.setAddressCode(address.getSubDistrictCode());
        pa.setSubDistrict(subDistrict);
        PostalAddressElement vtc = new PostalAddressElement();
        vtc.setAddressValue(address.getVTC());
        vtc.setAddressCode(address.getVTCCode());
        pa.setVtc(vtc);
        PostalAddressElement pinCode = new PostalAddressElement();
        pinCode.setAddressValue(address.getPinCodeValue());
        pinCode.setAddressCode(address.getPinCodeValue());
        pa.setPinCode(pinCode);
        PostalAddressElement state = new PostalAddressElement();
        state.setAddressValue(address.getState());
        state.setAddressCode(address.getStateCode());
        pa.setState(state);
        return new ArrayList<PostalAddress>(){
            {
                this.add(0, pa);
            }
        };
    }

    public void setEditable(boolean editable, boolean isNriAddress) {
        if (!isNriAddress) {
            this.getCareofPanel().setEditable(false);
            this.getHousePanel().setEditable(editable);
            this.getLandmarkPanel().setEditable(editable);
            this.getLocalityPanel().setEditable(editable);
            this.getPincodePanel().setEditable(editable);
            this.getPostOfficePanel().setEditable(editable);
            this.getStreetPanel().setEditable(editable);
        } else {
            this.getAddressPanelOne().addressTextField.setEditable(editable);
            this.getAddressPanelTwo().addressTextField.setEditable(editable);
            this.getAddressPanelThree().addressTextField.setEditable(editable);
            this.getZipCodePanel().getzipcodeTextField().setEditable(editable);
            this.getZipCodePanel().countryList.removeAllItems();
            this.getZipCodePanel().countryList.addItem(new Country("Select", ""));
        }
    }

    public void setPostOfficeEditable() {
        this.getPostOfficePanel().getPostOfficeTextField().setEditable(false);
        this.getPostOfficePanel().getPostOfficeTextField().setEnabled(true);
    }

    public void setEveryFieldEnabled(boolean enable, boolean isNriAddress) {
        if (isNriAddress) {
            this.getAddressPanelOne().addressTextField.setEditable(enable);
            this.getAddressPanelTwo().addressTextField.setEditable(enable);
            this.getAddressPanelThree().addressTextField.setEditable(enable);
            this.getZipCodePanel().getzipcodeTextField().setEditable(enable);
        } else {
            this.getCareofPanel().getCareofTextField().setEnabled(enable);
            this.getCareofPanel().getLocCareOf().setEnabled(enable);
            this.getHousePanel().getHouseTextField().setEnabled(enable);
            this.getHousePanel().getLocalHouse().setEnabled(enable);
            this.getStreetPanel().getStreetTextField().setEnabled(enable);
            this.getStreetPanel().getLocalStreet().setEnabled(enable);
            this.getLocalityPanel().getLocalityTextField().setEnabled(enable);
            this.getLocalityPanel().getLocalLocality().setEnabled(enable);
            this.getLandmarkPanel().getLandmark().setEnabled(enable);
            this.getLandmarkPanel().getLocalLandmark().setEnabled(enable);
            this.getPostOfficePanel().getPostOfficeTextField().setEnabled(enable);
            this.getPostOfficePanel().locPostOffField.setEnabled(enable);
            this.getPincodePanel().getPincodeTextField().setEnabled(enable);
            this.getPincodePanel().locPinField.setEnabled(enable);
        }
    }

    public CareOfPanel getCareofPanel() {
        return this.careofPanel;
    }

    public AddressPanel getAddressPanelOne() {
        return this.addressone;
    }

    public AddressPanel getAddressPanelTwo() {
        return this.addresstwo;
    }

    public AddressPanel getAddressPanelThree() {
        return this.addressthree;
    }

    public HousePanel getHousePanel() {
        return this.housePanel;
    }

    public StreetPanel getStreetPanel() {
        return this.streetPanel;
    }

    public LocalityPanel getLocalityPanel() {
        return this.localityPanel;
    }

    public VillagePanel getVillagePanel() {
        return this.villagePanel;
    }

    public DistrictPanel getDistrictPanel() {
        return this.districtPanel;
    }

    public PostOfficePanel getPostOfficePanel() {
        return this.postOfficePanel;
    }

    public StatePanel getStatePanel() {
        return this.statePanel;
    }

    public PincodePanel getPincodePanel() {
        return this.pincodePanel;
    }

    public ZipcodePanel getZipCodePanel() {
        return this.zipCodePanel;
    }

    public LandmarkPanel getLandmarkPanel() {
        return this.landmarkPanel;
    }

    public EmailPanel getEmailPanel() {
        return this.emailPanel;
    }

    public MobilePanel getMobilePanel() {
        return this.mobilePanel;
    }

    public JComponent getTab() {
        return this.contactPanel;
    }

    public void setMandatory(boolean isMandatory) {
        if (this.enrollmentService.doesNriHaveForeignAddress()) {
            this.addressone.setMandatory(isMandatory, 1);
            this.addresstwo.setMandatory(isMandatory, 2);
            this.zipCodePanel.setMandatory(isMandatory);
        } else {
            this.villagePanel.setMandatory(isMandatory);
            this.districtPanel.setMandatory(isMandatory);
            this.postOfficePanel.setMandatory(isMandatory);
            this.statePanel.setMandatory(isMandatory);
            this.pincodePanel.setMandatory(isMandatory);
        }
    }
}

