/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class EmailPanel
implements IViewElementComposite {
    private JLabel heading;
    private IEventContext eventContext;
    private IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="generateOTP", using=StandardSwingElementFactory.class)
    private JButton generateOtpButton;
    @ExportViewElement(as="resEmail", using=StandardSwingElementFactory.class)
    private PlaceholderTextField emailTextField;
    private JLabel verifyIndicator;
    private JLabel verifyLabel;
    private final EnrollmentService enrollmentService;

    EmailPanel(IEventContext eventContext, IResourceBundleContext enrolRbctx, EnrollmentService enrollmentService) {
        this.eventContext = eventContext;
        this.enrolRbctx = enrolRbctx;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create(boolean emailPresent) {
        JPanel emailPanel = new JPanel();
        this.heading = new JLabel();
        this.generateOtpButton = new JButton("Validate OTP");
        this.generateOtpButton.setEnabled(false);
        this.generateOtpButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.verifyIndicator = new JLabel();
        this.verifyLabel = new JLabel();
        this.emailTextField = new PlaceholderTextField();
        this.verifyIndicator.setVisible(false);
        this.verifyLabel.setVisible(false);
        emailPanel.setBackground(Color.WHITE);
        emailPanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(new Color(52, 73, 94));
        if (emailPresent) {
            this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EMAIL.toString(), new Object[0])));
        } else {
            this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EMAIL.toString(), new Object[0]));
        }
        emailPanel.add((Component)this.heading, new AbsoluteConstraints(10, 10, 200, 20));
        this.emailTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.emailTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.emailTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_EMAIL.toString(), new Object[0]));
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        new AutoSuggestDecorator((JTextField)this.emailTextField).name("email").delimiters("@");
        ilv.applyEmailILV(this.emailTextField);
        this.emailTextField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.emailTextField));
        emailPanel.add((Component)this.emailTextField, new AbsoluteConstraints(10, 30, 322, 39));
        emailPanel.add((Component)this.generateOtpButton, new AbsoluteConstraints(347, 30, 143, 39));
        this.verifyIndicator.setText("\ue86c");
        this.verifyIndicator.setFont(new Font("Material Icons", 0, 20));
        this.verifyIndicator.setForeground(Color.decode("#27AE61"));
        this.verifyIndicator.setHorizontalAlignment(0);
        emailPanel.add((Component)this.verifyIndicator, new AbsoluteConstraints(10, 75, -1, -1));
        this.verifyLabel.setText("Email id verified");
        this.verifyLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 12.0f));
        this.verifyLabel.setForeground(Color.decode("#27AE61"));
        emailPanel.add((Component)this.verifyLabel, new AbsoluteConstraints(35, 75, -1, -1));
        this.generateOtpButton.addActionListener(this::generateOtpWindow);
        this.generateOtpButton.setActionCommand("Email");
        return emailPanel;
    }

    private void generateOtpWindow(ActionEvent e) {
        boolean isValidEmail;
        boolean isEmailUpdate = this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getEmail().hasToBeUpdated();
        boolean bl = isValidEmail = !this.enrollmentService.getDemoContactDetails().getEmail().getExistingEmail().equals(this.enrollmentService.getDemoContactDetails().getEmail().email());
        if (isEmailUpdate) {
            if (isValidEmail) {
                ThreadPool.commonPool().submit(() -> ((ActionListener)this.eventContext.getEventListener("email_resend_otp", ActionListener.class)).actionPerformed(e));
            } else {
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_010.getReason()), ErrorCodes.UC_GEN_010.getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_010.getReason(), (Component)((JComponent)e.getSource()), ErrorCodes.UC_GEN_010.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
                return;
            }
        }
        ((ActionListener)this.eventContext.getEventListener("generateOTP", ActionListener.class)).actionPerformed(e);
    }

    public JTextField getEmailTextField() {
        return this.emailTextField;
    }

    public JButton getGenerateOtpButton() {
        return this.generateOtpButton;
    }

    public void setValid(boolean valid) {
        this.verifyIndicator.setVisible(valid);
        this.verifyLabel.setVisible(valid);
    }

    public void setMandatory(boolean isMandatory) {
        if (isMandatory) {
            this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EMAIL.toString(), new Object[0])));
        } else {
            this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EMAIL.toString(), new Object[0]));
        }
    }
}

