/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.swing.translit.IMTranslitElementFactory;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class HousePanel
implements IDemoTabConstants,
IViewElementComposite {
    @ExportViewElement(as="eID_DemoTab_House", using=StandardSwingElementFactory.class)
    private PlaceholderTextField houseTextField;
    @ExportViewElement(as="eID_DemoTab_THouse", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locHouseField;
    private final IResourceBundleContext enrolRbctx;
    private IMTranslitFieldBuilder imb;

    HousePanel(IResourceBundleContext enrolRbctx, IMTranslitFieldBuilder imb) {
        this.enrolRbctx = enrolRbctx;
        this.imb = imb;
    }

    public JComponent create() {
        JPanel housePanel = new JPanel();
        JLabel heading = new JLabel();
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        this.houseTextField = new PlaceholderTextField();
        housePanel.setBackground(Color.WHITE);
        housePanel.setLayout((LayoutManager)new AbsoluteLayout());
        heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        heading.setForeground(new Color(52, 73, 94));
        heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.HOUSE.toString(), new Object[0]));
        housePanel.add((Component)heading, new AbsoluteConstraints(10, 10, 300, 20));
        this.houseTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.houseTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.houseTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_DETAIL.toString(), new Object[0]));
        housePanel.add((Component)this.houseTextField, new AbsoluteConstraints(10, 30, 480, 39));
        ilv.applyFreeAddressILV(this.houseTextField);
        this.locHouseField = this.imb.createIMField(this.houseTextField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locHouseField);
        this.locHouseField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locHouseField));
        return housePanel;
    }

    public JComponent createEnrolment() {
        JPanel housePanel = (JPanel)this.create();
        LocaleLabel heading = CommonUtilsUC.createLocalUC(this.enrolRbctx, "label-tlit:addr.house");
        housePanel.add((Component)heading, new AbsoluteConstraints(530, 10, -1, 20));
        this.locHouseField.setFont(new Font(heading.getFont().getName(), 0, 14));
        this.locHouseField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        housePanel.add((Component)this.locHouseField, new AbsoluteConstraints(530, 30, 470, 39));
        return housePanel;
    }

    public void setEditable(boolean enable) {
        this.houseTextField.setEditable(enable);
        this.locHouseField.setEditable(enable);
    }

    public JTextField getHouseTextField() {
        return this.houseTextField;
    }

    public JTextField getLocalHouse() {
        return this.locHouseField;
    }
}

