/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilePanel
implements IViewElementComposite {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobilePanel.class);
    private JLabel isdHeading;
    private JLabel mobileHeading;
    @ExportViewElement(as="contactPanel", using=StandardSwingElementFactory.class)
    private JPanel mobilePanel;
    private JLabel isdList;
    private IEventContext eventContext;
    private IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="generateOTP", using=StandardSwingElementFactory.class)
    private JButton generateOtpButton;
    @ExportViewElement(as="resMobile", using=StandardSwingElementFactory.class)
    private PlaceholderTextField mobileTextField;
    private EnrollmentService enrollmentService;
    private JLabel verifyIndicator;
    private JLabel verifyLabel;

    public MobilePanel(IEventContext eventContext, IResourceBundleContext enrolRbctx, EnrollmentService enrollmentService) {
        this.eventContext = eventContext;
        this.enrolRbctx = enrolRbctx;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        this.mobilePanel = new JPanel();
        this.isdHeading = new JLabel();
        this.mobileHeading = new JLabel();
        this.isdList = new JLabel();
        this.mobileTextField = new PlaceholderTextField();
        this.generateOtpButton = new JButton("Validate OTP");
        this.verifyIndicator = new JLabel();
        this.verifyLabel = new JLabel();
        this.generateOtpButton.setEnabled(false);
        this.mobileHeading.setBackground(new Color(52, 73, 94));
        this.generateOtpButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.verifyIndicator.setVisible(false);
        this.verifyLabel.setVisible(false);
        this.mobilePanel.setBackground(Color.WHITE);
        this.mobilePanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.isdHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.isdHeading.setForeground(new Color(52, 73, 94));
        this.isdHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ISD.toString(), new Object[0]));
        this.mobilePanel.add((Component)this.isdHeading, new AbsoluteConstraints(10, 10, 111, 20));
        this.mobileHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.mobileHeading.setForeground(new Color(52, 73, 94));
        if (!this.enrollmentService.getDemoContactDetails().getMobile().number().isEmpty()) {
            this.mobileHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOBILE.toString(), new Object[0])));
        } else {
            this.mobileHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOBILE.toString(), new Object[0]));
        }
        this.mobilePanel.add((Component)this.mobileHeading, new AbsoluteConstraints(150, 10, -1, 20));
        this.isdList.setText("Select");
        this.isdList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.isdList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.isdList.setForeground(new Color(52, 73, 94));
        this.mobilePanel.add((Component)this.isdList, new AbsoluteConstraints(10, 30, 130, 39));
        this.mobileTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.mobileTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.mobileTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_MOBILE.toString(), new Object[0]));
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        ilv.applyMobileILV(this.mobileTextField, null);
        this.mobileTextField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.mobileTextField));
        this.mobilePanel.add((Component)this.mobileTextField, new AbsoluteConstraints(150, 30, 180, 39));
        this.mobilePanel.add((Component)this.generateOtpButton, new AbsoluteConstraints(350, 30, 130, 39));
        this.generateOtpButton.addActionListener(this::generateOtpWindow);
        this.generateOtpButton.setActionCommand("Mobile");
        this.verifyIndicator.setText("\ue86c");
        this.verifyIndicator.setFont(new Font("Material Icons", 0, 20));
        this.verifyIndicator.setForeground(Color.decode("#27AE61"));
        this.verifyIndicator.setHorizontalAlignment(0);
        this.mobilePanel.add((Component)this.verifyIndicator, new AbsoluteConstraints(10, 75, -1, -1));
        this.verifyLabel.setText("Mobile number verified");
        this.verifyLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 12.0f));
        this.verifyLabel.setForeground(Color.decode("#27AE61"));
        this.mobilePanel.add((Component)this.verifyLabel, new AbsoluteConstraints(35, 75, -1, -1));
        return this.mobilePanel;
    }

    private void generateOtpWindow(ActionEvent e) {
        boolean isMobileUpdate;
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        boolean isValid = !mobile.getExistingNumber().equals(mobile.number());
        boolean bl = isMobileUpdate = this.enrollmentService.isUpdateUC() && this.enrollmentService.getFieldsUpdateCount().getMobile().hasToBeUpdated();
        if (isMobileUpdate) {
            if (isValid) {
                ((ActionListener)this.eventContext.getEventListener("mobile_resend_otp", ActionListener.class)).actionPerformed(e);
            } else {
                LOGGER.info("Invalid mobile number");
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception("Entered same mobile number for mobile update"), ErrorCodes.UC_MOB_001.getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Please enter different mobile number than existing mobile number", null);
                return;
            }
        }
        ((ActionListener)this.eventContext.getEventListener("generateOTP", ActionListener.class)).actionPerformed(e);
    }

    public JTextField getMobileTextField() {
        return this.mobileTextField;
    }

    public JLabel getIsdList() {
        return this.isdList;
    }

    public JButton getGenerateOtpButton() {
        return this.generateOtpButton;
    }

    public void setValid(boolean valid) {
        this.verifyIndicator.setVisible(valid);
        this.verifyLabel.setVisible(valid);
    }

    public void setMandatory(boolean isMandatory) {
        if (isMandatory) {
            this.mobileHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOBILE.toString(), new Object[0])));
        } else {
            this.mobileHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOBILE.toString(), new Object[0]));
        }
    }
}

