/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class OtpPanel {
    protected JButton resendButton;
    protected JButton verifyButton;
    protected JPanel mainPanel;
    protected List<JTextField> fields;
    private boolean isMobile;
    private EnrollmentService enrollmentService;
    protected JLabel resendLabel;

    public OtpPanel(boolean isMobile, EnrollmentService enrollmentService) {
        this.isMobile = isMobile;
        this.enrollmentService = enrollmentService;
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel title = new JLabel();
        JLabel heading = new JLabel();
        JTextField field1 = new JTextField();
        JTextField field2 = new JTextField();
        JTextField field3 = new JTextField();
        JTextField field4 = new JTextField();
        JTextField field5 = new JTextField();
        JTextField field6 = new JTextField();
        this.verifyButton = new JButton();
        JLabel label = new JLabel();
        this.resendButton = new JButton();
        this.resendLabel = new JLabel();
        field1.setName("otp1");
        field2.setName("otp2");
        field3.setName("otp3");
        field4.setName("otp4");
        field5.setName("otp5");
        field6.setName("otp6");
        this.fields = new ArrayList<JTextField>(Arrays.asList(field1, field2, field3, field4, field5, field6));
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.mainPanel.setSize(472, 329);
        this.mainPanel.setPreferredSize(new Dimension(472, 329));
        this.mainPanel.setMaximumSize(new Dimension(472, 329));
        this.mainPanel.setMinimumSize(new Dimension(472, 329));
        String text = this.isMobile ? "Mobile number" : "Email ID";
        title.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 24.0f));
        title.setText("<html>Please enter the OTP to confirm your " + text + "</html>");
        title.setForeground(Color.decode("#34495E"));
        this.mainPanel.add((Component)title, new AbsoluteConstraints(0, 30, 470, 68));
        String id = this.isMobile ? this.enrollmentService.getDemoContactDetails().getMobile().number() : this.enrollmentService.getDemoContactDetails().getEmail().email();
        heading.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        heading.setText("A OTP has been sent to " + id);
        heading.setForeground(Color.decode("#34495E"));
        heading.setHorizontalAlignment(0);
        this.mainPanel.add((Component)heading, new AbsoluteConstraints(0, 118, 470, 20));
        int gap = 60;
        for (JTextField field : this.fields) {
            field.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
            field.setHorizontalAlignment(0);
            field.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
            field.setForeground(Color.decode("#34495E"));
            this.mainPanel.add((Component)field, new AbsoluteConstraints(6 + gap, 158, 40, 50));
            gap += 60;
        }
        this.verifyButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 18.0f));
        this.verifyButton.setText("Verify");
        this.verifyButton.setForeground(Color.decode("#297FB8"));
        this.verifyButton.setEnabled(false);
        this.mainPanel.add((Component)this.verifyButton, new AbsoluteConstraints(159, 228, 154, 46));
        this.resendLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 12.0f));
        this.resendLabel.setHorizontalAlignment(0);
        this.resendLabel.setText("Resend OTP in 60 Seconds");
        this.mainPanel.add((Component)this.resendLabel, new AbsoluteConstraints(134, 291, -1, -1));
        this.resendButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 12.0f));
        this.resendButton.setText("Resend");
        this.resendButton.setOpaque(false);
        this.resendButton.setContentAreaFilled(false);
        this.resendButton.setBorderPainted(false);
        this.resendButton.setForeground(Color.decode("#297FB8"));
        this.resendButton.setEnabled(false);
        this.mainPanel.add((Component)this.resendButton, new AbsoluteConstraints(285, 285, -1, -1));
    }

    public boolean isValidOtp() {
        for (JTextField field : this.fields) {
            if (!field.getText().isEmpty()) continue;
            return false;
        }
        return true;
    }
}

