/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.OtpPanel;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class OtpViewPeer
extends StandardViewPeer {
    @ExportViewElement(as="eID_Otp", using=StandardSwingElementFactory.class)
    JTextField otpField;
    @ExportViewElement(as="eID_email_otp", using=StandardSwingElementFactory.class)
    JTextField emailOtpField;
    private IResourceBundleContext rbCtxt;
    private EnrollmentService enrollmentService;
    private OtpPanel otpPanel;
    private boolean mobile;
    private Timer buttonTimer;
    private int interval;

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    protected void prepareImpl() {
        this.otpPanel = new OtpPanel(this.mobile, this.enrollmentService);
        this.otpField = new JTextField();
        this.emailOtpField = new JTextField();
        int index = 0;
        for (JTextField field : this.otpPanel.fields) {
            field.setDocument((Document)new FBNumericDocument((JTextComponent)field, 1));
            field.addKeyListener(new DigitInputListener(index++));
        }
        this.otpPanel.verifyButton.addActionListener(e -> {
            if (this.otpPanel.isValidOtp()) {
                String otp = "";
                for (JTextField field : this.otpPanel.fields) {
                    otp = otp + field.getText();
                }
                if (this.mobile) {
                    this.otpField.setText(otp);
                    ((ActionListener)this.getEventContext().getEventListener("hID_Otp_Submit", ActionListener.class)).actionPerformed(e);
                } else {
                    this.emailOtpField.setText(otp);
                    ((ActionListener)this.getEventContext().getEventListener("hID_Email_Otp_Submit", ActionListener.class)).actionPerformed(e);
                }
            }
        });
        this.setTimer();
        this.otpPanel.resendButton.addActionListener(this::resendListener);
        this.setContentPane(this.otpPanel.mainPanel);
    }

    private void resendListener(ActionEvent e) {
        this.otpPanel.fields.forEach(textField -> textField.setText(""));
        this.otpPanel.verifyButton.setEnabled(this.otpPanel.isValidOtp());
        this.setTimer();
        this.otpPanel.resendButton.setEnabled(false);
        ((ActionListener)this.getEventContext().getEventListener(this.mobile ? "mobile_resend_otp" : "email_resend_otp", ActionListener.class)).actionPerformed(e);
    }

    private void setTimer() {
        this.buttonTimer = new Timer();
        this.interval = 60;
        this.buttonTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((OtpViewPeer)OtpViewPeer.this).otpPanel.resendLabel.setText("Resend OTP in " + OtpViewPeer.this.setInterval() + " Seconds.");
            }
        }, 1000L, 1000L);
    }

    private int setInterval() {
        if (this.interval == 1) {
            this.buttonTimer.cancel();
            this.otpPanel.resendLabel.setText("Don't receive the OTP?");
            this.otpPanel.resendButton.setEnabled(true);
        }
        return --this.interval;
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
        if (this.otpPanel != null) {
            this.otpPanel.mainPanel.removeAll();
        }
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setRbCtxt(IResourceBundleContext rbCtxt) {
        this.rbCtxt = rbCtxt;
    }

    private class DigitInputListener
    implements KeyListener {
        private final int index;

        public DigitInputListener(int index) {
            this.index = index;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (!Character.isDigit(e.getKeyChar())) {
                e.consume();
            } else {
                JTextField source = (JTextField)e.getSource();
                if (source != ((OtpViewPeer)OtpViewPeer.this).otpPanel.fields.get(5)) {
                    int nextField = this.getNextFieldIndex();
                    ((OtpViewPeer)OtpViewPeer.this).otpPanel.fields.get(nextField).requestFocus();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 8 && this.index > 0) {
                ((OtpViewPeer)OtpViewPeer.this).otpPanel.fields.get(this.index - 1).requestFocus();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ((OtpViewPeer)OtpViewPeer.this).otpPanel.verifyButton.setEnabled(OtpViewPeer.this.otpPanel.isValidOtp());
        }

        private int getNextFieldIndex() {
            for (int i = 0; i < 5; ++i) {
                if (this.index != i) continue;
                return i + 1;
            }
            return 0;
        }
    }
}

