/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.contact;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.swing.translit.IMTranslitElementFactory;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class StreetPanel
implements IDemoTabConstants,
IViewElementComposite {
    @ExportViewElement(as="eID_DemoTab_Street", using=StandardSwingElementFactory.class)
    private PlaceholderTextField streetTextField;
    @ExportViewElement(as="eID_DemoTab_TStreet", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locStreetField;
    private final IResourceBundleContext enrolRbctx;
    private IMTranslitFieldBuilder imb;

    StreetPanel(IResourceBundleContext enrolRbctx, IMTranslitFieldBuilder imb) {
        this.enrolRbctx = enrolRbctx;
        this.imb = imb;
    }

    public JComponent create() {
        JPanel streetPanel = new JPanel();
        JLabel heading = new JLabel();
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        this.streetTextField = new PlaceholderTextField();
        streetPanel.setBackground(Color.WHITE);
        streetPanel.setLayout((LayoutManager)new AbsoluteLayout());
        heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        heading.setForeground(new Color(52, 73, 94));
        heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.STREET.toString(), new Object[0]));
        streetPanel.add((Component)heading, new AbsoluteConstraints(10, 10, 200, 20));
        this.streetTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.streetTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.streetTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_DETAIL.toString(), new Object[0]));
        streetPanel.add((Component)this.streetTextField, new AbsoluteConstraints(10, 30, 480, 39));
        ilv.applyFreeAddressILV(this.streetTextField);
        this.locStreetField = this.imb.createIMField(this.streetTextField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locStreetField);
        this.locStreetField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locStreetField));
        return streetPanel;
    }

    public JComponent createEnrolment() {
        JPanel streetPanel = (JPanel)this.create();
        LocaleLabel heading = CommonUtilsUC.createLocalUC(this.enrolRbctx, "label-tlit:addr.street");
        streetPanel.add((Component)heading, new AbsoluteConstraints(530, 10, -1, 20));
        this.locStreetField.setFont(new Font(heading.getFont().getName(), 0, 14));
        this.locStreetField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        streetPanel.add((Component)this.locStreetField, new AbsoluteConstraints(530, 30, 470, 39));
        return streetPanel;
    }

    public void setEditable(boolean enable) {
        this.streetTextField.setEditable(enable);
        this.locStreetField.setEditable(enable);
    }

    public JTextField getStreetTextField() {
        return this.streetTextField;
    }

    public JTextField getLocalStreet() {
        return this.locStreetField;
    }
}

