/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.control;

import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentHandler
implements IEventContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsentHandler.class);
    private final EnrollmentService enrollmentService;
    private final IOnScreenDisplay osd;
    private final GrpcService grpcService;
    private IEventContext evtCtxt;
    private final IPinCodeService pinCodeService;
    private final TokenManager consentTokenManager;
    private final TokenManager hofConsentTokenManager;
    private final IResourceBundleContext enrolRbCtxt;
    private ILiteEvent mainEvent;

    public ConsentHandler(EnrollmentService enrollmentService, IOnScreenDisplay osd, TokenManager consentTokenManager, TokenManager hofConsentTokenManager, IResourceBundleContext enrolRbCtxt, IPinCodeService pinCodeService) {
        this.enrollmentService = enrollmentService;
        this.osd = osd;
        this.pinCodeService = pinCodeService;
        this.consentTokenManager = consentTokenManager;
        this.hofConsentTokenManager = hofConsentTokenManager;
        this.enrolRbCtxt = enrolRbCtxt;
        this.grpcService = GrpcService.getInst();
    }

    @GenericEventHandler(value="get_event")
    public void getMainEvent(ILiteEvent evt) {
        this.mainEvent = evt;
    }

    @EventHandler(name="renderConsent", method="actionPerformed")
    public void displayConsent(ILiteEvent evt) {
        boolean isResidentConsentRequired;
        boolean isHofConsentRequired = this.enrollmentService.isHofEnrollment() || FieldInfoUtils.isHofConsentRequired();
        boolean bl = isResidentConsentRequired = !this.enrollmentService.isNewEnrollmentUC() && FieldInfoUtils.isConsentRequired();
        if (this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isHofEnrollment()) {
            this.startEnrolment();
        } else if (!this.consentTokenManager.isValid() && (isHofConsentRequired || isResidentConsentRequired)) {
            String scaffoldId = this.osd.compose("operatorLoginWin", "consentLoginPreview");
            this.enrollmentService.setHofConsentGoingOn(!this.hofConsentTokenManager.isValid() && isHofConsentRequired);
            this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
        } else {
            this.afterConsentSuccess();
        }
    }

    @GenericEventHandler(value="consent success")
    public void afterConsentSuccess() {
        if (this.enrollmentService.isHofConsentGoingOn()) {
            this.grpcService.setConsentTokenManager(this.hofConsentTokenManager);
            this.hofConsentTokenManager.setUniversalClientTransaction(true);
        } else {
            this.grpcService.setConsentTokenManager(this.consentTokenManager);
            this.consentTokenManager.setUniversalClientTransaction(true);
        }
        LOGGER.info("Consent Taken Successfully. Preparing other tabs");
        if (this.enrollmentService.isHofConsentGoingOn()) {
            this.enrollmentService.setHofConsentGoingOn(false);
            String scaffoldId = this.osd.compose("operatorLoginWin", "consentLoginPreview");
            if (!this.enrollmentService.isNewEnrollmentUC() && FieldInfoUtils.isConsentRequired()) {
                this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
            } else {
                this.startEnrolment();
            }
        } else if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isDemoUpdate() && FieldInfoUtils.isConsentRequired()) {
            this.profileFetch();
        } else {
            this.startEnrolment();
        }
    }

    private void profileFetch() {
        LOGGER.info("Making Profile Request");
        ILiteView view = this.osd.getView(this.mainEvent.getViewId());
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext(null);
        ThreadPool.commonPool().submit(() -> {
            try {
                Utils.showProgressBar(veCtxt, "Fetching Demographic detail, Please wait..");
                String uid = Strings.isNullOrEmpty((String)this.enrollmentService.getResidentUid()) ? this.enrollmentService.getHofUid() : this.enrollmentService.getResidentUid();
                String sid = this.enrollmentService.getSid();
                UcDemographicServiceProto.ProfileDataRequest profileDataRequest = UcDemographicServiceProto.ProfileDataRequest.newBuilder().setUid(uid).setSid(sid).build();
                this.grpcService.getProfileData(profileDataRequest, response -> this.handleProfileResponse((UcDemographicServiceProto.ProfileDataResponse)response, veCtxt), this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException exception) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in profile fetch :: {}, transaction id :: {}", (Object)exception.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                this.handleError(exception);
            }
        });
    }

    private void startEnrolment() {
        this.evtCtxt.fireGenericEvent("start update enrollment", new Object[]{this.mainEvent});
    }

    private void handleProfileResponse(UcDemographicServiceProto.ProfileDataResponse profileDataResponse, IVisualExecutionContext veCtxt) {
        LOGGER.info("Demographics fetched successfully");
        if (CommonUtilsUC.isAgeFiveOrLess(profileDataResponse.getDob())) {
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_012.getReason(), (Component)((JComponent)this.mainEvent.getEvent().getSource()), ErrorCodes.UC_GEN_012.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            OnlineGatewayException exception = new OnlineGatewayException(ErrorCodes.UC_GEN_012.getReason(), ErrorCodes.UC_GEN_012.getReason(), ErrorCodes.UC_GEN_012.getErrorCode());
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
            return;
        }
        Utils.cancelProgressBar(veCtxt);
        try {
            this.enrollmentService.updateDemographicsDataInEnrolment(profileDataResponse, this.pinCodeService);
            this.startEnrolment();
        }
        catch (OnlineGatewayException e) {
            this.handleError(e);
        }
    }

    private void handleUOSErrorResponse(UosResponse errorResponse) throws OnlineGatewayException {
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        throw OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse), (String)this.enrollmentService.getTransactionId(), null);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    private IVisualExecutionContext createVisualExecutionContext(Component component) {
        return new ModalVisualExecutionContext(component, false, new L10nDecorator(this.enrolRbCtxt, false));
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }
}

