/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.control;

import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountHandler.class);
    private final IOnScreenDisplay osd;
    private final EnrollmentService enrollmentService;
    private final IResourceBundleContext enrolRbCtxt;
    private final GrpcService grpcService;

    public CountHandler(EnrollmentService enrollmentService, IOnScreenDisplay osd, IResourceBundleContext enrolRbCtxt, TokenManager opTokenManager) {
        this.enrollmentService = enrollmentService;
        this.osd = osd;
        this.enrolRbCtxt = enrolRbCtxt;
        this.grpcService = GrpcService.getInst();
        this.grpcService.setGrpcConfigUOS(enrollmentService.getOauthGwApiService().getGatewayPreference().getGrpcServicesUrl());
        this.grpcService.setTokenManager(opTokenManager);
    }

    @EventHandler(name="Display uid window", method="actionPerformed")
    public void displayUIdWindow(ILiteEvent evt) {
        this.grpcService.setTransactionId(this.enrollmentService.getTransactionId());
        String scaffoldId = this.osd.compose("residentUidPopupWin", "residentUidPreview");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="initiate update", method="actionPerformed")
    public void initiateUpdate(ILiteEvent evt) {
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext(null);
        if (Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            this.grpcCountCall(veCtxt);
        }
    }

    private void grpcCountCall(IVisualExecutionContext veCtxt) {
        ThreadPool.commonPool().submit(() -> {
            try {
                LOGGER.info("Update Call Request Started");
                Utils.showProgressBar(veCtxt, "Fetching update limits, Please wait..");
                UcDemographicServiceProto.DemographicCountRequest countRequest = UcDemographicServiceProto.DemographicCountRequest.newBuilder().setUid(this.enrollmentService.getResidentUid()).build();
                this.grpcService.getUpdateCount(countRequest, countResponse -> this.handleCountResponse((UcDemographicServiceProto.DemographicCountResponse)countResponse, veCtxt), this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException exception) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in Grpc Count Call");
                this.handleError(exception);
            }
        });
    }

    private void handleCountResponse(UcDemographicServiceProto.DemographicCountResponse countResponse, IVisualExecutionContext veCtxt) {
        LOGGER.info("Grpc count call successfully completed");
        try {
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            fieldsUpdateCount.setName(countResponse.getName());
            fieldsUpdateCount.setDob(countResponse.getDob());
            fieldsUpdateCount.setAddress(countResponse.getAddress());
            fieldsUpdateCount.setGender(countResponse.getGender());
            fieldsUpdateCount.setEmail(countResponse.getEmail());
            fieldsUpdateCount.setMobile(countResponse.getMobile());
            fieldsUpdateCount.setBio();
            fieldsUpdateCount.setActivationAadhaar();
            fieldsUpdateCount.setPoa();
            fieldsUpdateCount.setPoi();
            fieldsUpdateCount.setPob();
            fieldsUpdateCount.setPor();
            fieldsUpdateCount.setPof();
            Utils.cancelProgressBar(veCtxt);
            this.enrollmentService.residentUpdateInfoSuccess();
            this.enrollmentService.countScreenSuccess();
        }
        catch (Exception e) {
            LOGGER.error("Error in Grpc Count Response");
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_CNT_001, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    @EventHandler(name="closeWin", method="actionPerformed")
    public void closeWinImpl(ILiteEvent evt) {
        try {
            if (this.osd != null) {
                this.osd.dispose(evt.getScaffoldId());
                this.osd.disposeView(evt.getViewId());
            } else {
                LOGGER.info("OSD is not initialized.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing window: " + e.getMessage());
        }
    }

    private void handleUOSErrorResponse(UosResponse errorResponse) throws OnlineGatewayException {
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        throw OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse), (String)this.enrollmentService.getTransactionId(), null);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    private IVisualExecutionContext createVisualExecutionContext(Component component) {
        return new ModalVisualExecutionContext(component, false, new L10nDecorator(this.enrolRbCtxt, false));
    }
}

