/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.control;

import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.Rgs;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrievanceHandler
implements IEventContextAware {
    private IEventContext evtCtxt;
    private static final Logger LOGGER = LoggerFactory.getLogger(GrievanceHandler.class);
    private final EnrollmentService enrollmentService;
    private final IResourceBundleContext enrolRbCtxt;
    private final GrpcService grpcService;

    public GrievanceHandler(EnrollmentService enrollmentService, IResourceBundleContext enrolRbCtxt, TokenManager opTokenManager) {
        this.enrollmentService = enrollmentService;
        this.enrolRbCtxt = enrolRbCtxt;
        this.grpcService = GrpcService.getInst();
        this.grpcService.setGrpcConfigUOS(enrollmentService.getOauthGwApiService().getGatewayPreference().getGrpcServicesUrl());
        this.grpcService.setTokenManager(opTokenManager);
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    @EventHandler(name="get grievance id", method="actionPerformed")
    public void getGrievanceId(ILiteEvent evt) {
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext(null);
        this.grpcGrievanceIdCall(veCtxt);
    }

    private void grpcGrievanceIdCall(IVisualExecutionContext veCtxt) {
        ThreadPool.commonPool().submit(() -> {
            try {
                LOGGER.info("Get Grievance Id Request Started");
                Utils.showProgressBar(veCtxt, "Verifying, Please wait..");
                Rgs.GetGrievanceIdRequest request = Rgs.GetGrievanceIdRequest.newBuilder().setLinkedEid(this.enrollmentService.getLinkedEid()).build();
                this.grpcService.getGrievanceId(request, response -> this.handleGrievanceResponse((Rgs.GetGrievanceIdResponse)response, veCtxt), this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException exception) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in Grpc Count Call");
                this.handleError(exception);
            }
        });
    }

    private void handleGrievanceResponse(Rgs.GetGrievanceIdResponse response, IVisualExecutionContext veCtxt) {
        LOGGER.info("Grpc grievance id call successfully completed");
        try {
            this.enrollmentService.setGrievanceId(response.getGrievanceId());
            Utils.cancelProgressBar(veCtxt);
            this.enrollmentService.grievanceStatusSuccess();
        }
        catch (Exception e) {
            LOGGER.error("Error in Grpc Get Grievance Id Response");
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_CNT_001, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private void handleUOSErrorResponse(UosResponse errorResponse) throws OnlineGatewayException {
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail()), (Object)errorResponse);
        throw OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail()), (String)this.enrollmentService.getTransactionId(), null);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    private IVisualExecutionContext createVisualExecutionContext(Component component) {
        return new ModalVisualExecutionContext(component, false, new L10nDecorator(this.enrolRbCtxt, false));
    }
}

