/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.control;

import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.protobuf.Mbu;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.mbu.MbuRequirement;
import in.gov.uidai.ec.service.mbu.MbuStatus;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.control.CountHandler;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MbuHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountHandler.class);
    private final IOnScreenDisplay osd;
    private final EnrollmentService enrollmentService;
    private final IResourceBundleContext enrolRbCtxt;
    private final GrpcService grpcService;
    private final IEventContext eventContext;

    public MbuHandler(EnrollmentService enrollmentService, IOnScreenDisplay osd, IResourceBundleContext enrolRbCtxt, TokenManager opTokenManager, IEventContext eventContext) {
        this.enrollmentService = enrollmentService;
        this.osd = osd;
        this.enrolRbCtxt = enrolRbCtxt;
        this.eventContext = eventContext;
        this.grpcService = GrpcService.getInst();
        this.grpcService.setGrpcConfigUOS(enrollmentService.getOauthGwApiService().getGatewayPreference().getGrpcServicesUrl());
        this.grpcService.setTokenManager(opTokenManager);
    }

    @EventHandler(name="mbu handler", method="actionPerformed")
    public void initiateMbu(ILiteEvent evt) {
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext(null);
        this.grpcMbuCall(veCtxt, evt);
    }

    private void grpcMbuCall(IVisualExecutionContext veCtxt, ILiteEvent event) {
        ThreadPool.commonPool().submit(() -> {
            try {
                LOGGER.info("Initiating MBU availability check call");
                Utils.showProgressBar(veCtxt, "Fetching MBU Availability details, Please wait..");
                Mbu.MbuRequest mbuAvailabilityCheck = Mbu.MbuRequest.newBuilder().setUid(this.enrollmentService.getResidentUid()).build();
                this.grpcService.mbuAvailabilityCheck(mbuAvailabilityCheck, mbuResponse -> this.processMbuAvailabilityCheckResponse((Mbu.MbuResponse)mbuResponse, veCtxt, event), this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException exception) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in Grpc MBU Availability Call :: {}, transaction id :: {}", (Object)exception.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                this.handleError(exception);
            }
        });
    }

    private void processMbuAvailabilityCheckResponse(Mbu.MbuResponse mbuResponse, IVisualExecutionContext veCtxt, ILiteEvent event) {
        LOGGER.info("GRPC MBU availability check call successfully completed");
        Utils.cancelProgressBar(veCtxt);
        if (!mbuResponse.getSuccess()) {
            Mbu.ErrorDetail errorDetail = mbuResponse.getErrorDetail();
            OnlineGatewayException onlineGatewayException = OnlineGatewayException.getClientException((String)errorDetail.getErrorCode(), (String)errorDetail.getErrorMessage(), (String)this.enrollmentService.getTransactionId(), null);
            this.handleError(onlineGatewayException);
        } else {
            try {
                MbuStatus mbuStatus = this.prepareMbuStatusFromResponse(mbuResponse.getData());
                this.enrollmentService.setMbuStatus(mbuStatus);
                ActionEvent actionEvent = new ActionEvent(event.getEvent().getSource(), 1, "actionPerformed");
                ((ActionListener)this.eventContext.getEventListener("initiate update", ActionListener.class)).actionPerformed(actionEvent);
            }
            catch (Exception e) {
                LOGGER.error("Error in processing MBU availability check call response :: {}, transaction id :: {}", (Object)e.getMessage(), (Object)this.enrollmentService.getTransactionId());
                OnlineGatewayException onlineGatewayException = OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_MBU_001, (String)this.enrollmentService.getTransactionId(), (Exception)e);
                this.handleError(onlineGatewayException);
            }
        }
    }

    private MbuStatus prepareMbuStatusFromResponse(Mbu.MbuData mbuData) {
        MbuStatus status = new MbuStatus();
        String respStatus = mbuData.getStatus();
        if ("Yes".equalsIgnoreCase(respStatus)) {
            int mbuType = Integer.parseInt(mbuData.getMbu());
            boolean isFreeUpdate = "Yes".equalsIgnoreCase(mbuData.getFreeUpdate());
            status.setBioCaptured("Yes".equalsIgnoreCase(mbuData.getBioCapture()));
            status.setMbuType(mbuType);
            if (isFreeUpdate) {
                status.setMbuRequirement(MbuRequirement.REQUIRED_FREE);
            } else {
                status.setMbuRequirement(MbuRequirement.REQUIRED_PAID);
            }
        } else if ("No".equalsIgnoreCase(respStatus)) {
            status.setMbuRequirement(MbuRequirement.NOT_REQUIRED);
        } else if ("NA".equalsIgnoreCase(respStatus)) {
            status.setMbuRequirement(MbuRequirement.NOT_APPLICABLE);
        }
        return status;
    }

    private void handleUOSErrorResponse(UosResponse errorResponse) throws OnlineGatewayException {
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        throw OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse), (String)this.enrollmentService.getTransactionId(), null);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    private IVisualExecutionContext createVisualExecutionContext(Component component) {
        return new ModalVisualExecutionContext(component, false, new L10nDecorator(this.enrolRbCtxt, false));
    }
}

