/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.control;

import com.google.common.base.Strings;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.json.srnapi.AgeGroup;
import in.gov.uidai.ec.oauthapi.json.srnapi.RequestSubType;
import in.gov.uidai.ec.oauthapi.json.srnapi.RequestType;
import in.gov.uidai.ec.oauthapi.json.srnapi.ResidentType;
import in.gov.uidai.ec.protobuf.FreighterService;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.protobuf.UosProto;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.ResidentUpdateInfo;
import in.gov.uidai.ec.service.gps.GeoData;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidHandler
implements IEventContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidHandler.class);
    private final EnrollmentService enrollmentService;
    private ResidentUpdateInfo residentUpdateInfo;
    private final GrpcService grpcService;
    private final IRegistrationService registrationService;
    private final IOucDataStore oucDataStore;
    private final IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private final IClientDeviceManager cdm;
    private final IResourceBundleContext enrolRbCtxt;
    private static String FOREIGN = "Foreigner";
    private static String NRI = "NRI";

    public SidHandler(EnrollmentService enrollmentService, IRegistrationService registrationService, IOucDataStore oucDataStore, IOnScreenDisplay osd, IClientDeviceManager cdm, IResourceBundleContext enrolRbCtxt) {
        this.enrollmentService = enrollmentService;
        this.registrationService = registrationService;
        this.oucDataStore = oucDataStore;
        this.osd = osd;
        this.cdm = cdm;
        this.enrolRbCtxt = enrolRbCtxt;
        this.grpcService = GrpcService.getInst();
    }

    @EventHandler(name="set resident update info modal", method="actionPerformed")
    public void setResidentUpdateInfo(ILiteEvent event) {
        this.residentUpdateInfo = (ResidentUpdateInfo)event.getExtraParameters().get("residentUpdateInfo");
    }

    @EventHandler(name="generate sid", method="actionPerformed")
    public void generateSid(ILiteEvent event) {
        ILiteView view;
        boolean isAppointmentFlow;
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            this.proceedNext(event);
            return;
        }
        boolean isProd = this.cdm.getRegisteredDeviceManager().getRdManagerPreference().getRegisteredDeviceEnvironment().equalsIgnoreCase("P");
        if (isProd && !CommonUtilsUC.isGpsValid(this.oucDataStore)) {
            TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_011.getReason()), ErrorCodes.UC_GEN_011.getErrorCode(), new String[0]);
            LOGGER.error("Invalid GPS Capture");
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_011.getReason(), null, ErrorCodes.UC_GEN_011.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
            return;
        }
        boolean bl = isAppointmentFlow = !Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId());
        if (!isAppointmentFlow) {
            this.enrollmentService.getOauthGwApiService().clearTransactionId();
        }
        IVisualExecutionContext veCtxt = (view = this.osd.getView(event.getViewId())) != null ? view.getVisualExecutionContext() : this.createVisualExecutionContext();
        Utils.showProgressBar(veCtxt, "Generating SID, please wait..");
        if (this.enrollmentService.isUpdateUC()) {
            this.srnForUpdate(event, veCtxt);
        } else {
            this.srnForEnrollment(event, veCtxt);
        }
    }

    private void srnForUpdate(ILiteEvent event, IVisualExecutionContext veCtxt) {
        ThreadPool.commonPool().submit(() -> {
            try {
                RequestType requestType = this.getRequestType();
                RequestSubType requestSubType = this.getRequestSubType();
                AgeGroup ageGroup = this.getAgeGroup();
                ResidentType residentType = this.getResidentType();
                FreighterService.EnrolMetadataAudit srnAudit = this.createAuditRequest();
                FreighterService.UpdateIndicator updateIndicator = this.createUpdateIndicatorRequest();
                FreighterService.DouUpdateIndicator douUpdateIndicator = this.createDouUpdateIndicatorRequest();
                FreighterService.FlowDataWithSrnRequest.Builder srnRequestBuilder = FreighterService.FlowDataWithSrnRequest.newBuilder().setAgeGroup(ageGroup.name()).setEnrolmentType(requestType.name()).setEnrolmentSubType(requestSubType.name()).setAudit(srnAudit).setUpdateIndicator(updateIndicator).setUid(this.enrollmentService.getResidentUid()).setDouUpdateIndicator(douUpdateIndicator).setResidentType(residentType.name());
                if (!Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId())) {
                    srnRequestBuilder.setGrievanceId(this.enrollmentService.getGrievanceId());
                }
                if (!Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId())) {
                    srnRequestBuilder.setAppointmentId(this.enrollmentService.getAppointment().getAppointmentId());
                }
                FreighterService.FlowDataWithSrnRequest srnRequest = srnRequestBuilder.build();
                this.grpcService.generateSrn(srnRequest, srnResponse -> {
                    try {
                        this.handleSidResponse((FreighterService.FlowDataWithSrnResponse)srnResponse, event, veCtxt);
                    }
                    catch (OnlineGatewayException e) {
                        Utils.cancelProgressBar(veCtxt);
                        LOGGER.error("Error in SID Generation :: {}, transaction id :: {}", (Object)e.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                        this.handleError(e);
                    }
                }, this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException e) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in SID Generation :: {}, transaction id :: {}", (Object)e.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                this.handleError(e);
            }
        });
    }

    private void srnForEnrollment(ILiteEvent event, IVisualExecutionContext veCtxt) {
        ThreadPool.commonPool().submit(() -> {
            try {
                RequestType requestType = this.getRequestType();
                RequestSubType requestSubType = this.getRequestSubType();
                AgeGroup ageGroup = this.getAgeGroup();
                ResidentType residentType = this.getResidentType();
                UcDemographicServiceProto.EnrolMetadataAudit srnAudit = this.createAuditRequestForEnrollment();
                UcDemographicServiceProto.UpdateIndicator updateIndicator = this.createUpdateIndicatorRequestEnrollment();
                UosProto.SrnRequest srnRequest = this.prepareSrnRequest(requestType, requestSubType, srnAudit, this.enrollmentService.getResidentUid(), updateIndicator, residentType, ageGroup);
                this.grpcService.generateSrn(srnRequest, srnResponse -> {
                    try {
                        this.handleSrnResponseEnrollment((UcDemographicServiceProto.EnrolMetadataResponse)srnResponse, veCtxt, event, new ActionEvent(event.getEvent().getSource(), 1, "actionPerformed"));
                    }
                    catch (OnlineGatewayException e) {
                        Utils.cancelProgressBar(veCtxt);
                        LOGGER.error("Error in SID Generation :: {}, transaction id :: {}", (Object)e.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                        this.handleError(e);
                    }
                }, this::handleUOSErrorResponse);
            }
            catch (OnlineGatewayException e) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error in SID Generation :: {}, transaction id :: {}", (Object)e.getDisplayMessage(), (Object)this.enrollmentService.getTransactionId());
                this.handleError(e);
            }
        });
    }

    private RequestSubType getRequestSubType() {
        if (this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isBiometricUpdate() && this.enrollmentService.isDemoUpdate()) {
            return RequestSubType.DEMO_BIO;
        }
        if (this.enrollmentService.isDemoUpdate()) {
            return RequestSubType.DEMO;
        }
        if (this.enrollmentService.isBiometricUpdate()) {
            return RequestSubType.BIO;
        }
        return RequestSubType.DEMO_BIO;
    }

    private RequestType getRequestType() {
        return this.enrollmentService.isNewEnrollmentUC() ? RequestType.N : RequestType.U;
    }

    private AgeGroup getAgeGroup() {
        if (this.enrollmentService.isUpdateUC()) {
            return AgeGroup.ALL;
        }
        if (this.enrollmentService.isAdultEnrollment()) {
            return AgeGroup.ABOVE18;
        }
        if (this.enrollmentService.isMinorEnrollment()) {
            return AgeGroup.BELOW18;
        }
        return AgeGroup.BELOW5;
    }

    private ResidentType getResidentType() {
        if (this.enrollmentService.isUpdateUC()) {
            return ResidentType.ALL;
        }
        if (this.enrollmentService.isForeignResident()) {
            return ResidentType.FOREIGN;
        }
        if (this.enrollmentService.isNRIEnrolment()) {
            return ResidentType.NRI;
        }
        return ResidentType.CITIZEN;
    }

    private FreighterService.UpdateIndicator createUpdateIndicatorRequest() throws OnlineGatewayException {
        try {
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            FreighterService.UpdateIndicator.Builder updateIndicatorBuilder = FreighterService.UpdateIndicator.newBuilder().setName(fieldsUpdateCount.getName().hasToBeUpdated()).setAddress(fieldsUpdateCount.getAddress().hasToBeUpdated()).setGender(fieldsUpdateCount.getGender().hasToBeUpdated()).setDob(fieldsUpdateCount.getDob().hasToBeUpdated()).setLanguage(false).setMobile(fieldsUpdateCount.getMobile().hasToBeUpdated()).setEmail(fieldsUpdateCount.getEmail().hasToBeUpdated()).setPofExpiry(fieldsUpdateCount.getActivationAadhaar().hasToBeUpdated()).setBio(fieldsUpdateCount.getBio().hasToBeUpdated()).setBioException(this.residentUpdateInfo.getIsBiometricException()).setHof(this.enrollmentService.isHofEnrollment()).setResidentForeigner(this.enrollmentService.isForeignResident()).setNri(this.enrollmentService.isNRIEnrolment());
            return updateIndicatorBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error("Error preparing update bit :: {}", (Object)e.getMessage());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_013, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private FreighterService.DouUpdateIndicator createDouUpdateIndicatorRequest() throws OnlineGatewayException {
        try {
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            return FreighterService.DouUpdateIndicator.newBuilder().setPoi(fieldsUpdateCount.getPoi().hasToBeUpdated()).setPoa(fieldsUpdateCount.getPoa().hasToBeUpdated()).setPob(fieldsUpdateCount.getPob().hasToBeUpdated()).setPor(fieldsUpdateCount.getPor().hasToBeUpdated()).setPof(fieldsUpdateCount.getPof().hasToBeUpdated()).build();
        }
        catch (Exception e) {
            LOGGER.error("Error preparing DOU update indicator :: {}", (Object)e.getMessage());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_013, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private FreighterService.EnrolMetadataAudit createAuditRequest() throws OnlineGatewayException {
        try {
            String operatorId = this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId();
            String clientLocation = this.registrationService.getClientLocation();
            String machineCode = this.registrationService.getRegisteredMachineCode();
            String agencyId = this.registrationService.getAgencyId();
            String registrarId = this.registrationService.getRegistrarId();
            String stationId = this.registrationService.getStationId();
            String longitude = GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLongitude().floatValue());
            String latitude = GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLatitude().floatValue());
            String clientVersion = ApplicationVersion.FULLDISPLAYVERSION;
            FreighterService.EnrolMetadataAudit.Builder auditBuilder = FreighterService.EnrolMetadataAudit.newBuilder().setOperatorId(operatorId).setEnrolmentCentre(clientLocation).setMachineCode(machineCode).setLongitude(longitude).setLatitude(latitude).setClientVersion(clientVersion).setAgencyCode(agencyId).setRegistrarId(registrarId).setStationId(stationId);
            if (!Strings.isNullOrEmpty((String)this.enrollmentService.getHofUid())) {
                auditBuilder.setHofUid(this.enrollmentService.getHofUid());
            }
            return auditBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error("Error preparing audit :: {}", (Object)e.getMessage());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_013, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private UcDemographicServiceProto.EnrolMetadataAudit createAuditRequestForEnrollment() throws OnlineGatewayException {
        try {
            String operatorId = this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId();
            String clientLocation = this.registrationService.getClientLocation();
            String machineCode = this.registrationService.getRegisteredMachineCode();
            String agencyId = this.registrationService.getAgencyId();
            String registrarId = this.registrationService.getRegistrarId();
            String stationId = this.registrationService.getStationId();
            String longitude = GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLongitude().floatValue());
            String latitude = GeoData.convertToDecimalDegrees((float)this.oucDataStore.getGpsInfo().getLatitude().floatValue());
            String clientVersion = ApplicationVersion.FULLDISPLAYVERSION;
            UcDemographicServiceProto.EnrolMetadataAudit.Builder auditBuilder = UcDemographicServiceProto.EnrolMetadataAudit.newBuilder().setOperatorId(operatorId).setEnrolmentCentre(clientLocation).setMachineCode(machineCode).setLongitude(longitude).setLatitude(latitude).setClientVersion(clientVersion).setAgencyCode(agencyId).setRegistrarId(registrarId).setStationId(stationId);
            if (!Strings.isNullOrEmpty((String)this.enrollmentService.getHofUid())) {
                auditBuilder.setHofUid(this.enrollmentService.getHofUid());
            }
            return auditBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error("Error preparing audit :: {}", (Object)e.getMessage());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_013, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private UcDemographicServiceProto.UpdateIndicator createUpdateIndicatorRequestEnrollment() throws OnlineGatewayException {
        try {
            UcDemographicServiceProto.UpdateIndicator.Builder updateIndicatorBuilder = UcDemographicServiceProto.UpdateIndicator.newBuilder();
            updateIndicatorBuilder.setName(true).setAddress(this.enrollmentService.isDocumentBasedEnrollment()).setGender(true).setDob(this.enrollmentService.getIsPobRequired()).setLanguage(true).setMobile(!Strings.isNullOrEmpty((String)this.enrollmentService.getDemographics().getContact().getMobile().number())).setEmail(!Strings.isNullOrEmpty((String)this.enrollmentService.getDemoContactDetails().getEmail().email()));
            updateIndicatorBuilder.setBio(this.enrollmentService.isBiometricUpdate());
            updateIndicatorBuilder.setHof(this.enrollmentService.isHofEnrollment());
            updateIndicatorBuilder.setResidentForeigner(this.enrollmentService.isForeignResident());
            updateIndicatorBuilder.setNri(this.enrollmentService.isNRIEnrolment());
            return updateIndicatorBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error("Error preparing update bit :: {}", (Object)e.getMessage());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_013, (String)this.enrollmentService.getTransactionId(), (Exception)e);
        }
    }

    private UosProto.SrnRequest prepareSrnRequest(RequestType requestType, RequestSubType requestSubType, UcDemographicServiceProto.EnrolMetadataAudit audit, String uid, UcDemographicServiceProto.UpdateIndicator updateIndicator, ResidentType residentType, AgeGroup ageGroup) {
        UosProto.SrnRequest.Builder builder = UosProto.SrnRequest.newBuilder().setAgeGroup(ageGroup.name()).setEnrolmentType(requestType.name()).setEnrolmentSubType(requestSubType.name()).setAudit(audit).setUpdateIndicator(updateIndicator).setResidentType(residentType.name());
        if (!Strings.isNullOrEmpty((String)uid)) {
            builder.setUid(uid);
        }
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId())) {
            builder.setGrievanceId(this.enrollmentService.getGrievanceId());
        }
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId())) {
            builder.setAppointmentId(this.enrollmentService.getAppointment().getAppointmentId());
        }
        return builder.build();
    }

    private void handleSrnResponseEnrollment(UcDemographicServiceProto.EnrolMetadataResponse srnResponse, IVisualExecutionContext veCtxt, ILiteEvent evt, ActionEvent event) {
        this.enrollmentService.setSid(srnResponse.getSid());
        this.enrollmentService.setRefId(srnResponse.getRefId());
        LOGGER.info("Sid: " + srnResponse.getSid());
        TelemetryService.getTelemetryServiceInstance().setSid(this.enrollmentService.getSid());
        if (!this.enrollmentService.getDemoContactDetails().getEmail().email().isEmpty()) {
            ThreadPool.commonPool().submit(() -> ((ActionListener)this.evtCtxt.getEventListener("email_resend_otp", ActionListener.class)).actionPerformed(event));
        }
        if (!this.enrollmentService.getDemoContactDetails().getMobile().getNumberForDisplay().isEmpty()) {
            ThreadPool.commonPool().submit(() -> ((ActionListener)this.evtCtxt.getEventListener("mobile_resend_otp", ActionListener.class)).actionPerformed(event));
        }
        this.proceedNext(evt);
        Utils.cancelProgressBar(veCtxt);
    }

    private void handleSidResponse(FreighterService.FlowDataWithSrnResponse srnResponse, ILiteEvent evt, IVisualExecutionContext veCtxt) {
        Utils.cancelProgressBar(veCtxt);
        if (!srnResponse.getSuccess()) {
            FreighterService.ErrorDetail errorDetail = srnResponse.getErrorDetail();
            throw OnlineGatewayException.getClientException((String)errorDetail.getErrorCode(), (String)errorDetail.getErrorMessage(), (String)this.enrollmentService.getTransactionId(), null);
        }
        if (srnResponse.hasClientMessage()) {
            this.displayMessage(srnResponse.getClientMessage().getMessage());
        }
        FreighterService.FlowDataWithSrn responseData = srnResponse.getData();
        this.enrollmentService.setSid(responseData.getSid());
        this.enrollmentService.setRefId(responseData.getRefId());
        LOGGER.info("Sid: " + this.enrollmentService.getSid());
        TelemetryService.getTelemetryServiceInstance().setSid(this.enrollmentService.getSid());
        String flow = responseData.getFreighterData().getFlowBitMapData();
        FieldInfoUtils.getEnabledTabs((String)flow);
        LOGGER.info("Enabled fields:{}", (Object)FieldInfoUtils.getEnabledTabs());
        boolean isBiometricUpdate = FieldInfoUtils.isFingerTabRequired() || FieldInfoUtils.isIrisTabRequired();
        boolean isPobRequired = FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POB);
        this.enrollmentService.setAadhaarActive(responseData.getFreighterData().getUidStatusCode() == 1);
        this.enrollmentService.setChildEnrollment(responseData.getAgeGroup().equalsIgnoreCase("1"));
        this.enrollmentService.setMinorEnrollment(responseData.getAgeGroup().equalsIgnoreCase("2") || responseData.getAgeGroup().equalsIgnoreCase("3"));
        this.enrollmentService.setAdultEnrollment(responseData.getAgeGroup().equalsIgnoreCase("4"));
        this.enrollmentService.setBiometricUpdate(isBiometricUpdate);
        this.enrollmentService.setPobRequired(isPobRequired);
        this.enrollmentService.setForeignResident(FOREIGN.equalsIgnoreCase(responseData.getResidentType()));
        this.enrollmentService.setIsNRIEnrolment(NRI.equalsIgnoreCase(responseData.getResidentType()));
        this.enrollmentService.getDemoPersonalDetails().setAadhaarNumber(this.enrollmentService.getResidentUid());
        this.enrollmentService.getPhotograph().setMandatory(FieldInfoUtils.isPhotoTabRequired());
        this.enrollmentService.getDemographics().getOtherDetail().setRelationType(this.residentUpdateInfo.getRelationshipType());
        this.proceedNext(evt);
    }

    private void displayBioxPanel(ActionEvent event) {
        ((ActionListener)this.evtCtxt.getEventListener("UC_hID_Uenrol_ShowBiox", ActionListener.class)).actionPerformed(event);
    }

    private void displayMessage(String message) {
        if (Strings.isNullOrEmpty((String)message)) {
            return;
        }
        L10nOptionPaneBuilder.getInstance().showInfoUC((Object)message.trim());
    }

    private void renderConsentPage(ActionEvent event) {
        ((ActionListener)this.evtCtxt.getEventListener("renderConsent", ActionListener.class)).actionPerformed(event);
    }

    private boolean handleYesNoMessage(String message, Window parent) {
        return L10nOptionPaneBuilder.getInstance().showYesNoUC(message, (Component)parent).equals((Object)MsgKeysCommon.YES);
    }

    private void proceedNext(ILiteEvent evt) {
        ActionEvent event = new ActionEvent(evt.getEvent().getSource(), 1, "actionPerformed");
        if (this.residentUpdateInfo.getIsBiometricException()) {
            this.displayBioxPanel(event);
        } else {
            this.renderConsentPage(event);
        }
    }

    private boolean aadhaarInvalidCheck(ActionEvent event, Window parent) {
        if (!this.enrollmentService.isAadhaarActive() && !this.handleYesNoMessage("Aadhaar is inactive, Do you wish to extend the aadhaar?", parent)) {
            ((ActionListener)this.evtCtxt.getEventListener("cancelDemo", ActionListener.class)).actionPerformed(event);
            return false;
        }
        return true;
    }

    private void handleUOSErrorResponse(UosResponse errorResponse) throws OnlineGatewayException {
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        throw OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse), (String)this.enrollmentService.getTransactionId(), null);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    private IVisualExecutionContext createVisualExecutionContext() {
        return new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }
}

