/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.brnapi.ChildInfoRequest;
import in.gov.uidai.ec.oauthapi.json.brnapi.ChildInfoResponse;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantConfirmGender;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.Brn;
import in.gov.uidai.ec.service.enrollment.model.ConfirmDob;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.RelativeDetail;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.BRNDetailsPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.BasicDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.PersonalDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.RelativeDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.ForeignPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysEnrol;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDetailControllerUC
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicDetailControllerUC.class);
    IVisualExecutionContext veCtxt;
    private BasicDetailPanel basicDetailPanel;
    private ForeignPanel foreignPanel;
    private EnrollmentService enrollmentService;
    private IResourceBundleContext enrlCxt;
    private RelationshipType hofRelation;
    private DemographicsTabViewPeerUC viewPeerUC;

    public BasicDetailControllerUC(DemographicsTabViewPeerUC viewPeerUC, EnrollmentService enrollmentService, ILiteView iLiteView) {
        super(iLiteView);
        this.viewPeerUC = viewPeerUC;
        this.basicDetailPanel = viewPeerUC.getBasicDetailPanel();
        this.enrollmentService = enrollmentService;
        this.enrlCxt = viewPeerUC.getEnrolRbctx();
        this.foreignPanel = viewPeerUC.getForeignPanel();
        this.veCtxt = this.view.getVisualExecutionContext();
        this.init();
    }

    private void init() {
        if (this.enrollmentService.isForeignResident()) {
            this.basicDetailPanel.getResidentPanel().getRefresh().addActionListener(e -> ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("UC_Nationality", ActionListener.class)).actionPerformed(e));
        } else if (this.enrollmentService.doesNriHaveForeignAddress()) {
            // empty if block
        }
        this.updateBasicDetailField();
    }

    public void nameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setFullName(this.basicDetailPanel.getPersonalDetailPanel().getNameField().getText());
        this.basicDetailPanel.getPersonalDetailPanel().getLocalName().setText(this.basicDetailPanel.getPersonalDetailPanel().getNamePanel().isOverrideCapitalizationSelected() ? this.basicDetailPanel.getPersonalDetailPanel().getNameField().getText().toLowerCase() : this.basicDetailPanel.getPersonalDetailPanel().getNameField().getText());
        this.enrollmentService.getDemoPersonalDetails().setFullNameLocal(this.basicDetailPanel.getPersonalDetailPanel().getLocalName().getText());
        this.updateBasicDetailField();
    }

    public void locNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setFullNameLocal(this.basicDetailPanel.getPersonalDetailPanel().getLocalName().getText());
        this.updateBasicDetailField();
    }

    public void newNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setNewName(this.basicDetailPanel.getPersonalDetailPanel().getNewNameField().getText());
        this.basicDetailPanel.getPersonalDetailPanel().getNewLocalNameField().setText(this.basicDetailPanel.getPersonalDetailPanel().getNamePanel().isOverrideCapitalizationSelected() ? this.basicDetailPanel.getPersonalDetailPanel().getNewNameField().getText().toLowerCase() : this.basicDetailPanel.getPersonalDetailPanel().getNewNameField().getText());
        this.enrollmentService.getDemoPersonalDetails().setNewNameLocal(this.basicDetailPanel.getPersonalDetailPanel().getNewLocalNameField().getText());
        this.updateBasicDetailField();
    }

    public void newLocalNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setNewNameLocal(this.basicDetailPanel.getPersonalDetailPanel().getNewLocalNameField().getText());
        this.updateBasicDetailField();
    }

    private void enrolNewNameFieldState() {
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNameField());
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getLocalName());
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        Name name = demoPersonalDetails.getName();
        if (!name.isValid()) {
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNameField(), name.nameError());
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getLocalName(), name.nameLocalError());
            if (name.nameError() != null && name.nameError().equals(this.enrlCxt.getMessage((Object)MsgKeysEnrol.NEWNAME_TOOSHORT_WARNING, new Object[0]))) {
                this.showWarning(this.basicDetailPanel.getPersonalDetailPanel().getNameField(), name.nameError());
            }
        }
    }

    private void updateNewNameFieldState() {
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNewNameField());
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNewLocalNameField());
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        Name name = demoPersonalDetails.getName();
        if (!name.isValid()) {
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNewNameField(), name.newNameError());
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getNewNameField(), name.newNameLocalError());
            if (name.newNameError() != null && name.newNameError().equals(this.enrlCxt.getMessage((Object)MsgKeysEnrol.NEWNAME_TOOSHORT_WARNING, new Object[0]))) {
                this.showWarning(this.basicDetailPanel.getPersonalDetailPanel().getNewNameField(), name.newNameError());
            }
        }
    }

    public void onGenderChange(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        Gender selectedGender = Objects.equals(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getGenderField().getSelectedItem(), "Select") ? Gender.NOT_GIVEN : (Gender)this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getGenderField().getSelectedItem();
        Gender gender = Objects.equals(selectedGender, Gender.getDefaultSelect()) ? Gender.NOT_GIVEN : selectedGender;
        String genderText = gender != Gender.NOT_GIVEN ? gender.toString() : "";
        this.basicDetailPanel.getPersonalDetailPanel().getLocalGender().setText(genderText);
        this.enrollmentService.getDemoPersonalDetails().setGenderLocal(this.basicDetailPanel.getPersonalDetailPanel().getLocalGender().getText());
        this.enrollmentService.getDemoPersonalDetails().setApplicantGender(gender.toString());
        if (gender != Gender.NOT_GIVEN) {
            this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setEnabled(true);
            if (Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId())) {
                this.enrollmentService.getDemoPersonalDetails().setApplicantConfirmGender("");
            }
            this.updateBasicDetailField();
        } else {
            this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setEnabled(false);
        }
        this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setSelectedItem(Gender.getDefaultSelect());
    }

    public void onConfirmGenderChange(ItemEvent ie) {
        Gender gender;
        if (ie.getStateChange() != 1) {
            return;
        }
        Gender selectedGender = Objects.equals(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().getSelectedItem(), "Select") ? Gender.NOT_GIVEN : (Gender)this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().getSelectedItem();
        Gender gender2 = gender = Objects.equals(selectedGender, Gender.getDefaultSelect()) ? Gender.NOT_GIVEN : selectedGender;
        if (gender != null) {
            String genderText = gender.toString();
            this.enrollmentService.getDemoPersonalDetails().setApplicantConfirmGender(genderText);
            this.enrollmentService.getDemoPersonalDetails().setConfirmGenderLocal(genderText);
            this.updateBasicDetailField();
        }
    }

    private void updateGenderFieldState() {
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getGenderField());
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        ApplicantGender applicantGender = demoPersonalDetails.getApplicantGender();
        if (!demoPersonalDetails.getApplicantGender().isValid()) {
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getGenderField(), applicantGender.englishError());
        }
    }

    private void updateConfirmGenderFieldState() {
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField());
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        ApplicantConfirmGender applicantConfirmGender = demoPersonalDetails.getApplicantConfirmGender();
        if (!demoPersonalDetails.getApplicantConfirmGender().isValid()) {
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField(), applicantConfirmGender.englishError());
        }
    }

    public void onDobOptSelected(ActionEvent e) {
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().setDobSelected(this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().isSelected());
        this.enrollmentService.getDemoPersonalDetails().getConfirmDob().setDobSelected(this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().isSelected());
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().setDob("");
        this.enrollmentService.getDemoPersonalDetails().getConfirmDob().setDob("");
    }

    public void onDobChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        if (ageDob.isDobSelected()) {
            ageDob.setDob(this.basicDetailPanel.getPersonalDetailPanel().getDobField().getText());
            this.enrollmentService.getDemoPersonalDetails().getConfirmDob().setDob("00-00-0000");
            this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobField().setText("00-00-0000");
        } else {
            ageDob.setAge(this.basicDetailPanel.getPersonalDetailPanel().getAgeField().getText());
        }
        this.onConfirmDobChange(focusEvent);
        this.updateBasicDetailField();
        this.updateLocalAgeField();
    }

    public void onConfirmDobChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        if (confirmDob.isDobSelected()) {
            confirmDob.setDob(this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobField().getText());
        } else {
            confirmDob.setAge(this.basicDetailPanel.getPersonalDetailPanel().getConfirmAgeField().getText());
        }
        this.updateBasicDetailField();
    }

    private void updateAgeDobFieldState() {
        String error;
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getDobField());
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobField());
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getAgeField());
        this.clearFieldError(this.basicDetailPanel.getPersonalDetailPanel().getConfirmAgeField());
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        if (ageDob.isDobSelected() && !ageDob.isValid()) {
            error = ageDob.getDayError() == null ? (ageDob.getMonthError() == null ? (ageDob.getYearError() == null ? ageDob.getAgeCheckError() : ageDob.getYearError()) : ageDob.getMonthError()) : ageDob.getDayError();
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getDobField(), error);
        } else if (!ageDob.isValid()) {
            error = ageDob.getAgeError() == null ? ageDob.getAgeCheckError() : ageDob.getAgeError();
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getAgeField(), error);
        }
        if (confirmDob.isDobSelected() && !confirmDob.isValid()) {
            error = confirmDob.getDayError() == null ? (confirmDob.getMonthError() == null ? confirmDob.getYearError() : confirmDob.getMonthError()) : confirmDob.getDayError();
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobField(), error);
        } else if (!confirmDob.isValid()) {
            error = confirmDob.getAgeError() != null ? confirmDob.getAgeError() : confirmDob.getAgeCheckError();
            this.showFieldError(this.basicDetailPanel.getPersonalDetailPanel().getConfirmAgeField(), error);
        }
    }

    private void updateLocalAgeField() {
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        if (ageDob.isDobSelected() && ageDob.isValid()) {
            String locText = ageDob.getDayForDisplay() + "/" + ageDob.getMonthForDisplay() + "/" + ageDob.getYearForDisplay();
            this.basicDetailPanel.getPersonalDetailPanel().getLocalAge().setText(locText);
        } else if (!ageDob.isDobSelected() && ageDob.isValid()) {
            int age = ageDob.getAge();
            String locText = ageDob.isValid() ? age + " years" : "years";
            this.basicDetailPanel.getPersonalDetailPanel().getLocalAge().setText(locText);
        } else if (!ageDob.isValid()) {
            this.basicDetailPanel.getPersonalDetailPanel().getLocalAge().setText("");
        }
        ageDob.setAgeDobLocal(this.basicDetailPanel.getPersonalDetailPanel().getLocalAge().getText());
    }

    public void onNationalityChange(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        ResidentialStatus residentialStatus = this.enrollmentService.getDemoResidentialStatus();
        JComboBox comboBox = (JComboBox)ie.getSource();
        switch (comboBox.getActionCommand()) {
            case "ForeignType": {
                this.foreignPanel.clearFields();
                this.enrollmentService.getDemoPersonalDetails().getForeignDetail().reset();
                residentialStatus.setForeignType((NationalityTypes)this.basicDetailPanel.getResidentPanel().getForeignType().getSelectedItem());
                NationalityTypes nationalityType = (NationalityTypes)ie.getItem();
                this.basicDetailPanel.getResidentPanel().getNationalityList().setEnabled(!nationalityType.getCode().isEmpty());
                this.addForeignCountries(this.basicDetailPanel.getResidentPanel().getNationalityList(), this.enrollmentService.getOnlineDocumentService().getCountryList());
                break;
            }
            case "Nationality": {
                residentialStatus.setCountry((Country)Objects.requireNonNull(this.basicDetailPanel.getResidentPanel().getNationalityList().getSelectedItem()));
            }
        }
        this.updateBasicDetailField();
    }

    private void updateNationalityField() {
        this.clearFieldError(this.basicDetailPanel.getResidentPanel().getNationalityList());
        this.clearFieldError(this.basicDetailPanel.getResidentPanel().getForeignType());
        ResidentialStatus residentialStatus = this.enrollmentService.getDemoResidentialStatus();
        if (!residentialStatus.isValid()) {
            this.showFieldError(this.basicDetailPanel.getResidentPanel().getNationalityList(), residentialStatus.getNationalityError());
            this.showFieldError(this.basicDetailPanel.getResidentPanel().getForeignType(), residentialStatus.getForeignTypeError());
        }
    }

    private void updateBrnField() {
        this.clearFieldError(this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField());
        this.clearFieldError(this.basicDetailPanel.getBrnDetailsPanel().getStateList());
        Brn brn = this.enrollmentService.getBrnDetails();
        if (!brn.isValid()) {
            this.showFieldError(this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField(), brn.getBrnNumError());
            this.showFieldError(this.basicDetailPanel.getBrnDetailsPanel().getStateList(), brn.getBrnStateError());
        }
    }

    public void updateBasicDetailField() {
        if (!(this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isUpdateUC() && this.enrollmentService.isAadhaarActive() && FieldInfoUtils.isDemographicTabRequired())) {
            this.updateNationalityField();
            return;
        }
        this.updateAgeDobFieldState();
        this.updateConfirmGenderFieldState();
        this.updateGenderFieldState();
        this.enrolNewNameFieldState();
        this.updateNationalityField();
        this.updateBrnField();
        this.updateRelativesFieldState();
        if (this.enrollmentService.isUpdateUC()) {
            this.updateNewNameFieldState();
        }
        this.viewPeerUC.isDemoDataUploaded = false;
    }

    public void onUidFocusLost(FocusEvent event, RelationshipType relationshipType) {
        if (event.isTemporary()) {
            return;
        }
        this.populateRelativeUids(relationshipType);
    }

    public void onRelativeNameFocusLost(FocusEvent event, RelationshipType relationshipType) {
        if (event.isTemporary()) {
            return;
        }
        this.populateRelativeUids(relationshipType);
    }

    public void onRelativeNameFocusLostForUpdate(FocusEvent event, RelationshipType relationshipType) {
        if (event.isTemporary()) {
            return;
        }
        RelativeDetailPanel relativePanel = this.basicDetailPanel.getRelativeDetailsPanel();
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        switch (relationshipType) {
            case FATHER: {
                RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
                String fatherName = relativePanel.getFatherName().getText();
                fatherDetail.setRelationType(relationshipType);
                fatherDetail.setName(fatherName);
                fatherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getFatherUID(), (String)"000000000000"));
                relativePanel.getFatherLocalName().setText(fatherName);
                String fatherLocalName = relativePanel.getFatherLocalName().getText();
                address.setCareOfName(fatherName);
                address.setExistingCareOfName(fatherName);
                address.setCareOfNameLocal(fatherLocalName);
                address.setExistingCareOfNameLocal(fatherLocalName);
                break;
            }
            case MOTHER: {
                RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
                String motherName = relativePanel.getMotherName().getText();
                motherDetail.setRelationType(relationshipType);
                motherDetail.setName(motherName);
                motherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getMotherUID(), (String)"000000000000"));
                relativePanel.getMotherLocalName().setText(motherName);
                String motherLocalName = relativePanel.getMotherLocalName().getText();
                address.setCareOfName(motherName);
                address.setExistingCareOfName(motherName);
                address.setCareOfNameLocal(motherLocalName);
                address.setExistingCareOfNameLocal(motherLocalName);
                break;
            }
            default: {
                RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
                String otherName = relativePanel.getOtherName().getText();
                otherDetail.setRelationType(relationshipType);
                otherDetail.setName(otherName);
                otherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getOtherUID(), (String)"000000000000"));
                relativePanel.getOtherLocalName().setText(otherName);
                String otherLocalName = relativePanel.getOtherLocalName().getText();
                address.setCareOfName(otherName);
                address.setExistingCareOfName(otherName);
                address.setCareOfNameLocal(otherLocalName);
                address.setExistingCareOfNameLocal(otherLocalName);
            }
        }
        this.updateBasicDetailField();
    }

    private void populateRelativeUids(RelationshipType relationshipType) {
        RelativeDetailPanel relativePanel = this.basicDetailPanel.getRelativeDetailsPanel();
        switch (relationshipType) {
            case FATHER: {
                RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
                fatherDetail.setRelationType(relationshipType);
                fatherDetail.setName(relativePanel.getFatherName().getText());
                fatherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getFatherUID(), (String)"000000000000"));
                break;
            }
            case MOTHER: {
                RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
                motherDetail.setRelationType(relationshipType);
                motherDetail.setName(relativePanel.getMotherName().getText());
                motherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getMotherUID(), (String)"000000000000"));
                break;
            }
            default: {
                RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
                otherDetail.setRelationType(relationshipType);
                otherDetail.setName(relativePanel.getOtherName().getText());
                otherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getOtherUID(), (String)"000000000000"));
            }
        }
        this.updateBasicDetailField();
    }

    private void updateRelativesFieldState() {
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getFatherName(), this.enrollmentService.getDemographics().getFatherDetail().getNameError());
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID(), this.enrollmentService.getDemographics().getFatherDetail().getUidError());
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getMotherName(), this.enrollmentService.getDemographics().getMotherDetail().getNameError());
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID(), this.enrollmentService.getDemographics().getMotherDetail().getUidError());
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getOtherName(), this.enrollmentService.getDemographics().getOtherDetail().getNameError());
        this.showError((JComponent)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), this.enrollmentService.getDemographics().getOtherDetail().getUidError());
    }

    void showError(JComponent component, String errorMessage) {
        this.clearFieldError(component);
        this.showFieldError(component, errorMessage);
    }

    public void populateRelatives(RelationshipType type, boolean isBRNPresent) {
        RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
        RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
        RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
        otherDetail.setMandatory(true);
        boolean enableBRN = this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isForeignResident();
        switch (Objects.requireNonNull(type)) {
            case FATHER: {
                this.hofRelation = RelationshipType.FATHER;
                fatherDetail.setMandatory(true);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherName().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setEditable(false);
                if (isBRNPresent) {
                    this.basicDetailPanel.getBrnDetailsPanel().setEnabled(enableBRN);
                }
                fatherDetail.setName(this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().getText());
                fatherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
                fatherDetail.setRelationType(RelationshipType.FATHER);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherName().setText("");
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setValue(null);
                motherDetail.setName("");
                motherDetail.setUid("");
                break;
            }
            case MOTHER: {
                this.hofRelation = RelationshipType.MOTHER;
                motherDetail.setMandatory(true);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherName().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setEditable(false);
                if (isBRNPresent) {
                    this.basicDetailPanel.getBrnDetailsPanel().setEnabled(enableBRN);
                }
                motherDetail.setName(this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().getText());
                motherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
                motherDetail.setRelationType(RelationshipType.MOTHER);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherName().setText("");
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setValue(null);
                fatherDetail.setName("");
                fatherDetail.setUid("");
                break;
            }
            default: {
                this.hofRelation = RelationshipType.LEGAL_GUARDIAN;
                fatherDetail.setMandatory(false);
                motherDetail.setMandatory(false);
                if (isBRNPresent) {
                    this.basicDetailPanel.getBrnDetailsPanel().setEnabled(enableBRN);
                }
                fatherDetail.setName("");
                fatherDetail.setUid("");
                motherDetail.setName("");
                motherDetail.setUid("");
            }
        }
        otherDetail.setRelationType(type);
        otherDetail.setName(this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().getText());
        otherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
        this.updateBasicDetailField();
    }

    public void populateRelativesForUpdate(RelationshipType type) {
        RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
        RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
        RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
        switch (Objects.requireNonNull(type)) {
            case FATHER: {
                this.hofRelation = RelationshipType.FATHER;
                fatherDetail.setMandatory(true);
                motherDetail.setMandatory(false);
                otherDetail.setMandatory(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherName().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setEditable(false);
                fatherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
                fatherDetail.setRelationType(RelationshipType.FATHER);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherName().setText("");
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setValue(null);
                motherDetail.setName("");
                motherDetail.setUid("");
                break;
            }
            case MOTHER: {
                this.hofRelation = RelationshipType.MOTHER;
                fatherDetail.setMandatory(false);
                motherDetail.setMandatory(true);
                otherDetail.setMandatory(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherName().setEditable(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setEditable(false);
                motherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
                motherDetail.setRelationType(RelationshipType.MOTHER);
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherName().setText("");
                this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setValue(null);
                fatherDetail.setName("");
                fatherDetail.setUid("");
                break;
            }
            default: {
                this.hofRelation = RelationshipType.LEGAL_GUARDIAN;
                fatherDetail.setMandatory(false);
                motherDetail.setMandatory(false);
                otherDetail.setMandatory(true);
                fatherDetail.setName("");
                fatherDetail.setUid("");
                motherDetail.setName("");
                motherDetail.setUid("");
                this.basicDetailPanel.getRelativeDetailsPanel().setEditableForParents(false);
                this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().setEditable(true);
            }
        }
        otherDetail.setRelationType(type);
        otherDetail.setName(this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().getText());
        otherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID(), (String)"000000000000"));
        this.updateBasicDetailField();
    }

    public void brnFieldFocusLost(FocusEvent evt) {
        if (evt.isTemporary()) {
            return;
        }
        BRNDetailsPanel brnPanel = this.basicDetailPanel.getBrnDetailsPanel();
        this.enrollmentService.getBrnDetails().setBrnNumber(brnPanel.getBrnTextField().getText());
        this.cleanRelations();
        this.updateBasicDetailField();
        if (this.enrollmentService.getBrnDetails().isValid()) {
            String message = "Please Confirm your,<br>BRN state: " + brnPanel.getStateList().getSelectedItem() + "<br>BRN number: " + brnPanel.getBrnTextField().getText();
            MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoUC(message, (Component)brnPanel.getBrnTextField());
            if (confirmation.equals((Object)MsgKeysCommon.YES)) {
                this.getBrnInfo();
            }
        }
    }

    public void brnStateFocusLost(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        String state = (String)ie.getItem();
        this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().setEnabled(!state.equalsIgnoreCase("Select"));
        this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().setText("");
        this.enrollmentService.getBrnDetails().setBrnState(state);
        this.cleanRelations();
        this.basicDetailPanel.getPersonalDetailPanel().setDefault();
        this.enrollmentService.getDemoPersonalDetails().cleanValues();
        this.addAllGenders();
        this.updateBasicDetailField();
    }

    public void onBrnButtonChange(ActionEvent ae) {
        boolean isBrnSelected = this.basicDetailPanel.getBrnDetailsPanel().getHaveBRNNumberButton().isSelected();
        this.basicDetailPanel.getBrnDetailsPanel().getStateList().setEnabled(isBrnSelected);
        this.basicDetailPanel.getBrnDetailsPanel().setDefault();
        this.basicDetailPanel.getPersonalDetailPanel().setDefault();
        this.enrollmentService.getDemoPersonalDetails().cleanValues();
        if (!this.enrollmentService.getIsPobRequired()) {
            this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().setSelected(isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobOpt().setSelected(isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().setEnabled(!isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getConfirmDobOpt().setEnabled(!isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getAgeOpt().setEnabled(!isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getConfirmAgeOpt().setEnabled(!isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getAgeField().setEnabled(!isBrnSelected);
            this.basicDetailPanel.getPersonalDetailPanel().getConfirmAgeField().setEnabled(!isBrnSelected);
            this.enrollmentService.getDemoPersonalDetails().getAgeDob().setDobSelected(this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().isSelected());
            this.enrollmentService.getDemoPersonalDetails().getConfirmDob().setDobSelected(this.basicDetailPanel.getPersonalDetailPanel().getDobOpt().isSelected());
        } else {
            this.basicDetailPanel.getPersonalDetailPanel().getAgePanel().setEnable(!isBrnSelected);
        }
        this.basicDetailPanel.getPersonalDetailPanel().getNamePanel().setEnable(!isBrnSelected);
        this.basicDetailPanel.getRelativeDetailsPanel().setEditableForParents(!isBrnSelected);
        this.cleanRelations();
        if (!isBrnSelected) {
            this.addAllGenders();
        }
        Brn brn = this.enrollmentService.getBrnDetails();
        brn.setBrnState((String)this.basicDetailPanel.getBrnDetailsPanel().getStateList().getSelectedItem());
        brn.setBrnNumber(this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().getText());
        brn.setSelected(isBrnSelected);
        this.updateBasicDetailField();
    }

    private void getBrnInfo() {
        Utils.showProgressBar(this.veCtxt, "Collecting Child information, Please wait..");
        ChildInfoRequest request = new ChildInfoRequest();
        request.setBrnNumber(this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().getText());
        request.setStateName((String)this.basicDetailPanel.getBrnDetailsPanel().getStateList().getSelectedItem());
        try {
            ChildInfoResponse response = this.enrollmentService.getOauthGwApiService().getChildInfo(request);
            this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().setEnabled(!response.success());
            if (!response.success()) {
                Utils.cancelProgressBar(this.veCtxt);
                LOGGER.error(response.getMessage() != null ? response.getMessage() : "Invalid Request. Failed to fetch BRN details.");
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(response.getMessage()), ErrorCodes.UC_BRN_001.getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(response.getMessage() != null ? response.getMessage() : "Invalid Request. Failed to fetch BRN details.", (Component)this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField(), ErrorCodes.UC_BRN_001.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
                return;
            }
            Utils.cancelProgressBar(this.veCtxt);
            if (!this.verifyBrnResponse(response)) {
                LOGGER.warn("BRN data miss match");
                return;
            }
            this.populateBrnDetails(response);
        }
        catch (OnlineGatewayException ex) {
            LOGGER.error("Error occurred while uploading demographic data to server");
            Utils.cancelProgressBar(this.veCtxt);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), ex.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ex.getMessage(), null, ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
    }

    private String reverseDob(String dob) {
        String revDob = Integer.parseInt(dob.split("-")[0]) > 1000 ? dob.split("-")[2] + "-" + dob.split("-")[1] + "-" + dob.split("-")[0] : dob;
        return revDob;
    }

    private void populateBrnDetails(ChildInfoResponse childInfo) {
        if (childInfo != null) {
            PersonalDetailPanel personalDetailPanel = this.basicDetailPanel.getPersonalDetailPanel();
            RelativeDetailPanel relativePanel = this.basicDetailPanel.getRelativeDetailsPanel();
            personalDetailPanel.getNameField().setText(CommonUtilsUC.capitalizeWords(childInfo.getChildName()));
            personalDetailPanel.getNameField().setEditable(childInfo.getChildName().isEmpty());
            Gender childGender = Gender.fromString((String)String.valueOf(childInfo.getChildGender().charAt(0)));
            this.cleanGender(childGender);
            personalDetailPanel.getGenderPanel().getGenderField().setSelectedItem(childGender);
            personalDetailPanel.getGenderPanel().getConfirmGenderField().setSelectedItem(childGender);
            personalDetailPanel.getLocalGender().setText(String.valueOf(String.valueOf(childInfo.getChildGender())));
            if (relativePanel.getFatherName().getText().isEmpty()) {
                relativePanel.getFatherName().setText(CommonUtilsUC.capitalizeWords(childInfo.getFatherName()));
            }
            if (relativePanel.getMotherName().getText().isEmpty()) {
                relativePanel.getMotherName().setText(CommonUtilsUC.capitalizeWords(childInfo.getMotherName()));
            }
            if (!Strings.isNullOrEmpty((String)childInfo.getFatherUid())) {
                relativePanel.getFatherUID().setValue(childInfo.getFatherUid().replaceAll("\\D", ""));
            }
            if (!Strings.isNullOrEmpty((String)childInfo.getMotherUid())) {
                relativePanel.getMotherUID().setValue(childInfo.getMotherUid().replaceAll("\\D", ""));
            }
            relativePanel.getFatherUID().setEditable(Strings.isNullOrEmpty((String)childInfo.getFatherUid()));
            relativePanel.getMotherUID().setEditable(Strings.isNullOrEmpty((String)childInfo.getMotherUid()));
            relativePanel.getFatherName().setEditable(Strings.isNullOrEmpty((String)childInfo.getFatherName()));
            relativePanel.getMotherName().setEditable(Strings.isNullOrEmpty((String)childInfo.getMotherName()));
            this.populateRelativeUids(RelationshipType.FATHER);
            this.populateRelativeUids(RelationshipType.MOTHER);
            if (!childInfo.getDob().isEmpty()) {
                String[] dob = this.reverseDob(childInfo.getDob()).split("-");
                personalDetailPanel.getAgePanel().setDobFields(dob[0], dob[1], dob[2]);
            }
            this.updateDemographicsDataInChildEnrolment(childInfo);
            RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
            RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
            fatherDetail.setName(relativePanel.getFatherName().getText());
            fatherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getFatherUID(), (String)"000000000000"));
            motherDetail.setName(relativePanel.getMotherName().getText());
            motherDetail.setUid(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.getMotherUID(), (String)"000000000000"));
        }
    }

    private boolean verifyBrnResponse(ChildInfoResponse childInfo) {
        String msg = "";
        String ageMsg = "";
        boolean responseOK = true;
        if (childInfo.getChildGender().isEmpty() || childInfo.getChildGender() == null) {
            msg = msg + "Gender,";
        }
        if (childInfo.getChildName().isEmpty() || childInfo.getChildName() == null) {
            msg = msg + "Name,";
        }
        if (childInfo.getDob().isEmpty() || childInfo.getDob() == null) {
            msg = msg + "Date of birth,";
        } else {
            String[] dob = this.reverseDob(childInfo.getDob()).split("-");
            GregorianCalendar cal = new GregorianCalendar();
            int age = cal.get(1) - Integer.parseInt(dob[2]);
            if (Integer.parseInt(dob[1]) > cal.get(2)) {
                --age;
            } else if (Integer.parseInt(dob[0]) > cal.get(5)) {
                --age;
            }
            if (this.enrollmentService.isBiometricUpdate() && age < 5) {
                ageMsg = "Child is below 5 years.";
            } else if (!this.enrollmentService.isBiometricUpdate() && age >= 5) {
                ageMsg = "Child is above 5 years";
            }
        }
        if (!ageMsg.isEmpty()) {
            responseOK = false;
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)("Cannot continue enrollment process. Reason: " + ageMsg), null, new Object[0]);
        }
        if (!msg.isEmpty()) {
            msg = msg.substring(0, msg.length() - 1);
            responseOK = false;
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)("Cannot continue enrollment process. Missing child details: " + msg), null, new Object[0]);
            this.basicDetailPanel.getBrnDetailsPanel().getBrnTextField().setEnabled(true);
        }
        Object motherUid = this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().getValue();
        Object fatherUid = this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().getValue();
        if (!(Objects.isNull(motherUid) || motherUid.equals("000000000000") || Strings.isNullOrEmpty((String)childInfo.getMotherUid()) || childInfo.getMotherUid().equals(motherUid))) {
            responseOK = false;
            TelemetryService.getTelemetryServiceInstance().postDebugData(ErrorCodes.UC_BRN_002.getReason() + "\nMother uid entered:" + motherUid + ", Mother uid fetched from brn:" + childInfo.getMotherUid(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_BRN_002.getReason(), null, new Object[0]);
        }
        if (!(Objects.isNull(fatherUid) || fatherUid.equals("000000000000") || Strings.isNullOrEmpty((String)childInfo.getFatherUid()) || childInfo.getFatherUid().equals(fatherUid))) {
            responseOK = false;
            TelemetryService.getTelemetryServiceInstance().postDebugData(ErrorCodes.UC_BRN_003.getReason() + "\nFather uid entered:" + fatherUid + ", Father uid fetched from brn:" + childInfo.getFatherUid(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_BRN_003.getReason(), null, new Object[0]);
        }
        return responseOK;
    }

    private void updateDemographicsDataInChildEnrolment(ChildInfoResponse childInfoResponse) {
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        if (StringUtils.isNotBlank((String)childInfoResponse.getChildName())) {
            personalDetail.setFullName(CommonUtilsUC.capitalizeWords(childInfoResponse.getChildName()));
        }
        if (StringUtils.isNotBlank((String)childInfoResponse.getChildGender())) {
            personalDetail.getApplicantGender().setGender(Gender.fromString((String)String.valueOf(childInfoResponse.getChildGender().charAt(0))));
        }
        if (StringUtils.isNotBlank((String)childInfoResponse.getDob())) {
            String[] dob = this.reverseDob(childInfoResponse.getDob()).split("-");
            personalDetail.getAgeDob().setDob(dob[0], dob[1], dob[2]);
            personalDetail.getConfirmDob().setDob(dob[0], dob[1], dob[2]);
        }
        this.updateBasicDetailField();
    }

    private void cleanGender(Gender childGender) {
        PersonalDetailPanel personalDetailPanel = this.basicDetailPanel.getPersonalDetailPanel();
        JComboBox<Object> genderDropdown = personalDetailPanel.getGenderPanel().getGenderField();
        genderDropdown.removeAllItems();
        genderDropdown.addItem(Gender.getDefaultSelect());
        genderDropdown.addItem(childGender);
        JComboBox<Object> confirmGenderDropdown = personalDetailPanel.getGenderPanel().getConfirmGenderField();
        confirmGenderDropdown.removeAllItems();
        confirmGenderDropdown.addItem(Gender.getDefaultSelect());
        confirmGenderDropdown.addItem(childGender);
    }

    private void addAllGenders() {
        JComboBox<Object> genderDropdown = this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getGenderField();
        JComboBox<Object> confirmGenderDropdown = this.basicDetailPanel.getPersonalDetailPanel().getGenderPanel().getConfirmGenderField();
        genderDropdown.removeAllItems();
        genderDropdown.addItem(Gender.getDefaultSelect());
        genderDropdown.addItem(Gender.MALE);
        genderDropdown.addItem(Gender.FEMALE);
        genderDropdown.addItem(Gender.TRANSGENDER);
        genderDropdown.setSelectedItem(Gender.getDefaultSelect());
        confirmGenderDropdown.removeAllItems();
        confirmGenderDropdown.addItem(Gender.getDefaultSelect());
        confirmGenderDropdown.addItem(Gender.MALE);
        confirmGenderDropdown.addItem(Gender.FEMALE);
        confirmGenderDropdown.addItem(Gender.TRANSGENDER);
        confirmGenderDropdown.setSelectedItem(Gender.getDefaultSelect());
    }

    private void cleanRelations() {
        if (this.hofRelation != RelationshipType.FATHER) {
            RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
            fatherDetail.setRelationType(null);
            fatherDetail.setName("");
            fatherDetail.setUid("000000000000");
            this.basicDetailPanel.getRelativeDetailsPanel().getFatherName().setText("");
            this.basicDetailPanel.getRelativeDetailsPanel().getFatherUID().setValue(null);
        }
        if (this.hofRelation != RelationshipType.MOTHER) {
            RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
            motherDetail.setRelationType(null);
            motherDetail.setName("");
            motherDetail.setUid("000000000000");
            this.basicDetailPanel.getRelativeDetailsPanel().getMotherName().setText("");
            this.basicDetailPanel.getRelativeDetailsPanel().getMotherUID().setValue(null);
        }
        if (this.hofRelation != RelationshipType.LEGAL_GUARDIAN) {
            RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
            otherDetail.setRelationType(null);
            otherDetail.setName("");
            otherDetail.setUid("000000000000");
            this.basicDetailPanel.getRelativeDetailsPanel().getOtherName().setText("");
            this.basicDetailPanel.getRelativeDetailsPanel().getOtherUID().setValue(null);
        }
    }

    private void addForeignCountries(JComboBox<Country> comboBox, CountryList[] countries) {
        comboBox.removeAllItems();
        comboBox.addItem(new Country("Select", ""));
        List<CountryList> nationalityTypeList = Arrays.asList(countries);
        String foreignType = this.basicDetailPanel.getResidentPanel().getForeignType().getSelectedItem().toString();
        if (foreignType.contains("Nepal") || foreignType.contains("NLBN")) {
            this.filterAndAddItems(nationalityTypeList, comboBox, "Nepal", "Bhutan");
        } else if (foreignType.contains("LTV")) {
            this.filterAndAddItems(nationalityTypeList, comboBox, "Afghanistan", "Bangladesh", "Pakistan");
        } else {
            nationalityTypeList.forEach(item -> {
                if (item.isActive() && !item.getCountryName().equalsIgnoreCase("INDIA")) {
                    comboBox.addItem(new Country(item.getCountryName(), item.getCountryCode()));
                }
            });
        }
        comboBox.setSelectedItem("Select");
    }

    private void filterAndAddItems(List<CountryList> countryList, JComboBox<Country> comboBox, String ... filterCriteria) {
        countryList.stream().filter(item -> {
            if (!item.isActive()) return false;
            if (!Arrays.stream(filterCriteria).anyMatch(item.getCountryName()::contains)) return false;
            return true;
        }).map(item -> new Country(item.getCountryName(), item.getCountryCode())).forEach(comboBox::addItem);
    }
}

