/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.ContactDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;
import in.gov.uidai.litef.devapi.ILiteView;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import org.apache.commons.lang.ObjectUtils;

public class ContactDetailControllerUC
extends ControllerBase {
    private final ContactDetailPanel contactDetailPanel;
    private final EnrollmentService enrollmentService;
    private final DemographicsTabViewPeerUC viewPeerUC;

    public ContactDetailControllerUC(DemographicsTabViewPeerUC viewPeerUC, EnrollmentService enrollmentService, ILiteView iLiteView) {
        super(iLiteView);
        this.contactDetailPanel = viewPeerUC.getContactDetailPanel();
        this.enrollmentService = enrollmentService;
        this.viewPeerUC = viewPeerUC;
        this.init();
    }

    private void init() {
        this.updateAddressFieldState();
    }

    public void careOfNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        address.setCareOfName(this.contactDetailPanel.getCareofPanel().getCareofTextField().getText());
        this.contactDetailPanel.getCareofPanel().getLocCareOf().setText(this.contactDetailPanel.getCareofPanel().getCareofTextField().getText());
        address.setCareOfNameLocal(this.contactDetailPanel.getCareofPanel().getLocCareOf().getText());
        this.contactDetailPanel.getCareofPanel().getCareofTextField().setEditable(false);
        this.contactDetailPanel.getCareofPanel().getLocCareOf().setEditable(false);
        this.updateAddressFieldState();
    }

    public void locCareOfNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getAddress().setCareOfNameLocal(this.contactDetailPanel.getCareofPanel().getLocCareOf().getText());
        this.updateAddressFieldState();
    }

    private void updateCareOfNameFieldState() {
        this.clearFieldError(this.contactDetailPanel.getCareofPanel().getCareofTextField());
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        if (!address.isValid()) {
            this.showFieldError(this.contactDetailPanel.getCareofPanel().getCareofTextField(), address.getCareOfNameError());
        }
    }

    public void addressOneFocuslost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignNRI address = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        address.setAddressOne(this.contactDetailPanel.getAddressPanelOne().getaddressTextField().getText());
        this.contactDetailPanel.getAddressPanelOne().getLocalAddressTextField().setText(this.contactDetailPanel.getAddressPanelOne().getaddressTextField().getText());
        address.setLocalAddressOne(this.contactDetailPanel.getAddressPanelOne().getLocalAddressTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateAddressOneFieldState() {
        this.clearFieldError(this.contactDetailPanel.getAddressPanelOne().getaddressTextField());
        ForeignNRI foreignNRI = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        if (!foreignNRI.isValid()) {
            this.showFieldError(this.contactDetailPanel.getAddressPanelOne().getaddressTextField(), foreignNRI.getAddressOneError());
        }
    }

    public void addressTwoFocuslost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignNRI address = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        address.setAddressTwo(this.contactDetailPanel.getAddressPanelTwo().getaddressTextField().getText());
        this.contactDetailPanel.getAddressPanelTwo().getLocalAddressTextField().setText(this.contactDetailPanel.getAddressPanelTwo().getaddressTextField().getText());
        address.setLocalAddressTwo(this.contactDetailPanel.getAddressPanelTwo().getLocalAddressTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateAddressTwoFieldState() {
        this.clearFieldError(this.contactDetailPanel.getAddressPanelTwo().getaddressTextField());
        ForeignNRI foreignNRI = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        if (!foreignNRI.isValid()) {
            this.showFieldError(this.contactDetailPanel.getAddressPanelTwo().getaddressTextField(), foreignNRI.getAddressTwoError());
        }
    }

    public void addressThreeFocuslost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignNRI address = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        address.setAddressThree(this.contactDetailPanel.getAddressPanelThree().getaddressTextField().getText());
        this.contactDetailPanel.getAddressPanelThree().getLocalAddressTextField().setText(this.contactDetailPanel.getAddressPanelThree().getaddressTextField().getText());
        address.setLocalAddressThree(this.contactDetailPanel.getAddressPanelThree().getLocalAddressTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateAddressThreeFieldState() {
        this.clearFieldError(this.contactDetailPanel.getAddressPanelThree().getaddressTextField());
        ForeignNRI foreignNRI = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        if (!foreignNRI.isValid()) {
            this.showFieldError(this.contactDetailPanel.getAddressPanelThree().getaddressTextField(), foreignNRI.getAddressThreeError());
        }
    }

    public void zipcodeFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignNRI address = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        address.setZipcode(this.contactDetailPanel.getZipCodePanel().getzipcodeTextField().getText());
        this.contactDetailPanel.getZipCodePanel().getLocalZipcodeTextField().setText(this.contactDetailPanel.getZipCodePanel().getzipcodeTextField().getText());
        address.setLocalZipcode(this.contactDetailPanel.getZipCodePanel().getLocalZipcodeTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateZipcodeField() {
        this.clearFieldError(this.contactDetailPanel.getZipCodePanel().getzipcodeTextField());
        ForeignNRI foreignNRI = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        if (!foreignNRI.isValid()) {
            this.showFieldError(this.contactDetailPanel.getZipCodePanel().getzipcodeTextField(), foreignNRI.getZipcodeError());
        }
    }

    public void onCountryChange(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        ForeignNRI foreignNRIAddress = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        JComboBox comboBox = (JComboBox)ie.getSource();
        Country currentCountry = (Country)Objects.requireNonNull(comboBox.getSelectedItem());
        foreignNRIAddress.setCountry(currentCountry);
        this.contactDetailPanel.getZipCodePanel().getTempCountryName().setText(currentCountry.getCountryName());
        this.contactDetailPanel.getZipCodePanel().getLocalCountryTextField().setText(currentCountry.getCountryName());
        foreignNRIAddress.setLocalCountry(this.contactDetailPanel.getZipCodePanel().getLocalCountryTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateCountryFieldState() {
        this.clearFieldError(this.contactDetailPanel.getZipCodePanel().getCountryListComboBox());
        ForeignNRI foreignNRI = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
        if (!foreignNRI.isValid()) {
            this.showFieldError(this.contactDetailPanel.getZipCodePanel().getCountryListComboBox(), foreignNRI.getCountryError());
        }
    }

    public void houseFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String houseBuilding = this.contactDetailPanel.getHousePanel().getHouseTextField().getText();
        contact.getAddress().setBuilding(houseBuilding);
        this.contactDetailPanel.getHousePanel().getLocalHouse().setText(houseBuilding);
        contact.getAddress().setBuildingLocal(this.contactDetailPanel.getHousePanel().getLocalHouse().getText());
        this.updateAddressFieldState();
    }

    public void locHouseFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getAddress().setBuildingLocal(this.contactDetailPanel.getHousePanel().getLocalHouse().getText());
        this.updateAddressFieldState();
    }

    private void updateHouseFieldState() {
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.clearFieldError(this.contactDetailPanel.getHousePanel().getHouseTextField());
        this.showFieldError(this.contactDetailPanel.getHousePanel().getHouseTextField(), contact.getAddress().getBuildingError());
    }

    public void streetFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String street = this.contactDetailPanel.getStreetPanel().getStreetTextField().getText();
        contact.getAddress().setStreet(street);
        this.contactDetailPanel.getStreetPanel().getLocalStreet().setText(street);
        contact.getAddress().setStreetLocal(this.contactDetailPanel.getStreetPanel().getLocalStreet().getText());
        this.updateAddressFieldState();
    }

    public void locStreetFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getAddress().setStreetLocal(this.contactDetailPanel.getStreetPanel().getLocalStreet().getText());
        this.updateAddressFieldState();
    }

    private void updateStreetFieldState() {
        this.clearFieldError(this.contactDetailPanel.getStreetPanel().getStreetTextField());
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.showFieldError(this.contactDetailPanel.getStreetPanel().getStreetTextField(), contact.getAddress().getStreetError());
    }

    public void landmarkFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String landmark = this.contactDetailPanel.getLandmarkPanel().getLandmark().getText();
        contact.getAddress().setLandmark(landmark);
        this.contactDetailPanel.getLandmarkPanel().getLocalLandmark().setText(landmark);
        contact.getAddress().setLandmarkLocal(this.contactDetailPanel.getLandmarkPanel().getLocalLandmark().getText());
        this.updateAddressFieldState();
    }

    public void locLandmarkFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getAddress().setLandmarkLocal(this.contactDetailPanel.getLandmarkPanel().getLocalLandmark().getText());
        this.updateAddressFieldState();
    }

    private void updateLandmarkFieldState() {
        this.clearFieldError(this.contactDetailPanel.getLandmarkPanel().getLandmark());
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.showFieldError(this.contactDetailPanel.getLandmarkPanel().getLandmark(), contact.getAddress().getLandmarkError());
    }

    public void localityFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String areaLocality = this.contactDetailPanel.getLocalityPanel().getLocalityTextField().getText();
        contact.getAddress().setLocality(areaLocality);
        this.contactDetailPanel.getLocalityPanel().getLocalLocality().setText(areaLocality);
        contact.getAddress().setLocalityLocal(this.contactDetailPanel.getLocalityPanel().getLocalLocality().getText());
        this.updateAddressFieldState();
    }

    public void locLocalityFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getAddress().setLocalityLocal(this.contactDetailPanel.getLocalityPanel().getLocalLocality().getText());
        this.updateAddressFieldState();
    }

    public void postOfficeFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String postOffice = this.contactDetailPanel.getPostOfficePanel().getPostOfficeTextField().getText();
        this.contactDetailPanel.getPostOfficePanel().locPostOffField.setText(postOffice);
        contact.getAddress().setPostOfficeLocal(this.contactDetailPanel.getPostOfficePanel().locPostOffField.getText());
        this.updateAddressFieldState();
    }

    private void updateLocalityFieldState() {
        super.clearFieldError(this.contactDetailPanel.getLocalityPanel().getLocalityTextField());
        Contact contact = this.enrollmentService.getDemoContactDetails();
        super.showFieldError(this.contactDetailPanel.getLocalityPanel().getLocalityTextField(), contact.getAddress().getLocalityError());
    }

    public synchronized void onPOCodeLoaded(Object o) {
        ContactDetailPanel addressComposite = this.contactDetailPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        if (addressComposite.getPostOfficePanel().getPostOfficeTextField().getSelectedOption() instanceof PostOffice) {
            PostOffice postOffice = (PostOffice)addressComposite.getPostOfficePanel().getPostOfficeTextField().getSelectedOption();
            postOffice.setLocaleName(addressComposite.getPostOfficePanel().locPostOffField.getText());
            contact.getAddress().setPostOffice(postOffice);
            contact.getAddress().setPostOfficeLocal(postOffice.getLocaleName());
            List<Object> poListOptions = addressComposite.getPostOfficePanel().getPostOfficeTextField().getOptions();
            long poListCount = poListOptions.size();
            contact.getAddress().setDefaultPo(poListCount == 1L ? ((PostOffice)poListOptions.get(0)).getName() : ((PostOffice)poListOptions.get(1)).getName());
        } else {
            contact.getAddress().setPostOffice(null);
            contact.getAddress().setPinCodeLocal(null);
        }
        this.updateAddressFieldState();
    }

    private void updatePOCodeFieldState() {
        super.clearFieldError(this.contactDetailPanel.getPostOfficePanel().getPostOfficeTextField());
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        String error = (String)ObjectUtils.defaultIfNull((Object)address.getPostOfficeError(), (Object)address.getDefaultPostOfficeError());
        super.showFieldError(this.contactDetailPanel.getPostOfficePanel().getPostOfficeTextField(), error);
    }

    public synchronized void onPinCodeLoaded(Object o) {
        ContactDetailPanel addressComposite = this.contactDetailPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        if (addressComposite.getPincodePanel().getPincodeTextField().getSelectedOption() instanceof PostalAddress) {
            PostalAddress postalAddress = (PostalAddress)addressComposite.getPincodePanel().getPincodeTextField().getSelectedOption();
            if (addressComposite.getPostOfficePanel().postOfficeTextField.getSelectedOption() instanceof PostOffice) {
                PostOffice postOffice = (PostOffice)addressComposite.getPostOfficePanel().postOfficeTextField.getSelectedOption();
                postOffice.setLocaleName(addressComposite.getPostOfficePanel().locPostOffField.getText());
                contact.getAddress().setPostOffice(postOffice);
                List<Object> poListOptions = addressComposite.getPostOfficePanel().postOfficeTextField.getOptions();
                long poListCount = poListOptions.size();
                contact.getAddress().setDefaultPo(poListCount == 1L ? ((PostOffice)poListOptions.get(0)).getName() : ((PostOffice)poListOptions.get(1)).getName());
                contact.getAddress().setPostalAddress(postalAddress);
                contact.getAddress().setPinCodeLocal(postalAddress.getPincode());
                contact.getAddress().setStateLocal(addressComposite.getStatePanel().getLocStateField().getText());
                contact.getAddress().setDistrictLocal(addressComposite.getDistrictPanel().getLocDistrictField().getText());
                contact.getAddress().setSubDistrictLocal(addressComposite.getDistrictPanel().getLocSubDistField().getText());
                contact.getAddress().setVTCLocal(addressComposite.getVillagePanel().getLocVtcField().getText());
            }
        } else {
            contact.getAddress().setPostOffice(null);
            contact.getAddress().setPostalAddress(null);
            contact.getAddress().setPinCodeLocal("");
            contact.getAddress().setStateLocal("");
            contact.getAddress().setDistrictLocal("");
            contact.getAddress().setSubDistrictLocal("");
            contact.getAddress().setVTCLocal("");
        }
        this.updateAddressFieldState();
    }

    private void updatePincodeFieldState() {
        super.clearFieldError(this.contactDetailPanel.getPincodePanel().getPincodeTextField());
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError(this.contactDetailPanel.getPincodePanel().getPincodeTextField(), address.getPinCodeDetail().getPinCode().getAddressValueError());
    }

    public void updateAddressFieldState() {
        if (this.enrollmentService.doesNriHaveForeignAddress()) {
            this.updateAddressOneFieldState();
            this.updateAddressTwoFieldState();
            this.updateAddressThreeFieldState();
            this.updateCountryFieldState();
            this.updateZipcodeField();
        } else {
            this.updateCareOfNameFieldState();
            this.updateHouseFieldState();
            this.updateStreetFieldState();
            this.updateLandmarkFieldState();
            this.updateLocalityFieldState();
            this.updatePOCodeFieldState();
            this.updatePincodeFieldState();
        }
        this.updateMobileFieldState();
        this.updateEmailFieldState();
        this.viewPeerUC.isDemoDataUploaded = false;
    }

    public void onMobileChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        mobile.setNumber(this.contactDetailPanel.getMobilePanel().getMobileTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateMobileFieldState() {
        this.clearFieldError(this.contactDetailPanel.getMobilePanel().getMobileTextField());
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        if (!mobile.isValid()) {
            super.showFieldError(this.contactDetailPanel.getMobilePanel().getMobileTextField(), mobile.numberError());
        }
        if (!this.enrollmentService.isUpdateUC()) {
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(!mobile.isMobileVerified() && !mobile.number().isEmpty() && this.enrollmentService.getIsdService().getDefaultSelect().getISDCode().equalsIgnoreCase(mobile.isdCode()));
        } else {
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(mobile.isUpdated() && !mobile.isMobileVerified());
        }
    }

    public void onMobileVerified(Mobile mobile) {
        if (mobile.isMandatory()) {
            this.contactDetailPanel.getMobilePanel().getMobileTextField().setEnabled(!mobile.isMobileVerified());
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(!mobile.isMobileVerified());
            this.contactDetailPanel.getMobilePanel().setValid(mobile.isMobileVerified() && mobile.isdCode().contains("+91"));
        } else {
            this.contactDetailPanel.getMobilePanel().getMobileTextField().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().setValid(false);
        }
    }

    public void onEmailVerified(Email email) {
        if (email.isMandatory()) {
            this.contactDetailPanel.getEmailPanel().getEmailTextField().setEnabled(!email.isEmailVerified());
            this.contactDetailPanel.getEmailPanel().getGenerateOtpButton().setEnabled(!email.isEmailVerified());
            this.contactDetailPanel.getEmailPanel().setValid(email.isEmailVerified());
        } else {
            this.contactDetailPanel.getEmailPanel().getEmailTextField().setEnabled(false);
            this.contactDetailPanel.getEmailPanel().getGenerateOtpButton().setEnabled(false);
            this.contactDetailPanel.getEmailPanel().setValid(false);
        }
    }

    public void onEmailChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Email email = this.enrollmentService.getDemoContactDetails().getEmail();
        email.setEmail(this.contactDetailPanel.getEmailPanel().getEmailTextField().getText());
        this.updateAddressFieldState();
    }

    private void updateEmailFieldState() {
        super.clearFieldError(this.contactDetailPanel.getEmailPanel().getEmailTextField());
        Email email = this.enrollmentService.getDemoContactDetails().getEmail();
        if (!email.isValid()) {
            super.showFieldError(this.contactDetailPanel.getEmailPanel().getEmailTextField(), email.getEmailError());
        }
        if (!this.enrollmentService.isUpdateUC()) {
            this.contactDetailPanel.getEmailPanel().getGenerateOtpButton().setEnabled(!email.getEmailForDisplay().isEmpty() && !email.isEmailVerified());
        } else {
            this.contactDetailPanel.getEmailPanel().getGenerateOtpButton().setEnabled(email.isUpdated() && !email.isEmailVerified());
        }
    }
}

