/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.brnapi.state.BrnState;
import in.gov.uidai.ec.oauthapi.json.brnapi.state.StateData;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.NationalityType;
import in.gov.uidai.ec.protobuf.UcDemographicServiceProto;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantConfirmGender;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.Brn;
import in.gov.uidai.ec.service.enrollment.model.ConfirmDob;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedDocuments;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.RelativeDetail;
import in.gov.uidai.ec.service.packet.UCPacketSummary;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.demographics.EnrollmentStages;
import in.gov.uidai.ec.ui.enrol.demographics.StagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.PersonalDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.ResidentPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.ContactDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.BasicDetailControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ContactDetailControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ForeignDetailControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.PopulateDemoUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.ForeignPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemographicsControllerUC
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemographicsControllerUC.class);
    private final DemographicsTabViewPeerUC viewPeerUC;
    private final IVisualExecutionContext veCtxt;
    private boolean isReferencesTabRendered;
    private boolean isReviewTabRendered;
    private boolean isBiometricsTabRendered;
    private boolean isContactPopulated;
    private Map<StagesUC, Boolean> tabState;
    private PopulateDemoUC populateDemoUC;

    public DemographicsControllerUC(DemographicsTabViewPeerUC viewElement) {
        super(viewElement.getLiteView(), viewElement.getEnrollmentService(), 0, viewElement.getTabIndex());
        this.viewPeerUC = viewElement;
        this.veCtxt = this.view.getVisualExecutionContext();
        if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isDemographicTabRequired()) {
            this.initView();
        } else {
            this.initWithoutDemographics();
        }
    }

    private void initWithoutDemographics() {
        this.viewPeerUC.getButtonPanel().nextButton.addActionListener(this::onNextButtonClick);
        this.viewPeerUC.getButtonPanel().previousButton.addActionListener(this::onPrevButtonClick);
        this.viewPeerUC.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        this.enrollmentService.addOnTabTransitionListeners(this::onTabTransition);
        this.enrollmentService.getDemoPersonalDetails().getForeignDetail().addValidityChangeListener(e -> this.enableNextButton(StagesUC.FE_FOREIGN_DOCUMENTS_DETAILS));
        this.enrollmentService.getDemoPersonalDetails().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
        this.enrollmentService.getDemoResidentialStatus().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
        if (this.enrollmentService.isForeignResident() && FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POF)) {
            ForeignDetailControllerUC foreignDetailControllerUC = new ForeignDetailControllerUC(this.viewPeerUC, this.enrollmentService, this.viewPeerUC.getLiteView());
            ForeignPanel foreignPanel = this.viewPeerUC.getForeignPanel();
            super.addFocusListener(foreignPanel.getDocNoTextField(), foreignDetailControllerUC::onDocNoChange);
            super.addFocusListener(foreignPanel.getIssueDateField(), foreignDetailControllerUC::onDateChange);
            super.addFocusListener(foreignPanel.getExpiryDateField(), foreignDetailControllerUC::onDateChange);
            super.addItemListener(foreignPanel.getPOFField(), foreignDetailControllerUC::onPOFChange);
            super.addFocusListener(foreignPanel.getVisaIssueField(), foreignDetailControllerUC::onDateChange);
            super.addFocusListener(foreignPanel.getVisaExpiryField(), foreignDetailControllerUC::onDateChange);
            super.addItemListener(foreignPanel.getVisaField(), foreignDetailControllerUC::onPOFChange);
            super.addFocusListener(foreignPanel.getVisaNumber(), foreignDetailControllerUC::onVisaNoChange);
            ResidentPanel residentPanel = this.viewPeerUC.getBasicDetailPanel().getResidentPanel();
            BasicDetailControllerUC controllerUC = new BasicDetailControllerUC(this.viewPeerUC, this.enrollmentService, this.viewPeerUC.getLiteView());
            super.addItemListener(residentPanel.getNationalityList(), controllerUC::onNationalityChange);
            super.addItemListener(residentPanel.getForeignType(), (ItemEvent e) -> this.onForeignTypeChange(e, controllerUC));
            this.addForeignTypes(this.viewPeerUC.getBasicDetailPanel().getResidentPanel().getForeignType(), this.enrollmentService.getOnlineDocumentService().getNationalityTypes());
            this.enrollmentService.addForeignTypeListener(this::fetchForeignTypes);
            foreignPanel.getPoiRefresh().addActionListener(e -> this.populateForeignDocuments(this.enrollmentService.getDemoResidentialStatus().getForeignType()));
            foreignPanel.getPofRefresh().addActionListener(e -> this.populateForeignDocuments(this.enrollmentService.getDemoResidentialStatus().getForeignType()));
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.FOREIGN_TAB, new Object[0]), this.viewPeerUC.getForeignPanel().getTab());
        }
        this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.DISCLOSURE_TAB, new Object[0]), this.viewPeerUC.getDisclosurePanel().getTab());
        super.addActionListener(this.viewPeerUC.getDisclosurePanel().checkBox, this::onDisclosureChange);
        this.viewPeerUC.getDemoPanel().getTabbedPane().addChangeListener(this::onTabChange);
        this.initialise();
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
    }

    private void initView() {
        boolean isBRNEnabled;
        this.viewPeerUC.getButtonPanel().nextButton.addActionListener(this::onNextButtonClick);
        this.viewPeerUC.getButtonPanel().previousButton.addActionListener(this::onPrevButtonClick);
        this.viewPeerUC.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        this.enrollmentService.addOnTabTransitionListeners(this::onTabTransition);
        this.enrollmentService.getDemoPersonalDetails().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
        this.enrollmentService.getDemoContactDetails().addValidityChangeListener(e -> this.enableNextButton(StagesUC.CONTACT_DETAILS));
        this.enrollmentService.getDemoPersonalDetails().getForeignDetail().addValidityChangeListener(e -> this.enableNextButton(StagesUC.FE_FOREIGN_DOCUMENTS_DETAILS));
        this.enrollmentService.getDemoResidentialStatus().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
        PersonalDetailPanel personalDetailPanel = this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel();
        ResidentPanel residentPanel = this.viewPeerUC.getBasicDetailPanel().getResidentPanel();
        BasicDetailControllerUC controllerUC = new BasicDetailControllerUC(this.viewPeerUC, this.enrollmentService, this.viewPeerUC.getLiteView());
        super.addFocusListener(personalDetailPanel.getNameField(), controllerUC::nameFocusLost);
        super.addFocusListener(personalDetailPanel.getLocalName(), controllerUC::locNameFocusLost);
        super.addItemListener(personalDetailPanel.getGenderPanel().getGenderField(), controllerUC::onGenderChange);
        super.addItemListener(personalDetailPanel.getGenderPanel().getConfirmGenderField(), controllerUC::onConfirmGenderChange);
        super.addActionListener(personalDetailPanel.getDobOpt(), controllerUC::onDobOptSelected);
        super.addActionListener(personalDetailPanel.getConfirmDobOpt(), controllerUC::onDobOptSelected);
        super.addActionListener(personalDetailPanel.getAgeOpt(), controllerUC::onDobOptSelected);
        super.addActionListener(personalDetailPanel.getConfirmAgeOpt(), controllerUC::onDobOptSelected);
        super.addFocusListener(personalDetailPanel.getDobField(), controllerUC::onDobChange);
        super.addFocusListener(personalDetailPanel.getAgeField(), controllerUC::onDobChange);
        super.addFocusListener(personalDetailPanel.getConfirmDobField(), controllerUC::onConfirmDobChange);
        super.addFocusListener(personalDetailPanel.getConfirmAgeField(), controllerUC::onConfirmDobChange);
        super.addItemListener(residentPanel.getNationalityList(), controllerUC::onNationalityChange);
        super.addItemListener(residentPanel.getForeignType(), (ItemEvent e) -> this.onForeignTypeChange(e, controllerUC));
        if (this.enrollmentService.isUpdateUC()) {
            super.addFocusListener(personalDetailPanel.getNewNameField(), controllerUC::newNameFocusLost);
            super.addFocusListener(personalDetailPanel.getNewLocalNameField(), controllerUC::newLocalNameFocusLost);
        }
        if (this.enrollmentService.getDemoPersonalDetails().getAgeDob().isDobSelected()) {
            personalDetailPanel.getAgePanel().setAgeEnable(false);
        }
        ContactDetailControllerUC contactDetailControllerUC = new ContactDetailControllerUC(this.viewPeerUC, this.enrollmentService, this.viewPeerUC.getLiteView());
        ContactDetailPanel contactDetailPanel = this.viewPeerUC.getContactDetailPanel();
        this.populateDemoUC = new PopulateDemoUC(this.viewPeerUC, controllerUC, contactDetailControllerUC);
        if (!this.enrollmentService.doesNriHaveForeignAddress()) {
            super.addFocusListener(contactDetailPanel.getCareofPanel().getCareofTextField(), contactDetailControllerUC::careOfNameFocusLost);
            super.addFocusListener(contactDetailPanel.getCareofPanel().getLocCareOf(), contactDetailControllerUC::locCareOfNameFocusLost);
            super.addFocusListener(contactDetailPanel.getHousePanel().getHouseTextField(), contactDetailControllerUC::houseFocusLost);
            super.addFocusListener(contactDetailPanel.getHousePanel().getLocalHouse(), contactDetailControllerUC::locHouseFocusLost);
            super.addFocusListener(contactDetailPanel.getStreetPanel().getStreetTextField(), contactDetailControllerUC::streetFocusLost);
            super.addFocusListener(contactDetailPanel.getStreetPanel().getLocalStreet(), contactDetailControllerUC::locStreetFocusLost);
            super.addFocusListener(contactDetailPanel.getLandmarkPanel().getLandmark(), contactDetailControllerUC::landmarkFocusLost);
            super.addFocusListener(contactDetailPanel.getLandmarkPanel().getLocalLandmark(), contactDetailControllerUC::locLandmarkFocusLost);
            super.addFocusListener(contactDetailPanel.getLocalityPanel().getLocalityTextField(), contactDetailControllerUC::localityFocusLost);
            super.addFocusListener(contactDetailPanel.getLocalityPanel().getLocalLocality(), contactDetailControllerUC::locLocalityFocusLost);
            if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment()) {
                super.addFocusListener(contactDetailPanel.getPostOfficePanel().getPostOfficeTextField(), contactDetailControllerUC::postOfficeFocusLost);
            }
            this.enrollmentService.addOnPinCodeLoadedListeners(contactDetailControllerUC::onPinCodeLoaded);
            this.enrollmentService.addOnPOListLoadedListeners(contactDetailControllerUC::onPOCodeLoaded);
        } else {
            super.addFocusListener(contactDetailPanel.getAddressPanelOne().getaddressTextField(), contactDetailControllerUC::addressOneFocuslost);
            super.addFocusListener(contactDetailPanel.getAddressPanelTwo().getaddressTextField(), contactDetailControllerUC::addressTwoFocuslost);
            super.addFocusListener(contactDetailPanel.getAddressPanelThree().getaddressTextField(), contactDetailControllerUC::addressThreeFocuslost);
            super.addFocusListener(contactDetailPanel.getZipCodePanel().getzipcodeTextField(), contactDetailControllerUC::zipcodeFocusLost);
            super.addItemListener(contactDetailPanel.getZipCodePanel().getCountryListComboBox(), contactDetailControllerUC::onCountryChange);
            this.addForeignCountriesForNRI(this.viewPeerUC.getContactDetailPanel().getZipCodePanel().getCountryListComboBox(), this.enrollmentService.getOnlineDocumentService().getCountryList());
        }
        super.addFocusListener(contactDetailPanel.getMobilePanel().getMobileTextField(), contactDetailControllerUC::onMobileChange);
        super.addFocusListener(contactDetailPanel.getEmailPanel().getEmailTextField(), contactDetailControllerUC::onEmailChange);
        this.enrollmentService.getDemoContactDetails().getMobile().addChangeListener(contactDetailControllerUC::onMobileVerified);
        this.enrollmentService.getDemoContactDetails().getEmail().addChangeListener(contactDetailControllerUC::onEmailVerified);
        if (this.enrollmentService.isForeignResident()) {
            ForeignDetailControllerUC foreignDetailControllerUC = new ForeignDetailControllerUC(this.viewPeerUC, this.enrollmentService, this.viewPeerUC.getLiteView());
            ForeignPanel foreignPanel = this.viewPeerUC.getForeignPanel();
            super.addFocusListener(foreignPanel.getDocNoTextField(), foreignDetailControllerUC::onDocNoChange);
            super.addFocusListener(foreignPanel.getIssueDateField(), foreignDetailControllerUC::onDateChange);
            super.addFocusListener(foreignPanel.getExpiryDateField(), foreignDetailControllerUC::onDateChange);
            super.addItemListener(foreignPanel.getPOFField(), foreignDetailControllerUC::onPOFChange);
            super.addFocusListener(foreignPanel.getVisaIssueField(), foreignDetailControllerUC::onDateChange);
            super.addFocusListener(foreignPanel.getVisaExpiryField(), foreignDetailControllerUC::onDateChange);
            super.addItemListener(foreignPanel.getVisaField(), foreignDetailControllerUC::onPOFChange);
            super.addFocusListener(foreignPanel.getVisaNumber(), foreignDetailControllerUC::onVisaNoChange);
            this.addForeignTypes(this.viewPeerUC.getBasicDetailPanel().getResidentPanel().getForeignType(), this.enrollmentService.getOnlineDocumentService().getNationalityTypes());
            this.enrollmentService.addForeignTypeListener(this::fetchForeignTypes);
            foreignPanel.getPoiRefresh().addActionListener(e -> this.populateForeignDocuments(this.enrollmentService.getDemoResidentialStatus().getForeignType()));
            foreignPanel.getPofRefresh().addActionListener(e -> this.populateForeignDocuments(this.enrollmentService.getDemoResidentialStatus().getForeignType()));
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.CONTACT_TAB, new Object[0]), this.viewPeerUC.getContactDetailPanel().getTab());
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.FOREIGN_TAB, new Object[0]), this.viewPeerUC.getForeignPanel().getTab());
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.DISCLOSURE_TAB, new Object[0]), this.viewPeerUC.getDisclosurePanel().getTab());
        } else {
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.CONTACT_TAB, new Object[0]), this.viewPeerUC.getContactDetailPanel().getTab());
            this.addTab(this.viewPeerUC.getEnrolRbctx().getMessage((Object)LabelKeysTab.DISCLOSURE_TAB, new Object[0]), this.viewPeerUC.getDisclosurePanel().getTab());
        }
        boolean isBRNPresent = this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isDocumentBasedEnrollment() && !this.enrollmentService.isForeignResident();
        boolean bl = isBRNEnabled = this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isForeignResident();
        if (isBRNPresent && isBRNEnabled) {
            super.addActionListener(this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getHaveBRNNumberButton(), controllerUC::onBrnButtonChange);
            super.addActionListener(this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getNotHaveBRNNumberButton(), controllerUC::onBrnButtonChange);
            this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getNotHaveBRNNumberButton().setSelected(true);
            ArrayList<BrnState> statesLists = new ArrayList<BrnState>(StateData.onlineDocuments);
            this.addItems(this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getStateList(), (List<BrnState>)statesLists, (BrnState)null);
            super.addItemListener(this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getStateList(), controllerUC::brnStateFocusLost);
            super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getBrnDetailsPanel().getBrnTextField(), controllerUC::brnFieldFocusLost);
        }
        if (this.enrollmentService.isHofEnrollment()) {
            this.enrollmentService.getDemographics().getFatherDetail().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
            this.enrollmentService.getDemographics().getMotherDetail().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
            this.enrollmentService.getDemographics().getOtherDetail().addValidityChangeListener(e -> this.enableNextButton(StagesUC.BASIC_DETAILS));
            if (this.enrollmentService.isNewEnrollmentUC()) {
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getFatherUID(), e -> controllerUC.onUidFocusLost(e, RelationshipType.FATHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getMotherUID(), e -> controllerUC.onUidFocusLost(e, RelationshipType.MOTHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getOtherUID(), e -> controllerUC.onUidFocusLost(e, RelationshipType.LEGAL_GUARDIAN));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getFatherName(), e -> controllerUC.onRelativeNameFocusLost(e, RelationshipType.FATHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getMotherName(), e -> controllerUC.onRelativeNameFocusLost(e, RelationshipType.MOTHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getOtherName(), e -> controllerUC.onRelativeNameFocusLost(e, RelationshipType.LEGAL_GUARDIAN));
                controllerUC.populateRelatives(this.enrollmentService.getDemographics().getOtherDetail().getRelationType(), isBRNPresent);
            } else {
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getFatherName(), e -> controllerUC.onRelativeNameFocusLostForUpdate(e, RelationshipType.FATHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getMotherName(), e -> controllerUC.onRelativeNameFocusLostForUpdate(e, RelationshipType.MOTHER));
                super.addFocusListener(this.viewPeerUC.getBasicDetailPanel().getRelativeDetailsPanel().getOtherName(), e -> controllerUC.onRelativeNameFocusLostForUpdate(e, RelationshipType.LEGAL_GUARDIAN));
                controllerUC.populateRelativesForUpdate(this.enrollmentService.getDemographics().getOtherDetail().getRelationType());
            }
        }
        super.addActionListener(this.viewPeerUC.getDisclosurePanel().checkBox, this::onDisclosureChange);
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().addMandatoryChangeListener(e -> this.setMandatoryField(e, "age"));
        this.enrollmentService.getDemoPersonalDetails().getApplicantGender().addMandatoryChangeListener(e -> this.setMandatoryField(e, "gender"));
        this.enrollmentService.getDemoContactDetails().getAddress().addMandatoryChangeListener(e -> this.setMandatoryField(e, "address"));
        this.enrollmentService.getDemoContactDetails().getMobile().addMandatoryChangeListener(e -> this.setMandatoryField(e, "mobile"));
        this.enrollmentService.getDemoContactDetails().getEmail().addMandatoryChangeListener(e -> this.setMandatoryField(e, "email"));
        this.enrollmentService.getDemoContactDetails().getForeignNriAddress().addMandatoryChangeListener(e -> this.setMandatoryField(e, "address"));
        this.viewPeerUC.getDemoPanel().getTabbedPane().addChangeListener(this::onTabChange);
        this.initialise();
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
    }

    private void onForeignTypeChange(ItemEvent ie, BasicDetailControllerUC controllerUC) {
        boolean selected = ie.getStateChange() == 1;
        NationalityTypes type = (NationalityTypes)ie.getItem();
        if (this.enrollmentService.isForeignResident() && selected && !type.getName().equals("Select")) {
            LOGGER.info("Foreign Type changed to {}", (Object)type.getName());
            ThreadPool.commonPool().submit(() -> this.populateForeignDocuments(type));
        }
        controllerUC.onNationalityChange(ie);
    }

    private void addItems(JComboBox<ProofDocument> comboBox, List<ProofDocument> options, ProofDocument defaultSelect) {
        comboBox.removeAllItems();
        options.forEach(comboBox::addItem);
        if (defaultSelect != null) {
            comboBox.setSelectedItem(defaultSelect);
        }
    }

    private void addItems(JComboBox<String> comboBox, List<BrnState> options, BrnState defaultSelect) {
        comboBox.removeAllItems();
        comboBox.addItem("Select");
        options.forEach(brnState -> comboBox.addItem(brnState.getStateName()));
        if (defaultSelect != null) {
            comboBox.setSelectedItem(defaultSelect);
        }
        comboBox.setSelectedItem("Select");
    }

    private void addVisaItems(JComboBox<ProofDocument> comboBox, List<ProofDocument> options, ProofDocument defaultSelect) {
        comboBox.removeAllItems();
        options.forEach(item -> {
            if (this.enrollmentService.isNewEnrollmentUC() && !item.getDocName().contains("Nepalese / Bhutanese - Passport")) {
                comboBox.addItem((ProofDocument)item);
            } else {
                comboBox.addItem((ProofDocument)item);
            }
        });
        if (defaultSelect != null) {
            comboBox.setSelectedItem(defaultSelect);
        }
    }

    private void addForeignTypes(JComboBox<NationalityTypes> comboBox, NationalityType[] nationalityTypes) {
        comboBox.removeAllItems();
        if (nationalityTypes != null) {
            comboBox.addItem(new NationalityTypes("", "Select"));
            List<NationalityType> nationalityTypeList = Arrays.asList(nationalityTypes);
            nationalityTypeList.forEach(item -> {
                if (!item.getNationalityTypeCode().equals("INDIAN")) {
                    comboBox.addItem(new NationalityTypes(item.getNationalityTypeCode(), item.getNationalityTypeName()));
                }
            });
            comboBox.setSelectedItem("Select");
        }
    }

    private void fetchForeignTypes() {
        this.addForeignTypes(this.viewPeerUC.getBasicDetailPanel().getResidentPanel().getForeignType(), this.enrollmentService.getOnlineDocumentService().getNationalityTypes());
    }

    private void addForeignCountriesForNRI(JComboBox<Country> comboBox, CountryList[] countries) {
        comboBox.removeAllItems();
        comboBox.addItem(new Country("Select", ""));
        if (countries != null) {
            List<CountryList> countryLists = Arrays.asList(countries);
            countryLists.forEach(item -> {
                if (item.isActive() && !item.getCountryName().equalsIgnoreCase("INDIA")) {
                    comboBox.addItem(new Country(item.getCountryName(), item.getCountryCode()));
                }
            });
        }
        comboBox.setSelectedItem("Select");
    }

    private void initialise() {
        StagesUC[] stages;
        this.tabState = new HashMap<StagesUC, Boolean>();
        for (StagesUC stage : stages = EnrollmentStages.getTabs(this.enrollmentService.isNewEnrollmentUC(), this.enrollmentService.isForeignResident())) {
            this.tabState.put(stage, false);
        }
        this.viewPeerUC.getDemoSections().setValid(this.tabState);
        ShadowPanel currentPanel = (ShadowPanel)this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedComponent();
        this.viewPeerUC.getDemoSections().currentTab(EnrollmentStages.getTabs()[this.viewPeerUC.getTabIndex()]);
    }

    @Override
    public void onNextButtonClick(ActionEvent event) {
        ShadowPanel currentPanel = (ShadowPanel)this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedComponent();
        int tabIndex = this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex();
        switch (currentPanel.getDemographicStage()) {
            case BASIC_DETAILS: {
                ThreadPool.commonPool().submit(this::packetDetails);
                this.handleBasicDetails(event, tabIndex);
                break;
            }
            case CONTACT_DETAILS: {
                this.handleContactDetails(event, tabIndex);
                break;
            }
            case FE_FOREIGN_DOCUMENTS_DETAILS: {
                this.handleForeignDocumentsDetails(event, tabIndex);
                break;
            }
            case DISCLOSURE: {
                this.handleDisclosure(event);
            }
        }
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex() != 0);
    }

    private void packetDetails() {
        UCPacketSummary pktsum = new UCPacketSummary();
        pktsum.setSid(this.enrollmentService.getSid());
        pktsum.setNRI(this.enrollmentService.isNRIEnrolment());
        pktsum.setOpId(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId());
        pktsum.setPktType(this.enrollmentService.getUpdateType().toString());
        this.viewPeerUC.getUCPacketDAO().putUCPacketSummary(pktsum);
    }

    private void handleBasicDetails(ActionEvent event, int tabIndex) {
        if (!this.enrollmentService.getDemoPersonalDetails().isValid() || !this.enrollmentService.getDemoResidentialStatus().isValid()) {
            LOGGER.warn("Personal detail validity: {}", (Object)this.enrollmentService.getDemoPersonalDetails().isValid());
            LOGGER.warn("Residential status validity : {}", (Object)this.enrollmentService.getDemoResidentialStatus().isValid());
            this.showWarningUC("Please fill the mandatory fields.", this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNameField());
            return;
        }
        if (this.enrollmentService.isUpdateUC() && !this.enrollmentService.isAadhaarActive() && this.enrollmentService.getDemoResidentialStatus().isValid()) {
            this.proceedToNextTab(event, tabIndex);
            return;
        }
        this.proceedToNextTab(event, tabIndex);
        if (this.enrollmentService.isUpdateUC() && !FieldInfoUtils.isDemographicTabRequired()) {
            return;
        }
        if (this.enrollmentService.isUpdateUC() && !this.isContactPopulated) {
            boolean isAddressUpdate = this.enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated();
            boolean isMobileUpdate = this.enrollmentService.getFieldsUpdateCount().getMobile().hasToBeUpdated();
            boolean isEmailUpdate = this.enrollmentService.getFieldsUpdateCount().getEmail().hasToBeUpdated();
            ForeignNRI foreignAddress = this.enrollmentService.getDemoContactDetails().getForeignNriAddress();
            Address address = this.enrollmentService.getDemoContactDetails().getAddress();
            Email email = this.enrollmentService.getDemoContactDetails().getEmail();
            Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
            foreignAddress.setUpdated(isAddressUpdate && this.enrollmentService.doesNriHaveForeignAddress());
            address.setUpdated(isAddressUpdate && !this.enrollmentService.doesNriHaveForeignAddress());
            email.setUpdated(isEmailUpdate);
            mobile.setUpdated(isMobileUpdate);
            if (foreignAddress.isMandatory()) {
                foreignAddress.setToExistingAddress();
            } else {
                address.setToExistingAddress();
            }
            if (isEmailUpdate) {
                email.setEmail(email.getExistingEmail());
            }
            if (isMobileUpdate) {
                mobile.setNumber(mobile.getExistingNumber());
            }
        } else if (this.enrollmentService.isHofEnrollment() && !this.isContactPopulated) {
            boolean isForeignAddress = this.enrollmentService.doesNriHaveForeignAddress();
            Address address = this.enrollmentService.getDemoContactDetails().getAddress();
            if (isForeignAddress) {
                this.enrollmentService.getDemoContactDetails().getForeignNriAddress().setToExistingAddress();
            } else {
                address.setToExistingAddress();
            }
            this.viewPeerUC.getContactDetailPanel().setEditable(false, isForeignAddress);
            if (!isForeignAddress && (Strings.isNullOrEmpty((String)address.getPoName()) || address.getPoName().equalsIgnoreCase("Select"))) {
                this.viewPeerUC.getContactDetailPanel().setPostOfficeEditable();
            }
        }
        if (!this.isContactPopulated) {
            this.populateDemoUC.populateContactDetails(this.enrollmentService.getDemoContactDetails(), this.enrollmentService.doesNriHaveForeignAddress());
            this.isContactPopulated = true;
        }
        if (this.enrollmentService.isUpdateUC() && this.enrollmentService.isHofEnrollment()) {
            this.populateDemoUC.populateCareOfField(this.enrollmentService.getDemoContactDetails().getAddress().getCareOfName(), this.enrollmentService.getDemoContactDetails().getAddress().getCareOfNameLocal());
        }
        if (!this.enrollmentService.getDemoContactDetails().isMandatory() || this.enrollmentService.getDemoContactDetails().isValid()) {
            this.enableNextButton(EnrollmentStages.getTabs()[tabIndex + 1]);
        }
    }

    private void handleContactDetails(ActionEvent event, int tabIndex) {
        if (this.enrollmentService.getDemoContactDetails().isValid()) {
            this.proceedToNextTab(event, tabIndex);
        } else {
            this.showWarningUC("Please fill the mandatory fields.", this.viewPeerUC.getContactDetailPanel().getCareofPanel().getCareofTextField());
        }
    }

    private void handleForeignDocumentsDetails(ActionEvent event, int tabIndex) {
        if (this.enrollmentService.isForeignResident() && this.enrollmentService.getDemoPersonalDetails().getForeignDetail().isValid()) {
            this.proceedToNextTab(event, tabIndex);
        } else {
            this.showWarningUC("Please fill the mandatory fields.", this.viewPeerUC.getForeignPanel().getDocNoTextField());
        }
    }

    private void handleDisclosure(ActionEvent event) {
        if (this.viewPeerUC.getDisclosurePanel().checkBox.isSelected()) {
            Utils.showProgressBar(this.veCtxt, "Uploading demographics data");
            ThreadPool.commonPool().submit(() -> {
                try {
                    if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isDemographicTabRequired() || FieldInfoUtils.isPOFRequired()) {
                        this.saveDemographicsToBackend(event);
                    } else {
                        this.renderNextTab();
                        Utils.cancelProgressBar(this.veCtxt);
                        super.onNextButtonClickForeign(event, this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex(), this.tabState.size(), "hID_Foreign_TabPane");
                    }
                }
                catch (OnlineGatewayException ex) {
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), ex.getErrorCode(), new String[0]);
                    LOGGER.error("Error occurred while uploading demographic data to server", (Throwable)ex);
                    Utils.cancelProgressBar(this.veCtxt);
                }
            });
        } else {
            this.showWarningUC("Please fill the mandatory fields.", this.viewPeerUC.getDisclosurePanel().checkBox);
        }
    }

    private void onTabTransition(Object o) {
        int tabIndex = (Integer)o;
        if (tabIndex == 0 && !this.viewPeerUC.isDemoDataUploaded) {
            this.handleDisclosure(new ActionEvent(o, 1, "TabTransition"));
        }
    }

    private void addTab(String title, JComponent component) {
        this.viewPeerUC.getDemoPanel().getTabbedPane().addTab(title, component);
    }

    private void proceedToNextTab(ActionEvent event, int tabIndex) {
        this.viewPeerUC.getDemoSections().setValid(this.tabState);
        this.viewPeerUC.getDemoSections().currentTab(EnrollmentStages.getTabs()[tabIndex + 1]);
        super.onNextButtonClickForeign(event, tabIndex, this.tabState.size(), "hID_Foreign_TabPane");
    }

    private void renderNextTab() {
        boolean isrefScreenReq;
        boolean bl = isrefScreenReq = this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isReferenceTabRequired();
        if (isrefScreenReq) {
            if (this.enrollmentService.isTabEnabled(1) && !this.isReferencesTabRendered) {
                this.viewPeerUC.getRefTabUC().renderReferencesTab();
                this.isReferencesTabRendered = true;
            }
            return;
        }
        boolean isPhotoTabReq = FieldInfoUtils.isPhotoTabRequired();
        boolean isFingerTabReq = FieldInfoUtils.isFingerTabRequired();
        boolean isIrisTabReq = FieldInfoUtils.isIrisTabRequired();
        if (!this.isBiometricsTabRendered) {
            if (isPhotoTabReq && this.enrollmentService.isTabEnabled(2)) {
                this.viewPeerUC.getPhotoTab().renderPhotoTab();
            }
            if (isFingerTabReq && this.enrollmentService.isTabEnabled(3)) {
                this.viewPeerUC.getFingerTab().renderFingerTab();
            }
            if (isIrisTabReq && this.enrollmentService.isTabEnabled(4)) {
                this.viewPeerUC.getIrisTab().renderIrisTab();
            }
            this.isBiometricsTabRendered = true;
            return;
        }
        if (!this.isReviewTabRendered && !isPhotoTabReq) {
            this.viewPeerUC.getReviewTabUC().renderReviewTabUC();
            this.isReviewTabRendered = true;
        }
    }

    @Override
    public void onPrevButtonClick(ActionEvent event) {
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex() != 1);
        this.viewPeerUC.getButtonPanel().nextButton.setEnabled(true);
        this.viewPeerUC.getDemoSections().setValid(this.tabState);
        this.viewPeerUC.getDemoSections().currentTab(EnrollmentStages.getTabs()[this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex() - 1]);
        super.onPrevButtonClickForeign(event, this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex());
    }

    private void enableNextButton(StagesUC stages) {
        if (this.tabState != null) {
            switch (stages) {
                case BASIC_DETAILS: {
                    this.tabState.replace(stages, this.isBasicDetailValid());
                    break;
                }
                case CONTACT_DETAILS: {
                    this.tabState.replace(stages, this.enrollmentService.getDemoContactDetails().isValid());
                    break;
                }
                case FE_FOREIGN_DOCUMENTS_DETAILS: {
                    this.tabState.replace(stages, this.enrollmentService.getDemoPersonalDetails().getForeignDetail().isValid());
                    break;
                }
                default: {
                    this.tabState.replace(stages, false);
                }
            }
            this.viewPeerUC.getButtonPanel().nextButton.setEnabled(this.tabState.get((Object)stages));
            this.viewPeerUC.getDemoSections().setValid(this.tabState);
            if (!this.tabState.containsValue(false)) {
                this.updateTabValidityState(true);
            }
        }
    }

    private boolean isRelativeDetailsValid() {
        RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
        RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
        RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
        return fatherDetail.isValid() || motherDetail.isValid() || otherDetail.isValid();
    }

    private void onTabChange(ChangeEvent event) {
        int tabIndex = this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex();
        StagesUC stage = EnrollmentStages.getTabs()[tabIndex];
        this.viewPeerUC.getButtonPanel().nextButton.setEnabled(this.tabState.get((Object)stage));
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex() != 0);
        if (!this.tabState.containsValue(false)) {
            this.updateTabValidityState(true);
        }
    }

    private void onViewLoadComplete(Object o) {
        if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isDemographicTabRequired()) {
            this.populateView();
            this.enableNextButton(StagesUC.BASIC_DETAILS);
            if (this.enrollmentService.isUpdateUC()) {
                this.disableFields();
                this.setMandatoryBasedOnUpdate();
            }
        }
        if (this.enrollmentService.isNewEnrollmentUC()) {
            this.enrollmentService.getDemoPersonalDetails().getForeignDetail().setUpdated(this.enrollmentService.isForeignResident());
        } else {
            this.enrollmentService.getDemoPersonalDetails().getForeignDetail().setUpdated(this.enrollmentService.isForeignResident() && (FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POI) || FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POF)));
        }
    }

    private void disableFields() {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNameField().setEnabled(false);
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getLocalName().setEnabled(false);
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNewNameField().setEnabled(fieldsUpdateCount.getName().hasToBeUpdated());
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNewLocalNameField().setEnabled(fieldsUpdateCount.getName().hasToBeUpdated());
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getGenderField().setEnabled(fieldsUpdateCount.getGender().hasToBeUpdated());
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setEnabled(fieldsUpdateCount.getGender().hasToBeUpdated());
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getDobField().setEnabled(fieldsUpdateCount.getDob().hasToBeUpdated());
        this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getConfirmDobField().setEnabled(fieldsUpdateCount.getDob().hasToBeUpdated());
        this.viewPeerUC.getContactDetailPanel().setEveryFieldEnabled(fieldsUpdateCount.getAddress().hasToBeUpdated(), this.enrollmentService.doesNriHaveForeignAddress());
        this.viewPeerUC.getContactDetailPanel().getEmailPanel().getEmailTextField().setEnabled(fieldsUpdateCount.getEmail().hasToBeUpdated());
        this.viewPeerUC.getContactDetailPanel().getMobilePanel().getMobileTextField().setEnabled(fieldsUpdateCount.getMobile().hasToBeUpdated());
    }

    private void setMandatoryBasedOnUpdate() {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        Name name = this.enrollmentService.getDemoPersonalDetails().getName();
        name.setUpdated(fieldsUpdateCount.getName().hasToBeUpdated());
        if (!fieldsUpdateCount.getName().hasToBeUpdated()) {
            this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNewNameField().setText("");
            this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getNewLocalNameField().setText("");
            name.setNewName("");
            name.setNewNameLocal("");
        }
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        ageDob.setUpdated(fieldsUpdateCount.getDob().hasToBeUpdated());
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        confirmDob.setUpdated(fieldsUpdateCount.getDob().hasToBeUpdated());
        ApplicantGender gender = this.enrollmentService.getDemoPersonalDetails().getApplicantGender();
        ApplicantConfirmGender confirmGender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantConfirmGender();
        gender.setUpdated(fieldsUpdateCount.getGender().hasToBeUpdated());
        confirmGender.setUpdated(fieldsUpdateCount.getGender().hasToBeUpdated());
        if (gender.isUpdated()) {
            if (gender.getGender() == Gender.NOT_GIVEN) {
                gender.setGender(gender.getExistingGender());
            }
            if (confirmGender.getGender() == Gender.NOT_GIVEN) {
                confirmGender.setGender(confirmGender.getExistingGender());
            }
        } else {
            gender.setGender(Gender.NOT_GIVEN);
            confirmGender.setGender(Gender.NOT_GIVEN);
            gender.setGenderLocal("");
            confirmGender.setGenderLocal("");
            Gender displayGender = gender.getDisplayGender();
            if (displayGender == Gender.NOT_GIVEN) {
                this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getGenderField().setSelectedIndex(0);
                this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setSelectedIndex(0);
            } else {
                this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getGenderField().setSelectedItem(displayGender);
                this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getGenderPanel().getConfirmGenderField().setSelectedItem(displayGender);
            }
            this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel().getLocalGender().setText(String.valueOf(displayGender));
        }
    }

    private void populateView() {
        this.populateDemoUC.populatePersonalDetails(this.enrollmentService.getDemoPersonalDetails());
        this.populateDemoUC.populateAppointmentId(this.enrollmentService.getAppointment().getAppointmentId());
        if (this.enrollmentService.isForeignResident()) {
            this.populateDemoUC.populateForeignNationality(this.enrollmentService.getDemoResidentialStatus());
        }
        if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment()) {
            this.populateDemoUC.populateHofDetails(this.enrollmentService);
        } else if (this.enrollmentService.isHofEnrollment()) {
            this.populateDemoUC.populateHofDetailsForHofUpdate(this.enrollmentService);
        }
        this.populateDemoUC.populateMobileEmailDetails(this.enrollmentService.getDemoContactDetails(), this.enrollmentService.getIsdService());
    }

    private void populateForeignDocuments(NationalityTypes nationalityType) {
        if (this.enrollmentService.isForeignResident() && !nationalityType.getCode().isEmpty()) {
            AgeGroup ageGroup = this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup();
            if (this.populateProofDocumentList(nationalityType.getCode(), this.enrollmentService.isNewEnrollmentUC() ? "NEW" : "UPDATE", ageGroup)) {
                References references = this.enrollmentService.getReferences();
                ReferenceAllowedDocuments allowedDocuments = references.getAllowedDocuments();
                if (references.getPoi().getProof().getDocName().contains("Select") || !allowedDocuments.getPoiDocs().contains(references.getPoi().getProof())) {
                    this.addItems(this.viewPeerUC.getForeignPanel().getPOFField(), allowedDocuments.getPoiDocs(), references.getPoi().getProof());
                }
                if (references.getPoi().getProof().getDocName().contains("Select") || !allowedDocuments.getPofDocs().contains(references.getPof().getProof())) {
                    this.addVisaItems(this.viewPeerUC.getForeignPanel().getVisaField(), allowedDocuments.getPofDocs(), references.getPof().getProof());
                }
            }
        }
    }

    private void saveDemographicsToBackend(ActionEvent event) {
        GrpcService grpcService = GrpcService.getInst();
        UcDemographicServiceProto.UpdateDemoRequest updateDemoRequest = this.enrollmentService.isNewEnrollmentUC() ? this.createEnrolDemoRequest() : this.createUpdateDemoRequest();
        CountDownLatch demoUploadCompleted = new CountDownLatch(1);
        grpcService.uploadDemo(updateDemoRequest, updateDemoResponse -> {
            LOGGER.info("Upload Demo Call Successful !");
            this.viewPeerUC.isDemoDataUploaded = true;
            Utils.cancelProgressBar(this.veCtxt);
            demoUploadCompleted.countDown();
            this.renderNextTab();
            if (!event.getActionCommand().equals("TabTransition")) {
                super.onNextButtonClickForeign(event, this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex(), this.tabState.size(), "hID_Foreign_TabPane");
            }
        }, errorResponse -> {
            LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), errorResponse);
            Utils.cancelProgressBar(this.veCtxt);
            demoUploadCompleted.countDown();
            this.showErrorUC((JComponent)event.getSource(), CommonUtilsUC.getErrorMessage(errorResponse), errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        });
        try {
            demoUploadCompleted.await(25L, TimeUnit.SECONDS);
            Utils.cancelProgressBar(this.veCtxt);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private UcDemographicServiceProto.UpdateDemoRequest createUpdateDemoRequest() {
        boolean isAddressValid;
        UcDemographicServiceProto.UpdateDemoRequest.Builder builder = UcDemographicServiceProto.UpdateDemoRequest.newBuilder();
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        Contact contact = demographics.getContact();
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        if (fieldsUpdateCount.getName().hasToBeUpdated() && personalDetail.getName().isValid()) {
            builder.setName(personalDetail.getName().newEnglish()).setLocalName(personalDetail.getName().newNameLocal());
        }
        boolean bl = isAddressValid = contact.getAddress().isValid() || contact.getForeignNriAddress().isValid();
        if ((fieldsUpdateCount.getAddress().hasToBeUpdated() || this.enrollmentService.isHofEnrollment()) && isAddressValid) {
            builder.setAddress(this.buildAddress(contact));
        }
        if (fieldsUpdateCount.getGender().hasToBeUpdated() && personalDetail.getApplicantGender().isValid()) {
            builder.setGender(personalDetail.getApplicantGender().getGender().toShorthand());
        }
        if (fieldsUpdateCount.getDob().hasToBeUpdated() && personalDetail.getAgeDob().isValid()) {
            builder.setDob(personalDetail.getAgeDob().getAgeDobFormattedUC()).setDobType(UcDemographicServiceProto.DobType.valueOf((String)personalDetail.getAgeDob().getStatus().value()));
        }
        if (fieldsUpdateCount.getMobile().hasToBeUpdated() && contact.getMobile().isValid() && contact.getMobile().isMobileVerified() && !contact.getMobile().getNumberForDisplay().isEmpty()) {
            builder.setMobile(this.buildMobile(contact.getMobile()));
        }
        if (fieldsUpdateCount.getEmail().hasToBeUpdated() && contact.getEmail().isValid() && contact.getEmail().isEmailVerified() && !contact.getEmail().getEmailForDisplay().isEmpty()) {
            builder.setEmail(this.buildEmail(contact.getEmail()));
        }
        if (this.enrollmentService.isForeignResident()) {
            builder.setResidentForeigner(this.buildResidentForeigner());
        }
        if (this.enrollmentService.isHofEnrollment()) {
            builder.addAllRelations(this.createChildSaveRequest());
        }
        builder.setLanguageCode(this.enrollmentService.getEnrollmentLangCode()).setSid(this.enrollmentService.getSid());
        return builder.build();
    }

    private UcDemographicServiceProto.UpdateDemoRequest createEnrolDemoRequest() {
        UcDemographicServiceProto.UpdateDemoRequest.Builder builder = UcDemographicServiceProto.UpdateDemoRequest.newBuilder();
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        Contact contact = demographics.getContact();
        builder.setAddress(this.buildAddress(contact)).setName(personalDetail.getName().english()).setLocalName(personalDetail.getName().local()).setGender(personalDetail.getApplicantGender().getGender().toShorthand()).setDob(personalDetail.getAgeDob().getAgeDobFormattedUC()).setDobType(UcDemographicServiceProto.DobType.valueOf((String)personalDetail.getAgeDob().getStatus().value())).setLanguageCode(this.enrollmentService.getEnrollmentLangCode()).setSid(this.enrollmentService.getSid());
        if (contact.getMobile().isMobileVerified() && !contact.getMobile().getNumberForDisplay().isEmpty()) {
            builder.setMobile(this.buildMobile(contact.getMobile()));
        }
        if (contact.getEmail().isEmailVerified() && !contact.getEmail().getEmailForDisplay().isEmpty()) {
            builder.setEmail(this.buildEmail(contact.getEmail()));
        }
        if (this.enrollmentService.isForeignResident()) {
            builder.setResidentForeigner(this.buildResidentForeigner());
        }
        if (this.enrollmentService.isHofEnrollment()) {
            builder.addAllRelations(this.createChildSaveRequest());
            builder.setBrnDetails(this.buildBrn(this.enrollmentService.getBrnDetails()));
        }
        return builder.build();
    }

    private UcDemographicServiceProto.Address buildAddress(Contact contact) {
        UcDemographicServiceProto.Address.Builder addressBuilder = UcDemographicServiceProto.Address.newBuilder();
        Address address = contact.getAddress();
        ForeignNRI foreignNRIAddress = contact.getForeignNriAddress();
        if (this.enrollmentService.doesNriHaveForeignAddress()) {
            addressBuilder.setCareOf(StringUtils.isNotBlank((String)address.getCareOfNameForDisplay()) ? String.format("%s: %s", address.getCareOf(), address.getCareOfNameForDisplay()) : "").setLocalCo(StringUtils.isNotBlank((String)address.getCareOfNameLocaleForDisplay()) ? String.format("%s: %s", address.getCareOfLocal(), address.getCareOfNameLocaleForDisplay()) : "").setAddressL1(foreignNRIAddress.getDisplayAddressOne()).setLocalAddressL1(foreignNRIAddress.getDisplayLocalAddressOne()).setAddressL2(foreignNRIAddress.getDisplayAddressTwo()).setLocalAddressL2(foreignNRIAddress.getDisplayLocalAddressTwo()).setAddressL3(foreignNRIAddress.getDisplayAddressThree() + ", " + foreignNRIAddress.getZipcode()).setLocalAddressL3(foreignNRIAddress.getDisplayLocalAddressThree() + ", " + foreignNRIAddress.getLocalZipcode()).setCountry(foreignNRIAddress.getCountry().getCountryName()).setLocalCountry(foreignNRIAddress.getLocalCountry()).setCountryCode(foreignNRIAddress.getCountry().getCountryCode());
        } else {
            addressBuilder.setCareOf(StringUtils.isNotBlank((String)address.getCareOfName()) ? String.format("%s: %s", address.getCareOf(), address.getCareOfName()) : "").setHouse(address.getBuilding()).setStreet(address.getStreet()).setLandmark(address.getLandmark()).setLocality(address.getLocality()).setVtc(address.getVTC()).setVillageCode(address.getVTCCode()).setDistrict(address.getDistrict()).setSubDistrict(address.getSubDistrict()).setState(address.getState()).setDistrictCode(address.getDistrictCode()).setSubDistrictCode(address.getSubDistrictCode()).setStateCode(address.getStateCode()).setPincode(address.getPinCodeValue()).setCountryCode(address.getCountryCode()).setPoType(address.getPoType().toString()).setCountry(address.getCountryName()).setLocalCo(StringUtils.isNotBlank((String)address.getCareOfName()) ? String.format("%s: %s", address.getCareOfLocal(), address.getCareOfNameLocal()) : "").setLocalHouse(address.getBuildingLocal()).setLocalStreet(address.getStreetLocal()).setLocalLandmark(address.getLandmarkLocal()).setLocalLocality(address.getLocalityLocal()).setLocalVtc(address.getVTCLocal()).setLocalDistrict(address.getDistrictLocal()).setLocalSubDistrict(address.getSubDistrictLocal()).setLocalCountry("\u092d\u093e\u0930\u0924").setLocalState(address.getStateLocal()).setLocalPo(address.getPoNameLocal());
            if (address.isMandatory()) {
                addressBuilder.setPo(address.getPoName());
            }
        }
        return addressBuilder.build();
    }

    private UcDemographicServiceProto.Mobile buildMobile(Mobile mobile) {
        return UcDemographicServiceProto.Mobile.newBuilder().setMobileNumber(mobile.getNumberForDisplay()).setIsdCode(mobile.isdCode()).setValidated(mobile.isMobileVerified() && !mobile.number().isEmpty()).build();
    }

    private UcDemographicServiceProto.BrnDetails buildBrn(Brn brn) {
        String brnState = brn.getBrnState();
        brn.getClass();
        if (brnState.equalsIgnoreCase("Select")) {
            brnState = "";
        }
        return UcDemographicServiceProto.BrnDetails.newBuilder().setBrn(brn.getBrnNumber()).setBrnState(brnState).build();
    }

    private UcDemographicServiceProto.Email buildEmail(Email email) {
        return UcDemographicServiceProto.Email.newBuilder().setEmailUpdated(email.getEmailForDisplay()).setValidated(email.isEmailVerified()).build();
    }

    private UcDemographicServiceProto.ResidentForeigner buildResidentForeigner() {
        String documentIssueDate;
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        String string = this.enrollmentService.isForeignResident() ? (foreignDetail.getVisaNo().isEmpty() ? foreignDetail.getIssueDateString() : foreignDetail.getVisaIssueDate()) : (documentIssueDate = "");
        String documentExpiryDate = this.enrollmentService.isForeignResident() ? (foreignDetail.getVisaNo().isEmpty() ? foreignDetail.getExpiryDateString() : foreignDetail.getVisaExpiryDate()) : "";
        return UcDemographicServiceProto.ResidentForeigner.newBuilder().setCountryCode(this.enrollmentService.getDemoResidentialStatus().getCountry().getCountryCode()).setNationalityType(foreignDetail.getForeignType()).setPofDocNumber(foreignDetail.getVisaNo().isEmpty() ? foreignDetail.getDocNo() : foreignDetail.getVisaNo()).setDocumentIssueDate(documentIssueDate).setDocumentExpiryDate(documentExpiryDate).build();
    }

    private List<UcDemographicServiceProto.Relation> createChildSaveRequest() {
        ArrayList<UcDemographicServiceProto.Relation> relations = new ArrayList<UcDemographicServiceProto.Relation>();
        RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
        RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
        RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
        if (!Strings.isNullOrEmpty((String)fatherDetail.getUid()) && !fatherDetail.getUid().equalsIgnoreCase("000000000000")) {
            relations.add(this.createRelationRequest(fatherDetail));
        }
        if (!Strings.isNullOrEmpty((String)motherDetail.getUid()) && !motherDetail.getUid().equalsIgnoreCase("000000000000")) {
            relations.add(this.createRelationRequest(motherDetail));
        }
        if (!Strings.isNullOrEmpty((String)otherDetail.getUid()) && !otherDetail.getUid().equalsIgnoreCase("000000000000")) {
            relations.add(this.createRelationRequest(otherDetail));
        }
        return relations;
    }

    private UcDemographicServiceProto.Relation createRelationRequest(RelativeDetail relativeDetail) {
        return UcDemographicServiceProto.Relation.newBuilder().setRelationName(relativeDetail.getName()).setRelationType(relativeDetail.getRelationType().name()).setRelationUid(relativeDetail.getUid()).build();
    }

    private void onDisclosureChange(ActionEvent event) {
        int tabIndex = this.viewPeerUC.getDemoPanel().getTabbedPane().getSelectedIndex();
        this.tabState.replace(StagesUC.DISCLOSURE, this.viewPeerUC.getDisclosurePanel().checkBox.isSelected());
        this.viewPeerUC.getButtonPanel().nextButton.setEnabled(this.tabState.get((Object)StagesUC.DISCLOSURE));
        this.viewPeerUC.getDemoSections().setValid(this.tabState);
        if (!this.tabState.containsValue(false)) {
            this.updateTabValidityState(true);
        }
    }

    private void setMandatoryField(boolean isMandatory, String field) {
        PersonalDetailPanel personalDetailPanel = this.viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel();
        ContactDetailPanel contactDetailPanel = this.viewPeerUC.getContactDetailPanel();
        switch (field) {
            case "age": {
                personalDetailPanel.getAgePanel().setMandatory(isMandatory);
                break;
            }
            case "gender": {
                personalDetailPanel.getGenderPanel().setMandatory(isMandatory);
                break;
            }
            case "address": {
                contactDetailPanel.setMandatory(isMandatory);
                break;
            }
            case "mobile": {
                contactDetailPanel.getMobilePanel().setMandatory(isMandatory);
                break;
            }
            case "email": {
                contactDetailPanel.getEmailPanel().setMandatory(isMandatory);
            }
        }
    }

    private boolean populateProofDocumentList(String foreignType, String modeType, AgeGroup ageGroup) {
        boolean isRefrequired;
        boolean bl = isRefrequired = this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isReferenceTabRequired();
        if (isRefrequired) {
            try {
                if (!this.enrollmentService.isDocumentPresent(foreignType, modeType, ageGroup.name())) {
                    LOGGER.info("List of documents not present, populating...");
                    this.enrollmentService.populateProofDocuments(foreignType, modeType, ageGroup.name());
                }
                this.enrollmentService.getReferences().setAllowedDocuments(this.enrollmentService.getReferences().getAllowedDocuments());
                this.enrollmentService.getReferences().reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), ageGroup, this.enrollmentService.getDemographics().getHofRelationType());
            }
            catch (OnlineGatewayException ex) {
                L10nOptionPaneBuilder.getInstance().showErrorUC("Error fetching proof documents: " + ex.getDisplayMessage(), null, ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), ex.getErrorCode(), new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean isBasicDetailValid() {
        boolean isValid = false;
        if (this.enrollmentService.isNewEnrollmentUC()) {
            isValid = this.enrollmentService.getDemoPersonalDetails().isValid() && this.enrollmentService.getDemoResidentialStatus().isValid() && (!this.enrollmentService.isHofEnrollment() || this.isRelativeDetailsValid());
        } else if (!this.enrollmentService.isAadhaarActive() && this.enrollmentService.isForeignResident()) {
            isValid = this.enrollmentService.getDemoResidentialStatus().isValid();
        } else if (this.enrollmentService.isUpdateUC() && this.enrollmentService.isAadhaarActive()) {
            isValid = this.enrollmentService.getDemoPersonalDetails().isValid() && (!this.enrollmentService.isHofEnrollment() || this.isRelativeDetailsValid());
        }
        return isValid;
    }
}

