/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.protobuf.ByteString;
import in.gov.uidai.ec.biometrics.postcap.BioxDataAnalyzer;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.protobuf.BiometricMessage;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.FingerPrint;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.fingerprint.IFingerTabConstants;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.FingerPrintTabViewPeerUC;
import in.gov.uidai.ec.ui.utils.BiometricUtilUC;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerPrintControllerUC
extends EnrollmentControllerBase
implements IFingerTabConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerPrintControllerUC.class);
    private final FingerPrintTabViewPeerUC viewElements;
    private final HashMap<String, HashMap<String, Object>> evtParams = new HashMap<String, HashMap<String, Object>>(){
        {
            this.put("eID_FingerTab_LeftSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_LeftSlap");
                }
            });
            this.put("eID_FingerTab_RightSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_RightSlap");
                }
            });
            this.put("eID_FingerTab_ThumbSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_ThumbSlap");
                }
            });
        }
    };
    private JLabel uploadStatus;
    private static final String FORMAT_TYPE_FINGER = "7";
    private static final String FORMAT_OWNER = "257";

    public FingerPrintControllerUC(ILiteView view, FingerPrintTabViewPeerUC viewElements, EnrollmentService enrollmentService, int maxCaptureAttempts, int tabIndex) {
        super(view, enrollmentService, 3, tabIndex);
        this.viewElements = viewElements;
        enrollmentService.getFingerPrint().setMaxCaptureAttempt(maxCaptureAttempts);
        this.initView();
    }

    private void initView() {
        IEventContext evtCtxt = this.viewElements.evtCtxt;
        FingerPrint fingerPrint = this.enrollmentService.getFingerPrint();
        Biometrics leftSlap = fingerPrint.getLeftSlap();
        Biometrics rightSlap = fingerPrint.getRightSlap();
        Biometrics bothThumbs = fingerPrint.getBothThumbs();
        BiometricsCaptureField leftSlapField = this.viewElements.fingerPrintPanel.getLeftSlapField();
        BiometricsCaptureField rightSlapField = this.viewElements.fingerPrintPanel.getRightSlapField();
        BiometricsCaptureField thumbSlapField = this.viewElements.fingerPrintPanel.getThumbSlapField();
        this.addListenersOnBiometricField(evtCtxt, leftSlap, leftSlapField, "eID_FingerTab_LeftSlap");
        this.addListenersOnBiometricField(evtCtxt, rightSlap, rightSlapField, "eID_FingerTab_RightSlap");
        this.addListenersOnBiometricField(evtCtxt, bothThumbs, thumbSlapField, "eID_FingerTab_ThumbSlap");
        fingerPrint.addFingerprintBiometricExceptionChangeListener(this::onBiometricsExceptionChange);
        fingerPrint.addMandatoryChangeListener(this::onFingerPrintMandatoryChange);
        fingerPrint.addValidityChangeListener(this::updateTabValidityState);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        if (this.enrollmentService.getBiometricsException().getExceptionDetail() != null && this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
            this.viewElements.fingerPrintPanel.getLeftSlapField().setEnabled(!this.enrollmentService.getBiometricsException().getExceptionDetail().isLeftSlapExceptionApplied());
            this.viewElements.fingerPrintPanel.getRightSlapField().setEnabled(!this.enrollmentService.getBiometricsException().getExceptionDetail().isRightSlapExceptionApplied());
            this.viewElements.fingerPrintPanel.getThumbSlapField().setEnabled(!this.enrollmentService.getBiometricsException().getExceptionDetail().isBothThumbsExceptionApplied());
        }
        this.addActionListener(this.viewElements.buttonPanel.nextButton, this::onNextButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.previousButton, this::onPrevButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.cancelButton, (ActionListener)this.viewElements.evtCtxt.getEventListener("cancelDemo", ActionListener.class));
        this.viewElements.buttonPanel.nextButton.setEnabled(true);
        this.viewElements.buttonPanel.previousButton.setEnabled(true);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateChange);
    }

    private void addListenersOnBiometricField(IEventContext evtCtxt, Biometrics biometrics, BiometricsCaptureField biometricsField, String slapEid) {
        biometricsField.addQSSActionListener((ActionListener)evtCtxt.getEventListener("hID_QSS_Slap", ActionListener.class, (Map)this.evtParams.get(slapEid)));
        biometricsField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSS_Slap_Capture", IBiometricsListener.class, (Map)this.evtParams.get(slapEid)));
        biometricsField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_FingerCapture", IBiometricsListener.class));
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> this.bioMetricListener((BiometricPosition)pos, (CaptureAttempt)captureAttempt, biometrics));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> this.bioDeleteListener(biometrics, (CaptureAttempt)captureAttempt, (BiometricPosition)pos));
        biometricsField.addBestCaptureAttemptChangeListeners((pos, bestAttempt) -> biometrics.setBestAttempt(bestAttempt));
        biometricsField.addCaptureAttemptClearChangeListener(pos -> this.bioClearListener(biometrics, (BiometricPosition)pos));
    }

    private void onViewLoadComplete(Object o) {
        boolean enable;
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        boolean bl = enable = this.enrollmentService.isBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() && ageDob.isValid() && !ageDob.isChild();
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            super.updateTabInteractionState(enable);
        }
    }

    private void onBiometricUpdateChange(Boolean biometricUpdate) {
        this.viewElements.fingerPrintPanel.getLeftSlapField().clear();
        this.viewElements.fingerPrintPanel.getRightSlapField().clear();
        this.viewElements.fingerPrintPanel.getThumbSlapField().clear();
    }

    private void onFingerPrintMandatoryChange(boolean isMandatory) {
        this.viewElements.fingerPrintPanel.getLeftSlapField().setEnabled(isMandatory);
        this.viewElements.fingerPrintPanel.getRightSlapField().setEnabled(isMandatory);
        this.viewElements.fingerPrintPanel.getThumbSlapField().setEnabled(isMandatory);
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            super.updateTabInteractionState(isMandatory);
        }
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        boolean leftSlapEnable = true;
        boolean rightSlapEnable = true;
        boolean bothThumbEnable = true;
        if (biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftSlapExceptionApplied()) {
                leftSlapEnable = false;
            }
            if (biometricsExceptionDetail.isRightSlapExceptionApplied()) {
                rightSlapEnable = false;
            }
            if (biometricsExceptionDetail.isBothThumbsExceptionApplied()) {
                bothThumbEnable = false;
            }
        }
        this.viewElements.fingerPrintPanel.getLeftSlapField().setEnabled(leftSlapEnable);
        this.viewElements.fingerPrintPanel.getRightSlapField().setEnabled(rightSlapEnable);
        this.viewElements.fingerPrintPanel.getThumbSlapField().setEnabled(bothThumbEnable);
    }

    private void bioMetricListener(BiometricPosition position, CaptureAttempt captureAttempt, Biometrics biometrics) {
        if (captureAttempt.getStartTime() < 0L) {
            this.setUploadStatus(false, position);
            LOGGER.error("finger qss upload failed, error code: {}, error message: {}", (Object)ErrorCodes.UC_BIO_001.getErrorCode(), (Object)ErrorCodes.UC_BIO_001.getReason());
            BiometricUtilUC.handleGenericError(ErrorCodes.UC_BIO_001.getReason(), ErrorCodes.UC_BIO_001.getErrorCode(), this.enrollmentService.getTransactionId());
            return;
        }
        biometrics.addCaptureAttempt(captureAttempt);
        if (this.enrollmentService.isUniversalClientTrnx()) {
            IBioxDataProvider bdp = this.viewElements.fingerPrintPanel.getBdp();
            List missingFingers = new ArrayList();
            if (bdp != null && position != null) {
                switch (position) {
                    case LEFT_SLAP: {
                        this.uploadStatus = this.viewElements.fingerPrintPanel.getLeftSlapField().uploadStatus;
                        missingFingers = BioxDataAnalyzer.getLeftSlapExceptions((IBioxDataProvider)bdp);
                        break;
                    }
                    case RIGHT_SLAP: {
                        this.uploadStatus = this.viewElements.fingerPrintPanel.getRightSlapField().uploadStatus;
                        missingFingers = BioxDataAnalyzer.getRightSlapExceptions((IBioxDataProvider)bdp);
                        break;
                    }
                    case BOTH_THUMBS: {
                        this.uploadStatus = this.viewElements.fingerPrintPanel.getThumbSlapField().uploadStatus;
                        missingFingers = BioxDataAnalyzer.getThumbSlapExceptions((IBioxDataProvider)bdp);
                    }
                }
            }
            ExecutorService executor = Executors.newFixedThreadPool(2);
            ArrayList finalMissingFingers = missingFingers;
            executor.submit(() -> this.uploadBiometric(captureAttempt, finalMissingFingers, position));
            executor.shutdown();
        }
    }

    private void bioDeleteListener(Biometrics biometrics, CaptureAttempt captureAttempt, BiometricPosition position) {
        biometrics.deleteCaptureAttempt(captureAttempt);
        BiometricMessage.DeleteCaptureRequest deleteRequest = this.createDeleteCaptureRequest(captureAttempt, biometrics);
        GrpcService.getInst().deleteCapture(deleteRequest, response -> {
            if (response.getSuccess()) {
                LOGGER.info("Delete capture request successful for attempt {}", (Object)captureAttempt.getAttemptNumber());
            } else {
                LOGGER.error(String.format("Delete capture failed for position: %s, sid: %s", position.name(), deleteRequest.getSid()));
                TelemetryService.getTelemetryServiceInstance().postDebugData(String.format("Delete capture failed for position: %s, sid: %s", position.name(), deleteRequest.getSid()), new String[0]);
            }
        }, error -> {
            LOGGER.error("Delete capture gRPC call failed, error code: {}, message: {}", (Object)error.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(error));
            this.showErrorUC(null, CommonUtilsUC.getErrorMessage(error), error.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        });
        if (this.enrollmentService.isUniversalClientTrnx() && captureAttempt.getAttemptNumber() < 1) {
            this.setUploadStatus(false, position);
        }
    }

    private void bioClearListener(Biometrics biometrics, BiometricPosition position) {
        biometrics.clearAttempts();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.setUploadStatus(false, position);
        }
    }

    private void setUploadStatus(boolean status, BiometricPosition position) {
        switch (position) {
            case LEFT_SLAP: {
                this.uploadStatus = this.viewElements.fingerPrintPanel.getLeftSlapField().uploadStatus;
                this.enrollmentService.getFingerPrint().getLeftSlap().setUploadStatus(status);
                break;
            }
            case RIGHT_SLAP: {
                this.uploadStatus = this.viewElements.fingerPrintPanel.getRightSlapField().uploadStatus;
                this.enrollmentService.getFingerPrint().getRightSlap().setUploadStatus(status);
                break;
            }
            case BOTH_THUMBS: {
                this.uploadStatus = this.viewElements.fingerPrintPanel.getThumbSlapField().uploadStatus;
                this.enrollmentService.getFingerPrint().getBothThumbs().setUploadStatus(status);
            }
        }
        if (status) {
            this.uploadStatus.setText("\ue86c");
            this.uploadStatus.setForeground(Color.decode("#27AE61"));
            this.uploadStatus.setToolTipText("Uploaded");
        } else {
            this.uploadStatus.setText("\ue5c9");
            this.uploadStatus.setForeground(Color.decode("#B30202"));
            this.uploadStatus.setToolTipText("Upload Failed");
        }
    }

    private void uploadBiometric(CaptureAttempt captureAttempt, List<BiometricPosition> missingFingers, BiometricPosition position) {
        BiometricMessage.UploadData fingerUploadRequest = this.createFingerUploadRequest(captureAttempt, missingFingers, position);
        GrpcService.getInst().uploadFingerprintQss(fingerUploadRequest, biometricResponse -> {
            if (biometricResponse.getResponse()) {
                LOGGER.info("finger qss successfully uploaded");
                this.setUploadStatus(true, position);
            } else {
                LOGGER.info("finger qss upload failed");
                this.setUploadStatus(false, position);
            }
        }, errorResponse -> {
            this.setUploadStatus(false, position);
            LOGGER.error("finger qss upload failed, error code: {}, error message: {}", (Object)errorResponse.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(errorResponse));
            BiometricUtilUC.handleErrorGrpcResponse(errorResponse, this.enrollmentService.getTransactionId());
        });
    }

    private BiometricMessage.UploadData createFingerUploadRequest(CaptureAttempt captureAttempt, List<BiometricPosition> missingFingers, BiometricPosition position) {
        ByteArrayOutputStream baos;
        FingerprintQSS qss = (FingerprintQSS)captureAttempt.getQSS();
        ArrayList fingerSegmentList = new ArrayList();
        qss.getFingerSegments().forEach(fSegment -> fingerSegmentList.add(BiometricMessage.FingerSegment.newBuilder().setTopLeft(BiometricMessage.Point.newBuilder().setX(fSegment.getTopLeft().x).setY(fSegment.getTopLeft().y)).setTopRight(BiometricMessage.Point.newBuilder().setX(fSegment.getTopRight().x).setY(fSegment.getTopRight().y)).setBottomLeft(BiometricMessage.Point.newBuilder().setX(fSegment.getBottomLeft().x).setY(fSegment.getBottomLeft().y)).setBottomRight(BiometricMessage.Point.newBuilder().setX(fSegment.getBottomRight().x).setY(fSegment.getBottomRight().y)).setFingerPosition(BiometricMessage.BioPosition.valueOf((String)fSegment.getFingerPosition().name())).setQuality(fSegment.getQuality()).setSegmentImage(ByteString.copyFrom((byte[])fSegment.getImage())).build()));
        ArrayList qualityFeedbackList = new ArrayList();
        qss.getQualityFeedback().forEach(qFeedback -> qualityFeedbackList.add(BiometricMessage.FingerQualityFeedback.newBuilder().setComments(qFeedback.getComments()).setCompliance(BiometricMessage.Compliance.valueOf((String)qFeedback.getCompliance().name())).setScore(qFeedback.getScore()).setQualityAttribute(BiometricMessage.FingerprintQualityAttribute.valueOf((String)qFeedback.getQualityAttribute().name())).build()));
        ArrayList missingFingerList = new ArrayList();
        missingFingers.forEach(missingFinger -> missingFingerList.add(BiometricMessage.BioPosition.forNumber((int)missingFinger.ordinal())));
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        byte[] data = captureAttempt.getImage().getOriginalData();
        BiometricMessage.FingerRequestv1 req = BiometricMessage.FingerRequestv1.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setImage(ByteString.copyFrom((byte[])data)).setEncoding("png").setSlapPosition(BiometricMessage.BioPosition.valueOf((String)position.name())).setCaptureStartTime(captureAttempt.getStartTime()).setCaptureEndTime(captureAttempt.getEndTime()).addAllMissingFingers(missingFingerList).setForcedCapture(captureAttempt.isForcedCapture()).addAllDeviceInfo(deviceInfoList).addAudit(BiometricMessage.Pair.newBuilder().setAttribute("appVersion").setValue(ApplicationVersion.VERSION).build()).setManualIntervention(captureAttempt.isForcedCapture() ? BiometricMessage.ManualInterventionType.FORCED : BiometricMessage.ManualInterventionType.MANUAL_INTERVENTION_TYPE_NONE).setOverallCompliance(BiometricMessage.Compliance.valueOf((String)qss.getOverallCompliance().name())).setOverallComments(qss.getOverallComments()).setOverallConfidence(qss.getOverallConfidence()).setOverallScore((double)((int)qss.getOverallScore())).setBdbInfo(this.getBDBInfo(BiometricMessage.BioPosition.valueOf((String)position.name()), captureAttempt)).addAllBodyPart(BiometricUtilUC.getAvailableBodyParts(position, this.enrollmentService)).addAllMissingBodyPart(BiometricUtilUC.getMissingBodyParts(position, this.enrollmentService)).setDeleted(captureAttempt.isDeleted()).setBestAttempt(captureAttempt.isBestCapture()).setHandedness(qss.getHandedness()).addAllQualityFeedback(qualityFeedbackList).addAllFingerSegments(fingerSegmentList).build();
        byte[] uploadData = req.toByteArray();
        try {
            data = BiometricUtilUC.compress(uploadData);
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        return BiometricMessage.UploadData.newBuilder().setUploadData(ByteString.copyFrom((byte[])encData)).setSid(this.enrollmentService.getSid()).build();
    }

    private BiometricMessage.DeleteCaptureRequest createDeleteCaptureRequest(CaptureAttempt captureAttempt, Biometrics biometrics) {
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        BiometricMessage.Modality modality = this.mapToProtoModality(biometrics.getCaptureModality());
        return BiometricMessage.DeleteCaptureRequest.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setModality(modality).build();
    }

    private BiometricMessage.Modality mapToProtoModality(CaptureModality captureModality) {
        switch (captureModality) {
            case LEFT_SLAP: {
                return BiometricMessage.Modality.MODALITY_LEFT_SLAP;
            }
            case RIGHT_SLAP: {
                return BiometricMessage.Modality.MODALITY_RIGHT_SLAP;
            }
            case THUMB_SLAP: {
                return BiometricMessage.Modality.MODALITY_BOTH_THUMBS;
            }
        }
        return BiometricMessage.Modality.MODALITY_BOTH_THUMBS;
    }

    private BiometricMessage.BdbInfo getBDBInfo(BiometricMessage.BioPosition position, CaptureAttempt captureAttempt) {
        String subtype = position == BiometricMessage.BioPosition.LEFT_SLAP ? "left pointer-finger ring-finger middle-finger little-finger" : (position == BiometricMessage.BioPosition.RIGHT_SLAP ? "right pointer-finger ring-finger middle-finger little-finger" : (position == BiometricMessage.BioPosition.BOTH_THUMBS ? "left right thumb" : null));
        return BiometricMessage.BdbInfo.newBuilder().setType("finger").setFormatType(FORMAT_TYPE_FINGER).setSubType(subtype).setFormatOwner(FORMAT_OWNER).setCreationDate(String.valueOf(captureAttempt.getStartTime())).build();
    }
}

