/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.ForeignPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class ForeignDetailControllerUC
extends ControllerBase {
    private final EnrollmentService enrollmentService;
    private final ForeignPanel foreignPanel;
    private final DemographicsTabViewPeerUC viewPeerUC;

    public ForeignDetailControllerUC(DemographicsTabViewPeerUC viewPeerUC, EnrollmentService enrollmentService, ILiteView view) {
        super(view);
        this.enrollmentService = enrollmentService;
        this.foreignPanel = viewPeerUC.getForeignPanel();
        this.viewPeerUC = viewPeerUC;
        if (enrollmentService.isUpdateUC()) {
            this.foreignPanel.getVisaPanel().setEnabled(FieldInfoUtils.isPOFRequired());
            this.foreignPanel.getVisaPanel().setMandatory(FieldInfoUtils.isPOFRequired());
            this.foreignPanel.getForeignPanel().setEnable(FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POI));
            this.foreignPanel.getForeignPanel().setMandatory(FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POI));
        }
    }

    public void onDocNoChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        foreignDetail.setDocNo(this.foreignPanel.getDocNoTextField().getText());
        this.updateForeignState(foreignDetail);
    }

    public void onVisaNoChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        foreignDetail.setVisaNo(this.foreignPanel.getVisaNumber().getText());
        this.updateForeignState(foreignDetail);
    }

    public void onDateChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        JTextField textField = (JTextField)focusEvent.getSource();
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        switch (textField.getName()) {
            case "Issue": {
                foreignDetail.setIssueDate(this.foreignPanel.getIssueDateField().getText());
                foreignDetail.setValidPoiIssue(false);
                break;
            }
            case "Expiry": {
                foreignDetail.setExpiryDate(this.foreignPanel.getExpiryDateField().getText());
                break;
            }
            case "VisaIssue": {
                foreignDetail.setVisaIssueDate(this.foreignPanel.getVisaIssueField().getText());
                foreignDetail.setValidPofIssue(false);
                break;
            }
            case "VisaExpiry": {
                foreignDetail.setVisaExpiryDate(this.foreignPanel.getVisaExpiryField().getText());
            }
        }
        this.updateForeignState(foreignDetail);
    }

    public void onPOFChange(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        JComboBox comboBox = (JComboBox)ie.getSource();
        ProofDocument item = (ProofDocument)ie.getItem();
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        NationalityTypes foreignType = this.enrollmentService.getDemoResidentialStatus().getForeignType();
        foreignDetail.setForeignType(foreignType.getCode());
        switch (comboBox.getActionCommand()) {
            case "POI": {
                this.onForeignPoiChange(foreignDetail, comboBox, item);
                break;
            }
            case "Visa": {
                this.onForeignPofChange(foreignDetail, comboBox, item);
            }
        }
        this.updateForeignState(foreignDetail);
    }

    private void onForeignPoiChange(ForeignDetail foreignDetail, JComboBox<ProofDocument> comboBox, ProofDocument item) {
        this.foreignPanel.clearForeignProofFields();
        foreignDetail.resetPOI();
        foreignDetail.setPoiDocument(item);
        comboBox.setToolTipText(item.getDocName());
        if (!foreignDetail.invalidPoiDocument()) {
            this.enrollmentService.getReferences().getProof(DocumentType.POI).setProofDocumentForForeign(item);
            if (foreignDetail.isNlbnPassportSelected()) {
                this.enrollmentService.getReferences().getProof(DocumentType.POF).setProofDocumentForForeign(item);
            }
            this.foreignPanel.setExpiryDateMandatory(foreignDetail.poiDocRequiredExpiryDate());
            this.foreignPanel.getVisaPanel().setEnabled(!foreignDetail.isNlbnPassportSelected());
            this.foreignPanel.getVisaPanel().setMandatory(!foreignDetail.isNlbnPassportSelected());
            this.foreignPanel.getVisaPanel().setExpiryDateEnabled(foreignDetail.pofDocRequiredExpiryDate() && !foreignDetail.isNlbnPassportSelected());
            this.foreignPanel.getVisaPanel().setExpiryDateMandatory(foreignDetail.pofDocRequiredExpiryDate() && !foreignDetail.isNlbnPassportSelected());
        } else {
            this.foreignPanel.setExpiryDateMandatory(this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFieldEnabled((FieldInformation)FieldInformation.POI));
        }
    }

    private void onForeignPofChange(ForeignDetail foreignDetail, JComboBox<ProofDocument> comboBox, ProofDocument item) {
        this.foreignPanel.clearVisaFields();
        foreignDetail.resetPOF();
        foreignDetail.setPofDocument(item);
        comboBox.setToolTipText(item.getDocName());
        if (!foreignDetail.invalidPofDocument()) {
            this.enrollmentService.getReferences().getProof(DocumentType.POF).setProofDocumentForForeign(item);
            if (foreignDetail.pofDocRequiredExpiryDate()) {
                this.updatePofPanel(true, true);
            } else {
                this.updatePofPanel(false, false);
            }
        } else {
            this.updatePofPanel(true, true);
        }
    }

    private void updatePoiPanel(boolean expiryMandatory) {
        this.foreignPanel.setExpiryDateMandatory(expiryMandatory);
    }

    private void setEnablePofPanel(boolean visaMandatory) {
        this.foreignPanel.getVisaPanel().setMandatory(visaMandatory);
        this.foreignPanel.getVisaPanel().setEnabled(visaMandatory);
    }

    private void updatePofPanel(boolean expiryEnable, boolean expiryMandatory) {
        this.foreignPanel.getVisaPanel().setExpiryDateEnabled(expiryEnable);
        this.foreignPanel.getVisaPanel().setExpiryDateMandatory(expiryMandatory);
    }

    private void updateForeignState(ForeignDetail foreignDetail) {
        this.updatePoiFields(foreignDetail);
        this.updatePofFields(foreignDetail);
        this.viewPeerUC.isDemoDataUploaded = false;
    }

    private void updatePoiFields(ForeignDetail foreignDetail) {
        super.clearFieldError(this.foreignPanel.getDocNoTextField());
        super.clearFieldError(this.foreignPanel.getIssueDateField());
        super.clearFieldError(this.foreignPanel.getExpiryDateField());
        super.clearFieldError(this.foreignPanel.getPOFField());
        if (!foreignDetail.isValid()) {
            if (this.enrollmentService.isNewEnrollmentUC() && !Strings.isNullOrEmpty((String)foreignDetail.getIssueDateError()) && foreignDetail.getIssueDateError().equalsIgnoreCase("Invalid issue date.") && foreignDetail.allowPoiLessThan182Day()) {
                String message = "Issue date is short for 182 days, resident needs to upload old and new document";
                MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoUC(message, (Component)this.foreignPanel.getIssueDateField());
                foreignDetail.setValidPoiIssue(confirmation.equals((Object)MsgKeysCommon.YES));
            }
            super.showFieldError(this.foreignPanel.getDocNoTextField(), foreignDetail.getDocNoError());
            super.showFieldError(this.foreignPanel.getIssueDateField(), foreignDetail.getIssueDateError());
            super.showFieldError(this.foreignPanel.getExpiryDateField(), foreignDetail.getExpiryDateError());
            super.showFieldError(this.foreignPanel.getPOFField(), foreignDetail.getProofError());
        }
    }

    private void updatePofFields(ForeignDetail foreignDetail) {
        super.clearFieldError(this.foreignPanel.getVisaNumber());
        super.clearFieldError(this.foreignPanel.getVisaIssueField());
        super.clearFieldError(this.foreignPanel.getVisaExpiryField());
        super.clearFieldError(this.foreignPanel.getVisaField());
        if (!foreignDetail.isValid()) {
            if (this.enrollmentService.isNewEnrollmentUC() && !Strings.isNullOrEmpty((String)foreignDetail.getVisaIssueDateError()) && foreignDetail.getVisaIssueDateError().equalsIgnoreCase("Invalid issue date.") && foreignDetail.allowPofLessThan182Day()) {
                String message = "Issue date is short for 182 days, resident needs to upload old and new document";
                MsgKeysCommon confirmation = L10nOptionPaneBuilder.getInstance().showYesNoUC(message, (Component)this.foreignPanel.getVisaIssueField());
                foreignDetail.setValidPofIssue(confirmation.equals((Object)MsgKeysCommon.YES));
            }
            super.showFieldError(this.foreignPanel.getVisaNumber(), foreignDetail.getVisaNoError());
            super.showFieldError(this.foreignPanel.getVisaIssueField(), foreignDetail.getVisaIssueDateError());
            super.showFieldError(this.foreignPanel.getVisaExpiryField(), foreignDetail.getVisaExpiryDateError());
            super.showFieldError(this.foreignPanel.getVisaField(), foreignDetail.getVisaProofError());
        }
    }
}

