/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.protobuf.ByteString;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.protobuf.BiometricMessage;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Iris;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.iris.IrisPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.IrisTabViewPeerUC;
import in.gov.uidai.ec.ui.utils.BiometricUtilUC;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisControllerUC
extends EnrollmentControllerBase
implements INavigationConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(IrisControllerUC.class);
    private final IrisTabViewPeerUC viewElements;
    private final EnrollmentService enrollmentService;
    private boolean isReviewTabRendered;
    private JLabel uploadStatus;
    private static final String FORMAT_TYPE_IRIS = "9";
    private static final String FORMAT_OWNER = "257";

    public IrisControllerUC(IrisTabViewPeerUC viewElements, int tabIndex) {
        super(viewElements.view, viewElements.enrollmentService, 4, tabIndex);
        this.viewElements = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.enrollmentService.getIris().setMaxCaptureAttempt(viewElements.uiPref.getMaxCaptureAttempts(5));
        this.uploadStatus = viewElements.irisPanel.getBothEyesField().uploadStatus;
        this.initView();
    }

    @Override
    protected void onNextButtonClick(ActionEvent event) {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (this.enrollmentService.getBiometricsException().getExceptionDetail().isBothEyesExceptionApplied()) {
                this.updateTabValidityState(true);
            }
            ArrayList<String> missingComponents = new ArrayList<String>();
            if (!this.enrollmentService.getPhotograph().isValid()) {
                missingComponents.add("Photograph");
            }
            if (this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied() && !this.enrollmentService.getIsExceptionPhotoUploaded()) {
                missingComponents.add("Exception Photo");
            }
            if (!this.enrollmentService.getFingerPrint().isValid()) {
                missingComponents.add("Fingerprint");
            }
            if (!this.enrollmentService.getIris().isValid()) {
                missingComponents.add("Iris scan");
            }
            if (!missingComponents.isEmpty()) {
                String message = String.join((CharSequence)", ", missingComponents) + " is missing or invalid. Please provide it to continue the process.";
                this.showWarningUC(message, (JComponent)event.getSource());
                return;
            }
            if (!this.isReviewTabRendered) {
                this.viewElements.reviewTabUC.renderReviewTabUC();
                this.isReviewTabRendered = true;
            }
        }
        super.onNextButtonClick(event);
    }

    private void initView() {
        Iris iris = this.enrollmentService.getIris();
        BiometricsCaptureField leftEyeField = this.viewElements.irisPanel.getLeftEyeField();
        BiometricsCaptureField rightEyeField = this.viewElements.irisPanel.getRightEyeField();
        BiometricsCaptureField bothEyesField = this.viewElements.irisPanel.getBothEyesField();
        this.addListenersToBiometricField(iris, leftEyeField, "eID_IrisTab_LeftEye", BiometricPosition.LEFT_IRIS, "hID_QSS_Iris_Capture");
        this.addListenersToBiometricField(iris, rightEyeField, "eID_IrisTab_RightEye", BiometricPosition.RIGHT_IRIS, "hID_QSS_Iris_Capture");
        this.addListenersToBiometricField(iris, bothEyesField, "eID_IrisTab_BothEyes", BiometricPosition.BOTH_IRIS, "hID_QSS_Dual_Iris_Capture");
        this.viewElements.irisPanel.getIrisCaptureModeOption().addActionListener(this::onIrisModeOptionChange);
        iris.addIrisBiometricExceptionChangeListener(this::onBiometricsExceptionChange);
        if (this.enrollmentService.getBiometricsException().getExceptionDetail() != null && this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied() && (this.enrollmentService.getBiometricsException().getExceptionDetail().isLeftEyeExceptionApplied() || this.enrollmentService.getBiometricsException().getExceptionDetail().isRightEyeExceptionApplied())) {
            this.onBiometricsExceptionChange(this.enrollmentService.getBiometricsException());
        }
        if (!this.enrollmentService.isNewEnrollmentUC()) {
            iris.addMandatoryChangeListener(this::onIrisMandatoryChange);
        }
        iris.addValidityChangeListener(this::updateTabValidityState);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.addActionListener(this.viewElements.buttonPanel.nextButton, this::onNextButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.previousButton, this::onPrevButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.cancelButton, (ActionListener)this.viewElements.evtCtxt.getEventListener("cancelDemo", ActionListener.class));
        this.viewElements.buttonPanel.nextButton.setEnabled(true);
        this.viewElements.buttonPanel.previousButton.setEnabled(true);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateChange);
    }

    private void addListenersToBiometricField(Iris iris, BiometricsCaptureField biometricsField, String irisEid, BiometricPosition position, String hidQssIrisCapture) {
        this.addQSSListener(irisEid, biometricsField, position, "hID_QSS_Iris", this.viewElements.evtCtxt);
        this.addBioListener(irisEid, biometricsField, hidQssIrisCapture, this.viewElements.evtCtxt);
        biometricsField.addBiometricsListener((IBiometricsListener)this.viewElements.evtCtxt.getEventListener("hID_QSSDedup_IrisCapture", IBiometricsListener.class));
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> this.bioMetricListener(iris, (BiometricPosition)pos, (CaptureAttempt)captureAttempt));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> this.bioDeleteListener(iris, (BiometricPosition)pos, (CaptureAttempt)captureAttempt));
        biometricsField.addBestCaptureAttemptChangeListeners((arg_0, arg_1) -> ((Iris)iris).setBestAttempt(arg_0, arg_1));
        biometricsField.addCaptureAttemptClearChangeListener(pos -> this.bioClearListener(iris, (BiometricPosition)pos));
    }

    private void onViewLoadComplete(Object o) {
        boolean enable;
        boolean bl = enable = this.enrollmentService.isBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild() && this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() >= 5;
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            super.updateTabInteractionState(enable);
        }
    }

    private void onBiometricUpdateChange(Boolean biometricUpdate) {
        this.viewElements.irisPanel.getBothEyesField().clear();
        this.viewElements.irisPanel.getLeftEyeField().clear();
        this.viewElements.irisPanel.getRightEyeField().clear();
    }

    private void onIrisMandatoryChange(boolean isMandatory) {
        this.viewElements.irisPanel.getLeftEyeField().setEnabled(isMandatory);
        this.viewElements.irisPanel.getRightEyeField().setEnabled(isMandatory);
        this.viewElements.irisPanel.getBothEyesField().setEnabled(isMandatory);
        super.updateTabInteractionState(isMandatory);
    }

    private void onIrisModeOptionChange(ActionEvent event) {
        this.enrollmentService.getIris().setCaptureBothIrisSeparately(((JCheckBox)event.getSource()).isSelected());
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        boolean leftIrisEnabled = true;
        boolean rightIrisEnabled = true;
        boolean captureEachEyeSeparately = false;
        if (biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftEyeExceptionApplied()) {
                leftIrisEnabled = false;
                captureEachEyeSeparately = true;
            }
            if (biometricsExceptionDetail.isRightEyeExceptionApplied()) {
                rightIrisEnabled = false;
                captureEachEyeSeparately = true;
            }
        }
        IrisPanel irisPanel = this.viewElements.irisPanel;
        irisPanel.getLeftEyeField().setEnabled(leftIrisEnabled);
        irisPanel.getLeftEyeField().setVisible(captureEachEyeSeparately);
        irisPanel.getRightEyeField().setEnabled(rightIrisEnabled);
        irisPanel.getRightEyeField().setVisible(captureEachEyeSeparately);
        irisPanel.getBothEyesField().setEnabled(!captureEachEyeSeparately);
        irisPanel.getBothEyesField().setVisible(!captureEachEyeSeparately);
        irisPanel.getIrisCaptureModeOption().setSelected(captureEachEyeSeparately);
        irisPanel.getIrisCaptureModeOption().setEnabled(!captureEachEyeSeparately);
    }

    private void addQSSListener(String fieldName, BiometricsCaptureField field, BiometricPosition bioPos, String hid, IEventContext evtCtxt) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        if (bioPos != null) {
            evtParams.put("prm_BioFieldSubType", (String)bioPos);
            field.addQSSActionListener((ActionListener)evtCtxt.getEventListener(hid, ActionListener.class, evtParams), bioPos);
        } else {
            field.addQSSActionListener((ActionListener)evtCtxt.getEventListener(hid, ActionListener.class, evtParams));
        }
    }

    private void addBioListener(String fieldName, BiometricsCaptureField field, String hid, IEventContext evtCtxt) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        field.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener(hid, IBiometricsListener.class, evtParams));
    }

    private void bioMetricListener(Iris iris, BiometricPosition position, CaptureAttempt captureAttempt) {
        if (captureAttempt.getStartTime() < 0L) {
            this.setUploadStatus(false, position);
            LOGGER.error("iris qss upload failed, error code: {}, error message: {}", (Object)ErrorCodes.UC_BIO_001.getErrorCode(), (Object)ErrorCodes.UC_BIO_001.getReason());
            BiometricUtilUC.handleGenericError(ErrorCodes.UC_BIO_001.getReason(), ErrorCodes.UC_BIO_001.getErrorCode(), this.enrollmentService.getTransactionId());
            return;
        }
        iris.setCaptureAttempts(position, captureAttempt);
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (this.viewElements.irisPanel.getIrisCaptureModeOption().isSelected()) {
                switch (position) {
                    case LEFT_IRIS: {
                        this.uploadStatus = this.viewElements.irisPanel.getLeftEyeField().uploadStatus;
                        break;
                    }
                    case RIGHT_IRIS: {
                        this.uploadStatus = this.viewElements.irisPanel.getRightEyeField().uploadStatus;
                    }
                }
            } else {
                this.uploadStatus = this.viewElements.irisPanel.getBothEyesField().uploadStatus;
            }
            ExecutorService executor = Executors.newFixedThreadPool(2);
            executor.submit(() -> this.uploadBiometric(captureAttempt, position));
            executor.shutdown();
        }
    }

    private void bioDeleteListener(Iris iris, BiometricPosition position, CaptureAttempt captureAttempt) {
        iris.setDeletedAttempts(position, captureAttempt);
        BiometricMessage.DeleteCaptureRequest deleteRequest = this.createDeleteCaptureRequest(captureAttempt, iris);
        GrpcService.getInst().deleteCapture(deleteRequest, response -> {
            if (response.getSuccess()) {
                LOGGER.info("Delete capture request successful for attempt {}", (Object)captureAttempt.getAttemptNumber());
            } else {
                LOGGER.error(String.format("Delete capture failed for position: %s, sid: %s", position.name(), deleteRequest.getSid()));
                TelemetryService.getTelemetryServiceInstance().postDebugData(String.format("Delete capture failed for position: %s, sid: %s", position.name(), deleteRequest.getSid()), new String[0]);
            }
        }, error -> {
            LOGGER.error("Delete capture gRPC call failed, error code: {}, message: {}", (Object)error.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(error));
            this.showErrorUC(null, CommonUtilsUC.getErrorMessage(error), error.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        });
        if (this.enrollmentService.isUniversalClientTrnx() && captureAttempt.getAttemptNumber() < 1) {
            this.setUploadStatus(false, position);
        }
    }

    private void bioClearListener(Iris iris, BiometricPosition position) {
        iris.clearAttempts(position);
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.setUploadStatus(false, position);
        }
    }

    private void setUploadStatus(boolean status, BiometricPosition position) {
        switch (position) {
            case LEFT_IRIS: {
                this.enrollmentService.getIris().getLeftEye().setUploadStatus(status);
                break;
            }
            case RIGHT_IRIS: {
                this.enrollmentService.getIris().getRightEye().setUploadStatus(status);
            }
        }
        if (status) {
            this.uploadStatus.setText("\ue86c");
            this.uploadStatus.setForeground(Color.decode("#27AE61"));
            this.uploadStatus.setToolTipText("Uploaded");
        } else {
            this.uploadStatus.setText("\ue5c9");
            this.uploadStatus.setForeground(Color.decode("#B30202"));
            this.uploadStatus.setToolTipText("Upload Failed");
        }
    }

    private void uploadBiometric(CaptureAttempt attempt, BiometricPosition position) {
        BiometricMessage.UploadData irisRequestv1 = this.createIrisUploadRequest(attempt, position);
        this.setUploadStatus(false, position);
        GrpcService.getInst().uploadIrisQss(irisRequestv1, biometricResponse -> {
            if (biometricResponse.getResponse()) {
                LOGGER.info("iris qss successfully uploaded");
                this.setUploadStatus(true, position);
            } else {
                LOGGER.error("iris qss upload failed");
                this.setUploadStatus(false, position);
            }
        }, errorResponse -> {
            this.setUploadStatus(false, position);
            LOGGER.error("Iris qss upload failed, error code: {}, error message: {}", (Object)errorResponse.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(errorResponse));
            BiometricUtilUC.handleErrorGrpcResponse(errorResponse, this.enrollmentService.getTransactionId());
        });
    }

    public BiometricMessage.UploadData createIrisUploadRequest(CaptureAttempt captureAttempt, BiometricPosition position) {
        ByteArrayOutputStream baos;
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        IrisQSS qss = (IrisQSS)captureAttempt.getQSS();
        ArrayList qualityFeedbackList = new ArrayList();
        qss.getQualityFeedback().forEach(qFeedback -> qualityFeedbackList.add(BiometricMessage.IrisQualityFeedback.newBuilder().setComments(qFeedback.getComments()).setCompliance(BiometricMessage.Compliance.valueOf((int)qFeedback.getCompliance().getvalue())).setScore(qFeedback.getScore()).setQualityAttribute(BiometricMessage.IrisQualityAttribute.valueOf((int)qFeedback.getQualityAttribute().getvalue())).build()));
        ArrayList landMarkList = new ArrayList();
        qss.getLandMarkList().forEach(landMark -> landMarkList.add(BiometricMessage.LandMark.newBuilder().setLandMarkType(BiometricMessage.LandMarkType.forNumber((int)landMark.getLandMarkType().ordinal())).setX(landMark.getX()).setY(landMark.getY()).build()));
        byte[] data = captureAttempt.getImage().getOriginalData();
        BiometricMessage.IrisRequestv1 req = BiometricMessage.IrisRequestv1.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setImage(ByteString.copyFrom((byte[])data)).setEncoding("png").setIrisPosition(BiometricMessage.BioPosition.forNumber((int)position.ordinal())).setCaptureStartTime(captureAttempt.getStartTime()).setCaptureEndTime(captureAttempt.getEndTime()).setForcedCapture(captureAttempt.isForcedCapture()).addAllDeviceInfo(deviceInfoList).addAudit(BiometricMessage.Pair.newBuilder().setAttribute("appVersion").setValue(ApplicationVersion.VERSION).build()).setManualIntervention(captureAttempt.isForcedCapture() ? BiometricMessage.ManualInterventionType.FORCED : BiometricMessage.ManualInterventionType.MANUAL_INTERVENTION_TYPE_NONE).setOverallScore(qss.getOverallScore()).setBdbInfo(this.getBDBInfo(BiometricMessage.BioPosition.valueOf((String)position.name()), captureAttempt.getStartTime())).setOverallComments(qss.getOverallComments()).addAllQualityFeedback(qualityFeedbackList).addAllLandMarks(landMarkList).addAllBodyPart(BiometricUtilUC.getAvailableBodyParts(position, this.enrollmentService)).addAllMissingBodyPart(BiometricUtilUC.getMissingBodyParts(position, this.enrollmentService)).setDeleted(captureAttempt.isDeleted()).setBestAttempt(captureAttempt.isBestCapture()).build();
        byte[] uploadData = req.toByteArray();
        try {
            data = BiometricUtilUC.compress(uploadData);
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        return BiometricMessage.UploadData.newBuilder().setUploadData(ByteString.copyFrom((byte[])encData)).setSid(this.enrollmentService.getSid()).build();
    }

    private BiometricMessage.DeleteCaptureRequest createDeleteCaptureRequest(CaptureAttempt captureAttempt, Iris iris) {
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        BiometricMessage.Modality modality = this.mapIrisModality(iris);
        return BiometricMessage.DeleteCaptureRequest.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setModality(modality).build();
    }

    private BiometricMessage.Modality mapIrisModality(Iris iris) {
        if (iris.getLeftEye() != null) {
            return BiometricMessage.Modality.MODALITY_LEFT_IRIS;
        }
        if (iris.getRightEye() != null) {
            return BiometricMessage.Modality.MODALITY_RIGHT_IRIS;
        }
        return BiometricMessage.Modality.MODALITY_LEFT_IRIS;
    }

    private BiometricMessage.BdbInfo getBDBInfo(BiometricMessage.BioPosition position, long captureStartTime) {
        String subType = position == BiometricMessage.BioPosition.LEFT_IRIS ? "left" : "right";
        return BiometricMessage.BdbInfo.newBuilder().setType("iris").setFormatType(FORMAT_TYPE_IRIS).setSubType(subType).setFormatOwner(FORMAT_OWNER).setCreationDate(String.valueOf(captureStartTime)).build();
    }
}

