/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.protobuf.ByteString;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.protobuf.BiometricMessage;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Photograph;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.photograph.IPhotoTabConstants;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.PhotographTabViewPeerUC;
import in.gov.uidai.ec.ui.utils.BiometricUtilUC;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotographControllerUC
extends EnrollmentControllerBase
implements IPhotoTabConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotographControllerUC.class);
    private final HashMap<String, Object> photographEvtParams = new HashMap<String, Object>(){
        {
            this.put("prm_BioFieldName", "eID_PhotoTab_Face");
        }
    };
    private final Photograph photograph;
    private final PhotographTabViewPeerUC viewElements;
    private boolean isReviewTabRendered;
    private static final String FORMAT_TYPE_FACE = "8";
    private static final String FORMAT_OWNER = "257";
    private FaceQSS qss;
    private final JLabel uploadStatus;

    public PhotographControllerUC(ILiteView view, PhotographTabViewPeerUC viewElements) {
        super(view, viewElements.enrollmentService, 2, viewElements.getTabIndex());
        this.viewElements = viewElements;
        this.photograph = viewElements.enrollmentService.getPhotograph();
        this.photograph.setMaxCaptureAttempts(viewElements.uiPref.getMaxCaptureAttempts(5));
        this.initView();
        this.uploadStatus = viewElements.photoPanel.getPhotoField().uploadStatus;
    }

    private void initView() {
        IEventContext evtCtxt = this.viewElements.evtCtxt;
        BiometricsCaptureField photoField = this.viewElements.photoPanel.getPhotoField();
        Biometrics photo = this.photograph.getPhoto();
        BiometricsCaptureField exceptionPhotoField = this.viewElements.exceptionPhotoPanel.getExceptionPhotoField();
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_PhotoCapture", IBiometricsListener.class));
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_PhotoCapture", IBiometricsListener.class));
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSS_Face_Capture", IBiometricsListener.class, this.photographEvtParams));
        photoField.addQSSActionListener((ActionListener)evtCtxt.getEventListener("hID_QSS_Face", ActionListener.class, this.photographEvtParams));
        this.addCaptureListeners(photo, photoField);
        if (exceptionPhotoField != null) {
            Biometrics exceptionPhoto = this.photograph.getExceptionPhoto();
            this.addExceptionCaptureListeners(exceptionPhoto, exceptionPhotoField);
        }
        if (this.enrollmentService.getBiometricsException().getExceptionDetail() != null && this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
            this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setEnabled(true);
        }
        this.photograph.addBiometricsExceptionChangeListener(this::onBiometricsExceptionChange);
        this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().addChangeListener(this::onageAgeDobChangeListener);
        this.photograph.addValidityChangeListener(this::onValidityChange);
        this.addActionListener(this.viewElements.buttonPanel.nextButton, this::onNextButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.previousButton, this::onPrevButtonClick);
        this.addActionListener(this.viewElements.buttonPanel.cancelButton, (ActionListener)this.viewElements.evtCtxt.getEventListener("cancelDemo", ActionListener.class));
        this.viewElements.buttonPanel.nextButton.setEnabled(true);
        this.viewElements.buttonPanel.previousButton.setEnabled(true);
        this.addEventListenersForNonRdBasedUpdateEnrollment();
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
    }

    private void bioMetricListener(BiometricPosition position, CaptureAttempt captureAttempt, Biometrics biometrics) {
        if (captureAttempt.getStartTime() < 0L) {
            this.setUploadStatus(false);
            LOGGER.error("face qss upload failed, error code: {}, error message: {}", (Object)ErrorCodes.UC_BIO_001.getErrorCode(), (Object)ErrorCodes.UC_BIO_001.getReason());
            BiometricUtilUC.handleGenericError(ErrorCodes.UC_BIO_001.getReason(), ErrorCodes.UC_BIO_001.getErrorCode(), this.enrollmentService.getTransactionId());
            return;
        }
        biometrics.addCaptureAttempt(captureAttempt);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.submit(() -> this.uploadBiometric(captureAttempt));
        executor.shutdown();
    }

    private void bioxMetricListener(CaptureAttempt captureAttempt, Biometrics biometrics) {
        if (captureAttempt.getStartTime() < 0L) {
            LOGGER.error("exception photo upload failed, error code: {}, error message: {}", (Object)ErrorCodes.UC_BIO_001.getErrorCode(), (Object)ErrorCodes.UC_BIO_001.getReason());
            BiometricUtilUC.handleGenericError(ErrorCodes.UC_BIO_001.getReason(), ErrorCodes.UC_BIO_001.getErrorCode(), this.enrollmentService.getTransactionId());
            return;
        }
        biometrics.addCaptureAttempt(captureAttempt);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.submit(() -> this.uploadExceptionBiometric(captureAttempt));
        executor.shutdown();
    }

    private void bioDeleteListener(Biometrics biometrics, CaptureAttempt captureAttempt) {
        biometrics.deleteCaptureAttempt(captureAttempt);
        this.deleteCapturedAttempt(captureAttempt, BiometricMessage.Modality.MODALITY_PHOTO);
        if (this.enrollmentService.isUniversalClientTrnx() && captureAttempt.getAttemptNumber() < 1) {
            this.setUploadStatus(false);
        }
    }

    private void bioxDeleteListener(Biometrics biometrics, CaptureAttempt captureAttempt) {
        biometrics.deleteCaptureAttempt(captureAttempt);
        this.enrollmentService.setIsExceptionPhotoUploaded(false);
        this.deleteCapturedAttempt(captureAttempt, BiometricMessage.Modality.MODALITY_EXCEPTION_PHOTO);
    }

    private void bioClearListener(Biometrics biometrics) {
        biometrics.clearAttempts();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.setUploadStatus(false);
        }
    }

    private void addCaptureListeners(Biometrics biometrics, BiometricsCaptureField biometricsField) {
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> this.bioMetricListener((BiometricPosition)pos, (CaptureAttempt)captureAttempt, biometrics));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> this.bioDeleteListener(biometrics, (CaptureAttempt)captureAttempt));
        biometricsField.addBestCaptureAttemptChangeListeners((pos, bestAttempt) -> biometrics.setBestAttempt(bestAttempt));
        biometricsField.addCaptureAttemptClearChangeListener(pos -> this.bioClearListener(biometrics));
    }

    private void addExceptionCaptureListeners(Biometrics biometrics, BiometricsCaptureField biometricsField) {
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> this.bioxMetricListener((CaptureAttempt)captureAttempt, biometrics));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> this.bioxDeleteListener(biometrics, (CaptureAttempt)captureAttempt));
        biometricsField.addBestCaptureAttemptChangeListeners((pos, bestAttempt) -> biometrics.setBestAttempt(bestAttempt));
    }

    private void enableRDBioCapture(Boolean valid) {
        this.viewElements.bioPanel.getRDBioField(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).setEnabled(valid.booleanValue());
        this.viewElements.bioPanel.getRDVerifyButton(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).setEnabled(valid);
    }

    private void addEventListenersForNonRdBasedUpdateEnrollment() {
        if (!this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isRDBasedUpdate()) {
            return;
        }
        this.enrollmentService.addOnViewLoadCompleteListeners(o -> this.onBiometricUpdateTypeChange(this.enrollmentService.isBiometricUpdate()));
        this.photograph.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.photograph.addAgeUpdateChangeListener(this::onUpdateAgeChangeListener);
    }

    private void onBiometricUpdateTypeChange(Boolean isBiometricUpdate) {
        if (!isBiometricUpdate.booleanValue()) {
            this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setEnabled(false);
        }
        this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setVisible(isBiometricUpdate.booleanValue());
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setEnabled(biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied());
        this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().clear();
    }

    private void onageAgeDobChangeListener(AgeDob ageDob) {
        if (!this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isUniversalClientTrnx()) {
            if (this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().getAgeGroup().equals((Object)AgeGroup.BELOW5)) {
                this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setVisible(false);
                this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setEnabled(false);
            } else {
                this.viewElements.exceptionPhotoPanel.getExceptionPhotoField().setVisible(true);
            }
        }
    }

    private void onUpdateAgeChangeListener(Boolean isAgeUpdate) {
        if (this.enrollmentService.isOnlineUpdate() || this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment() || this.enrollmentService.isAdultEnrollment()) {
            // empty if block
        }
    }

    private void onValidityChange(boolean valid) {
        this.updateTabValidityState(valid);
    }

    private void onResidentRDSignatureCapture(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        if (captureType.getUserType() != AuthParamType.RESIDENT) {
            return;
        }
        this.photograph.getResidentConfirmation().setRDBioCapture(signature, captureAttempt);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onNextButtonClick(ActionEvent event) {
        if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isChildEnrollment()) {
            if (!this.enrollmentService.getPhotograph().isValid()) {
                this.showWarningUC("Photograph is not uploaded or captured.", (JComponent)event.getSource());
                return;
            }
            if (!this.isReviewTabRendered) {
                this.viewElements.reviewTabUC.renderReviewTabUC();
                this.isReviewTabRendered = true;
            }
        } else {
            boolean isFingerTabReq = FieldInfoUtils.isFingerTabRequired();
            boolean isIrisTabReq = FieldInfoUtils.isIrisTabRequired();
            if (!isIrisTabReq || !isFingerTabReq) {
                if (!this.enrollmentService.getPhotograph().isValid()) {
                    this.showWarningUC("Photograph is not uploaded or captured.", (JComponent)event.getSource());
                    return;
                }
                if (!this.isReviewTabRendered) {
                    this.viewElements.reviewTabUC.renderReviewTabUC();
                    this.isReviewTabRendered = true;
                }
            }
        }
        super.onNextButtonClick(event);
    }

    private void setUploadStatus(boolean status) {
        if (status) {
            this.uploadStatus.setText("\ue86c");
            this.uploadStatus.setForeground(Color.decode("#27AE61"));
            this.uploadStatus.setToolTipText("Uploaded");
        } else {
            this.uploadStatus.setText("\ue5c9");
            this.uploadStatus.setForeground(Color.decode("#B30202"));
            this.uploadStatus.setToolTipText("Upload Failed");
        }
        this.enrollmentService.getPhotograph().getPhoto().setUploadStatus(status);
    }

    private void uploadBiometric(CaptureAttempt captureAttempt) {
        this.qss = (FaceQSS)captureAttempt.getQSS();
        this.uploadStatus.setForeground(Color.decode("#BEC3C7"));
        this.uploadStatus.setToolTipText("Not Uploaded");
        this.enrollmentService.getPhotograph().getPhoto().setUploadStatus(false);
        BiometricMessage.UploadData faceRequestv1 = this.createFaceRequestv1(captureAttempt);
        GrpcService.getInst().uploadFaceQss(faceRequestv1, biometricResponse -> {
            if (biometricResponse.getResponse()) {
                LOGGER.info("face qss successfully uploaded");
                this.setUploadStatus(true);
            } else {
                LOGGER.info("face qss upload failed");
                this.setUploadStatus(false);
            }
            this.qss.setFullFrontalFace(null);
            this.qss.setFullFrontalFaceForDisplay(null);
        }, errorResponse -> {
            this.setUploadStatus(false);
            this.qss.setFullFrontalFace(null);
            this.qss.setFullFrontalFaceForDisplay(null);
            LOGGER.error("face qss upload failed, error code: {}, error message: {}", (Object)errorResponse.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(errorResponse));
            BiometricUtilUC.handleErrorGrpcResponse(errorResponse, this.enrollmentService.getTransactionId());
        });
    }

    private void uploadExceptionBiometric(CaptureAttempt captureAttempt) {
        this.enrollmentService.getPhotograph().getExceptionPhoto().setUploadStatus(false);
        BiometricMessage.UploadData exceptionPhotoRequestv1 = this.createExceptionPhotoRequestv1(captureAttempt);
        GrpcService.getInst().uploadExceptionPhoto(exceptionPhotoRequestv1, biometricResponse -> {
            if (biometricResponse.getResponse()) {
                LOGGER.info("exception photo uploaded successfully");
                this.enrollmentService.setIsExceptionPhotoUploaded(true);
            } else {
                LOGGER.info("exception photo upload failed");
            }
        }, errorResponse -> {
            this.setUploadStatus(false);
            LOGGER.error("exception photo upload failed, error code: {}, error message: {}", (Object)errorResponse.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(errorResponse));
            BiometricUtilUC.handleErrorGrpcResponse(errorResponse, this.enrollmentService.getTransactionId());
        });
    }

    private List<BiometricMessage.FaceQualityFeedback> getQualityFeedbackList() {
        return this.qss.getQualityFeedback().stream().map(qFeedback -> BiometricMessage.FaceQualityFeedback.newBuilder().setComments(qFeedback.getComments()).setCompliance(BiometricMessage.Compliance.valueOf((String)qFeedback.getCompliance().name())).setScore(qFeedback.getScore()).setQualityAttribute(BiometricMessage.FaceQualityAttribute.valueOf((String)qFeedback.getQualityAttribute().name())).build()).collect(Collectors.toList());
    }

    private List<BiometricMessage.LandMark> getLandmarkList() {
        return this.qss.getLandMarkList().stream().map(landMark -> BiometricMessage.LandMark.newBuilder().setLandMarkType(BiometricMessage.LandMarkType.valueOf((String)landMark.getLandMarkType().name())).setX(landMark.getX()).setY(landMark.getY()).build()).collect(Collectors.toList());
    }

    private BiometricMessage.UploadData createFaceRequestv1(CaptureAttempt captureAttempt) {
        ByteArrayOutputStream baos;
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        BiometricMessage.FaceRequestv1 req = BiometricMessage.FaceRequestv1.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setImage(ByteString.copyFrom((byte[])this.qss.getFullFrontalFace())).setCaptureStartTime(captureAttempt.getStartTime()).setCaptureEndTime(captureAttempt.getEndTime()).setEncoding("png").setForcedCapture(captureAttempt.isForcedCapture()).addAllDeviceInfo(deviceInfoList).addAudit(BiometricMessage.Pair.newBuilder().setAttribute("appVersion").setValue(ApplicationVersion.VERSION).build()).setFullFrontalFace(ByteString.copyFrom((byte[])this.qss.getFullFrontalFace())).setFullFrontalFaceForDisplay(ByteString.copyFrom((byte[])captureAttempt.getImage().getImageData())).setManualIntervention(captureAttempt.isForcedCapture() ? BiometricMessage.ManualInterventionType.FORCED : BiometricMessage.ManualInterventionType.MANUAL_INTERVENTION_TYPE_NONE).setOverallComments(this.qss.getOverallComments()).setOverallCompliance(BiometricMessage.Compliance.valueOf((String)this.qss.getOverallCompliance().name())).setOverallScore((int)this.qss.getOverallScore()).setBdbInfo(this.getBDBInfo(captureAttempt)).addAllQualityFeedback(this.getQualityFeedbackList()).addAllLandMarks(this.getLandmarkList()).addAllBodyPart(BiometricUtilUC.getAvailableBodyParts(BiometricPosition.FACE, this.enrollmentService)).addAllMissingBodyPart(BiometricUtilUC.getMissingBodyParts(BiometricPosition.FACE, this.enrollmentService)).setDeleted(captureAttempt.isDeleted()).setBestAttempt(captureAttempt.isBestCapture()).build();
        byte[] uploadData = req.toByteArray();
        try {
            byte[] data = BiometricUtilUC.compress(uploadData);
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        return BiometricMessage.UploadData.newBuilder().setUploadData(ByteString.copyFrom((byte[])encData)).setSid(this.enrollmentService.getSid()).build();
    }

    private BiometricMessage.UploadData createExceptionPhotoRequestv1(CaptureAttempt captureAttempt) {
        ByteArrayOutputStream baos;
        byte[] imgData = captureAttempt.getImage().getOriginalData();
        if (imgData != null && imgData.length > 0) {
            imgData[35] = 1;
        } else {
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_191.getReason(), null, ErrorCodes.UC_GEN_191.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        }
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        BiometricMessage.ExceptionPhotoRequestv1 req = BiometricMessage.ExceptionPhotoRequestv1.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setImage(ByteString.copyFrom((byte[])imgData)).setCaptureStartTime(captureAttempt.getStartTime()).setCaptureEndTime(captureAttempt.getEndTime()).setEncoding("png").setForcedCapture(captureAttempt.isForcedCapture()).addAllDeviceInfo(deviceInfoList).addAudit(BiometricMessage.Pair.newBuilder().setAttribute("appVersion").setValue(ApplicationVersion.VERSION).build()).setFullFrontalFace(ByteString.copyFrom((byte[])imgData)).setFullFrontalFaceForDisplay(ByteString.copyFrom((byte[])captureAttempt.getImage().getImageData())).setManualIntervention(captureAttempt.isForcedCapture() ? BiometricMessage.ManualInterventionType.FORCED : BiometricMessage.ManualInterventionType.MANUAL_INTERVENTION_TYPE_NONE).setBdbInfo(this.getBDBInfo(captureAttempt)).addAllBodyPart(BiometricUtilUC.getAvailableBodyParts(BiometricPosition.FACE, this.enrollmentService)).addAllMissingBodyPart(BiometricUtilUC.getMissingBodyParts(BiometricPosition.FACE, this.enrollmentService)).setDeleted(captureAttempt.isDeleted()).setBestAttempt(captureAttempt.isBestCapture()).build();
        byte[] uploadData = req.toByteArray();
        try {
            byte[] data = BiometricUtilUC.compress(uploadData);
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        return BiometricMessage.UploadData.newBuilder().setUploadData(ByteString.copyFrom((byte[])encData)).setSid(this.enrollmentService.getSid()).build();
    }

    private void deleteCapturedAttempt(CaptureAttempt captureAttempt, BiometricMessage.Modality modality) {
        ArrayList deviceInfoList = new ArrayList();
        captureAttempt.getDeviceInfo().getDeviceAttributes().forEach((attribute, value) -> deviceInfoList.add(BiometricMessage.Pair.newBuilder().setAttribute(attribute).setValue(value).build()));
        BiometricMessage.DeleteCaptureRequest deleteRequest = BiometricMessage.DeleteCaptureRequest.newBuilder().setSid(this.enrollmentService.getSid()).setAttemptNumber(captureAttempt.getAttemptNumber()).setModality(modality).build();
        GrpcService.getInst().deleteCapture(deleteRequest, response -> {
            if (response.getSuccess()) {
                LOGGER.info("Delete capture request successful for attempt {}", (Object)captureAttempt.getAttemptNumber());
            } else {
                LOGGER.error(String.format("Delete capture failed for position: %s, sid: %s", modality.getValueDescriptor(), deleteRequest.getSid()));
                TelemetryService.getTelemetryServiceInstance().postDebugData(String.format("Delete capture failed for position: %s, sid: %s", modality.getValueDescriptor(), deleteRequest.getSid()), new String[0]);
            }
        }, error -> {
            LOGGER.error("Delete capture gRPC call failed, error code: {}, message: {}", (Object)error.getErrorCode(), (Object)CommonUtilsUC.getErrorMessage(error));
            this.showErrorUC(null, CommonUtilsUC.getErrorMessage(error), error.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        });
    }

    private BiometricMessage.BdbInfo getBDBInfo(CaptureAttempt captureAttempt) {
        return BiometricMessage.BdbInfo.newBuilder().setType("face").setFormatType(FORMAT_TYPE_FACE).setSubType("face").setFormatOwner(FORMAT_OWNER).setCreationDate(String.valueOf(captureAttempt.getStartTime())).build();
    }
}

