/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantConfirmGender;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.ConfirmDob;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.NationalityTypes;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.isd.IISDService;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.AppointmentPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.GenderPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.PersonalDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.RelativeDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.basic.ResidentPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.contact.ContactDetailPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.BasicDetailControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ContactDetailControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;

public class PopulateDemoUC {
    private final PersonalDetailPanel personalDetailPanel;
    private final AppointmentPanel appointmentPanel;
    private final ContactDetailPanel contactDetailPanel;
    private final BasicDetailControllerUC basicController;
    private final ContactDetailControllerUC contactController;
    private final RelativeDetailPanel relativeDetailPanel;
    private final ResidentPanel residentPanel;

    public PopulateDemoUC(DemographicsTabViewPeerUC viewPeerUC, BasicDetailControllerUC basicController, ContactDetailControllerUC contactController) {
        this.personalDetailPanel = viewPeerUC.getBasicDetailPanel().getPersonalDetailPanel();
        this.contactDetailPanel = viewPeerUC.getContactDetailPanel();
        this.relativeDetailPanel = viewPeerUC.getRelativeDetailPanel();
        this.basicController = basicController;
        this.contactController = contactController;
        this.residentPanel = viewPeerUC.getResidentPanel();
        this.appointmentPanel = viewPeerUC.getBasicDetailPanel().getAppointmentPanel();
    }

    public void populatePersonalDetails(PersonalDetail demoPersonalDetails) {
        Name name = demoPersonalDetails.getName();
        this.personalDetailPanel.getNameField().setText(name.english());
        this.personalDetailPanel.getLocalName().setText(name.local());
        this.populateGender(demoPersonalDetails);
        this.populateConfirmGender(demoPersonalDetails);
        this.populateAgeDob(demoPersonalDetails);
        this.populateConfirmDob(demoPersonalDetails);
        this.basicController.updateBasicDetailField();
    }

    public void populateAppointmentId(String appointmentId) {
        if (!Strings.isNullOrEmpty((String)appointmentId)) {
            this.appointmentPanel.getAppointmentTextField().setText(appointmentId);
        }
    }

    public void populateForeignNationality(ResidentialStatus residentialStatus) {
        if (!this.residentPanel.nationalityExists(this.residentPanel.getForeignType(), "Select")) {
            this.residentPanel.getForeignType().insertItemAt(new NationalityTypes("", "Select"), 0);
            this.residentPanel.getForeignType().setSelectedIndex(0);
        } else {
            this.residentPanel.getForeignType().setSelectedItem(residentialStatus.getForeignType());
        }
        if (!this.residentPanel.countryExists(this.residentPanel.getNationalityList(), "Select")) {
            this.residentPanel.getNationalityList().insertItemAt(new Country("Select", ""), 0);
            this.residentPanel.getNationalityList().setSelectedIndex(0);
        } else {
            this.residentPanel.getNationalityList().setSelectedItem(residentialStatus.getCountry());
        }
    }

    public void populateHofDetailsForHofUpdate(EnrollmentService enrollmentService) {
        switch (enrollmentService.getDemographics().getOtherDetail().getRelationType()) {
            case FATHER: {
                this.relativeDetailPanel.getFatherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getFatherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getFatherDetail().setHOF(true);
                break;
            }
            case MOTHER: {
                this.relativeDetailPanel.getMotherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getMotherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getMotherDetail().setHOF(true);
                break;
            }
            case LEGAL_GUARDIAN: {
                this.relativeDetailPanel.getOtherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getOtherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getOtherDetail().setHOF(true);
            }
        }
    }

    public void populateHofDetails(EnrollmentService enrollmentService) {
        switch (enrollmentService.getDemographics().getOtherDetail().getRelationType()) {
            case FATHER: {
                this.relativeDetailPanel.getFatherName().setText(enrollmentService.getHofName());
                this.relativeDetailPanel.getFatherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getFatherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getFatherDetail().setName(enrollmentService.getHofName());
                enrollmentService.getDemographics().getFatherDetail().setHOF(true);
                break;
            }
            case MOTHER: {
                this.relativeDetailPanel.getMotherName().setText(enrollmentService.getHofName());
                this.relativeDetailPanel.getMotherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getMotherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getMotherDetail().setName(enrollmentService.getHofName());
                enrollmentService.getDemographics().getMotherDetail().setHOF(true);
                break;
            }
            case LEGAL_GUARDIAN: {
                this.relativeDetailPanel.getOtherName().setText(enrollmentService.getHofName());
                this.relativeDetailPanel.getOtherUID().setValue(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getOtherDetail().setUid(enrollmentService.getHofUid());
                enrollmentService.getDemographics().getOtherDetail().setName(enrollmentService.getHofName());
                enrollmentService.getDemographics().getOtherDetail().setHOF(true);
            }
        }
    }

    private void populateGender(PersonalDetail demoPersonalDetails) {
        ApplicantGender gender = demoPersonalDetails.getApplicantGender();
        GenderPanel genderPanel = this.personalDetailPanel.getGenderPanel();
        if (!genderPanel.itemExists(genderPanel.getGenderField(), Gender.getDefaultSelect())) {
            genderPanel.getGenderField().insertItemAt(Gender.getDefaultSelect(), 0);
        }
        if (gender.getDisplayGender() == Gender.NOT_GIVEN) {
            genderPanel.getGenderField().setSelectedIndex(0);
        } else {
            genderPanel.getGenderField().setSelectedItem(gender.getDisplayGender());
            this.personalDetailPanel.getLocalGender().setText(gender.getDisplayGender().toString());
        }
    }

    private void populateConfirmGender(PersonalDetail demoPersonalDetails) {
        ApplicantConfirmGender gender = demoPersonalDetails.getApplicantConfirmGender();
        GenderPanel genderPanel = this.personalDetailPanel.getGenderPanel();
        if (!genderPanel.itemExists(genderPanel.getGenderField(), Gender.getDefaultSelect())) {
            genderPanel.getConfirmGenderField().insertItemAt(Gender.getDefaultSelect(), 0);
        }
        if (gender.getDisplayGender() == Gender.NOT_GIVEN) {
            genderPanel.getConfirmGenderField().setSelectedIndex(0);
        } else {
            genderPanel.getConfirmGenderField().setSelectedItem(gender.getDisplayGender());
        }
    }

    private void populateAgeDob(PersonalDetail demoPersonalDetails) {
        AgeDob ageDob = demoPersonalDetails.getAgeDob();
        if (ageDob.isDobSelected() && !ageDob.getDayForDisplay().toString().equals("-1")) {
            this.personalDetailPanel.getDobField().setText(ageDob.getDayForDisplay().toString() + "-" + ageDob.getMonthForDisplay().toString() + "-" + ageDob.getYearForDisplay().toString());
        } else {
            this.personalDetailPanel.getAgeField().setText(ageDob.getAge().toString());
        }
        this.updateLocalAgeField(demoPersonalDetails);
    }

    private void updateLocalAgeField(PersonalDetail demoPersonalDetails) {
        AgeDob ageDob = demoPersonalDetails.getAgeDob();
        if (!ageDob.isDobSelected() || ageDob.isValid() && ageDob.isMandatory() && !ageDob.isEmpty()) {
            int age = ageDob.getAge();
            String locText = ageDob.isValid() ? age + " years" : "years";
            this.personalDetailPanel.getLocalAge().setText(locText);
        } else if (!ageDob.isValid()) {
            this.personalDetailPanel.getLocalAge().setText("");
        }
        ageDob.setAgeDobLocal(this.personalDetailPanel.getLocalAge().getText());
    }

    private void populateConfirmDob(PersonalDetail demoPersonalDetails) {
        ConfirmDob confirmDob = demoPersonalDetails.getConfirmDob();
        if (confirmDob.isDobSelected() && !confirmDob.getDayForDisplay().toString().equals("-1")) {
            this.personalDetailPanel.getConfirmDobField().setText(confirmDob.getDayForDisplay().toString() + "-" + confirmDob.getMonthForDisplay().toString() + "-" + confirmDob.getYearForDisplay().toString());
        } else {
            this.personalDetailPanel.getConfirmAgeField().setText(confirmDob.getAge().toString());
        }
    }

    public void populateContactDetails(Contact demoContactDetails, boolean isNriForeignAddress) {
        if (!isNriForeignAddress) {
            this.populateAddress(demoContactDetails);
        } else {
            this.populateNRIAddress(demoContactDetails);
        }
        this.contactController.updateAddressFieldState();
    }

    private void populateAddress(Contact demoContactDetails) {
        Address address = demoContactDetails.getAddress();
        this.contactDetailPanel.setAddressFields(address);
    }

    private void populateNRIAddress(Contact demoContactDetails) {
        ForeignNRI foreignNRIAddress = demoContactDetails.getForeignNriAddress();
        this.contactDetailPanel.setNRIForeignAddressFields(foreignNRIAddress);
    }

    public void populateMobileEmailDetails(Contact demoContactDetails, IISDService iisdService) {
        Mobile mobile = demoContactDetails.getMobile();
        Email email = demoContactDetails.getEmail();
        if (mobile.getNumberForDisplay().isEmpty()) {
            mobile.setMobileVerified(false);
            this.contactDetailPanel.getMobilePanel().getMobileTextField().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().getIsdList().setEnabled(false);
        } else {
            mobile.setMobileVerified(!iisdService.getDefaultSelect().getISDCode().equalsIgnoreCase(mobile.isdCode()));
            this.contactDetailPanel.getMobilePanel().getMobileTextField().setText(mobile.getNumberForDisplay());
            this.contactDetailPanel.getMobilePanel().getMobileTextField().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().getIsdList().setText(mobile.isdCode());
            this.contactDetailPanel.getMobilePanel().getIsdList().setEnabled(false);
            this.contactDetailPanel.getMobilePanel().getGenerateOtpButton().setEnabled(iisdService.getDefaultSelect().getISDCode().equalsIgnoreCase(mobile.isdCode()));
        }
        if (email.getEmailForDisplay().isEmpty()) {
            email.setEmailVerified(false);
            demoContactDetails.getEmail().setEmail("");
            this.contactDetailPanel.getEmailPanel().getEmailTextField().setEnabled(false);
            this.contactDetailPanel.getEmailPanel().getGenerateOtpButton().setEnabled(false);
        } else {
            email.setEmailVerified(false);
            this.contactDetailPanel.getEmailPanel().getEmailTextField().setText(email.getEmailForDisplay());
            this.contactDetailPanel.getEmailPanel().getEmailTextField().setEnabled(false);
        }
    }

    public void populateCareOfField(String name, String localName) {
        this.contactDetailPanel.getCareofPanel().getCareofTextField().setText(name);
        this.contactDetailPanel.getCareofPanel().getLocCareOf().setText(localName);
    }
}

