/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import in.gov.uidai.ec.ecmpapi.model.RegistryType;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.json.dvsapi.UploadType;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.ProofDetails;
import in.gov.uidai.ec.protobuf.UcDocumentServiceProto;
import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.document.digilocker.ValuesDocumentModel;
import in.gov.uidai.ec.service.document.digilocker.VerifiableDocument;
import in.gov.uidai.ec.service.document.roi.RoiCoordinate;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedDocuments;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.RelativeDetail;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.references.IReferenceTabContants;
import in.gov.uidai.ec.ui.enrol.references.ReferenceStagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.DocumentUploadPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.DocumentVerifyPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.IdVerificationPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.POXPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PobPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReferenceTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.NotificationPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceControllerUC
extends EnrollmentControllerBase
implements IReferenceTabContants,
INavigationConstants {
    private final ReferenceTabViewPeerUC viewPeerUC;
    private static final String DOC_UPLOADED_TIP = "Document Uploaded";
    private static final String DOC_NOT_UPLOADED_TIP = "Document upload failed";
    private static final String DOC_UPLOAD_AGAIN = "Upload document again";
    private static final String REGISTRY_NOT_VERIFIED_MESSAGE = "Not verified from Registry";
    private static final String REGISTRY_VERIFIED_MESSAGE = "Verified from Registry";
    private static final String DOC_VALIDATE_TIP = "Document validated";
    private static final String DOC_NOT_VALIDATE_TIP = "Document validation failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceControllerUC.class);
    private boolean isBiometricsTabRendered;
    private boolean isReviewTabRendered;
    private final IVisualExecutionContext veCtxt;
    private Map<ReferenceStagesUC, Boolean> tabState;
    private ReferenceStagesUC[] referenceStagesUCList;
    private ActionListener showPreviewListener;

    public ReferenceControllerUC(ReferenceTabViewPeerUC viewPeerUC) {
        super(viewPeerUC.getLiteView(), viewPeerUC.getEnrollmentService(), 1, viewPeerUC.getTabIndex());
        this.viewPeerUC = viewPeerUC;
        this.veCtxt = this.view.getVisualExecutionContext();
        this.init();
    }

    private void init() {
        boolean isAppointmentFlow;
        References references = this.enrollmentService.getReferences();
        this.addActionListener(this.viewPeerUC.getButtonPanel().nextButton, this::onNextButtonClick);
        this.addActionListener(this.viewPeerUC.getButtonPanel().previousButton, this::onPrevButtonClick);
        references.addValidityChangeListener(this::updateTabValidityState);
        this.referenceStagesUCList = new ReferenceStagesUC[]{ReferenceStagesUC.DOCUMENT_UPLOAD, ReferenceStagesUC.DOCUMENT_VERIFY};
        this.enrollmentService.setDocumentFetchType("digilocker");
        this.viewPeerUC.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        PobPanel pobPanel = this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel();
        this.addItemListener(pobPanel.pobList, (ItemEvent evt) -> this.documentSelection(evt, DocumentType.POB, this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList));
        this.addActionListener(pobPanel.scan, (ActionEvent evt) -> this.setAttachOrScan(evt, DocumentType.POB, "scan_document"));
        this.addActionListener(pobPanel.preview, (ActionEvent evt) -> this.previewDocument(evt, DocumentType.POB));
        this.addActionListener(pobPanel.digilocker, (ActionEvent evt) -> this.openDigilockerPanel(evt, DocumentType.POB));
        IdVerificationPanel verificationPanel = this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel();
        this.addItemListener(verificationPanel.getPoiPanel().poiList, (ItemEvent evt) -> this.documentSelection(evt, DocumentType.POI, verificationPanel.getPoiPanel().poiList));
        this.addActionListener(verificationPanel.getPoiPanel().scan, (ActionEvent evt) -> this.setAttachOrScan(evt, DocumentType.POI, "scan_document"));
        this.addActionListener(verificationPanel.getPoiPanel().preview, (ActionEvent evt) -> this.previewDocument(evt, DocumentType.POI));
        this.addActionListener(verificationPanel.getPoiPanel().digilocker, (ActionEvent evt) -> this.openDigilockerPanel(evt, DocumentType.POI));
        this.addItemListener(verificationPanel.getPoaPanel().poaList, (ItemEvent evt) -> this.documentSelection(evt, DocumentType.POA, verificationPanel.getPoaPanel().poaList));
        this.addActionListener(verificationPanel.getPoaPanel().scan, (ActionEvent evt) -> this.setAttachOrScan(evt, DocumentType.POA, "scan_document"));
        this.addActionListener(verificationPanel.getPoaPanel().preview, (ActionEvent evt) -> this.previewDocument(evt, DocumentType.POA));
        this.addActionListener(verificationPanel.getPoaPanel().digilocker, (ActionEvent evt) -> this.openDigilockerPanel(evt, DocumentType.POA));
        this.addActionListener(verificationPanel.getPofPanel().scan, (ActionEvent evt) -> this.setAttachOrScan(evt, DocumentType.POF, "scan_document"));
        this.addActionListener(verificationPanel.getPofPanel().preview, (ActionEvent evt) -> this.previewDocument(evt, DocumentType.POF));
        this.addItemListener(verificationPanel.getPorPanel().porList, (ItemEvent evt) -> this.documentSelection(evt, DocumentType.POR, verificationPanel.getPorPanel().porList));
        this.addActionListener(verificationPanel.getPorPanel().scan, (ActionEvent evt) -> this.setAttachOrScan(evt, DocumentType.POR, "scan_document"));
        this.addActionListener(verificationPanel.getPorPanel().preview, (ActionEvent evt) -> this.previewDocument(evt, DocumentType.POR));
        DocumentsManager documentsManager = this.enrollmentService.getDocManager();
        documentsManager.addChangeListener(this::onDocumentChange);
        verificationPanel.getPorPanel().refresh.addActionListener(e -> this.selectDefaultDocumentsAndRefresh());
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(true);
        this.enrollmentService.getDocManager().setDocumentUploadSuccessDigilocker(() -> {
            this.setStatusIconForUpload(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify(), true, DOC_UPLOADED_TIP, false);
            this.enablePreviewButton(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify(), true);
        });
        references.getPof().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPoa().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPob().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPoi().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPor().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPof().addDocumentUploadListener(this::verifyAndValidateDocument);
        references.getPoa().addDocumentUploadListener(this::verifyAndValidateDocument);
        references.getPob().addDocumentUploadListener(this::verifyAndValidateDocument);
        references.getPoi().addDocumentUploadListener(this::verifyAndValidateDocument);
        references.getPor().addDocumentUploadListener(this::verifyAndValidateDocument);
        references.getPoa().addMandatoryChangeListener(e -> this.enableDocumentTypes(e, DocumentType.POA));
        references.getPob().addMandatoryChangeListener(e -> this.enableDocumentTypes(e, DocumentType.POB));
        references.getPoi().addMandatoryChangeListener(e -> this.enableDocumentTypes(e, DocumentType.POI));
        references.getPor().addMandatoryChangeListener(e -> this.enableDocumentTypes(e, DocumentType.POR));
        references.getPof().addMandatoryChangeListener(e -> this.enableDocumentTypes(e, DocumentType.POF));
        RelativeDetail fatherDetail = this.enrollmentService.getDemographics().getFatherDetail();
        RelativeDetail motherDetail = this.enrollmentService.getDemographics().getMotherDetail();
        RelativeDetail otherDetail = this.enrollmentService.getDemographics().getOtherDetail();
        RelationshipType type = !Strings.isNullOrEmpty((String)fatherDetail.getUid()) ? RelationshipType.FATHER : (!Strings.isNullOrEmpty((String)motherDetail.getUid()) ? RelationshipType.MOTHER : (!Strings.isNullOrEmpty((String)otherDetail.getUid()) ? RelationshipType.LEGAL_GUARDIAN : RelationshipType.NOT_GIVEN));
        boolean bl = isAppointmentFlow = !Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId());
        if (isAppointmentFlow) {
            this.populateDocuments(this.enrollmentService.getReferences().getAllowedDocuments(), references);
        }
        references.getAllowedDocuments().addChangeListener(e -> this.populateDocuments((ReferenceAllowedDocuments)e, references));
        if (type != RelationshipType.NOT_GIVEN || this.enrollmentService.isUpdateUC() || isAppointmentFlow) {
            this.enrollmentService.getReferences().reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup(), type);
        }
        this.enrollmentService.getReferences().setMandatory(this.enrollmentService.isForeignResident(), this.enrollmentService.getIsPobRequired());
        if (this.enrollmentService.isForeignResident()) {
            this.initForeignEnrollment(references);
        }
        DocumentType[] allDocumentTypesInReference = new DocumentType[]{DocumentType.POB, DocumentType.POI, DocumentType.POA, DocumentType.POF, DocumentType.POR};
        DocumentVerifyPanel documentVerifyPanel = this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel();
        for (DocumentType documentType : allDocumentTypesInReference) {
            this.addActionListener(documentVerifyPanel.getPanelForDocumentType().get(documentType).getVerifyButton(), (ActionEvent event) -> this.checkVerifyRequired(event, documentType));
        }
        this.showPreviewListener = (ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("hID_ShowPreview", ActionListener.class);
        this.initialise();
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().addChangeListener(ageDob -> {
            this.changeToDefaultDocument();
            this.enrollmentService.getReferences().reEvaluateReferences(this.enrollmentService.getDemographics().getResidentialStatus().isNRI(), ageDob.getAgeGroup(), this.enrollmentService.getDemographics().getHofRelationType());
        });
    }

    private void enableDocumentTypes(boolean enable, DocumentType documentType) {
        switch (documentType) {
            case POA: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaList.setEnabled(enable);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().setMandatory(enable);
                break;
            }
            case POB: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList.setEnabled(enable);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().setMandatory(enable);
                break;
            }
            case POI: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiList.setEnabled(enable);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().setMandatory(enable);
                break;
            }
            case POR: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().porList.setEnabled(enable);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().setMandatory(enable);
                break;
            }
            case POF: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().setMandatory(enable);
            }
        }
    }

    private void populateDocuments(ReferenceAllowedDocuments referenceAllowedDocuments, References references) {
        this.addItems(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaList, referenceAllowedDocuments.getPoaDocs(), references.getPoa().getProof());
        this.addItems(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList, referenceAllowedDocuments.getPobDocs(), references.getPob().getProof());
        this.addItems(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiList, referenceAllowedDocuments.getPoiDocs(), references.getPoi().getProof());
        this.addItems(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().porList, referenceAllowedDocuments.getPorDocs(), references.getPor().getProof());
    }

    private void initForeignEnrollment(References references) {
        references.getPof().addDocNameChangeListener(this::loadDocumentName);
        references.getPoi().addDocNameChangeListener(this::loadDocumentName);
    }

    private void loadDocumentName(ReferenceDocument document) {
        ProofDocument pofDoc = this.enrollmentService.getReferences().getPof().getProof();
        ProofDocument poiDoc = this.enrollmentService.getReferences().getPoi().getProof();
        ProofDocument poaDoc = this.enrollmentService.getReferences().getPoa().getProof();
        ProofDocument pobDoc = this.enrollmentService.getReferences().getPob().getProof();
        ReferenceDocument referenceDocument = this.enrollmentService.getReferences().getReferenceDoc(document.getDocumentType());
        IdVerificationPanel verificationPanel = this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel();
        PobPanel pobPanel = this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel();
        this.clearDocument(document.getDocumentType());
        this.setStatusIconForUpload(document.getDocumentType(), false, DOC_UPLOAD_AGAIN, true);
        this.setStatusIconForVerification(document.getDocumentType(), true, true, "Status of the document", "Status of the document", true);
        switch (document.getDocumentType()) {
            case POB: {
                if (pobDoc != null && !Strings.isNullOrEmpty((String)pobDoc.getDocId())) {
                    pobPanel.pobTextField.setText(pobDoc.getDocName());
                    pobPanel.pobTextField.setToolTipText(pobDoc.getDocName());
                    pobPanel.scan.setEnabled(true);
                    this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobTextField, referenceDocument);
                    break;
                }
                pobPanel.scan.setEnabled(false);
                break;
            }
            case POI: {
                if (poiDoc != null && !Strings.isNullOrEmpty((String)poiDoc.getDocId())) {
                    verificationPanel.getPoiPanel().poiTextField.setText(poiDoc.getDocName());
                    verificationPanel.getPoiPanel().poiTextField.setToolTipText(poiDoc.getDocName());
                    verificationPanel.getPoiPanel().scan.setEnabled(true);
                    this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiTextField, referenceDocument);
                    break;
                }
                verificationPanel.getPoiPanel().scan.setEnabled(false);
                break;
            }
            case POA: {
                if (poaDoc != null && !Strings.isNullOrEmpty((String)poaDoc.getDocId())) {
                    verificationPanel.getPoaPanel().poaTextField.setText(poaDoc.getDocName());
                    verificationPanel.getPoaPanel().poaTextField.setToolTipText(poaDoc.getDocName());
                    verificationPanel.getPoaPanel().scan.setEnabled(true);
                    this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaTextField, referenceDocument);
                    break;
                }
                verificationPanel.getPoaPanel().scan.setEnabled(false);
                break;
            }
            case POF: {
                if (pofDoc != null && !Strings.isNullOrEmpty((String)pofDoc.getDocId())) {
                    verificationPanel.getPofPanel().pofTextField.setText(pofDoc.getDocName());
                    verificationPanel.getPofPanel().pofTextField.setToolTipText(pofDoc.getDocName());
                    verificationPanel.getPofPanel().scan.setEnabled(true);
                    this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().pofTextField, referenceDocument);
                    break;
                }
                verificationPanel.getPofPanel().scan.setEnabled(false);
                break;
            }
        }
        if (this.allDocumentsAttached(this.enrollmentService.getDocManager())) {
            this.enrollmentService.getDocManager().setDocumentUploadSuccessFalse(document.getDocumentType());
            this.viewPeerUC.getButtonPanel().nextButton.setEnabled(false);
        }
    }

    private boolean allDocumentsAttached(DocumentsManager documentsManager) {
        boolean documentsAttached = true;
        if (this.enrollmentService.getReferences().getPob().isMandatory() && !documentsManager.isDocumentUploaded(DocumentType.POB)) {
            documentsAttached = false;
        }
        if (this.enrollmentService.getReferences().getPoi().isMandatory() && !documentsManager.isDocumentUploaded(DocumentType.POI)) {
            documentsAttached = false;
        }
        if (this.enrollmentService.getReferences().getPof().isMandatory() && !documentsManager.isDocumentUploaded(DocumentType.POF)) {
            documentsAttached = false;
        }
        if (this.enrollmentService.getReferences().getPoa().isMandatory() && !documentsManager.isDocumentUploaded(DocumentType.POA)) {
            documentsAttached = false;
        }
        if (this.enrollmentService.getReferences().getPor().isMandatory() && !documentsManager.isDocumentUploaded(DocumentType.POR)) {
            documentsAttached = false;
        }
        return documentsAttached;
    }

    private void onDocumentChange(DocumentsManager documentsManager) {
        DocumentType currentDocType = documentsManager.getCurrentDocumentTypeForUploadOrVerify();
        if (currentDocType == DocumentType.SIGNED_ACK_SLIP || currentDocType == DocumentType.ENROL_FORM) {
            return;
        }
        boolean allDocsAttached = this.allDocumentsAttached(documentsManager);
        boolean docValidationOverride = documentsManager.isDocValidationOverride();
        if (allDocsAttached && !docValidationOverride && documentsManager.getDvsResultMap().isEmpty()) {
            this.viewPeerUC.getButtonPanel().nextButton.setEnabled(true);
        }
        if (docValidationOverride) {
            LOGGER.info("Demographics details did not match with the details for some documents, overriding mismatch details");
            this.enrollmentService.resetRoiEnabled();
            this.viewPeerUC.getButtonPanel().nextButton.setEnabled(true);
        }
    }

    @Override
    public void onNextButtonClick(ActionEvent event) {
        ShadowPanel currentPanel = (ShadowPanel)this.viewPeerUC.getReferencePanel().getTabbedPane().getSelectedComponent();
        int tabIndex = this.viewPeerUC.getReferencePanel().getTabbedPane().getSelectedIndex();
        switch (currentPanel.getReferenceStage()) {
            case DOCUMENT_UPLOAD: {
                this.handleDocumentUploadPanelValidation(event, tabIndex);
                break;
            }
            case DOCUMENT_VERIFY: {
                this.renderNextTab();
                super.onNextButtonClick(event);
                break;
            }
        }
    }

    private void renderNextTab() {
        boolean isPhotoTabReq = FieldInfoUtils.isPhotoTabRequired();
        boolean isFingerTabReq = FieldInfoUtils.isFingerTabRequired();
        boolean isIrisTabReq = FieldInfoUtils.isIrisTabRequired();
        if (!this.isBiometricsTabRendered) {
            if (isPhotoTabReq && this.enrollmentService.isTabEnabled(2)) {
                this.viewPeerUC.getPhotoTab().renderPhotoTab();
            }
            if (isFingerTabReq && this.enrollmentService.isTabEnabled(3)) {
                this.viewPeerUC.getFingerTab().renderFingerTab();
            }
            if (isIrisTabReq && this.enrollmentService.isTabEnabled(4)) {
                this.viewPeerUC.getIrisTab().renderIrisTab();
            }
            this.isBiometricsTabRendered = true;
            return;
        }
        if (!this.isReviewTabRendered) {
            this.viewPeerUC.getReviewTab().renderReviewTabUC();
            this.isReviewTabRendered = true;
        }
    }

    private boolean digilockerDocumentPresent(ProofDocument proofDocument) {
        Map digilockerDocuments = this.enrollmentService.getReferences().getAllowedDocuments().getDigilockerList();
        return digilockerDocuments.containsKey(proofDocument.getDocId());
    }

    private void documentSelection(ItemEvent ie, DocumentType docType, JComboBox<ProofDocument> field) {
        if (ie.getStateChange() != 1) {
            return;
        }
        this.clearDocument(docType);
        this.setStatusIconForUpload(docType, false, DOC_UPLOAD_AGAIN, true);
        this.setStatusIconForVerification(docType, true, true, "Status of the document", "Status of the document", true);
        ProofDocument proofDocument = (ProofDocument)ie.getItem();
        boolean isDigilockerDocument = !this.enrollmentService.isForeignResident() && !this.enrollmentService.isNRIEnrolment() && this.isDigilockerAvailability(proofDocument);
        switch (docType) {
            case POB: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().scan.setEnabled(!proofDocument.getDocName().equalsIgnoreCase("Select"));
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().digilocker.setEnabled(isDigilockerDocument);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList.setToolTipText(proofDocument.getDocName());
                break;
            }
            case POI: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().scan.setEnabled(!proofDocument.getDocName().equalsIgnoreCase("Select"));
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().digilocker.setEnabled(isDigilockerDocument);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiList.setToolTipText(proofDocument.getDocName());
                break;
            }
            case POA: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().scan.setEnabled(!proofDocument.getDocName().equalsIgnoreCase("Select"));
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().digilocker.setEnabled(isDigilockerDocument);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaList.setToolTipText(proofDocument.getDocName());
                break;
            }
            case POF: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().scan.setEnabled(!proofDocument.getDocName().equalsIgnoreCase("Select"));
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().digilocker.setEnabled(isDigilockerDocument);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().pofTextField.setToolTipText(proofDocument.getDocName());
                break;
            }
            case POR: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().scan.setEnabled(!proofDocument.getDocName().equalsIgnoreCase("Select"));
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().digilocker.setEnabled(isDigilockerDocument);
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().porList.setToolTipText(proofDocument.getDocName());
            }
        }
        if (this.allDocumentsAttached(this.enrollmentService.getDocManager())) {
            this.enrollmentService.getDocManager().setDocumentUploadSuccessFalse(docType);
            this.viewPeerUC.getButtonPanel().nextButton.setEnabled(false);
        }
        this.updateReferenceDocument(ie, this.enrollmentService.getReferences().getProof(docType), field);
    }

    private boolean isDigilockerAvailability(ProofDocument proofDocument) {
        return this.enrollmentService.getReferences().getAllowedDocuments().getMdaOnlineDocumentsMap().get(proofDocument.getDocId()) != null && ((ProofDetails)this.enrollmentService.getReferences().getAllowedDocuments().getMdaOnlineDocumentsMap().get(proofDocument.getDocId())).isDigilockerAvailability();
    }

    private boolean isVerifiableDocument(String documentId) {
        return this.enrollmentService.getReferences().getAllowedDocuments().getMdaOnlineDocumentsMap().get(documentId) != null && ((ProofDetails)this.enrollmentService.getReferences().getAllowedDocuments().getMdaOnlineDocumentsMap().get(documentId)).isVerifiable();
    }

    private void setAttachOrScan(ActionEvent evt, DocumentType documentType, String attachOrScan) {
        this.enablePreviewButton(documentType, false);
        this.setStatusIconForUpload(documentType, true, DOC_UPLOAD_AGAIN, true);
        this.setStatusIconForVerification(documentType, true, true, "Status of the document", "Status of the document", true);
        this.viewPeerUC.getEvtCtxt().fireGenericEvent("set_attach_or_scan", new Object[]{evt, documentType, attachOrScan});
    }

    private void checkVerifyRequired(ActionEvent evt, DocumentType documentType) {
        this.setStatusIconForVerification(documentType, true, true, "Status of the document", "Status of the document", true);
        boolean isVerifiableDocument = this.isVerifiableDocument(this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof().getDocId());
        this.enrollmentService.getDocManager().setPreviewType(LabelKeysAction.VERIFY.toString());
        this.enrollmentService.getDocManager().setcurrentOperatingDocTypeForVerification(documentType);
        this.enrollmentService.getDocManager().setPreviewSaveButtonListener(this::onDocScanPreviewSaveButtonForVerify);
        if (isVerifiableDocument) {
            this.enrollmentService.setDocumentFetchType("verifiable");
            this.openDigilockerPanelForVerifiableDocuments(evt, documentType);
        } else {
            this.showPreviewListener.actionPerformed(evt);
        }
    }

    private void openDigilockerPanelForVerifiableDocuments(ActionEvent evt, DocumentType docType) {
        try {
            References references = this.enrollmentService.getReferences();
            ProofDocument proofDocument = references.getReferenceDoc(docType).getProof();
            VerifiableDocument verifiableDocument = (VerifiableDocument)references.getAllowedDocuments().getVerifiableDocumentsList().get(proofDocument.getDocId());
            verifiableDocument.setDocumentName(proofDocument.getDocName());
            this.enrollmentService.setValuesDocumentModel(new ValuesDocumentModel(verifiableDocument));
            ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("digilocker", ActionListener.class)).actionPerformed(evt);
        }
        catch (Exception e) {
            LOGGER.error("Error while initialising Verifiable panel", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_189.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_189.getReason(), (Component)((JComponent)evt.getSource()), ErrorCodes.UC_GEN_189.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[]{"You can reload the documents or skip the verification."});
        }
    }

    private void openDigilockerPanel(ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        this.setStatusIconForUpload(docType, true, DOC_UPLOAD_AGAIN, true);
        this.setStatusIconForVerification(docType, true, true, "Status of the document", "Status of the document", true);
        TelemetryService.getTelemetryServiceInstance().postDebugData("Attempted digilocker flow", new String[0]);
        this.viewPeerUC.getEvtCtxt().fireGenericEvent("open_digilocker", new Object[]{evt, docType});
    }

    private void updateReferenceDocument(ItemEvent ie, ReferenceDocument doc, JComponent field) {
        boolean isAppointmentFlow;
        boolean bl = isAppointmentFlow = !Strings.isNullOrEmpty((String)this.enrollmentService.getAppointment().getAppointmentId());
        if (!isAppointmentFlow) {
            ProofDocument item = (ProofDocument)ie.getItem();
            doc.setProofDocument(item);
        }
        this.updateDocumentFieldState(field, doc);
    }

    private void updateDocumentFieldState(JComponent theComp, ReferenceDocument doc) {
        this.clearFieldError(theComp);
        this.showFieldError(theComp, doc.getProofDocumentError());
    }

    private void addItems(JComboBox<ProofDocument> comboBox, List<ProofDocument> options, ProofDocument defaultSelect) {
        comboBox.removeAllItems();
        options.forEach(comboBox::addItem);
        if (defaultSelect != null) {
            comboBox.setSelectedItem(defaultSelect);
        }
    }

    private void copyDocumentIfSelected(boolean isValid) {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        DocumentType currentDocumentType = docManager.getCurrentDocumentTypeForUploadOrVerify();
        if (currentDocumentType == null) {
            return;
        }
        if (this.enrollmentService.getDocManager().isDocumentCompressAndSaved(currentDocumentType) && !this.enrollmentService.getDocManager().isDocumentUploaded(currentDocumentType) && isValid) {
            ExecutorService thread = ThreadPool.commonPool();
            thread.submit(() -> this.uploadDocumentHandling(this.viewPeerUC.toSwing(), currentDocumentType));
        }
    }

    private void setStatusIconForUpload(DocumentType docType, boolean icon, String tooltip, boolean disable) {
        JLabel docFieldLbl = null;
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getReferenceDoc(docType);
        DocumentUploadPanel uploadPanel = this.viewPeerUC.getReferencePanel().getDocumentUploadPanel();
        referenceDoc.setDocumentAttached();
        switch (docType) {
            case POI: {
                docFieldLbl = uploadPanel.getIdVerificationPanel().getPoiPanel().status;
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiList, referenceDoc);
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiTextField, referenceDoc);
                break;
            }
            case POA: {
                docFieldLbl = uploadPanel.getIdVerificationPanel().getPoaPanel().status;
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaList, referenceDoc);
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaTextField, referenceDoc);
                break;
            }
            case POB: {
                docFieldLbl = uploadPanel.getPobPanel().status;
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList, referenceDoc);
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobTextField, referenceDoc);
                break;
            }
            case POF: {
                docFieldLbl = uploadPanel.getIdVerificationPanel().getPofPanel().status;
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().pofTextField, referenceDoc);
                break;
            }
            case POR: {
                docFieldLbl = uploadPanel.getIdVerificationPanel().getPorPanel().status;
                this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().porList, referenceDoc);
            }
        }
        if (docFieldLbl != null) {
            if (disable) {
                docFieldLbl.setText("\ue86c");
                docFieldLbl.setForeground(Color.decode("#BEC3C7"));
            } else {
                docFieldLbl.setText(icon ? "\ue86c" : "\ue5c9");
                docFieldLbl.setForeground(icon ? Color.decode("#27AE61") : Color.decode("#B30202"));
            }
            docFieldLbl.setToolTipText(tooltip);
        }
        this.setNotification(docType, tooltip);
    }

    private void setStatusIconForUpload(DocumentType docType) {
        boolean icon;
        boolean bl = icon = this.enrollmentService.getDocManager().isDocumentCompressAndSaved(docType) && this.enrollmentService.getDocManager().isDocumentUploaded(docType) && this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null;
        String tooltip = !this.enrollmentService.getDocManager().isDocumentCompressAndSaved(docType) || !this.enrollmentService.getDocManager().isDocumentUploaded(docType) ? DOC_UPLOAD_AGAIN : (this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null ? DOC_NOT_UPLOADED_TIP : DOC_UPLOADED_TIP);
        boolean isDvsFail = this.enrollmentService.getDocManager().getDvsResultMap().values().stream().anyMatch(error -> error.contains("Technical Error"));
        tooltip = isDvsFail ? DOC_UPLOAD_AGAIN : tooltip;
        boolean isRegistryNotVerified = this.enrollmentService.getDocManager().getDvsResultMap().values().stream().anyMatch(error -> error.contains(REGISTRY_NOT_VERIFIED_MESSAGE));
        tooltip = isRegistryNotVerified ? REGISTRY_NOT_VERIFIED_MESSAGE : tooltip;
        this.setStatusIconForUpload(docType, icon, tooltip, false);
    }

    private void enablePreviewButton(DocumentType docType, boolean enable) {
        switch (docType) {
            case POB: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().preview.setEnabled(enable);
                break;
            }
            case POI: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().preview.setEnabled(enable);
                break;
            }
            case POA: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().preview.setEnabled(enable);
                break;
            }
            case POF: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().preview.setEnabled(enable);
                break;
            }
            case POR: {
                this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().preview.setEnabled(enable);
            }
        }
    }

    private void setNotification(DocumentType docType, String message) {
        switch (docType) {
            case POB: {
                NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().status).showToolTip(message, true);
                break;
            }
            case POI: {
                NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().status, (String)message).showToolTip(message, true);
                break;
            }
            case POA: {
                NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().status, (String)message).showToolTip(message, true);
                break;
            }
            case POF: {
                NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPofPanel().status, (String)message).showToolTip(message, true);
            }
        }
    }

    private void uploadDocumentHandling(JComponent parent, DocumentType documentType) {
        String docId = this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof().getDocId();
        this.setNotification(documentType, "Uploading Document");
        DocumentsManager documentsManager = this.enrollmentService.getDocManager();
        if (!documentsManager.isDocumentUploaded(documentsManager.getCurrentDocumentTypeForUploadOrVerify())) {
            this.setNotification(documentType, "Uploading Document");
            this.uploadDocument(parent, documentType, docId);
        } else {
            this.setStatusIconForUpload(documentType);
        }
    }

    private UcDocumentServiceProto.DocumentUploadRequest createDocSaveRequest(DocumentType documentType, String docId) {
        UcDocumentServiceProto.DocumentUploadRequest.Builder documentRequest = UcDocumentServiceProto.DocumentUploadRequest.newBuilder();
        try {
            String nationalityType = this.enrollmentService.getDemoResidentialStatus().getForeignTypeEnum();
            String documentNumber = "";
            if (documentType.equals((Object)DocumentType.POI)) {
                documentNumber = this.enrollmentService.getDemoPersonalDetails().getForeignDetail().getDocNo();
            } else if (documentType.equals((Object)DocumentType.POF)) {
                documentNumber = this.enrollmentService.getDemoPersonalDetails().getForeignDetail().getVisaNo();
            }
            boolean isManual = Strings.isNullOrEmpty((String)((String)this.enrollmentService.getXmlData().get(documentType)));
            UcDocumentServiceProto.RequestHeader requestHeader = UcDocumentServiceProto.RequestHeader.newBuilder().setSid(this.enrollmentService.getSid()).setRefId(this.enrollmentService.getRefId()).setDocumentFormatType("JP2000").setDocType(documentType.value()).setUploadType(isManual ? UploadType.MANUAL.name() : UploadType.DIGILOCKER_NMR.name()).setDocNationalityType(nationalityType).setDocId(docId).setDocumentNumber(documentNumber).build();
            ArrayList<UcDocumentServiceProto.Page> pages = new ArrayList<UcDocumentServiceProto.Page>();
            for (int i = 0; i < this.enrollmentService.getDocManager().getScannedDoc().getTotalScannedPages(); ++i) {
                UcDocumentServiceProto.Page docPage = UcDocumentServiceProto.Page.newBuilder().setData(ByteString.copyFrom((byte[])this.enrollmentService.getDocManager().getScannedDoc().getConvertedBytes(i))).setIndex(i + 1).build();
                pages.add(docPage);
            }
            documentRequest.setRequestId(this.enrollmentService.getTransactionId()).setRequestHeader(requestHeader).addAllPages(pages);
            if (!Strings.isNullOrEmpty((String)((String)this.enrollmentService.getXmlData().get(documentType)))) {
                UcDocumentServiceProto.XmlDocument xmlDocument = UcDocumentServiceProto.XmlDocument.newBuilder().setData(ByteString.copyFromUtf8((String)((String)this.enrollmentService.getXmlData().get(documentType)))).build();
                documentRequest.setXmlDocument(xmlDocument);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in creating request for document upload", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_184.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_GEN_184.getReason(), (Component)this.viewPeerUC.getRefUCpanel(), new Object[]{ErrorCodes.UC_GEN_184.getErrorCode(), "Please try again..."});
        }
        return documentRequest.build();
    }

    private UcDocumentServiceProto.DocumentRoisRequestWrapper createDocValidateRequest(DocumentType documentType) {
        List annotations = this.enrollmentService.getDocManager().getDocAnnotations(documentType);
        List roiRequests = annotations.stream().filter(annotation -> !"Expiry Date".equalsIgnoreCase(annotation.getPartLabel())).map(this::createRoiRequest).collect(Collectors.toList());
        boolean isManual = Strings.isNullOrEmpty((String)((String)this.enrollmentService.getXmlData().get(documentType)));
        UcDocumentServiceProto.DocumentRoisRequest documentRoisRequest = UcDocumentServiceProto.DocumentRoisRequest.newBuilder().setSid(this.enrollmentService.getSid()).setRefId(this.enrollmentService.getRefId()).setDocType(documentType.value()).setUploadType(isManual ? UploadType.MANUAL.name() : UploadType.DIGILOCKER_NMR.name()).addAllRois(roiRequests).build();
        return UcDocumentServiceProto.DocumentRoisRequestWrapper.newBuilder().setRoisRequest(documentRoisRequest).build();
    }

    private UcDocumentServiceProto.RoiRequest createRoiRequest(Annotation annotation) {
        RoiCoordinate leftTop = (RoiCoordinate)annotation.getBoundingBox().getCoordinates().get(0);
        RoiCoordinate rightBottom = (RoiCoordinate)annotation.getBoundingBox().getCoordinates().get(1);
        return UcDocumentServiceProto.RoiRequest.newBuilder().setLabel(annotation.getLabel()).setPageIndex(annotation.getPageIndex().intValue()).setPartLabel(annotation.getPartLabel()).setUserLeftX(leftTop.getX()).setUserTopY(leftTop.getY()).setUserRightX(rightBottom.getX()).setUserBottomY(rightBottom.getY()).build();
    }

    private void handleErrorResponse(UosResponse errorResponse, JComponent parent, DocumentType documentType, boolean isDocumentUpload) {
        Utils.cancelProgressBar(this.veCtxt);
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail()), (Object)errorResponse);
        String skipVerificationText = "";
        if (isDocumentUpload) {
            this.setStatusIconForUpload(documentType);
            this.enrollmentService.getDocManager().setDocumentUploadSuccessFalse(documentType);
            skipVerificationText = "Please try uploading again.";
        } else {
            ArrayList<String> mismatchLabelList = (ArrayList<String>)this.enrollmentService.getDocManager().getDvsResultMap().get(documentType.value());
            if (mismatchLabelList == null) {
                mismatchLabelList = new ArrayList<String>();
            }
            mismatchLabelList.add(CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail()));
            this.enrollmentService.getDocManager().updateDvsResultMap(documentType.value(), mismatchLabelList);
            skipVerificationText = "If you want, you can skip the verification.";
            this.setStatusIconForVerification(documentType, false);
        }
        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail()), (Component)parent, errorResponse.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[]{skipVerificationText});
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(CommonUtilsUC.getErrorMessage(errorResponse.getErrorDetail())), errorResponse.getErrorCode(), new String[0]);
    }

    private void populateMismatchLabel(List<String> labelList, String value) {
        if (value.isEmpty()) {
            return;
        }
        labelList.add(value);
    }

    private void previewDocument(ActionEvent evt, DocumentType docType) {
        this.enrollmentService.getDocManager().setPreviewDocType(docType);
        this.viewPeerUC.getEvtCtxt().fireGenericEvent("preview", new Object[]{docType});
    }

    private void clearDocument(DocumentType docType) {
        if (this.enrollmentService.getDocManager().getDocumentBytes(docType) != null) {
            this.enrollmentService.getDocManager().resetDocument(docType);
        }
        if (this.enrollmentService.getXmlData() != null) {
            this.enrollmentService.getXmlData().remove(docType);
        }
        this.enablePreviewButton(docType, false);
    }

    private void selectDefaultDocumentsAndRefresh() {
        this.changeToDefaultDocument();
        this.viewPeerUC.getEvtCtxt().fireGenericEvent("UC_Docs", new Object[]{this.enrollmentService.getDemoResidentialStatus().getForeignType().getCode(), true});
    }

    private void uploadDocument(JComponent parent, DocumentType documentType, String docId) {
        UcDocumentServiceProto.DocumentUploadRequest documentRequest = this.createDocSaveRequest(documentType, docId);
        GrpcService.getInst().documentSave(documentRequest, documentSaveResponse -> this.handleDocumentSaveResponse((UcDocumentServiceProto.DocumentUploadResponse)documentSaveResponse, documentType, docId), errorResponse -> this.handleErrorResponse((UosResponse)errorResponse, parent, documentType, true));
    }

    private void handleDocumentSaveResponse(UcDocumentServiceProto.DocumentUploadResponse response, DocumentType docType, String docId) {
        LOGGER.info("Upload document status is success for {}", (Object)docType.value());
        this.enrollmentService.getDocManager().setDocumentUploadSuccess(docType);
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getReferenceDoc(docType);
        referenceDoc.setDocumentAttached();
    }

    private void verifyAndValidateDocument(ReferenceDocument referenceDocument) {
        JComponent parent = this.viewPeerUC.toSwing();
        DocumentType documentType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
        if (documentType == null) {
            return;
        }
        String docId = this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof().getDocId();
        List mismatchLabelList = (List)this.enrollmentService.getDocManager().getDvsResultMap().get(documentType.value());
        if (mismatchLabelList != null && !mismatchLabelList.isEmpty()) {
            mismatchLabelList.clear();
        }
        try {
            UcDocumentServiceProto.DocumentRoisRequestWrapper documentRoisRequestWrapper = this.createDocValidateRequest(documentType);
            UcDocumentServiceProto.DocumentVerifyRequest documentVerifyRequest = this.createDocumentVerifyRequest(documentType, docId);
            UcDocumentServiceProto.DocumentVerifyAndValidateRequest documentVerifyAndValidateRequest = UcDocumentServiceProto.DocumentVerifyAndValidateRequest.newBuilder().setValidateDocRequest(documentRoisRequestWrapper).setVerifyDocRequest(documentVerifyRequest).build();
            GrpcService.getInst().documentVerifyAndValidate(documentVerifyAndValidateRequest, documentVerifyAndValidateResponse -> this.handleDocumentVerifyAndValidateResponse((UcDocumentServiceProto.DocumentVerifyAndValidateResponse)documentVerifyAndValidateResponse, documentType), errorResponse -> this.handleErrorResponse((UosResponse)errorResponse, parent, documentType, false));
        }
        catch (Exception e) {
            LOGGER.error("Error in creating request for document verify and validate", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_185.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_GEN_185.getReason(), (Component)this.viewPeerUC.getRefUCpanel(), new Object[]{ErrorCodes.UC_GEN_185.getErrorCode(), "Please try again..."});
        }
    }

    private UcDocumentServiceProto.DocumentVerifyRequest createDocumentVerifyRequest(DocumentType documentType, String documentId) {
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        UcDocumentServiceProto.DocumentVerifyRequest.Builder documentVerifyRequestBuilder = UcDocumentServiceProto.DocumentVerifyRequest.newBuilder();
        documentVerifyRequestBuilder.setSid(this.enrollmentService.getSid());
        documentVerifyRequestBuilder.setRefId(this.enrollmentService.getRefId());
        documentVerifyRequestBuilder.setName(personalDetail.getName().english());
        documentVerifyRequestBuilder.setGender(personalDetail.getApplicantGender().toString());
        documentVerifyRequestBuilder.setDob(personalDetail.getAgeDob().getAgeDobFormattedUC());
        documentVerifyRequestBuilder.setDocId(documentId);
        documentVerifyRequestBuilder.setRegistryType(this.getRegistryTypeOnBasisOfDocumentId(documentType));
        if (this.isVerifiableDocument(documentId)) {
            documentVerifyRequestBuilder.putAllFormFields(this.enrollmentService.getValuesDocumentModel().getFormFieldsValues());
        }
        return documentVerifyRequestBuilder.build();
    }

    private String getRegistryTypeOnBasisOfDocumentId(DocumentType documentType) {
        ProofDocument currentSelectedDocument = this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof();
        if (currentSelectedDocument.getDocName().toLowerCase().contains("passport")) {
            return RegistryType.PASSPORT.toString();
        }
        if (currentSelectedDocument.getDocName().toLowerCase().contains("pan")) {
            return RegistryType.PANCARD.toString();
        }
        return RegistryType.UNKNOWN.toString();
    }

    private void handleDocumentVerifyAndValidateResponse(UcDocumentServiceProto.DocumentVerifyAndValidateResponse response, DocumentType docType) {
        boolean registryVerified = true;
        ArrayList mismatchLabelList = new ArrayList();
        boolean isMisMatch = response.getRoiLabelResponseList().stream().anyMatch(roi -> roi.getDemoMatchStatus().equalsIgnoreCase("REJECT"));
        response.getRoiLabelResponseList().forEach(roi -> this.populateMismatchLabel(mismatchLabelList, roi.getDemoMatchStatus().equalsIgnoreCase("REJECT") ? roi.getLabel() + " mismatch" : ""));
        if (this.isVerifiableDocument(this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocId()) && response.getVerifyStatus().equalsIgnoreCase("failure")) {
            registryVerified = false;
        }
        this.enrollmentService.getDocManager().updateDvsResultMap(docType.value(), mismatchLabelList);
        this.setStatusIconForVerification(docType, registryVerified);
        if (isMisMatch) {
            LOGGER.info("Demographics details did not match with the details in document for {}", (Object)docType.value());
        } else if (!registryVerified) {
            LOGGER.info("Registry document not verified for {}", (Object)docType.value());
        } else {
            LOGGER.info("Demographics Details Matched and Registry verified !! for {}", (Object)docType.value());
        }
    }

    private void initialise() {
        this.tabState = new HashMap<ReferenceStagesUC, Boolean>();
        for (ReferenceStagesUC stage : this.referenceStagesUCList) {
            this.tabState.put(stage, false);
        }
        this.viewPeerUC.getReferenceSections().setValid(this.tabState);
        this.viewPeerUC.getReferenceSections().currentTab(this.referenceStagesUCList[0]);
    }

    private void proceedToNextTab(ActionEvent event, int tabIndex) {
        this.viewPeerUC.getReferenceSections().setValid(this.tabState);
        this.viewPeerUC.getReferenceSections().currentTab(this.referenceStagesUCList[tabIndex + 1]);
        super.onNextButtonClickForeign(event, tabIndex, this.tabState.size(), "hID_Reference_TabPane");
    }

    @Override
    public void onPrevButtonClick(ActionEvent event) {
        this.viewPeerUC.getButtonPanel().nextButton.setEnabled(true);
        this.viewPeerUC.getReferenceSections().setValid(this.tabState);
        int currentTabIndex = this.viewPeerUC.getReferencePanel().getTabbedPane().getSelectedIndex();
        if (currentTabIndex > 0) {
            this.viewPeerUC.getReferenceSections().currentTab(this.referenceStagesUCList[currentTabIndex - 1]);
            super.onPrevButtonClickReference(event, currentTabIndex);
        } else {
            super.onPrevButtonClick(event);
        }
    }

    private void handleDocumentUploadPanelValidation(ActionEvent event, int tabIndex) {
        try {
            DocumentVerifyPanel documentVerifyPanel = this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel();
            for (DocumentType documentType : this.enrollmentService.getDocManager().getDocumentTypes()) {
                POXPanel poxPanel = documentVerifyPanel.getPanelForDocumentType().get(documentType);
                poxPanel.getTextField().setText(this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof().getDocName());
                poxPanel.getVerifyButton().setEnabled(true);
            }
            if (this.enrollmentService.getReferences().isValid() && this.allDocumentsAttached(this.enrollmentService.getDocManager())) {
                this.proceedToNextTab(event, tabIndex);
            } else {
                this.showWarningUC("Please complete the process to continue", (JComponent)event.getSource());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in handling validation for document upload", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_186.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_GEN_186.getReason(), (Component)this.viewPeerUC.getRefUCpanel(), new Object[]{ErrorCodes.UC_GEN_186.getErrorCode(), "Please try again..."});
        }
    }

    private void setStatusIconForVerification(DocumentType docType, boolean iconOCR, boolean iconRegistry, String tooltipOCR, String tooltipRegistry, boolean disable) {
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getReferenceDoc(docType);
        JLabel registryLabel = this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel().getPanelForDocumentType().get(docType).getRegistryStatus();
        JLabel ocrLabel = this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel().getPanelForDocumentType().get(docType).getOcrStatus();
        this.updateDocumentFieldState(this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel().getPanelForDocumentType().get(docType).getTextField(), referenceDoc);
        boolean disableRegistry = this.enrollmentService.getReferences().getReferenceDoc(docType).getProof() != null && !this.isVerifiableDocument(this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocId());
        boolean disableOCR = disable;
        if (disable) {
            ocrLabel.setText("\ue86c");
            ocrLabel.setForeground(Color.decode("#BEC3C7"));
        } else {
            ocrLabel.setText(iconOCR ? "\ue86c" : "\ue5c9");
            ocrLabel.setForeground(iconOCR ? Color.decode("#27AE61") : Color.decode("#B30202"));
            ocrLabel.setToolTipText(tooltipOCR);
        }
        if (disableRegistry || disable) {
            registryLabel.setText("\ue86c");
            registryLabel.setForeground(Color.decode("#BEC3C7"));
        } else {
            registryLabel.setText(iconRegistry ? "\ue86c" : "\ue5c9");
            registryLabel.setForeground(iconRegistry ? Color.decode("#27AE61") : Color.decode("#B30202"));
            registryLabel.setToolTipText(tooltipRegistry);
        }
        this.setNotificationForVerification(docType, tooltipRegistry, tooltipOCR);
    }

    private void setStatusIconForVerification(DocumentType docType, boolean isRegistryVerified) {
        boolean iconOCR = this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null;
        String tooltipOCR = this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null ? DOC_VALIDATE_TIP : DOC_NOT_VALIDATE_TIP;
        boolean iconRegistry = isRegistryVerified;
        String tooltipRegistry = isRegistryVerified ? REGISTRY_VERIFIED_MESSAGE : REGISTRY_NOT_VERIFIED_MESSAGE;
        this.setStatusIconForVerification(docType, iconOCR, iconRegistry, tooltipOCR, tooltipRegistry, false);
    }

    private void setNotificationForVerification(DocumentType docType, String registryMessage, String ocrMessage) {
        NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel().getPanelForDocumentType().get(docType).getRegistryStatus(), (String)registryMessage).showToolTip(registryMessage, true);
        NotificationPopup.getToolTip((JComponent)this.viewPeerUC.getReferencePanel().getDocumentVerifyPanel().getPanelForDocumentType().get(docType).getOcrStatus(), (String)ocrMessage).showToolTip(ocrMessage, true);
    }

    private void onDocScanPreviewSaveButtonForVerify(ActionEvent actionEvent) {
        ModalVisualExecutionContext visualExecutionContext = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.viewPeerUC.getEnrolRbctx(), false));
        visualExecutionContext.reset();
        visualExecutionContext.setMessage("Saving the document. Please wait.");
        DocumentType docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
        List annotations = this.enrollmentService.getDocManager().getAnnotations(docType);
        this.enrollmentService.getDocManager().addToDocAnnotations(docType, annotations);
        ThreadPool.commonPool().submit(() -> this.lambda$onDocScanPreviewSaveButtonForVerify$38(docType, (IVisualExecutionContext)visualExecutionContext, actionEvent));
    }

    private void changeToDefaultDocument() {
        ProofDocument defaultDocument = this.enrollmentService.getReferences().getAllowedDocuments().getDocumentDefaultSelect();
        this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getPobPanel().pobList.setSelectedItem(defaultDocument);
        this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoiPanel().poiList.setSelectedItem(defaultDocument);
        this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPoaPanel().poaList.setSelectedItem(defaultDocument);
        this.viewPeerUC.getReferencePanel().getDocumentUploadPanel().getIdVerificationPanel().getPorPanel().porList.setSelectedItem(defaultDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$onDocScanPreviewSaveButtonForVerify$38(DocumentType docType, IVisualExecutionContext visualExecutionContext, ActionEvent actionEvent) {
        try {
            this.enrollmentService.getReferences().getReferenceDoc(docType).setReadyToVerify();
            visualExecutionContext.cancel();
        }
        catch (Exception e) {
            LOGGER.error("Error in verifying the document ", (Throwable)e);
            this.showSimpleError((JButton)actionEvent.getSource(), "Error while verifying the document. " + e.getMessage(), new Object[0]);
            visualExecutionContext.cancel();
        }
        finally {
            SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).dispose();
            visualExecutionContext.cancel();
        }
    }
}

