/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.ResidentInfo;
import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.operator.TransactionType;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.AddressType;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.ContactInfoPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.EnrollmentTypePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.POBinfoPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.ResidentTypePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.WhitelistTypePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ResidentInfoTabViewPeerUC;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidentInfoControllerUC
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResidentInfoControllerUC.class);
    private final ResidentInfoTabViewPeerUC view;
    private final ResidentInfo residentInfo;
    private final TransactionType transactionType;
    private final boolean isAdult;
    private final boolean isChild;
    private final boolean isMinor;
    private final IVisualExecutionContext veCtxt;

    public ResidentInfoControllerUC(ResidentInfoTabViewPeerUC view) {
        super(view.getLiteView(), view.getEnrollmentService(), 7, view.getTabIndex());
        this.view = view;
        this.residentInfo = view.getResidentInfo();
        this.veCtxt = view.getLiteView().getVisualExecutionContext();
        this.transactionType = view.getTransactions().get(0);
        this.isChild = this.transactionType.equals((Object)TransactionType.CHILD_ENROL_BELOW_5);
        this.isMinor = this.transactionType.equals((Object)TransactionType.CHILD_ENROL_ABOVE_5);
        this.isAdult = !this.isChild && !this.isMinor;
        this.init();
    }

    private void init() {
        super.addActionListener(this.view.getResidentInfoPanel().residentTypePanel.indian, this::residentTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().residentTypePanel.nri, this::residentTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().residentTypePanel.foreign, this::residentTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().enrollmentTypePanel.document, this::enrollmentTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().enrollmentTypePanel.hof, this::enrollmentTypeChange);
        super.addFocusListener(this.view.getResidentInfoPanel().enrollmentTypePanel.hofUid, this::onHofUidChange);
        super.addItemListener(this.view.getResidentInfoPanel().enrollmentTypePanel.relationType, this::relationTypeChange);
        this.view.getResidentInfoPanel().enrollmentTypePanel.setEnable(true);
        super.addActionListener(this.view.getResidentInfoPanel().poBinfoPanel.yes, this::onPobCheckChange);
        super.addActionListener(this.view.getResidentInfoPanel().poBinfoPanel.no, this::onPobCheckChange);
        super.addActionListener(this.view.getResidentInfoPanel().addressType.indian, this::addressTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().addressType.foreign, this::addressTypeChange);
        super.addItemListener(this.view.getResidentInfoPanel().contactInfoPanel.comboCode, this::onIsdChange);
        super.addFocusListener(this.view.getResidentInfoPanel().contactInfoPanel.mobNo, this::onMobileChange);
        super.addFocusListener(this.view.getResidentInfoPanel().contactInfoPanel.emailField, this::onEmailChange);
        super.addActionListener(this.view.getResidentInfoPanel().whitelistTypePanel.yesRadioBtn, this::onWhitelistTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().whitelistTypePanel.noRadioBtn, this::onWhitelistTypeChange);
        super.addFocusListener(this.view.getResidentInfoPanel().whitelistTypePanel.linkedEid, this::onLinkedEidChange);
        super.addActionListener(this.view.getResidentInfoPanel().whitelistTypePanel.verifyBtn, this::onWhitelistVerifyClick);
        this.enrollmentService.grievanceStatusListener(this::setGrievanceStatus);
        super.addActionListener(this.view.getResidentInfoPanel().bioExceptionPanel.no, this::onBioExceptionTypeChange);
        super.addActionListener(this.view.getResidentInfoPanel().bioExceptionPanel.yes, this::onBioExceptionTypeChange);
        this.view.getResidentInfoPanel().bioExceptionPanel.setEnable(!this.isChild);
        this.getMobileCodes(true);
        this.view.getButtonPanel().nextButton.setEnabled(true);
        super.addActionListener(this.view.getButtonPanel().nextButton, this::onNextButtonClick);
        this.view.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.view.evtCtxt.getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        this.defaultType();
    }

    private void setGrievanceStatus() {
        boolean isSuccess = !Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId());
        this.view.getResidentInfoPanel().whitelistTypePanel.status.setForeground(isSuccess ? Color.decode("#27AE61") : Color.decode("#BEC3C7"));
        this.view.getResidentInfoPanel().whitelistTypePanel.linkedEid.setEnabled(false);
        this.view.getResidentInfoPanel().whitelistTypePanel.verifyBtn.setEnabled(false);
    }

    private void onWhitelistVerifyClick(ActionEvent actionEvent) {
        ((ActionListener)this.view.evtCtxt.getEventListener("get grievance id", ActionListener.class)).actionPerformed(actionEvent);
    }

    private void onLinkedEidChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String newText = this.view.getResidentInfoPanel().whitelistTypePanel.linkedEid.getText().trim();
        this.enrollmentService.setLinkedEid(newText);
        this.view.getResidentInfoPanel().whitelistTypePanel.verifyBtn.setEnabled(!Objects.equals(newText, ""));
    }

    private void onWhitelistTypeChange(ActionEvent event) {
        WhitelistTypePanel whitelistTypePanel = this.view.getResidentInfoPanel().whitelistTypePanel;
        boolean isYesSelected = whitelistTypePanel.yesRadioBtn.isSelected();
        this.residentInfo.setIsWhitelist(isYesSelected);
        whitelistTypePanel.linkedEid.setEnabled(isYesSelected);
        if (!isYesSelected) {
            this.enrollmentService.setLinkedEid("");
            this.enrollmentService.setGrievanceId(null);
            whitelistTypePanel.linkedEid.setText("");
            whitelistTypePanel.verifyBtn.setEnabled(false);
        }
    }

    private void onBioExceptionTypeChange(ActionEvent event) {
        this.residentInfo.setBioException(this.view.getResidentInfoPanel().bioExceptionPanel.yes.isSelected());
    }

    private void defaultType() {
        this.residentInfo.setIndianResident(true);
        this.residentInfo.setDocumentBased(true);
        this.updateFields();
    }

    private void residentTypeChange(ActionEvent event) {
        ResidentTypePanel residentTypePanel = this.view.getResidentInfoPanel().residentTypePanel;
        this.residentInfo.setIndianResident(residentTypePanel.indian.isSelected());
        this.residentInfo.setNriResident(residentTypePanel.nri.isSelected());
        this.residentInfo.setForeignResident(residentTypePanel.foreign.isSelected());
        AddressType addressType = this.view.getResidentInfoPanel().addressType;
        EnrollmentTypePanel enrollmentTypePanel = this.view.getResidentInfoPanel().enrollmentTypePanel;
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        if (this.isAdult) {
            this.handleResidentChangeForAdult();
        }
        if (this.isChild) {
            this.handleResidentChangeForChild();
        }
        if (this.isMinor) {
            this.handleResidentChangeForMinor();
        }
        this.getMobileCodes(this.residentInfo.isIndianResident() || this.residentInfo.isForeignResident());
        this.residentInfo.setIndianAddress(addressType.indian.isSelected());
        this.residentInfo.setForeignAddress(addressType.foreign.isSelected());
        this.residentInfo.setPobPresent(poBinfoPanel.yes.isSelected());
        this.residentInfo.setDocumentBased(enrollmentTypePanel.document.isSelected());
        this.residentInfo.setHofBased(enrollmentTypePanel.hof.isSelected());
        this.view.getResidentInfoPanel().contactInfoPanel.setEmailMandatory(this.residentInfo.isNriResident() || this.residentInfo.isForeignResident());
        this.updateFields();
    }

    private void handleResidentChangeForAdult() {
        AddressType addressType = this.view.getResidentInfoPanel().addressType;
        EnrollmentTypePanel enrollmentTypePanel = this.view.getResidentInfoPanel().enrollmentTypePanel;
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        if (this.residentInfo.isIndianResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, true);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, true);
        }
        if (this.residentInfo.isNriResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, true);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, true);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes, false);
        }
        if (this.residentInfo.isForeignResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, false);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, false);
        }
    }

    private void handleResidentChangeForChild() {
        AddressType addressType = this.view.getResidentInfoPanel().addressType;
        EnrollmentTypePanel enrollmentTypePanel = this.view.getResidentInfoPanel().enrollmentTypePanel;
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        if (this.residentInfo.isIndianResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, true);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, true);
        }
        if (this.residentInfo.isNriResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, true);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.hof, false);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes, false);
        }
        if (this.residentInfo.isForeignResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, false);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, false);
        }
    }

    private void handleResidentChangeForMinor() {
        AddressType addressType = this.view.getResidentInfoPanel().addressType;
        EnrollmentTypePanel enrollmentTypePanel = this.view.getResidentInfoPanel().enrollmentTypePanel;
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        if (this.residentInfo.isIndianResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, true);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, true);
        }
        if (this.residentInfo.isNriResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, true);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, true);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes, false);
        }
        if (this.residentInfo.isForeignResident()) {
            addressType.enableButtonGroupWithDefault(addressType.indian, false);
            enrollmentTypePanel.enableButtonGroupWithDefault(enrollmentTypePanel.document, false);
            this.enrollmentTypeChange(null);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, false);
        }
    }

    private void enrollmentTypeChange(ActionEvent event) {
        EnrollmentTypePanel enrollmentTypePanel = this.view.getResidentInfoPanel().enrollmentTypePanel;
        this.residentInfo.setDocumentBased(enrollmentTypePanel.document.isSelected());
        this.residentInfo.setHofBased(enrollmentTypePanel.hof.isSelected());
        ContactInfoPanel contactInfoPanel = this.view.getResidentInfoPanel().contactInfoPanel;
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        if (this.residentInfo.isDocumentBased()) {
            this.residentInfo.setHofUid("");
            enrollmentTypePanel.enableHofFields(false);
            if (!this.residentInfo.isNriResident()) {
                poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.no, true);
            }
        }
        if (this.residentInfo.isHofBased()) {
            contactInfoPanel.mobNo.setText("");
            contactInfoPanel.emailField.setText("");
            this.residentInfo.setMobile("");
            this.residentInfo.setEmail("");
            this.enrollmentService.getDemoContactDetails().getMobile().setNumber("");
            this.enrollmentService.getDemoContactDetails().getEmail().setEmail("");
            enrollmentTypePanel.enableHofFields(true);
            this.residentInfo.setResidentType(RelationshipType.NOT_GIVEN);
            poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes, false);
        }
        contactInfoPanel.setEmailMandatory(!this.residentInfo.isIndianResident());
        this.residentInfo.setPobPresent(poBinfoPanel.yes.isSelected());
        this.updateFields();
    }

    private void onHofUidChange(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        this.residentInfo.setHofUid(this.view.getResidentInfoPanel().enrollmentTypePanel.hofUid.getText());
        this.updateFields();
    }

    private void relationTypeChange(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        this.view.getResidentInfoPanel().enrollmentTypePanel.hofUid.setText("");
        RelationshipType currentRelation = (RelationshipType)event.getItem();
        POBinfoPanel poBinfoPanel = this.view.getResidentInfoPanel().poBinfoPanel;
        switch (currentRelation) {
            case FATHER: 
            case MOTHER: {
                poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes, false);
                break;
            }
            case LEGAL_GUARDIAN: {
                poBinfoPanel.enableButtonGroupWithDefault(poBinfoPanel.yes.isSelected() ? poBinfoPanel.yes : poBinfoPanel.no, true);
            }
        }
        this.residentInfo.setResidentType(currentRelation);
        this.residentInfo.setPobPresent(poBinfoPanel.yes.isSelected());
        this.updateFields();
    }

    private void onPobCheckChange(ActionEvent event) {
        this.residentInfo.setPobPresent(this.view.getResidentInfoPanel().poBinfoPanel.yes.isSelected());
        this.updateFields();
    }

    private void addressTypeChange(ActionEvent event) {
        AddressType addressType = this.view.getResidentInfoPanel().addressType;
        this.residentInfo.setIndianAddress(addressType.indian.isSelected());
        this.residentInfo.setForeignAddress(addressType.foreign.isSelected());
        this.updateFields();
    }

    private void onIsdChange(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        ISD isd = (ISD)this.view.getResidentInfoPanel().contactInfoPanel.comboCode.getSelectedItem();
        assert (isd != null);
        this.residentInfo.setIsd(isd.getISDCode());
        this.enrollmentService.getDemoContactDetails().getMobile().setIsdCode(this.residentInfo.getIsd());
        this.updateFields();
    }

    private void onMobileChange(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        this.residentInfo.setMobile(this.view.getResidentInfoPanel().contactInfoPanel.mobNo.getText());
        this.enrollmentService.getDemoContactDetails().getMobile().setNumber(this.residentInfo.getMobile());
        this.updateFields();
    }

    private void onEmailChange(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        this.residentInfo.setEmail(this.view.getResidentInfoPanel().contactInfoPanel.emailField.getText());
        this.enrollmentService.getDemoContactDetails().getEmail().setEmail(this.residentInfo.getEmail());
        this.updateFields();
    }

    private void updateFields() {
        this.updateEmailField();
        this.updateMobileField();
        this.updateHofUidField();
        this.updateRelationTypeField();
    }

    private void updateHofUidField() {
        this.clearFieldError(this.view.getResidentInfoPanel().enrollmentTypePanel.hofUid);
        if (!this.residentInfo.isValid()) {
            this.showFieldError(this.view.getResidentInfoPanel().enrollmentTypePanel.hofUid, this.residentInfo.getHofUidError());
        }
    }

    private void updateRelationTypeField() {
        this.clearFieldError(this.view.getResidentInfoPanel().enrollmentTypePanel.relationType);
        if (!this.residentInfo.isValid()) {
            this.showFieldError(this.view.getResidentInfoPanel().enrollmentTypePanel.relationType, this.residentInfo.getRelationTypeError());
        }
    }

    private void updateMobileField() {
        this.clearFieldError(this.view.getResidentInfoPanel().contactInfoPanel.mobNo);
        String error = this.enrollmentService.getDemoContactDetails().getMobile().numberError();
        if (!this.residentInfo.isValid() || !this.enrollmentService.getDemoContactDetails().getMobile().isValid()) {
            this.showFieldError(this.view.getResidentInfoPanel().contactInfoPanel.mobNo, error);
        }
    }

    private void updateEmailField() {
        this.clearFieldError(this.view.getResidentInfoPanel().contactInfoPanel.emailField);
        if (!this.residentInfo.isValid()) {
            this.showFieldError(this.view.getResidentInfoPanel().contactInfoPanel.emailField, this.residentInfo.getEmailError());
        }
    }

    private void getMobileCodes(boolean isIndian) {
        this.view.getResidentInfoPanel().contactInfoPanel.comboCode.removeAllItems();
        if (isIndian) {
            this.enrollmentService.getIsdService().getISDCodes().stream().filter(item -> item.getISDCode().contains("+91")).forEach(this.view.getResidentInfoPanel().contactInfoPanel.comboCode::addItem);
        } else {
            this.enrollmentService.getIsdService().getISDCodes().forEach(this.view.getResidentInfoPanel().contactInfoPanel.comboCode::addItem);
        }
        this.view.getResidentInfoPanel().contactInfoPanel.comboCode.setSelectedItem(this.enrollmentService.getIsdService().getDefaultSelect());
    }

    private boolean validateGrievance() {
        String grievanceId = this.enrollmentService.getGrievanceId() != null ? this.enrollmentService.getGrievanceId() : "";
        boolean isYesSelected = this.view.getResidentInfoPanel().whitelistTypePanel.yesRadioBtn.isSelected();
        return !isYesSelected || !grievanceId.equals("");
    }

    @Override
    public void onNextButtonClick(ActionEvent event) {
        if (!this.validateGrievance()) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Please verify linked EID", (Component)((JComponent)event.getSource()), new Object[0]);
            return;
        }
        if (this.residentInfo.isBioException() && !this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
            ((ActionListener)this.view.evtCtxt.getEventListener("UC_hID_Uenrol_ShowBiox", ActionListener.class)).actionPerformed(event);
            return;
        }
        if (this.residentInfo.isValid() && this.enrollmentService.getDemoContactDetails().getMobile().isValid() && this.enrollmentService.getDemoContactDetails().getEmail().isValid()) {
            if (!(this.residentInfo.getEmail().isEmpty() && this.residentInfo.getMobile().isEmpty() || !L10nOptionPaneBuilder.getInstance().showYesNoUC(this.getText(), (Component)this.view.getResidentInfoPanel().contactInfoPanel.emailField).equals((Object)MsgKeysCommon.YES))) {
                try {
                    this.disableFields();
                    HashMap<String, Object> evtParams = new HashMap<String, Object>();
                    evtParams.put("residentInfo", this.residentInfo);
                    evtParams.put("transactionType", (Object)this.view.getTransactions().get(0));
                    ((ActionListener)this.view.evtCtxt.getEventListener("transaction_selected", ActionListener.class, evtParams)).actionPerformed(event);
                }
                catch (OnlineGatewayException e) {
                    Utils.cancelProgressBar(this.veCtxt);
                    LOGGER.error("Error While Generating Otp", (Throwable)e);
                    L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)this.view.getResidentInfoPanel().contactInfoPanel.mobNo, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
                }
            } else if (this.residentInfo.getEmail().isEmpty() && this.residentInfo.getMobile().isEmpty()) {
                this.disableFields();
                HashMap<String, Object> evtParams = new HashMap<String, Object>();
                evtParams.put("residentInfo", this.residentInfo);
                evtParams.put("transactionType", (Object)this.view.getTransactions().get(0));
                ((ActionListener)this.view.evtCtxt.getEventListener("transaction_selected", ActionListener.class, evtParams)).actionPerformed(event);
            }
        } else {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Please Fill mandatory fields", (Component)((JComponent)event.getSource()), new Object[0]);
        }
    }

    private String getText() {
        String msg = "Please confirm your,<br>";
        if (!this.residentInfo.getEmail().isEmpty()) {
            msg = msg + "Email id: " + this.residentInfo.getEmail() + "<br>";
        }
        if (!this.residentInfo.getMobile().isEmpty()) {
            msg = msg + "Mobile Number: " + this.residentInfo.getMobile();
        }
        return msg;
    }

    private void disableFields() {
        this.view.getResidentInfoPanel().setEnableFields(false);
    }
}

