/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.google.common.base.Strings;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.ResidentUpdateInfo;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ResidentInfoControllerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.enrol.universalClient.residentInfo.WhitelistTypePanel;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ResidentUpdateInfoTabViewPeerUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidentUpdateInfoControllerUC
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResidentInfoControllerUC.class);
    private final ResidentUpdateInfoTabViewPeerUC view;
    private final ResidentUpdateInfo residentUpdateInfo;
    private final IVisualExecutionContext veCtxt;
    private ActionEvent event;

    public ResidentUpdateInfoControllerUC(ResidentUpdateInfoTabViewPeerUC view) {
        super(view.getLiteView(), view.getEnrollmentService(), 7, view.getTabIndex());
        this.view = view;
        this.residentUpdateInfo = view.getResidentUpdateInfo();
        this.veCtxt = view.getLiteView().getVisualExecutionContext();
        this.enrollmentService.countScreenListener(this::renderCountScreen);
        this.init();
    }

    private void init() {
        super.addFocusListener(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.uidField, this::onUidChange);
        super.addFocusListener(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField, this::onHofUidChange);
        super.addActionListener(this.view.getResidentUpdateInfoPanel().whitelistTypePanel.yesRadioBtn, this::onWhitelistTypeChange);
        super.addActionListener(this.view.getResidentUpdateInfoPanel().whitelistTypePanel.noRadioBtn, this::onWhitelistTypeChange);
        super.addFocusListener(this.view.getResidentUpdateInfoPanel().whitelistTypePanel.linkedEid, this::onLinkedEidChange);
        super.addActionListener(this.view.getResidentUpdateInfoPanel().whitelistTypePanel.verifyBtn, this::onWhitelistVerifyClick);
        super.addItemListener(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofRelationDropdown, this::relationTypeChange);
        this.enrollmentService.grievanceStatusListener(this::setGrievanceStatus);
        super.addActionListener(this.view.getResidentUpdateInfoPanel().bioExceptionPanel.no, this::onBioExceptionTypeChange);
        super.addActionListener(this.view.getResidentUpdateInfoPanel().bioExceptionPanel.yes, this::onBioExceptionTypeChange);
        this.view.getButtonPanel().nextButton.setEnabled(true);
        super.addActionListener(this.view.getButtonPanel().nextButton, this::onNextButtonClick);
        this.view.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.view.evtCtxt.getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        this.enrollmentService.residentUpdateInfoSuccessListener(this::disableAll);
    }

    private void setGrievanceStatus() {
        boolean isSuccess = !Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId());
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.status.setForeground(isSuccess ? Color.decode("#27AE61") : Color.decode("#BEC3C7"));
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.linkedEid.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.verifyBtn.setEnabled(false);
    }

    public void renderCountScreen() {
        this.view.getUpdateCountTab().prepare();
        this.view.getUpdateCountTab().renderUpdateCountTab();
        super.onNextButtonClick(this.event);
    }

    private void onUidChange(FocusEvent focusEvent) {
        String newUid = this.view.getResidentUpdateInfoPanel().uidUpdatePanel.uidField.getText();
        this.residentUpdateInfo.setUid(newUid);
        this.updateUidField();
    }

    private void onHofUidChange(FocusEvent focusEvent) {
        String hofUid = this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField.getText();
        this.residentUpdateInfo.setHofUid(hofUid);
        this.updateHofUidField();
    }

    private void onWhitelistVerifyClick(ActionEvent actionEvent) {
        ((ActionListener)this.view.evtCtxt.getEventListener("get grievance id", ActionListener.class)).actionPerformed(actionEvent);
    }

    private void onLinkedEidChange(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String newText = this.view.getResidentUpdateInfoPanel().whitelistTypePanel.linkedEid.getText().trim();
        this.enrollmentService.setLinkedEid(newText);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.verifyBtn.setEnabled(!Objects.equals(newText, ""));
    }

    private void onWhitelistTypeChange(ActionEvent event) {
        WhitelistTypePanel whitelistTypePanel = this.view.getResidentUpdateInfoPanel().whitelistTypePanel;
        boolean isYesSelected = whitelistTypePanel.yesRadioBtn.isSelected();
        this.residentUpdateInfo.setWhitelist(isYesSelected);
        whitelistTypePanel.linkedEid.setEnabled(isYesSelected);
        if (!isYesSelected) {
            this.enrollmentService.setLinkedEid("");
            this.enrollmentService.setGrievanceId(null);
            whitelistTypePanel.linkedEid.setText("");
            whitelistTypePanel.verifyBtn.setEnabled(false);
        }
    }

    private boolean validateGrievance() {
        String grievanceId = this.enrollmentService.getGrievanceId() != null ? this.enrollmentService.getGrievanceId() : "";
        boolean isYesSelected = this.view.getResidentUpdateInfoPanel().whitelistTypePanel.yesRadioBtn.isSelected();
        return !isYesSelected || !grievanceId.equals("");
    }

    private void onBioExceptionTypeChange(ActionEvent event) {
        this.residentUpdateInfo.setBiometricException(this.view.getResidentUpdateInfoPanel().bioExceptionPanel.yes.isSelected());
    }

    private void updateUidField() {
        this.clearFieldError(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.uidField);
        this.residentUpdateInfo.validateUid();
        if (this.residentUpdateInfo.getUidError() != null) {
            this.showFieldError(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.uidField, this.residentUpdateInfo.getUidError());
        }
    }

    private void updateHofUidField() {
        this.clearFieldError(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField);
        this.residentUpdateInfo.validateHOF();
        if (this.residentUpdateInfo.getHofUidError() != null) {
            this.showFieldError(this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField, this.residentUpdateInfo.getHofUidError());
        }
    }

    @Override
    public void onNextButtonClick(ActionEvent event) {
        this.event = event;
        this.residentUpdateInfo.validateDetails();
        if (!this.validateGrievance()) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Please verify linked EID", (Component)((JComponent)event.getSource()), new Object[0]);
            return;
        }
        if (!Strings.isNullOrEmpty((String)this.residentUpdateInfo.getUidError())) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Please enter valid UID", (Component)((JComponent)event.getSource()), new Object[0]);
            return;
        }
        if (!Strings.isNullOrEmpty((String)this.residentUpdateInfo.getHofUidError())) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Please enter valid HOF Uid", (Component)((JComponent)event.getSource()), new Object[0]);
            return;
        }
        if (Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            String residentUid = this.residentUpdateInfo.getUid();
            String hofUid = this.residentUpdateInfo.getHofUid();
            boolean isLinkedEidPresent = !Strings.isNullOrEmpty((String)this.enrollmentService.getLinkedEid());
            String grievanceId = isLinkedEidPresent ? this.enrollmentService.getGrievanceId() : null;
            this.enrollmentService.initiateUcUpdate(residentUid, this.enrollmentService.isPACValidationRequired());
            this.enrollmentService.setGrievanceId(grievanceId);
            if (!Strings.isNullOrEmpty((String)hofUid)) {
                this.enrollmentService.setHofEnrollment(true);
                this.enrollmentService.setHofUid(hofUid);
            }
            ThreadPool.commonPool().submit(() -> {
                HashMap<String, ResidentUpdateInfo> evtParams = new HashMap<String, ResidentUpdateInfo>();
                evtParams.put("residentUpdateInfo", this.residentUpdateInfo);
                ((ActionListener)this.view.evtCtxt.getEventListener("set resident update info modal", ActionListener.class, evtParams)).actionPerformed(event);
            });
            ((ActionListener)this.view.evtCtxt.getEventListener("initiate update", ActionListener.class)).actionPerformed(event);
        }
    }

    private void relationTypeChange(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        RelationshipType currentRelation = (RelationshipType)event.getItem();
        PlaceholderTextField hofUidField = this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField;
        hofUidField.setEnabled(currentRelation != RelationshipType.NOT_GIVEN);
        hofUidField.setText("");
        this.residentUpdateInfo.setRelationshipType(currentRelation);
    }

    private void disableAll() {
        this.view.getResidentUpdateInfoPanel().uidUpdatePanel.uidField.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().uidUpdatePanel.hofUidField.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.yesRadioBtn.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.noRadioBtn.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.linkedEid.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().whitelistTypePanel.verifyBtn.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().bioExceptionPanel.yes.setEnabled(false);
        this.view.getResidentUpdateInfoPanel().bioExceptionPanel.no.setEnabled(false);
        this.view.getButtonPanel().nextButton.setEnabled(false);
        this.view.getButtonPanel().previousButton.setEnabled(false);
        this.view.getButtonPanel().cancelButton.setEnabled(false);
    }
}

