/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.controllers;

import com.github.jaiimageio.jpeg2000.impl.J2KImageReader;
import com.github.jaiimageio.jpeg2000.impl.J2KImageReaderSpi;
import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.Appointment;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.Brn;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.ForeignNRI;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelativeDetail;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReviewTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang.StringUtils;

public class ReviewControllerUC
extends EnrollmentControllerBase {
    private final ReviewTabViewPeerUC viewPeerUC;
    private final IResourceBundleContext enrolRbctx;
    private boolean isoperatorConfirmed;
    private TokenManager supTokenManager;

    public ReviewControllerUC(ReviewTabViewPeerUC viewPeerUC, int tabIndex, TokenManager supTokenManager) {
        super(viewPeerUC.getLiteView(), viewPeerUC.getEnrollmentService(), 5, tabIndex);
        this.viewPeerUC = viewPeerUC;
        this.enrolRbctx = viewPeerUC.getEnrolRbctx();
        this.supTokenManager = supTokenManager;
        this.initView();
        this.loadPage();
    }

    private void initView() {
        boolean isRefrequired;
        this.addActionListener(this.viewPeerUC.getButtonPanel().nextButton, this::onNextButtonClick);
        this.addActionListener(this.viewPeerUC.getButtonPanel().previousButton, this::onPrevButtonClick);
        this.viewPeerUC.getButtonPanel().cancelButton.addActionListener(e -> ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener("cancelDemo", ActionListener.class)).actionPerformed(e));
        if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isDemographicTabRequired()) {
            this.enrollmentService.getDemoResidentialStatus().addChangeListener(this::onResidentialStatusChange);
            this.enrollmentService.getDemographics().getPersonalDetail().getName().addChangeListener(this::onNameChange);
            this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender().addChangeListener(this::onGenderChange);
            this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().addChangeListener(this::onAgeDobChange);
            this.enrollmentService.getDemographics().getPersonalDetail().getAadhaarNumber().addChangeListener(this::onAadhaarNumberChange);
            this.enrollmentService.getDemographics().getContact().addChangeListener(this::onContactChange);
            this.enrollmentService.getDemographics().getContact().getMobile().addChangeListener(this::onMobileNumberChange);
            this.enrollmentService.getDemographics().getContact().getEmail().addChangeListener(this::onEmailChange);
            this.enrollmentService.getDemographics().getBrnDetails().addChangeListener(this::onBRNDetailsChange);
            this.enrollmentService.getDemographics().getFatherDetail().addChangeListener(this::onFatherRelationChange);
            this.enrollmentService.getDemographics().getMotherDetail().addChangeListener(this::onMotherRelationChange);
            this.enrollmentService.getDemographics().getOtherDetail().addChangeListener(this::onGuardianRelationChange);
            this.enrollmentService.getDemographics().addValidityChangeListener(this::onValidityChange);
        }
        this.enrollmentService.getAppointment().addChangeListener(this::onAppointmentIdChange);
        this.enrollmentService.operatorConfirmationListener(this::onOperatorConfirmation);
        this.enrollmentService.getPhotograph().getPhoto().addChangeListener(this::onBiometricChange);
        this.enrollmentService.getPhotograph().addValidityChangeListener(this::onValidityChange);
        if (this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isFingerTabRequired() || FieldInfoUtils.isIrisTabRequired()) {
            this.enrollmentService.getFingerPrint().addValidityChangeListener(this::onValidityChange);
            this.enrollmentService.getIris().addValidityChangeListener(this::onValidityChange);
        }
        boolean bl = isRefrequired = this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isReferenceTabRequired();
        if (isRefrequired) {
            this.enrollmentService.getReferences().addValidityChangeListener(this::onValidityChange);
            this.enrollmentService.getReferences().getPob().addChangeListener(this::onDocumentChange);
            this.enrollmentService.getReferences().getPoi().addChangeListener(this::onDocumentChange);
            this.enrollmentService.getReferences().getPoa().addChangeListener(this::onDocumentChange);
            this.enrollmentService.getReferences().getPof().addChangeListener(this::onDocumentChange);
            this.enrollmentService.getReferences().getPor().addChangeListener(this::onDocumentChange);
        }
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(true);
        this.isoperatorConfirmed = false;
    }

    private void loadPage() {
        this.onAadhaarNumberChange(this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber());
        this.onNameChange(this.enrollmentService.getDemoPersonalDetails().getName());
        this.onGenderChange(this.enrollmentService.getDemoPersonalDetails().getApplicantGender());
        this.onAgeDobChange(this.enrollmentService.getDemoPersonalDetails().getAgeDob());
        this.onContactChange(this.enrollmentService.getDemoContactDetails());
        this.onResidentialStatusChange(this.enrollmentService.getDemoResidentialStatus());
        this.onAppointmentIdChange(this.enrollmentService.getAppointment());
        if (this.enrollmentService.isUpdateUC()) {
            StringBuilder updateType = new StringBuilder();
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            if (fieldsUpdateCount.getName().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Name");
            }
            if (fieldsUpdateCount.getGender().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Gender");
            }
            if (fieldsUpdateCount.getDob().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Age/DOB");
            }
            if (fieldsUpdateCount.getAddress().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Address");
            }
            if (fieldsUpdateCount.getMobile().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Mobile");
            }
            if (fieldsUpdateCount.getEmail().hasToBeUpdated()) {
                this.addUpdateToList(updateType, "Email");
            }
            if (this.enrollmentService.isBiometricUpdate()) {
                this.addUpdateToList(updateType, "Biometrics");
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_BIOMETRICS_VALUE", "Face, Finger and Iris");
            }
            if (fieldsUpdateCount.getActivationAadhaar().hasToBeUpdated() && this.enrollmentService.isAadhaarActive()) {
                this.changeUpdateType("Extend Aadhaar");
            } else if (!this.enrollmentService.isAadhaarActive() && Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId())) {
                this.changeUpdateType("Reactivation Aadhaar");
            } else {
                updateType.append(" Update");
                this.changeUpdateType(updateType.toString());
            }
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("nameChanged", fieldsUpdateCount.getName().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("genderChanged", fieldsUpdateCount.getGender().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("ageDobChanged", fieldsUpdateCount.getDob().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("addressChanged", fieldsUpdateCount.getAddress().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("mobileChanged", fieldsUpdateCount.getMobile().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("emailChanged", fieldsUpdateCount.getEmail().hasToBeUpdated());
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("biometricsChanged", this.enrollmentService.isBiometricUpdate());
        }
    }

    private void addUpdateToList(StringBuilder updateTypeList, String updateType) {
        if (updateTypeList.length() > 0) {
            updateTypeList.append(", ");
        }
        updateTypeList.append(updateType);
    }

    private void onResidentialStatusChange(ResidentialStatus residentialStatus) {
        if (residentialStatus.isValid()) {
            String type = this.enrollmentService.isNRIEnrolment() ? this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NON_RESIDENT_INDIAN, new Object[0]) : (this.enrollmentService.isForeignResident() ? this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.FOREIGN_NATIONAL_RESIDENT, new Object[0]) : this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.INDIAN_RESIDENT, new Object[0]));
            String locType = this.enrollmentService.isNRIEnrolment() ? "label-tlit:demotab.non.resident.indian" : "label-tlit:demotab.indian.resident";
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("RESIDENT_TYPE_VALUE", this.checkEmptyNull(type));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_RESIDENT_TYPE_VALUE", this.checkEmptyNull(this.enrolRbctx.getLocaleMessage((Object)locType, new Object[0])));
            String country = residentialStatus.getCountry().getCountryName();
            if (residentialStatus.getCountry().getCountryName().equalsIgnoreCase("Select")) {
                country = residentialStatus.getForeignType().getName();
            }
            country = country.equalsIgnoreCase("Select") ? "INDIAN" : country;
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("NATIONALITY_KEY", this.checkEmptyNull("Country"));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("NATIONALITY_VALUE", this.checkEmptyNull(country));
        }
    }

    private void onAppointmentIdChange(Appointment appointment) {
        if (appointment.isValid()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("APPOINTMENT_LABEL_VALUE", this.checkEmptyNull(appointment.getAppointmentId()));
        }
    }

    private void onNameChange(Name name) {
        if (name.isValid()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("NAME_VALUE", this.checkEmptyNull(name.english()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_NAME_VALUE", this.checkEmptyNull(name.local()));
            if (this.enrollmentService.isUpdateUC()) {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_NAME_VALUE", this.checkEmptyNull(name.newEnglish()));
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_NAME_VALUE", this.checkEmptyNull(name.newNameLocal()));
            }
        }
    }

    private void onGenderChange(ApplicantGender applicantGender) {
        if (applicantGender.isValid()) {
            String ageGenderText = applicantGender.getDisplayGender().toString();
            if (this.enrollmentService.isNewEnrollmentUC()) {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("GENDER_VALUE", this.checkEmptyNull(ageGenderText));
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_GENDER_VALUE", this.checkEmptyNull(applicantGender.getGenderLocal()));
            } else {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_GENDER_VALUE", this.checkEmptyNull(ageGenderText));
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_GENDER_VALUE", this.checkEmptyNull(applicantGender.getGenderLocal()));
            }
        }
    }

    private void onAgeDobChange(AgeDob ageDob) {
        StringBuilder ageDobString = new StringBuilder();
        ageDobString.append(ageDob.getAgeDobFormattedUC());
        ageDobString.append('(');
        ageDobString.append(ageDob.getAge().toString());
        ageDobString.append(" years)");
        StringBuilder localAgeDobString = new StringBuilder();
        localAgeDobString.append(ageDob.getAgeDobFormattedUC());
        localAgeDobString.append('(');
        localAgeDobString.append(ageDob.getAge().toString());
        localAgeDobString.append(")");
        if (ageDob.isValid()) {
            if (this.enrollmentService.isNewEnrollmentUC()) {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("AGE_DOB_VALUE", this.checkEmptyNull(String.valueOf(ageDobString)));
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_AGE_DOB_VALUE", this.checkEmptyNull(String.valueOf(localAgeDobString)));
            } else {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_AGE_DOB_VALUE", this.checkEmptyNull(String.valueOf(ageDobString)));
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_AGE_DOB_VALUE", this.checkEmptyNull(String.valueOf(localAgeDobString)));
            }
        }
    }

    private void onContactChange(Contact contact) {
        if (contact.isValid()) {
            if (this.enrollmentService.isNewEnrollmentUC()) {
                if (this.enrollmentService.doesNriHaveForeignAddress()) {
                    ForeignNRI foreignNRIAddress = contact.getForeignNriAddress();
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("ADDRESS_ONE_VALUE", this.checkEmptyNull(foreignNRIAddress.getAddressOne()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("ADDRESS_TWO_VALUE", this.checkEmptyNull(foreignNRIAddress.getAddressTwo()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("ADDRESS_THREE_VALUE", this.checkEmptyNull(foreignNRIAddress.getAddressThree()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("ZIPCODE_VALUE", this.checkEmptyNull(foreignNRIAddress.getZipcode()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("COUNTRY_VALUE", this.checkEmptyNull(foreignNRIAddress.getCountry().getCountryName()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_ADDRESS_ONE_VALUE", this.checkEmptyNull(foreignNRIAddress.getLocalAddressOne()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_ADDRESS_TWO_VALUE", this.checkEmptyNull(foreignNRIAddress.getLocalAddressTwo()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_ADDRESS_THREE_VALUE", this.checkEmptyNull(foreignNRIAddress.getLocalAddressThree()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_ZIPCODE_VALUE", this.checkEmptyNull(foreignNRIAddress.getLocalZipcode()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_COUNTRY_VALUE", this.checkEmptyNull(foreignNRIAddress.getLocalCountry()));
                } else {
                    Address address = contact.getAddress();
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("CARE_OF_VALUE", this.checkEmptyNull(address.getCareOfName()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("STREET_ROAD_LANE_VALUE", this.checkEmptyNull(address.getStreet()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("VILLAGE_TOWN_CITY_VALUE", this.checkEmptyNull(address.getVTC()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POSTOFFICE_VALUE", this.checkEmptyNull(address.getPoName()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("PINCODE_VALUE", this.checkEmptyNull(address.getPinCode()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("HOUSE_BUILDING_APARTMENT_NUMBER_VALUE", this.checkEmptyNull(address.getBuilding()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCALITY_VALUE", this.checkEmptyNull(address.getLocality()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LANDMARK_VALUE", this.checkEmptyNull(address.getLandmark()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("DISTRICT_VALUE", this.checkEmptyNull(address.getDistrict()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("STATE_VALUE", this.checkEmptyNull(address.getState()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_CARE_OF_VALUE", this.checkEmptyNull(address.getCareOfNameLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_STREET_ROAD_LANE_VALUE", this.checkEmptyNull(address.getStreetLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_VILLAGE_TOWN_CITY_VALUE", this.checkEmptyNull(address.getVTCLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_POSTOFFICE_VALUE", this.checkEmptyNull(address.getPoNameLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_PINCODE_VALUE", this.checkEmptyNull(address.getPinCodeLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_HOUSE_BUILDING_APARTMENT_NUMBER_VALUE", this.checkEmptyNull(address.getBuildingLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_LOCALITY_VALUE", this.checkEmptyNull(address.getLocalityLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_LANDMARK_VALUE", this.checkEmptyNull(address.getLandmarkLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_DISTRICT_VALUE", this.checkEmptyNull(address.getDistrictLocal()));
                    this.viewPeerUC.getNewReviewPanel().updateHtmlAt("LOCAL_STATE_VALUE", this.checkEmptyNull(address.getStateLocal()));
                }
            } else if (this.enrollmentService.doesNriHaveForeignAddress()) {
                ForeignNRI foreignNRI = contact.getForeignNriAddress();
                StringBuilder addressString = new StringBuilder();
                StringBuilder localAddressString = new StringBuilder();
                this.addAddressField(addressString, foreignNRI.getDisplayAddressOne());
                this.addAddressField(localAddressString, foreignNRI.getDisplayLocalAddressOne());
                this.addAddressField(addressString, foreignNRI.getDisplayAddressTwo());
                this.addAddressField(localAddressString, foreignNRI.getDisplayLocalAddressTwo());
                this.addAddressField(addressString, foreignNRI.getDisplayAddressThree());
                this.addAddressField(localAddressString, foreignNRI.getDisplayLocalAddressThree());
                this.addAddressField(addressString, foreignNRI.getDisplayZipCode());
                this.addAddressField(localAddressString, foreignNRI.getDisplayZipCode());
                this.addAddressField(addressString, foreignNRI.getCountry().getCountryName());
                this.addAddressField(localAddressString, foreignNRI.getLocalCountry());
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_ADDRESS_VALUE", addressString.toString());
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_ADDRESS_VALUE", localAddressString.toString());
            } else {
                Address address = contact.getAddress();
                StringBuilder addressString = new StringBuilder();
                StringBuilder localAddressString = new StringBuilder();
                if (!Strings.isNullOrEmpty((String)address.getCareOfName())) {
                    addressString.append(address.getCareOf());
                    addressString.append(": ");
                    addressString.append(address.getCareOfName());
                    addressString.append(", ");
                }
                if (!Strings.isNullOrEmpty((String)address.getCareOfNameLocal())) {
                    localAddressString.append(address.getCareOfLocal());
                    localAddressString.append(": ");
                    localAddressString.append(address.getCareOfNameLocal());
                    localAddressString.append(", ");
                }
                this.addAddressField(addressString, address.getBuilding());
                this.addAddressField(localAddressString, address.getBuildingLocal());
                this.addAddressField(addressString, address.getStreet());
                this.addAddressField(localAddressString, address.getStreetLocal());
                this.addAddressField(addressString, address.getLocality());
                this.addAddressField(localAddressString, address.getLocalityLocal());
                this.addAddressField(addressString, address.getLandmark());
                this.addAddressField(localAddressString, address.getLandmarkLocal());
                this.addAddressField(addressString, address.getVTC());
                this.addAddressField(localAddressString, address.getVTCLocal());
                this.addAddressField(addressString, address.getDistrict());
                this.addAddressField(localAddressString, address.getDistrictLocal());
                this.addAddressField(addressString, address.getState());
                this.addAddressField(localAddressString, address.getStateLocal());
                addressString.append(address.getPinCodeValue());
                localAddressString.append(address.getPinCodeLocal());
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_ADDRESS_VALUE", addressString.toString());
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_ADDRESS_VALUE", localAddressString.toString());
            }
        }
        this.onAgeDobChange(this.enrollmentService.getDemoPersonalDetails().getAgeDob());
    }

    private void addAddressField(StringBuilder stringBuilder, String fieldValue) {
        if (!Strings.isNullOrEmpty((String)fieldValue)) {
            stringBuilder.append(fieldValue);
            stringBuilder.append(", ");
        }
    }

    private void onBRNDetailsChange(Brn brnDetails) {
        if (!brnDetails.isSelected() || brnDetails.isValid()) {
            String brnState = "";
            if (!brnDetails.getBrnState().equals("Select")) {
                brnState = brnDetails.getBrnState();
            }
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("BRN_STATE_VALUE", this.checkEmptyNull(brnState));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("BRN_NUMBER_VALUE", this.checkEmptyNull(brnDetails.getBrnNumber()));
        }
    }

    private void onFatherRelationChange(RelativeDetail fatherDetails) {
        if (fatherDetails.isValid()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("FATHER_NAME_VALUE", this.checkEmptyNull(fatherDetails.getName()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("FATHER_UID_VALUE", this.checkEmptyNull(fatherDetails.getUid()));
        }
    }

    private void onMotherRelationChange(RelativeDetail motherDetails) {
        if (motherDetails.isValid()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("MOTHER_NAME_VALUE", this.checkEmptyNull(motherDetails.getName()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("MOTHER_UID_VALUE", this.checkEmptyNull(motherDetails.getUid()));
        }
    }

    private void onGuardianRelationChange(RelativeDetail guardianDetails) {
        if (guardianDetails.isValid()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("GUARDIAN_NAME_VALUE", this.checkEmptyNull(guardianDetails.getName()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("GUARDIAN_UID_VALUE", this.checkEmptyNull(guardianDetails.getUid()));
        }
    }

    private void changeUpdateType(String updateType) {
        if (this.enrollmentService.isUpdateUC()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATE_TYPE_VALUE", this.checkEmptyNull(updateType));
        }
    }

    private void onAadhaarNumberChange(AadhaarNo aadhaarNo) {
        if (this.enrollmentService.isUpdateUC()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("AADHAAR_NUMBER_VALUE", this.checkEmptyNull(aadhaarNo.getAadhaarNumber()));
        }
    }

    private void onMobileNumberChange(Mobile mobile) {
        if (this.enrollmentService.isUpdateUC()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_MOBILE_VALUE", this.checkEmptyNull(mobile.number()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_MOBILE_VALUE", this.checkEmptyNull(mobile.number()));
        }
    }

    private void onEmailChange(Email email) {
        if (this.enrollmentService.isUpdateUC()) {
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_EMAIL_VALUE", this.checkEmptyNull(email.email()));
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("UPDATED_LOCAL_EMAIL_VALUE", this.checkEmptyNull(email.email()));
        }
    }

    private void onDocumentChange(ReferenceDocument referenceDocument) {
        if (referenceDocument == null) {
            return;
        }
        References references = this.enrollmentService.getReferences();
        if (!referenceDocument.isMandatory()) {
            return;
        }
        switch (referenceDocument.getDocumentType()) {
            case POB: {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POB_DOCUMENT_VALUE", this.documentNameForDisplay(references.getPob().getProof()));
                break;
            }
            case POI: {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POI_DOCUMENT_VALUE", this.documentNameForDisplay(references.getPoi().getProof()));
                break;
            }
            case POF: {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POF_DOCUMENT_VALUE", this.documentNameForDisplay(references.getPof().getProof()));
                break;
            }
            case POA: {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POA_DOCUMENT_VALUE", this.documentNameForDisplay(references.getPoa().getProof()));
                break;
            }
            case POR: {
                this.viewPeerUC.getNewReviewPanel().updateHtmlAt("POR_DOCUMENT_VALUE", this.documentNameForDisplay(references.getPor().getProof()));
            }
        }
    }

    private String documentNameForDisplay(ProofDocument proofDocument) {
        if (proofDocument == null) {
            return "Not Given";
        }
        String docName = proofDocument.getDocName();
        if (StringUtils.isBlank((String)docName) || StringUtils.equalsIgnoreCase((String)docName, (String)"Select")) {
            return "Not Given";
        }
        return docName;
    }

    private void onBiometricChange(Biometrics biometrics) {
        CaptureModality captureModality = biometrics.getCaptureModality();
        if (captureModality == CaptureModality.FACE && biometrics.getCaptureAttemptWithMaxScore() != null && biometrics.getCaptureAttemptWithMaxScore().getImage() != null) {
            byte[] imageBytes = biometrics.getCaptureAttemptWithMaxScore().getImage().getImageData();
            String base64Image = "";
            try {
                BufferedImage jp2Image;
                J2KImageReader reader = new J2KImageReader((ImageReaderSpi)new J2KImageReaderSpi());
                try (ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(imageBytes));){
                    reader.setInput(input);
                    jp2Image = reader.read(0);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)jp2Image, "jpeg", outputStream);
                byte[] jpegBytes = outputStream.toByteArray();
                base64Image = Base64.getEncoder().encodeToString(jpegBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.viewPeerUC.getNewReviewPanel().updateHtmlAt("IMAGE_BASE64", base64Image);
        }
    }

    @Override
    public void onNextButtonClick(ActionEvent event) {
        boolean supValid = this.supTokenManager.isValid();
        if (this.enrollmentService.isSupervisorAuthRequired()) {
            if (supValid) {
                this.disableNavigation();
                this.fireEvent("HID_ACK_SLIP_PANEL_DISPLAY", event);
            } else if (this.isoperatorConfirmed) {
                this.disableNavigation();
                this.fireEvent("supervisorAuth", event);
            } else {
                this.fireEvent("hID_Enrol_OSI_ShowWin", event);
            }
            return;
        }
        if (this.isoperatorConfirmed) {
            this.disableNavigation();
            this.fireEvent("HID_ACK_SLIP_PANEL_DISPLAY", event);
        } else {
            this.fireEvent("hID_Enrol_OSI_ShowWin", event);
        }
    }

    private void disableNavigation() {
        this.viewPeerUC.getTabbedPane().setEnabled(false);
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(false);
    }

    private void fireEvent(String eventId, ActionEvent event) {
        ((ActionListener)this.viewPeerUC.getEvtCtxt().getEventListener(eventId, ActionListener.class)).actionPerformed(event);
    }

    private void onOperatorConfirmation() {
        this.viewPeerUC.getTabbedPane().setEnabled(false);
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(false);
        this.isoperatorConfirmed = true;
    }

    private void onValidityChange(boolean valid) {
        boolean isEnrollmentValid = valid && this.enrollmentService.getDemographics().isValid() && this.enrollmentService.getReferences().isValid() && this.enrollmentService.getPhotograph().isValid() && this.enrollmentService.getFingerPrint().isValid() && this.enrollmentService.getIris().isValid();
        boolean isBioUpdateValid = valid && this.enrollmentService.getDemographics().isValid() && this.enrollmentService.getPhotograph().isValid() && this.enrollmentService.getFingerPrint().isValid() && this.enrollmentService.getIris().isValid();
        boolean isDemoUpdateValid = valid && this.enrollmentService.getDemographics().isValid() && this.enrollmentService.getReferences().isValid();
        boolean enabled = false;
        if (this.enrollmentService.isNewEnrollmentUC() && isEnrollmentValid) {
            enabled = true;
        } else if (this.enrollmentService.isBiometricUpdate() && isBioUpdateValid) {
            enabled = true;
        } else if (this.enrollmentService.isUpdateUC() && isDemoUpdateValid) {
            enabled = true;
        }
        this.viewPeerUC.getButtonPanel().nextButton.setEnabled(enabled);
        this.viewPeerUC.getButtonPanel().previousButton.setEnabled(true);
    }

    private String checkEmptyNull(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return "<i style=\"color: grey;\">Not Given</i>";
        }
        return text;
    }
}

