/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.customUI;

import in.gov.uidai.swing.notify.NotificationPopup;
import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class DateDocument
extends DocumentFilter {
    String pattern = "^(\\d{0,2}(-\\d{0,2}(-\\d{0,4})?)?)?$";
    String finalPattern = "^(0?[1-9]|[12][0-9]|3[01])-(0?[1-9]|1[0-2])-(\\d{4})$";
    private final JTextComponent theComp;

    public DateDocument(JTextComponent comp) {
        this.theComp = comp;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (string == null) {
            return;
        }
        this.replace(fb, offset, 0, string, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (text == null) {
            return;
        }
        Document document = fb.getDocument();
        StringBuilder sb = new StringBuilder(document.getText(0, document.getLength()));
        sb.replace(offset, offset + length, text);
        String currentText = sb.toString();
        if (currentText.length() > 10) {
            return;
        }
        StringBuilder formattedText = new StringBuilder();
        formattedText.append(currentText);
        if (formattedText.length() >= 2 && formattedText.indexOf("-") < 0) {
            formattedText.insert(2, "-");
        }
        if (formattedText.length() >= 5 && formattedText.lastIndexOf("-") <= 2) {
            formattedText.insert(5, "-");
        }
        if (formattedText.length() == 10 && !this.patternCheck(this.finalPattern, currentText)) {
            return;
        }
        if (formattedText.length() > 10) {
            formattedText.delete(10, formattedText.length());
        }
        if (!this.patternCheck(this.pattern, currentText)) {
            return;
        }
        super.replace(fb, 0, document.getLength(), formattedText.toString(), attrs);
    }

    protected void showFeedback(String text) {
        NotificationPopup.getToolTip((JComponent)this.theComp).showToolTip(text, true);
    }

    private boolean patternCheck(String pattern, String currentText) {
        String errorMessage = "Invalid date format";
        if (!Pattern.matches(pattern, currentText)) {
            this.showFeedback(StringUtils.isBlank((String)errorMessage) ? "input must match " + pattern : errorMessage);
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return true;
    }
}

