/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.customUI;

import in.gov.uidai.ec.ui.enrol.demographics.StagesUC;
import in.gov.uidai.ec.ui.enrol.references.ReferenceStagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowRenderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;

public class ShadowPanel
extends JComponent {
    private int shadowSize = 10;
    private int borderSize = 0;
    private Color gradientColor = new Color(156, 156, 156);
    private Color backgroundLight = Color.WHITE;
    private BufferedImage imageRender;
    private StagesUC demographicStage;
    private ReferenceStagesUC referenceStage;

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
        this.setBorder(new EmptyBorder(shadowSize, shadowSize, shadowSize, shadowSize));
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        this.refresh();
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.gradientColor = gradientColor;
        this.refresh();
    }

    public Color getBackgroundLight() {
        return this.backgroundLight;
    }

    public void setBackgroundLight(Color backgroundLight) {
        this.backgroundLight = backgroundLight;
        this.refresh();
    }

    public ShadowPanel() {
        this.setBorder(new EmptyBorder(this.shadowSize, this.shadowSize, this.shadowSize, this.shadowSize));
        this.setBackground(Color.WHITE);
    }

    private void refresh() {
        this.createImageRender();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.imageRender != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage((Image)this.imageRender, 0, 0, null);
            g2.dispose();
        }
        super.paintComponent(g);
    }

    private void createImageRender() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            Insets inset = this.getInsets();
            this.imageRender = new BufferedImage(width, height, 2);
            Graphics2D g2 = this.imageRender.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage((Image)this.createShadow(width, height, inset, this.gradientColor, true), 0, 0, null);
            g2.drawImage((Image)this.createShadow(width, height, inset, this.gradientColor, false), 0, 0, null);
            Area area = new Area(new Rectangle2D.Double(inset.left, inset.top, width - inset.left - inset.right, height - inset.top - inset.bottom));
            g2.setColor(this.getBackground());
            g2.fill(area);
            area.subtract(new Area(new Rectangle2D.Double(width / 2, 0.0, width / 2, height)));
            g2.setColor(this.backgroundLight);
            g2.fill(area);
            g2.drawImage((Image)this.createBorder(width, height, inset), 0, 0, null);
            g2.dispose();
        }
    }

    private BufferedImage createShadow(int width, int height, Insets inset, Color color, boolean leftShadow) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2 = img.createGraphics();
        Path2D.Double p = new Path2D.Double();
        double w = width - inset.left - inset.right;
        double h = height - inset.top - inset.bottom;
        if (leftShadow) {
            ((Path2D)p).moveTo(0.0, 0.0);
            ((Path2D)p).lineTo(w, h);
            ((Path2D)p).lineTo(0.0, h);
        } else {
            ((Path2D)p).moveTo(0.0, 0.0);
            ((Path2D)p).lineTo(w, 0.0);
            ((Path2D)p).lineTo(w, h);
        }
        g2.fill(p);
        g2.dispose();
        return new ShadowRenderer(this.shadowSize, 0.45f, color).createShadow(img);
    }

    private BufferedImage createBorder(int width, int height, Insets inset) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = width - inset.left - inset.right;
        int h = height - inset.top - inset.bottom;
        Color tranColor = this.toTranslucentColor(this.gradientColor);
        g2.setPaint(new GradientPaint(0.0f, (float)h * 0.1f, tranColor, 0.0f, h, this.gradientColor));
        g2.fill(new Rectangle2D.Double(inset.left, inset.top, this.borderSize, h));
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientColor, (float)w * 0.9f, 0.0f, tranColor));
        g2.fill(new Rectangle2D.Double(inset.left, height - inset.bottom - this.borderSize, w, this.borderSize));
        g2.setPaint(new GradientPaint((float)w * 0.1f, 0.0f, tranColor, w, 0.0f, this.gradientColor));
        g2.fill(new Rectangle2D.Double(inset.left, inset.top, w, this.borderSize));
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.gradientColor, 0.0f, (float)h * 0.9f, tranColor));
        g2.fill(new Rectangle2D.Double(width - inset.right - this.borderSize, inset.top, this.borderSize, h));
        g2.dispose();
        return img;
    }

    private Color toTranslucentColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createImageRender();
    }

    public StagesUC getDemographicStage() {
        return this.demographicStage;
    }

    public void setDemographicStage(StagesUC demographicStage) {
        this.demographicStage = demographicStage;
    }

    public ReferenceStagesUC getReferenceStage() {
        return this.referenceStage;
    }

    public void setReferenceStage(ReferenceStagesUC referenceStage) {
        this.referenceStage = referenceStage;
    }
}

