/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar;

import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Button;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Dates;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Event;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.EventDateChooser;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Months;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.SelectedAction;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.SelectedDate;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Slider;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.calendar.Years;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateChooser
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateChooser.class);
    private JTextField textRefernce;
    private final String[] MONTH_ENGLISH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String dateFormat = "dd-MM-yyyy";
    private int MONTH = 1;
    private int YEAR = 2021;
    private int DAY = 1;
    private int STATUS = 1;
    private int startYear;
    private SelectedDate selectedDate = new SelectedDate();
    private List<EventDateChooser> events;
    private JLayeredPane MY;
    private Button cmdForward;
    private Button cmdMonth;
    private Button cmdPrevious;
    private Button cmdYear;
    private JPanel header;
    private JLabel lb;
    private JPopupMenu popup;
    private Slider slide;

    public JTextField getTextRefernce() {
        return this.textRefernce;
    }

    public void addEventDateChooser(EventDateChooser event) {
        this.events.add(event);
    }

    public DateChooser() {
        this.initComponents();
        this.execute();
    }

    private void execute() {
        this.setForeground(new Color(204, 93, 93));
        this.events = new ArrayList<EventDateChooser>();
        this.popup.add(this);
        this.toDay(false);
    }

    public void setTextRefernce(JTextField txt) {
        this.textRefernce = txt;
        this.textRefernce.setEditable(false);
        this.textRefernce.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (DateChooser.this.textRefernce.isEnabled()) {
                    DateChooser.this.showPopup();
                }
            }
        });
    }

    private void setText(boolean runEvent, int act) {
        if (this.textRefernce != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
                Date date = df.parse(this.DAY + "-" + this.MONTH + "-" + this.YEAR);
                this.textRefernce.setText(new SimpleDateFormat(this.dateFormat).format(date));
            }
            catch (ParseException e) {
                LOGGER.error("Exception :", (Throwable)e);
            }
        }
        if (runEvent) {
            this.runEvent(act);
        }
    }

    private void runEvent(final int act) {
        SelectedAction action = new SelectedAction(){

            @Override
            public int getAction() {
                return act;
            }
        };
        for (EventDateChooser event : this.events) {
            event.dateSelected(action, this.selectedDate);
        }
    }

    private Event getEventDay(Dates dates) {
        return (evt, num) -> {
            dates.clearSelected();
            dates.setSelected(num);
            this.DAY = num;
            this.selectedDate.setDay(this.DAY);
            this.selectedDate.setMonth(this.MONTH);
            this.selectedDate.setYear(this.YEAR);
            this.setText(true, 1);
            if (evt != null && evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt)) {
                this.popup.setVisible(false);
            }
        };
    }

    private Event getEventMonth() {
        return (evt, num) -> {
            this.MONTH = num;
            this.selectedDate.setDay(this.DAY);
            this.selectedDate.setMonth(this.MONTH);
            this.selectedDate.setYear(this.YEAR);
            this.setText(true, 2);
            Dates d = new Dates();
            d.setForeground(this.getForeground());
            d.setEvent(this.getEventDay(d));
            d.showDate(this.MONTH, this.YEAR, this.selectedDate);
            if (this.slide.slideToDown(d)) {
                this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
                this.cmdYear.setText(this.YEAR + "");
                this.STATUS = 1;
            }
        };
    }

    private Event getEventYear() {
        return (evt, num) -> {
            this.YEAR = num;
            this.selectedDate.setDay(this.DAY);
            this.selectedDate.setMonth(this.MONTH);
            this.selectedDate.setYear(this.YEAR);
            this.setText(true, 3);
            Months d = new Months();
            d.setEvent(this.getEventMonth());
            if (this.slide.slideToDown(d)) {
                this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
                this.cmdYear.setText(this.YEAR + "");
                this.STATUS = 2;
            }
        };
    }

    private void toDay(boolean runEvent) {
        Dates dates = new Dates();
        dates.setForeground(this.getForeground());
        dates.setEvent(this.getEventDay(dates));
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String toDay = df.format(date);
        this.DAY = Integer.valueOf(toDay.split("-")[0]);
        this.MONTH = Integer.valueOf(toDay.split("-")[1]);
        this.YEAR = Integer.valueOf(toDay.split("-")[2]);
        this.selectedDate.setDay(this.DAY);
        this.selectedDate.setMonth(this.MONTH);
        this.selectedDate.setYear(this.YEAR);
        dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
        this.slide.slideNon(dates);
        this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
        this.cmdYear.setText(this.YEAR + "");
        this.setText(runEvent, 0);
    }

    public void toDay() {
        this.toDay(true);
    }

    private void setDateNext() {
        Dates dates = new Dates();
        dates.setForeground(this.getForeground());
        dates.setEvent(this.getEventDay(dates));
        dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
        if (this.slide.slideToLeft(dates)) {
            this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
            this.cmdYear.setText(this.YEAR + "");
        }
    }

    private void setDateBack() {
        Dates dates = new Dates();
        dates.setForeground(this.getForeground());
        dates.setEvent(this.getEventDay(dates));
        dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
        if (this.slide.slideToRight(dates)) {
            this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
            this.cmdYear.setText(this.YEAR + "");
        }
    }

    private void setYearNext() {
        Years years = new Years();
        years.setEvent(this.getEventYear());
        this.startYear = years.next(this.startYear);
        this.slide.slideToLeft(years);
    }

    private void setYearBack() {
        if (this.startYear >= 1000) {
            Years years = new Years();
            years.setEvent(this.getEventYear());
            this.startYear = years.back(this.startYear);
            this.slide.slideToLeft(years);
        }
    }

    public void showPopup(Component com, int x, int y) {
        this.popup.show(com, x, y);
    }

    public void showPopup() {
        this.popup.show(this.textRefernce, 0, this.textRefernce.getHeight());
    }

    public void hidePopup() {
        this.popup.setVisible(false);
    }

    private void initComponents() {
        this.popup = new JPopupMenu(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                grphcs.setColor(new Color(114, 113, 113));
                grphcs.fillRect(0, 0, this.getWidth(), this.getHeight());
                grphcs.setColor(Color.WHITE);
                grphcs.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }
        };
        this.header = new JPanel();
        this.cmdForward = new Button();
        this.MY = new JLayeredPane();
        this.cmdMonth = new Button();
        this.lb = new JLabel();
        this.cmdYear = new Button();
        this.cmdPrevious = new Button();
        this.slide = new Slider();
        this.setBackground(new Color(255, 255, 255));
        this.header.setBackground(new Color(204, 93, 93));
        this.header.setMaximumSize(new Dimension(262, 40));
        this.cmdForward.setCursor(new Cursor(12));
        String forward = "res/images/forward.png";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.cmdForward.setIcon(new ImageIcon(Objects.requireNonNull(cl.getResource(forward))));
        this.cmdForward.setFocusable(true);
        this.cmdForward.setPaintBackground(false);
        this.cmdForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooser.this.cmdForwardActionPerformed(evt);
            }
        });
        FlowLayout flowLayout1 = new FlowLayout(1, 5, 0);
        flowLayout1.setAlignOnBaseline(true);
        this.MY.setLayout(flowLayout1);
        this.cmdMonth.setCursor(new Cursor(12));
        this.cmdMonth.setForeground(new Color(255, 255, 255));
        this.cmdMonth.setText("January");
        this.cmdMonth.setFocusPainted(false);
        this.cmdMonth.setFont(new Font("Kh Content", 0, 14));
        this.cmdMonth.setPaintBackground(false);
        this.cmdMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooser.this.cmdMonthActionPerformed(evt);
            }
        });
        this.MY.add(this.cmdMonth);
        this.lb.setForeground(new Color(255, 255, 255));
        this.lb.setHorizontalAlignment(0);
        this.lb.setText("-");
        this.MY.add(this.lb);
        this.cmdYear.setCursor(new Cursor(12));
        this.cmdYear.setForeground(new Color(255, 255, 255));
        this.cmdYear.setText("2018");
        this.cmdYear.setFocusPainted(false);
        this.cmdYear.setFont(new Font("Kh Content", 0, 14));
        this.cmdYear.setPaintBackground(false);
        this.cmdYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooser.this.cmdYearActionPerformed(evt);
            }
        });
        this.MY.add(this.cmdYear);
        this.cmdPrevious.setCursor(new Cursor(12));
        String previous = "res/images/previous.png";
        this.cmdPrevious.setIcon(new ImageIcon(Objects.requireNonNull(cl.getResource(previous))));
        this.cmdPrevious.setFocusable(true);
        this.cmdPrevious.setPaintBackground(false);
        this.cmdPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateChooser.this.cmdPreviousActionPerformed(evt);
            }
        });
        this.cmdPrevious.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DateChooser.this.cmdPreviousKeyPressed(evt);
            }
        });
        GroupLayout headerLayout = new GroupLayout(this.header);
        this.header.setLayout(headerLayout);
        headerLayout.setHorizontalGroup(headerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerLayout.createSequentialGroup().addContainerGap().addComponent(this.cmdPrevious, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MY, -1, 198, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdForward, -2, -1, -2).addContainerGap()));
        headerLayout.setVerticalGroup(headerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerLayout.createSequentialGroup().addContainerGap().addGroup(headerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdPrevious, -1, -1, Short.MAX_VALUE).addComponent(this.MY, -2, -1, -2).addComponent(this.cmdForward, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.slide.setLayout(new BoxLayout(this.slide, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.slide, -1, -1, Short.MAX_VALUE).addComponent(this.header, -2, -1, -2)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.header, -2, -1, -2).addGap(3, 3, 3).addComponent(this.slide, -2, 165, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cmdPreviousActionPerformed(ActionEvent evt) {
        if (this.STATUS == 1) {
            if (this.MONTH == 1) {
                this.MONTH = 12;
                --this.YEAR;
            } else {
                --this.MONTH;
            }
            this.setDateBack();
        } else if (this.STATUS == 3) {
            this.setYearBack();
        } else if (this.YEAR >= 1000) {
            --this.YEAR;
            Months months = new Months();
            months.setEvent(this.getEventMonth());
            this.slide.slideToLeft(months);
            this.cmdYear.setText(this.YEAR + "");
        }
    }

    private void cmdForwardActionPerformed(ActionEvent evt) {
        if (this.STATUS == 1) {
            if (this.MONTH == 12) {
                this.MONTH = 1;
                ++this.YEAR;
            } else {
                ++this.MONTH;
            }
            this.setDateNext();
        } else if (this.STATUS == 3) {
            this.setYearNext();
        } else {
            ++this.YEAR;
            Months months = new Months();
            months.setEvent(this.getEventMonth());
            this.slide.slideToLeft(months);
            this.cmdYear.setText(this.YEAR + "");
        }
    }

    private void cmdMonthActionPerformed(ActionEvent evt) {
        if (this.STATUS != 2) {
            this.STATUS = 2;
            Months months = new Months();
            months.setEvent(this.getEventMonth());
            this.slide.slideToDown(months);
        } else {
            Dates dates = new Dates();
            dates.setForeground(this.getForeground());
            dates.setEvent(this.getEventDay(dates));
            dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
            this.slide.slideToDown(dates);
            this.STATUS = 1;
        }
    }

    private void cmdYearActionPerformed(ActionEvent evt) {
        if (this.STATUS != 3) {
            this.STATUS = 3;
            Years years = new Years();
            years.setEvent(this.getEventYear());
            this.startYear = years.showYear(this.YEAR);
            this.slide.slideToDown(years);
        } else {
            Dates dates = new Dates();
            dates.setForeground(this.getForeground());
            dates.setEvent(this.getEventDay(dates));
            dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
            this.slide.slideToDown(dates);
            this.STATUS = 1;
        }
    }

    private void cmdPreviousKeyPressed(KeyEvent evt) {
        Component com;
        if (evt.getKeyCode() == 38) {
            Component com2 = this.slide.getComponent(0);
            if (com2 instanceof Dates) {
                Dates d = (Dates)com2;
                d.up();
            }
        } else if (evt.getKeyCode() == 40) {
            Component com3 = this.slide.getComponent(0);
            if (com3 instanceof Dates) {
                Dates d = (Dates)com3;
                d.down();
            }
        } else if (evt.getKeyCode() == 37) {
            Component com4 = this.slide.getComponent(0);
            if (com4 instanceof Dates) {
                Dates d = (Dates)com4;
                d.back();
            }
        } else if (evt.getKeyCode() == 39 && (com = this.slide.getComponent(0)) instanceof Dates) {
            Dates d = (Dates)com;
            d.next();
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSelectedDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        String d = df.format(date);
        this.DAY = Integer.valueOf(d.split("-")[0]);
        this.MONTH = Integer.valueOf(d.split("-")[1]);
        this.YEAR = Integer.valueOf(d.split("-")[2]);
        this.selectedDate.setDay(this.DAY);
        this.selectedDate.setMonth(this.MONTH);
        this.selectedDate.setYear(this.YEAR);
        Dates dates = new Dates();
        dates.setForeground(this.getForeground());
        dates.setEvent(this.getEventDay(dates));
        dates.setSelected(this.DAY);
        dates.showDate(this.MONTH, this.YEAR, this.selectedDate);
        this.slide.slideNon(dates);
        this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
        this.cmdYear.setText(this.YEAR + "");
        this.setText(true, 0);
        this.STATUS = 1;
    }

    public SelectedDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(SelectedDate selectedDate) {
        this.selectedDate = selectedDate;
        this.DAY = selectedDate.getDay();
        this.MONTH = selectedDate.getMonth();
        this.YEAR = selectedDate.getYear();
        Dates dates = new Dates();
        dates.setForeground(this.getForeground());
        dates.setEvent(this.getEventDay(dates));
        dates.setSelected(this.DAY);
        dates.showDate(this.MONTH, this.YEAR, selectedDate);
        this.slide.slideNon(dates);
        this.cmdMonth.setText(this.MONTH_ENGLISH[this.MONTH - 1]);
        this.cmdYear.setText(this.YEAR + "");
        this.setText(true, 0);
        this.STATUS = 1;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.header != null) {
            this.header.setBackground(color);
            this.toDay(false);
        }
    }
}

