/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.foreign;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.ui.enrol.demographics.StagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.ForeignProofPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.foreign.VisaPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ForeignPanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    private ForeignProofPanel foreignProofPanel;
    private VisaPanel visaPanel;
    protected ShadowPanel mainPanel;

    public ForeignPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create() {
        this.mainPanel = new ShadowPanel();
        this.mainPanel.setDemographicStage(StagesUC.FE_FOREIGN_DOCUMENTS_DETAILS);
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.mainPanel.setPreferredSize(new Dimension(1026, 562));
        this.foreignProofPanel = new ForeignProofPanel(this.enrolRbctx);
        this.visaPanel = new VisaPanel(this.enrolRbctx);
        JLabel title = new JLabel();
        this.mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        title.setForeground(Color.decode("#297FB8"));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysHeader.PERSONAL.toString(), new Object[0]));
        this.mainPanel.add((Component)this.foreignProofPanel.create(), new AbsoluteConstraints(10, 10, 1000, 220));
        this.mainPanel.add((Component)this.visaPanel.create(), new AbsoluteConstraints(10, 226, 1000, 260));
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ForeignPanel.this.mainPanel.requestFocusInWindow();
            }
        });
        return this.mainPanel;
    }

    public JTextField getDocNoTextField() {
        return this.foreignProofPanel.docNoTextField;
    }

    public JTextField getIssueDateField() {
        return this.foreignProofPanel.issueDateField;
    }

    public JTextField getExpiryDateField() {
        return this.foreignProofPanel.expiryDateField;
    }

    public JComboBox<ProofDocument> getPOFField() {
        return this.foreignProofPanel.poiList;
    }

    public JComboBox<ProofDocument> getVisaField() {
        return this.visaPanel.visaList;
    }

    public VisaPanel getVisaPanel() {
        return this.visaPanel;
    }

    public ForeignProofPanel getForeignPanel() {
        return this.foreignProofPanel;
    }

    public JTextField getVisaIssueField() {
        return this.visaPanel.issueDateField;
    }

    public JTextField getVisaExpiryField() {
        return this.visaPanel.expiryDateField;
    }

    public JTextField getVisaNumber() {
        return this.visaPanel.visaNumberTextField;
    }

    public void clearFields() {
        this.foreignProofPanel.clearFields();
        this.visaPanel.clearFields();
    }

    public void clearForeignProofFields() {
        this.foreignProofPanel.clearFields();
    }

    public void clearVisaFields() {
        this.visaPanel.clearFields();
    }

    public JComponent getTab() {
        return this.mainPanel;
    }

    public StagesUC getStage() {
        return StagesUC.FE_FOREIGN_DOCUMENTS_DETAILS;
    }

    public void setExpiryDateMandatory(boolean mandatory) {
        this.foreignProofPanel.setExpiryDateMandatory(mandatory);
    }

    public JButton getPoiRefresh() {
        return this.foreignProofPanel.refresh;
    }

    public JButton getPofRefresh() {
        return this.visaPanel.refresh;
    }
}

