/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.foreign;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.swing.TipListCellRenderer;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.DateDocument;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.AbstractDocument;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ForeignProofPanel {
    private IResourceBundleContext enrolRbctx;
    protected PlaceholderTextField docNoTextField;
    protected PlaceholderTextField issueDateField;
    protected PlaceholderTextField expiryDateField;
    protected JLabel expiryDateHeading;
    protected JLabel heading;
    protected JLabel issue;
    protected JLabel docNoHeading;
    protected JComboBox<ProofDocument> poiList;
    protected JButton refresh;

    public ForeignProofPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create() {
        JPanel foreignPanel = new JPanel();
        JLabel title = new JLabel();
        this.heading = new JLabel();
        this.docNoTextField = new PlaceholderTextField();
        this.issueDateField = new PlaceholderTextField();
        this.expiryDateField = new PlaceholderTextField();
        foreignPanel.setBackground(new Color(255, 255, 255));
        foreignPanel.setLayout((LayoutManager)new AbsoluteLayout());
        foreignPanel.setPreferredSize(new Dimension(980, 120));
        title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        title.setForeground(Color.decode("#297FB8"));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.POF.toString(), new Object[0]));
        foreignPanel.add((Component)title, new AbsoluteConstraints(24, 17, -1, 20));
        foreignPanel.add((Component)CommonUtilsUC.createDivider(), new AbsoluteConstraints(375, 17, 650, 10));
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.heading.setText(CommonUtilsUC.setMandatoryText("Proof of Identity"));
        foreignPanel.add((Component)this.heading, new AbsoluteConstraints(24, 49, -1, 20));
        this.poiList = new JComboBox();
        this.poiList.setActionCommand("POI");
        this.poiList.setRenderer(new TipListCellRenderer(this.poiList));
        this.poiList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.poiList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.poiList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.poiList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        foreignPanel.add(this.poiList, new AbsoluteConstraints(24, 75, 435, 40));
        this.poiList.setName("PoiList");
        this.refresh = new JButton();
        this.refresh.setText("\ue627");
        this.refresh.setFont(new Font("Material Icons", 0, 25));
        this.refresh.setForeground(Color.decode("#34495E"));
        this.refresh.setHorizontalAlignment(0);
        this.refresh.setToolTipText("Sync the list");
        foreignPanel.add((Component)this.refresh, new AbsoluteConstraints(465, 75, 40, 40));
        this.docNoHeading = new JLabel();
        this.docNoHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.docNoHeading.setForeground(Color.decode("#34495E"));
        this.docNoHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DOCUMENT.toString(), new Object[0])));
        foreignPanel.add((Component)this.docNoHeading, new AbsoluteConstraints(519, 49, 147, 20));
        this.docNoTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.docNoTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_DOCUMENT.toString(), new Object[0]));
        this.docNoTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        InlineValidations ilv = new InlineValidations(this.enrolRbctx);
        this.docNoTextField.addActionListener(e -> foreignPanel.requestFocusInWindow());
        foreignPanel.add((Component)this.docNoTextField, new AbsoluteConstraints(519, 75, 480, 40));
        this.docNoTextField.setName("PoiNo");
        this.issue = new JLabel();
        this.issue.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.issue.setForeground(Color.decode("#34495E"));
        this.issue.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ISSUE.toString(), new Object[0])));
        foreignPanel.add((Component)this.issue, new AbsoluteConstraints(24, 125, 480, 20));
        this.issueDateField.setName("Issue");
        JPanel issueDate = this.prepare(this.issueDateField);
        this.issueDateField.addActionListener(e -> foreignPanel.requestFocusInWindow());
        foreignPanel.add((Component)issueDate, new AbsoluteConstraints(24, 155, 480, 40));
        this.expiryDateHeading = new JLabel();
        this.expiryDateHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.expiryDateHeading.setForeground(Color.decode("#34495E"));
        this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EXPIRY.toString(), new Object[0])));
        foreignPanel.add((Component)this.expiryDateHeading, new AbsoluteConstraints(519, 125, 480, 20));
        this.expiryDateField.setName("Expiry");
        JPanel expiryDate = this.prepare(this.expiryDateField);
        this.expiryDateField.addActionListener(e -> foreignPanel.requestFocusInWindow());
        foreignPanel.add((Component)expiryDate, new AbsoluteConstraints(519, 155, 480, 40));
        return foreignPanel;
    }

    private JPanel prepare(PlaceholderTextField date) {
        JPanel jPanel1 = new JPanel();
        date.setPlaceholder("DD-MM-YYYY");
        date.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        date.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        date.setColumns(10);
        AbstractDocument document = (AbstractDocument)date.getDocument();
        document.setDocumentFilter(new DateDocument(date));
        jPanel1.setBackground(new Color(255, 255, 255));
        jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        jPanel1.add((Component)date, new AbsoluteConstraints(0, 0, 480, 40));
        return jPanel1;
    }

    protected void clearFields() {
        this.docNoTextField.setText("");
        this.issueDateField.setText("");
        this.expiryDateField.setText("");
    }

    public void setEnable(boolean enable) {
        this.clearFields();
        this.docNoTextField.setEnabled(enable);
        this.issueDateField.setEnabled(enable);
        this.expiryDateField.setEnabled(enable);
        this.poiList.setEnabled(enable);
    }

    public void setMandatory(boolean mandatory) {
        if (mandatory) {
            this.heading.setText(CommonUtilsUC.setMandatoryText("Proof of Identity"));
            this.issue.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ISSUE.toString(), new Object[0])));
            this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EXPIRY.toString(), new Object[0])));
            this.docNoHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DOCUMENT.toString(), new Object[0])));
        } else {
            this.clearFields();
            this.heading.setText("Proof of Identity");
            this.issue.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ISSUE.toString(), new Object[0]));
            this.expiryDateHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EXPIRY.toString(), new Object[0]));
            this.docNoHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DOCUMENT.toString(), new Object[0]));
        }
    }

    public void setExpiryDateMandatory(boolean mandatory) {
        if (mandatory) {
            this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EXPIRY.toString(), new Object[0])));
        } else {
            this.expiryDateHeading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.EXPIRY.toString(), new Object[0]));
            this.expiryDateField.setText("");
        }
        this.expiryDateField.setEnabled(mandatory);
    }
}

