/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.foreign;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.swing.TipListCellRenderer;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.DateDocument;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.AbstractDocument;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class VisaPanel {
    private IResourceBundleContext enrolRbctx;
    protected PlaceholderTextField visaNumberTextField;
    private JPanel issueDatePanel;
    private JPanel expiryDatePanel;
    protected PlaceholderTextField issueDateField;
    protected PlaceholderTextField expiryDateField;
    protected JComboBox<ProofDocument> visaList;
    protected JButton refresh;
    JLabel visaTypeHeading;
    JLabel visaNumberHeading;
    JLabel issueDateHeading;
    JLabel expiryDateHeading;

    public VisaPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create() {
        JLabel title = new JLabel();
        JPanel visaPanel = new JPanel();
        this.visaTypeHeading = new JLabel();
        this.visaNumberHeading = new JLabel();
        this.issueDateHeading = new JLabel();
        this.expiryDateHeading = new JLabel();
        this.issueDateField = new PlaceholderTextField();
        this.expiryDateField = new PlaceholderTextField();
        this.visaNumberTextField = new PlaceholderTextField();
        this.visaList = new JComboBox();
        visaPanel.setBackground(Color.WHITE);
        visaPanel.setLayout((LayoutManager)new AbsoluteLayout());
        visaPanel.setBackground(new Color(255, 255, 255));
        visaPanel.setPreferredSize(new Dimension(1026, 240));
        title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        title.setForeground(new Color(41, 127, 184));
        title.setText("Additional Document");
        visaPanel.add((Component)title, new AbsoluteConstraints(24, 17, -1, 20));
        visaPanel.add((Component)CommonUtilsUC.createDivider(), new AbsoluteConstraints(180, 17, 900, 10));
        this.visaTypeHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.visaTypeHeading.setForeground(new Color(52, 73, 94));
        this.visaTypeHeading.setText(CommonUtilsUC.setMandatoryText("Type/Class"));
        visaPanel.add((Component)this.visaTypeHeading, new AbsoluteConstraints(24, 49, -1, 20));
        this.visaList.setActionCommand("Visa");
        this.visaList.setRenderer(new TipListCellRenderer(this.visaList));
        this.visaList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.visaList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.visaList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.visaList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        visaPanel.add(this.visaList, new AbsoluteConstraints(24, 75, 435, 40));
        this.visaList.setName("PofList");
        this.refresh = new JButton();
        this.refresh.setText("\ue627");
        this.refresh.setFont(new Font("Material Icons", 0, 25));
        this.refresh.setForeground(Color.decode("#34495E"));
        this.refresh.setHorizontalAlignment(0);
        this.refresh.setToolTipText("Sync the list");
        visaPanel.add((Component)this.refresh, new AbsoluteConstraints(465, 75, 40, 40));
        this.visaNumberHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.visaNumberHeading.setForeground(new Color(52, 73, 94));
        this.visaNumberHeading.setText(CommonUtilsUC.setMandatoryText("Document Number"));
        visaPanel.add((Component)this.visaNumberHeading, new AbsoluteConstraints(519, 49, 147, 20));
        this.visaNumberTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.visaNumberTextField.setPlaceholder("Document Number");
        this.visaNumberTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.visaNumberTextField.addActionListener(e -> visaPanel.requestFocusInWindow());
        visaPanel.add((Component)this.visaNumberTextField, new AbsoluteConstraints(519, 75, 480, 40));
        this.visaNumberTextField.setName("PofNo");
        this.issueDateHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.issueDateHeading.setForeground(new Color(52, 73, 94));
        this.issueDateHeading.setText(CommonUtilsUC.setMandatoryText("Issue Date (DD/MM/YYYY)"));
        visaPanel.add((Component)this.issueDateHeading, new AbsoluteConstraints(24, 125, 480, 20));
        this.issueDateField.setName("VisaIssue");
        this.issueDatePanel = this.prepare(this.issueDateField);
        this.issueDateField.addActionListener(e -> visaPanel.requestFocusInWindow());
        visaPanel.add((Component)this.issueDatePanel, new AbsoluteConstraints(24, 155, 480, 40));
        this.expiryDateHeading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.expiryDateHeading.setForeground(new Color(52, 73, 94));
        this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText("Expiry Date (DD/MM/YYYY)"));
        visaPanel.add((Component)this.expiryDateHeading, new AbsoluteConstraints(519, 125, 480, 20));
        this.expiryDateField.setName("VisaExpiry");
        this.expiryDatePanel = this.prepare(this.expiryDateField);
        this.expiryDateField.addActionListener(e -> visaPanel.requestFocusInWindow());
        visaPanel.add((Component)this.expiryDatePanel, new AbsoluteConstraints(519, 155, 480, 40));
        return visaPanel;
    }

    private JPanel prepare(PlaceholderTextField date) {
        JPanel jPanel1 = new JPanel();
        date.setPlaceholder("DD-MM-YYYY");
        date.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        date.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        date.setColumns(10);
        AbstractDocument document = (AbstractDocument)date.getDocument();
        document.setDocumentFilter(new DateDocument(date));
        jPanel1.setBackground(new Color(255, 255, 255));
        jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        jPanel1.add((Component)date, new AbsoluteConstraints(0, 0, 480, 40));
        return jPanel1;
    }

    public void setEnabled(boolean enable) {
        if (!enable) {
            this.visaNumberTextField.setText("");
            this.issueDateField.setText("");
            this.expiryDateField.setText("");
        }
        this.visaNumberTextField.setEnabled(enable);
        this.issueDateField.setEnabled(enable);
        this.expiryDateField.setEnabled(enable);
        this.visaList.setEnabled(enable);
    }

    protected void clearFields() {
        this.visaNumberTextField.setText("");
        this.issueDateField.setText("");
        this.expiryDateField.setText("");
    }

    public void setMandatory(boolean mandatory) {
        if (mandatory) {
            this.visaTypeHeading.setText(CommonUtilsUC.setMandatoryText("Type/Class"));
            this.visaNumberHeading.setText(CommonUtilsUC.setMandatoryText("Document Number"));
            this.issueDateHeading.setText(CommonUtilsUC.setMandatoryText("Issue Date (DD/MM/YYYY)"));
            this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText("Expiry Date (DD/MM/YYYY)"));
        } else {
            this.visaTypeHeading.setText("Type/Class");
            this.visaNumberHeading.setText("Document Number");
            this.issueDateHeading.setText("Issue Date (DD/MM/YYYY)");
            this.expiryDateHeading.setText("Expiry Date (DD/MM/YYYY)");
        }
    }

    public void setExpiryDateMandatory(boolean mandatory) {
        if (mandatory) {
            this.expiryDateHeading.setText(CommonUtilsUC.setMandatoryText("Expiry Date (DD/MM/YYYY)"));
        } else {
            this.expiryDateHeading.setText("Expiry Date (DD/MM/YYYY)");
        }
    }

    public void setExpiryDateEnabled(boolean enable) {
        if (!enable) {
            this.expiryDateField.setText("");
        }
        this.expiryDateField.setEnabled(enable);
    }
}

