/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.operator.NoticeBoardPanel;
import in.gov.uidai.ec.ui.enrol.references.ReferenceStagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.IdVerificationPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PobPanel;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

public class DocumentUploadPanel
implements IViewElementComposite {
    private IResourceBundleContext enrolRbctx;
    private PobPanel pobPanel;
    private IdVerificationPanel idVerificationPanel;
    private NoticeBoardPanel noticeBoard;

    public DocumentUploadPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create(EnrollmentService enrollmentService) {
        ShadowPanel mainPanel = new ShadowPanel();
        mainPanel.setReferenceStage(ReferenceStagesUC.DOCUMENT_UPLOAD);
        mainPanel.setLayout(new FlowLayout());
        JPanel documentsDropdownPanel = new JPanel();
        documentsDropdownPanel.setBackground(Color.WHITE);
        documentsDropdownPanel.setLayout(new BoxLayout(documentsDropdownPanel, 1));
        this.pobPanel = new PobPanel(this.enrolRbctx);
        documentsDropdownPanel.add(this.pobPanel.create());
        this.pobPanel.setEnable(enrollmentService.getIsPobRequired());
        this.idVerificationPanel = new IdVerificationPanel(this.enrolRbctx);
        documentsDropdownPanel.add(this.idVerificationPanel.create(enrollmentService));
        if (enrollmentService.getIsPobRequired()) {
            this.noticeBoard = new NoticeBoardPanel(enrollmentService.getDocManager().getBroadCastMessages(), "Recommended Documents");
            this.noticeBoard.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.noticeBoard.setMaximumSize(new Dimension(500, 300));
            JSplitPane splitPane = new JSplitPane(1, documentsDropdownPanel, this.noticeBoard);
            splitPane.setDividerSize(10);
            splitPane.setDividerLocation(0.2);
            splitPane.setResizeWeight(0.7);
            splitPane.setBorder(null);
            splitPane.setEnabled(false);
            mainPanel.add(splitPane);
        } else {
            mainPanel.add(documentsDropdownPanel);
        }
        return mainPanel;
    }

    public PobPanel getPobPanel() {
        return this.pobPanel;
    }

    public IdVerificationPanel getIdVerificationPanel() {
        return this.idVerificationPanel;
    }

    public NoticeBoardPanel getNoticeBoardPanel() {
        return this.noticeBoard;
    }
}

