/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.ui.enrol.references.ReferenceStagesUC;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.POXPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysRefTab;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DocumentVerifyPanel {
    private final IResourceBundleContext enrolRbctx;
    private Map<DocumentType, POXPanel> panelForDocumentType;

    public DocumentVerifyPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create() {
        this.panelForDocumentType = new TreeMap<DocumentType, POXPanel>();
        ShadowPanel mainPanel = new ShadowPanel();
        mainPanel.setReferenceStage(ReferenceStagesUC.DOCUMENT_VERIFY);
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        titleLabel.setForeground(Color.decode("#297FB8"));
        titleLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_SELECTED_DOCUMENTS.toString(), new Object[0]));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(25, 5, 0, 0));
        JPanel titlePanel = this.createTitlePanel(titleLabel);
        mainPanel.add(titlePanel);
        mainPanel.add(this.createHeadingPanel());
        DocumentType[] allDocumentTypesInReference = new DocumentType[]{DocumentType.POB, DocumentType.POI, DocumentType.POA, DocumentType.POF, DocumentType.POR};
        String[] headingTexts = new String[]{this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POB.toString(), new Object[0]), this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POI.toString(), new Object[0]), this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POA.toString(), new Object[0]), "Additional Document", this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_HOF_DOC.toString(), new Object[0])};
        for (int i = 0; i < allDocumentTypesInReference.length; ++i) {
            POXPanel poxPanel = new POXPanel(allDocumentTypesInReference[i]);
            this.panelForDocumentType.put(allDocumentTypesInReference[i], poxPanel);
            mainPanel.add(poxPanel.create(headingTexts[i]));
        }
        return mainPanel;
    }

    private JPanel createTitlePanel(JLabel titleLabel) {
        JPanel titleWrapper = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout((LayoutManager)new AbsoluteLayout());
        titlePanel.add((Component)titleLabel, new AbsoluteConstraints(0, 0, -1, -1));
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        titlePanel.add((Component)label, new AbsoluteConstraints(titleLabel.getPreferredSize().width + 10, 32, 1000 - titleLabel.getPreferredSize().width, -1));
        titleWrapper.add((Component)titlePanel, "West");
        return titleWrapper;
    }

    private JPanel createHeadingPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel emptyPanel = new JPanel();
        JLabel registryLabel = new JLabel("Registry Verified");
        JLabel ocrLabel = new JLabel("OCR Verified");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipady = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 90.0;
        gbc.insets = new Insets(1, 5, 1, 5);
        mainPanel.add((Component)emptyPanel, gbc);
        registryLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 10.0f));
        registryLabel.setForeground(Color.decode("#34495E"));
        registryLabel.setHorizontalAlignment(0);
        gbc.gridx = 1;
        gbc.weightx = 3.5;
        gbc.insets = new Insets(1, 5, 1, 5);
        mainPanel.add((Component)registryLabel, gbc);
        ocrLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 10.0f));
        ocrLabel.setForeground(Color.decode("#34495E"));
        ocrLabel.setHorizontalAlignment(0);
        gbc.gridx = 2;
        gbc.weightx = 4.5;
        gbc.insets = new Insets(1, 5, 1, 5);
        mainPanel.add((Component)ocrLabel, gbc);
        return mainPanel;
    }

    public Map<DocumentType, POXPanel> getPanelForDocumentType() {
        return this.panelForDocumentType;
    }
}

