/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PoaPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PofPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PoiPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.PorPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysRefTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class IdVerificationPanel
implements IViewElementComposite {
    private IResourceBundleContext enrolRbctx;
    private PoiPanel poiPanel;
    private PofPanel pofPanel;
    private PoaPanel poaPanel;
    private PorPanel porPanel;

    public IdVerificationPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create(EnrollmentService enrollmentService) {
        JPanel mainPanel = new JPanel();
        JLabel title = new JLabel();
        JLabel heading = new JLabel();
        mainPanel.setBackground(new Color(255, 255, 255));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        title.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        title.setForeground(Color.decode("#297FB8"));
        title.setText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_ID.toString(), new Object[0]));
        title.setBorder(BorderFactory.createEmptyBorder(25, 24, 0, 0));
        mainPanel.add(this.createTitlePanel(title));
        heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        heading.setForeground(Color.decode("#34495E"));
        heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_OPT_DOC.toString(), new Object[0]));
        heading.setBorder(BorderFactory.createEmptyBorder(15, 24, 0, 0));
        mainPanel.add(heading);
        boolean showTextFieldForPOI = enrollmentService.isForeignResident();
        this.poiPanel = new PoiPanel(this.enrolRbctx);
        mainPanel.add(this.poiPanel.create(showTextFieldForPOI));
        boolean showTextFieldForPOA = false;
        this.poaPanel = new PoaPanel(this.enrolRbctx);
        mainPanel.add(this.poaPanel.create(showTextFieldForPOA));
        this.pofPanel = new PofPanel(this.enrolRbctx);
        mainPanel.add(this.pofPanel.create());
        this.porPanel = new PorPanel(this.enrolRbctx);
        mainPanel.add(this.porPanel.create());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        this.getPoaPanel().setEnable(!enrollmentService.isHofEnrollment() && !enrollmentService.isUpdateUC());
        this.getPoiPanel().setEnable(!enrollmentService.isHofEnrollment() && !enrollmentService.isUpdateUC());
        return mainPanel;
    }

    private JPanel createTitlePanel(JLabel titleLabel) {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout((LayoutManager)new AbsoluteLayout());
        titlePanel.add((Component)titleLabel, new AbsoluteConstraints(0, 0, -1, -1));
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        titlePanel.add((Component)label, new AbsoluteConstraints(titleLabel.getPreferredSize().width + 10, 32, 1000 - titleLabel.getPreferredSize().width, -1));
        return titlePanel;
    }

    public PoiPanel getPoiPanel() {
        return this.poiPanel;
    }

    public PofPanel getPofPanel() {
        return this.pofPanel;
    }

    public PoaPanel getPoaPanel() {
        return this.poaPanel;
    }

    public PorPanel getPorPanel() {
        return this.porPanel;
    }
}

