/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class POXPanel {
    private DocumentType documentType;
    private JLabel heading;
    private PlaceholderTextField textField;
    private JButton verifyButton;
    private JLabel registryStatus;
    private JLabel ocrStatus;
    private JLabel metricsLabel;

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getVerifyButton() {
        return this.verifyButton;
    }

    public JLabel getRegistryStatus() {
        return this.registryStatus;
    }

    public JLabel getOcrStatus() {
        return this.ocrStatus;
    }

    public JLabel getMetricsLabel() {
        return this.metricsLabel;
    }

    POXPanel(DocumentType documentType) {
        this.documentType = documentType;
    }

    public JPanel create(String headingText) {
        this.initialiseComponents(headingText);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        mainPanel.setBackground(new Color(255, 255, 255));
        JPanel headingPanel = new JPanel(new FlowLayout(0));
        headingPanel.add(this.heading);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipady = 8;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 50.0;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPanel.add((Component)this.textField, gbc);
        gbc.gridx = 1;
        gbc.weightx = 15.0;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPanel.add((Component)this.verifyButton, gbc);
        this.registryStatus.setHorizontalAlignment(0);
        gbc.gridx = 2;
        gbc.weightx = 7.0;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPanel.add((Component)this.registryStatus, gbc);
        this.ocrStatus.setHorizontalAlignment(0);
        gbc.gridx = 3;
        gbc.weightx = 7.0;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPanel.add((Component)this.ocrStatus, gbc);
        this.metricsLabel.setHorizontalAlignment(0);
        gbc.gridx = 4;
        gbc.weightx = 35.0;
        gbc.insets = new Insets(20, 5, 20, 5);
        contentPanel.add((Component)this.metricsLabel, gbc);
        this.metricsLabel.setVisible(false);
        contentPanel.setPreferredSize(new Dimension(-1, 40));
        mainPanel.add(headingPanel);
        mainPanel.add(contentPanel);
        return mainPanel;
    }

    public void initialiseComponents(String headingText) {
        this.heading = new JLabel();
        this.textField = new PlaceholderTextField();
        this.verifyButton = new JButton();
        this.registryStatus = new JLabel();
        this.ocrStatus = new JLabel();
        this.metricsLabel = new JLabel();
        this.verifyButton.setEnabled(false);
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.heading.setText(headingText);
        this.textField.setPlaceholder("No Document Selected");
        this.textField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.textField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.textField.setEnabled(false);
        this.verifyButton.setText("Verify");
        this.registryStatus.setText("\ue86c");
        this.registryStatus.setFont(new Font("Material Icons", 0, 25));
        this.registryStatus.setForeground(Color.decode("#BEC3C7"));
        this.registryStatus.setHorizontalAlignment(0);
        this.registryStatus.setToolTipText("Status of the document");
        this.registryStatus.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.ocrStatus.setText("\ue86c");
        this.ocrStatus.setFont(new Font("Material Icons", 0, 25));
        this.ocrStatus.setForeground(Color.decode("#BEC3C7"));
        this.ocrStatus.setHorizontalAlignment(0);
        this.ocrStatus.setToolTipText("Status of the document");
        this.ocrStatus.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.metricsLabel.setText("Verification would speed up the process by x%");
        this.metricsLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }
}

