/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.swing.TipListCellRenderer;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysRefTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class PoiPanel
implements IViewElementComposite {
    private IResourceBundleContext enrolRbctx;
    public JButton attach;
    @ExportViewElement(as="PoiAttach", using=StandardSwingElementFactory.class)
    public JButton scan;
    public JButton digilocker;
    public JButton preview;
    public JLabel status;
    public PlaceholderTextField poiTextField;
    @ExportViewElement(as="PoiPanel", using=StandardSwingElementFactory.class)
    public JComboBox<ProofDocument> poiList;
    public JPanel mainPanel;
    JLabel heading;

    public PoiPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent create(boolean showTextField) {
        JPanel mainPanel = new JPanel();
        this.heading = new JLabel();
        this.poiTextField = new PlaceholderTextField();
        this.poiList = new JComboBox();
        this.attach = new JButton();
        this.scan = new JButton();
        this.digilocker = new JButton();
        this.preview = new JButton();
        this.status = new JLabel();
        this.attach.setEnabled(false);
        this.scan.setEnabled(false);
        this.digilocker.setEnabled(false);
        this.poiTextField.setEditable(false);
        this.preview.setEnabled(false);
        mainPanel.setBackground(new Color(255, 255, 255));
        mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POI.toString(), new Object[0]));
        mainPanel.add((Component)this.heading, new AbsoluteConstraints(24, 10, -1, -1));
        if (showTextField) {
            this.poiTextField.setPlaceholder("Select");
            this.poiTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
            this.poiTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
            mainPanel.add((Component)this.poiTextField, new AbsoluteConstraints(24, 35, 340, 40));
        } else {
            this.poiList.setRenderer(new TipListCellRenderer(this.poiList));
            this.poiList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
            this.poiList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
            this.poiList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
            this.poiList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
            this.poiList.setEnabled(false);
            mainPanel.add(this.poiList, new AbsoluteConstraints(24, 35, 340, 40));
        }
        this.attach.setText("\ue226");
        this.attach.setFont(new Font("Material Icons", 0, 25));
        this.attach.setForeground(Color.decode("#34495E"));
        this.attach.setHorizontalAlignment(0);
        this.attach.setToolTipText("Sync the list");
        this.scan.setText("\ue329");
        this.scan.setFont(new Font("Material Icons", 0, 25));
        this.scan.setForeground(Color.decode("#34495E"));
        this.scan.setHorizontalAlignment(0);
        this.scan.setToolTipText("Scan document");
        this.scan.setEnabled(false);
        this.status.setText("\ue86c");
        this.status.setFont(new Font("Material Icons", 0, 25));
        this.status.setForeground(Color.decode("#BEC3C7"));
        this.status.setHorizontalAlignment(0);
        this.status.setToolTipText("Status of the document");
        this.preview.setText("\uf1c5");
        this.preview.setFont(new Font("Material Icons", 0, 25));
        this.preview.setForeground(Color.decode("#34495E"));
        this.preview.setHorizontalAlignment(0);
        this.preview.setToolTipText("Document preview");
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), "res/ecmp/ucFont/digilockerIcon.png");
        this.digilocker.setIcon(icon);
        this.digilocker.setToolTipText("Fetch document from digilocker");
        mainPanel.add((Component)this.scan, new AbsoluteConstraints(374, 35, 40, 40));
        mainPanel.add((Component)this.digilocker, new AbsoluteConstraints(419, 35, 40, 40));
        this.status.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        mainPanel.add((Component)this.status, new AbsoluteConstraints(464, 35, 40, 40));
        mainPanel.add((Component)this.preview, new AbsoluteConstraints(509, 35, 40, 40));
        return mainPanel;
    }

    public void setEnable(boolean enable) {
        this.poiList.setEnabled(enable);
        this.scan.setEnabled(enable);
    }

    public void setMandatory(boolean mandatory) {
        if (mandatory) {
            this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POI.toString(), new Object[0])));
        } else {
            this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysRefTab.VERIFY_POI.toString(), new Object[0]));
        }
    }

    public boolean haveTextField() {
        return !Strings.isNullOrEmpty((String)this.poiTextField.getPlaceholder());
    }
}

