/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.ValuesDocumentModel;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.controllers.ReferenceControllerUC;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceControl
implements IOnScreenDisplayAware,
IEventContextAware {
    private IOnScreenDisplay osd;
    protected EnrollmentService enrollmentService;
    private IResourceBundleContext enrolRbCtxt;
    private IVisualExecutionContext veCtxt;
    private IOucDataStore oucDataStore;
    private ActionListener showPreviewListener;
    private IEventContext eventContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceControllerUC.class);
    private static final String DOC_VALIDATE_TIP = "Document validated";
    private static final String DOC_NOT_VALIDATE_TIP = "Document validation failed";
    private static final String DOC_UPLOAD_AGAIN = "Upload document again";

    public void setResourceBundleContext(IResourceBundleContext rbCtxt) {
        this.enrolRbCtxt = rbCtxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    @GenericEventHandler(value="open_digilocker")
    public void openDigilockerPanel(ActionEvent evt, DocumentType docType) {
        try {
            LOGGER.info("openDigilockerPanel triggered with docType: {}", (Object)docType);
            this.clearDocument(docType);
            DocumentsManager docMan = this.enrollmentService.getDocManager();
            docMan.setPreviewType(LabelKeysAction.UPLOAD.toString());
            docMan.setCurrentOperatingDocType(docType);
            this.enrollmentService.getDocManager().setPreviewSaveButtonListener(this::onDocScanPreviewSaveButtonForUpload);
            this.enrollmentService.setDocumentFetchType("digilocker");
            References references = this.enrollmentService.getReferences();
            ProofDocument proofDocument = references.getReferenceDoc(docType).getProof();
            DigilockerDocument digilockerDocument = (DigilockerDocument)references.getAllowedDocuments().getDigilockerList().get(proofDocument.getDocId());
            digilockerDocument.setDocumentName(proofDocument.getDocName());
            this.enrollmentService.setValuesDocumentModel(new ValuesDocumentModel(digilockerDocument));
        }
        catch (Exception e) {
            LOGGER.error("Error while initialising Digilocker panel", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_187.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_187.getReason(), (Component)((JComponent)evt.getSource()), ErrorCodes.UC_GEN_187.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[]{"You can reload the documents or try to manually scan the document."});
        }
        this.displayDigilocker(null);
    }

    @EventHandler(name="digilocker", method="actionPerformed")
    public void displayDigilocker(ILiteEvent evt) {
        this.osd.display(this.osd.compose("digilockerPopupWin", "digilockerViewPeer"), ScaffoldPlacement.CENTERED);
    }

    @GenericEventHandler(value="set_attach_or_scan")
    public void setAttachOrScan(ActionEvent evt, DocumentType documentType, String attachOrScan) {
        this.clearDocument(documentType);
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        docMan.setPreviewType(LabelKeysAction.UPLOAD.toString());
        docMan.setCurrentOperatingDocType(documentType);
        if (this.tryReuseExistingDocument(documentType, this.enrollmentService.getReferences().getReferenceDoc(documentType).getProof())) {
            return;
        }
        this.enrollmentService.getDocManager().setPreviewSaveButtonListener(this::onDocScanPreviewSaveButtonForUpload);
        this.veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
        if (attachOrScan.equals("attach_document")) {
            this.attachDocument(evt);
        } else {
            this.scanDocument(evt);
        }
    }

    @GenericEventHandler(value="attach_document")
    public void attachDocument(ActionEvent evt) {
        this.showPreviewListener = (ActionListener)this.eventContext.getEventListener("hID_ShowPreview", ActionListener.class);
        DocumentType docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
        this.clearDocument(docType);
        String docName = this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocName();
        JButton parent = (JButton)evt.getSource();
        this.setStatusIcon(docType);
        if ("Select".equalsIgnoreCase(docName)) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Document name selection is mandatory to attach the document", (Component)parent.getRootPane(), new Object[0]);
            return;
        }
        Utils.showProgressBar(this.veCtxt, "Attaching document, Please wait.");
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        docMan.setDocValidationOverride(false);
        docMan.setDocumentUploadSuccessFalse(docType);
        try {
            File file = DocumentUtils.getInstance().selectPdfFileFromBrowser(parent);
            if (file != null) {
                docMan.setDocumentBytes(file);
                String error = docMan.getAttachedDoc().getError();
                if (StringUtils.isNotBlank((String)error)) {
                    throw new Exception(error);
                }
            }
        }
        catch (Exception e) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)e.getMessage(), (Component)parent, new Object[0]);
            docMan.resetDocument();
            LOGGER.error("Failed to attach document. Exception:", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_122.getErrorCode(), new String[0]);
            return;
        }
        try {
            BufferedImage bufferedImage = this.enrollmentService.getDocManager().getAttachedDoc().getBufferedImage();
            this.enrollmentService.getDocManager().addNextDocument(bufferedImage, "BLACK");
        }
        catch (OutOfMemoryError e) {
            this.clearDocument(docType);
            LOGGER.error("System error - out of memory", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(new Exception("Out of memory"), ErrorCodes.UC_GEN_123.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Unable to display the document (System error - out of memory)", (Component)evt.getSource(), new Object[0]);
            return;
        }
        catch (Throwable e) {
            this.clearDocument(docType);
            Utils.cancelProgressBar(this.veCtxt);
            throw new RuntimeException("Failed to capture image", e);
        }
        Utils.cancelProgressBar(this.veCtxt);
        if (!this.populateRoi(docType)) {
            this.clearDocument(docType);
            return;
        }
        LOGGER.info("Starting Preview of Attached Document :");
        this.showPreviewListener.actionPerformed(evt);
    }

    @GenericEventHandler(value="scan_document")
    public void scanDocument(ActionEvent evt) {
        this.enrollmentService.getDocManager().setPreviewType(LabelKeysAction.UPLOAD.toString());
        DocumentType docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
        this.showPreviewListener = (ActionListener)this.eventContext.getEventListener("hID_ShowPreview", ActionListener.class);
        Utils.showProgressBar(this.veCtxt, "Scanning in progress, Please wait.");
        ThreadPool.commonPool().submit(() -> {
            try {
                this.handleDocumentScanning(evt, docType);
            }
            catch (OnlineGatewayException e) {
                this.handleScanningException((Exception)((Object)e), evt, docType);
            }
            catch (OutOfMemoryError e) {
                this.handleOutOfMemoryError(e, evt, docType);
            }
            catch (StationInfoStoreException | IOException e) {
                this.handleScannerInfoError((Exception)e, evt, docType);
            }
            finally {
                Utils.cancelProgressBar(this.veCtxt);
            }
        });
    }

    private void handleDocumentScanning(ActionEvent evt, DocumentType docType) throws OnlineGatewayException, StationInfoStoreException, IOException {
        this.clearDocument(docType);
        this.setStatusIcon(docType);
        if (!this.isScannerAndDocumentValid(evt, docType)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.enrollmentService.getDocManager().setCurrentOperatingDocType(docType);
        this.enrollmentService.getDocManager().setDocValidationOverride(false);
        this.enrollmentService.getDocManager().setDocumentUploadSuccessFalse(docType);
        BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(ScanMode.COLOR, null, this.enrollmentService);
        if (bufferedImage == null) {
            LOGGER.error(ErrorCodes.UC_GEN_008.getReason());
            throw OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_GEN_008, (String)this.enrollmentService.getTransactionId(), (Exception)new Exception(ErrorCodes.UC_GEN_008.getReason()));
        }
        long responseTime = System.currentTimeMillis() - startTime;
        TelemetryService.getTelemetryServiceInstance().postMetricsData("UC-ScanTime", TelemetryMetrics.SCAN_TIME, responseTime, new String[0]);
        this.enrollmentService.getDocManager().addNextDocument(bufferedImage, this.oucDataStore.getScannerInfo().getLastMode());
        if (!this.populateRoi(docType)) {
            return;
        }
        LOGGER.info("Starting Preview of Scan Document :");
        this.showPreviewListener.actionPerformed(evt);
    }

    private void handleScanningException(Exception e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        this.enrollmentService.getDocManager().resetDocument();
        L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_008.getReason(), (Component)((JButton)evt.getSource()), ErrorCodes.UC_GEN_008.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_008.getErrorCode(), new String[0]);
        LOGGER.error("Error while Scanning document.", (Throwable)e);
    }

    private void handleOutOfMemoryError(OutOfMemoryError e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        LOGGER.error("*********************Out of memory*************************");
        L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_006.getReason(), (Component)((JButton)evt.getSource()), ErrorCodes.UC_GEN_006.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_006.getReason()), ErrorCodes.UC_GEN_006.getErrorCode(), new String[0]);
    }

    private void handleScannerInfoError(Exception e, ActionEvent evt, DocumentType docType) {
        this.clearDocument(docType);
        LOGGER.error("Scanner is not found");
        L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_009.getReason(), (Component)((JButton)evt.getSource()), ErrorCodes.UC_GEN_009.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(ErrorCodes.UC_GEN_009.getReason()), ErrorCodes.UC_GEN_009.getErrorCode(), new String[0]);
    }

    private void clearDocument(DocumentType docType) {
        if (this.enrollmentService.getDocManager().getDocumentBytes(docType) != null) {
            this.enrollmentService.getDocManager().resetDocument(docType);
        }
        if (this.enrollmentService.getXmlData() != null) {
            this.enrollmentService.getXmlData().remove(docType);
        }
        System.gc();
    }

    private boolean isScannerAndDocumentValid(ActionEvent evt, DocumentType docType) throws StationInfoStoreException, IOException {
        String docName = this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocName();
        ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
        String scanner = scannerInfo.getLastScanner();
        if (StringUtils.isBlank((String)scanner) || "select".equalsIgnoreCase(scanner) || "select".equalsIgnoreCase(docName)) {
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Scanner and Document name selection is mandatory to scan the document", (Component)((JButton)evt.getSource()), new Object[0]);
            Utils.cancelProgressBar(this.veCtxt);
            return false;
        }
        return true;
    }

    private boolean populateRoi(DocumentType docType) {
        TransparentBox axnPanel = new TransparentBox((LayoutManager)new FlowLayout(0, 0, 2));
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getProof(docType);
        if (referenceDoc != null) {
            Document proofDetails = this.enrollmentService.getOnlineDocumentService().getDocument(docType, referenceDoc.getProof().getDocName());
            try {
                this.enrollmentService.fetchRegionsOfInterest(proofDetails.getDocType(), proofDetails.getDocumentId());
                return true;
            }
            catch (OnlineGatewayException e) {
                this.clearDocument(docType);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
                L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)axnPanel, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        }
        return false;
    }

    public void populateEventContext(IEventContext eventContext) {
        this.eventContext = eventContext;
    }

    private void setStatusIcon(DocumentType docType) {
        boolean icon;
        boolean bl = icon = this.enrollmentService.getDocManager().isDocumentCompressAndSaved(docType) && this.enrollmentService.getDocManager().isDocumentUploaded(docType) && this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null;
        String tooltip = this.enrollmentService.getDocManager().isDocumentCompressAndSaved(docType) ? (this.enrollmentService.getDocManager().isDocumentUploaded(docType) ? (this.enrollmentService.getDocManager().getDvsResultMap().get(docType.value()) == null ? DOC_VALIDATE_TIP : DOC_NOT_VALIDATE_TIP) : DOC_UPLOAD_AGAIN) : DOC_UPLOAD_AGAIN;
        boolean isDvsFail = this.enrollmentService.getDocManager().getDvsResultMap().values().stream().anyMatch(error -> error.contains("Technical Error"));
        tooltip = isDvsFail ? DOC_UPLOAD_AGAIN : tooltip;
    }

    public void onDocScanPreviewSaveButtonForUpload(ActionEvent actionEvent) {
        DocumentType docType;
        this.veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
        if (this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage("Saving the document. Please wait.");
        }
        if ((docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify()) == DocumentType.SIGNED_ACK_SLIP || docType == DocumentType.ENROL_FORM) {
            SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).setVisible(false);
        }
        ThreadPool.commonPool().submit(() -> {
            this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().finalizeDocument();
            try {
                this.enrollmentService.getDocManager().saveToJp2000();
                this.enrollmentService.getDocManager().setDocumentCompressAndSaved(docType);
                if (docType == DocumentType.SIGNED_ACK_SLIP || docType == DocumentType.ENROL_FORM) {
                    this.enrollmentService.fireDocUploadSuccess();
                }
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
                this.enrollmentService.getDocManager().validateDocs(docType);
            }
            catch (Exception e) {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
                LOGGER.error("Error while converting image to jp2000 format ", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)("Error while saving the document. " + e.getMessage()), (Component)((JButton)actionEvent.getSource()).getRootPane(), new Object[0]);
            }
            finally {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
                SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).dispose();
            }
        });
    }

    public boolean tryReuseExistingDocument(DocumentType docType, ProofDocument selectedProof) {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        for (DocumentType sourceDocType : new DocumentType[]{DocumentType.POB, DocumentType.POI, DocumentType.POA, DocumentType.POF, DocumentType.POR}) {
            ReferenceDocument sourceRefDoc;
            if (sourceDocType == docType || (sourceRefDoc = this.enrollmentService.getReferences().getReferenceDoc(sourceDocType)).getProof() == null || !sourceRefDoc.getProof().getDocId().equals(selectedProof.getDocId()) || !docManager.isDocumentCompressAndSaved(sourceDocType)) continue;
            LOGGER.info("Found existing document {} to reuse for {}", (Object)sourceRefDoc.getProof().getDocName(), (Object)docType);
            if (!this.populateRoi(docType)) {
                LOGGER.info("Not able to get ROIs for {} ({})", (Object)sourceRefDoc.getProof().getDocName(), (Object)docType);
                this.clearDocument(docType);
                return false;
            }
            docManager.copyFromUC(sourceDocType);
            this.enrollmentService.getReferences().getReferenceDoc(docType).setDocumentAttached();
            return true;
        }
        return false;
    }
}

