/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.reference;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.ReferenceSections;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.DocumentUploadPanel;
import in.gov.uidai.ec.ui.enrol.universalClient.reference.DocumentVerifyPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class ReferencePanel
implements IViewElementComposite {
    protected ReferenceSections referenceSections;
    protected IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="hID_Reference_TabPane", using=StandardSwingElementFactory.class)
    protected JTabbedPane tabbedPane;
    protected EnrollmentService enrollmentService;
    protected DocumentUploadPanel documentUploadPanel;
    protected DocumentVerifyPanel documentVerifyPanel;

    public ReferencePanel(IResourceBundleContext enrolRbctx, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        JPanel referencePanel = new JPanel();
        this.referenceSections = new ReferenceSections(this.enrolRbctx, this.enrollmentService);
        this.tabbedPane = new JTabbedPane();
        this.initialiseTab();
        this.documentUploadPanel = new DocumentUploadPanel(this.enrolRbctx);
        this.documentVerifyPanel = new DocumentVerifyPanel(this.enrolRbctx);
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.DOCUMENT_UPLOAD_TAB, new Object[0]), this.documentUploadPanel.create(this.enrollmentService));
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.DOCUMENT_VERIFY_TAB, new Object[0]), this.documentVerifyPanel.create());
        referencePanel.setBackground(Color.white);
        referencePanel.setLayout(new BorderLayout(0, 0));
        referencePanel.add((Component)this.referenceSections.create(), "North");
        referencePanel.add((Component)this.tabbedPane, "South");
        this.tabbedPane.addChangeListener(e -> this.adjustTabHeight());
        this.adjustTabHeight();
        return referencePanel;
    }

    private void adjustTabHeight() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1) {
            Component tab = this.tabbedPane.getComponentAt(index);
            int maxHeight = tab.getPreferredSize().height;
            this.tabbedPane.setPreferredSize(new Dimension(this.tabbedPane.getPreferredSize().width, maxHeight + 25));
            this.tabbedPane.revalidate();
        }
    }

    private void initialiseTab() {
        this.tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 0;
            }

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                return 0;
            }
        });
        this.tabbedPane.setForeground(Color.white);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ReferenceSections getReferenceSections() {
        return this.referenceSections;
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public String getTab() {
        return this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
    }

    public DocumentUploadPanel getDocumentUploadPanel() {
        return this.documentUploadPanel;
    }

    public DocumentVerifyPanel getDocumentVerifyPanel() {
        return this.documentVerifyPanel;
    }
}

