/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.residentInfo;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ContactInfoPanel
implements IViewElementComposite {
    @ExportViewElement(as="isdCode", using=StandardSwingElementFactory.class)
    public JComboBox<ISD> comboCode;
    public PlaceholderTextField emailField;
    public PlaceholderTextField mobNo;
    public JLabel mobLabel;
    public JLabel emailLabel;
    public JLabel isdLabel;
    protected IResourceBundleContext rbCtxt;
    private EnrollmentService enrollmentService;

    public ContactInfoPanel(IResourceBundleContext rbCtxt, EnrollmentService enrollmentService) {
        this.rbCtxt = rbCtxt;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        this.initialise();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        mainPanel.add((Component)this.createTitlePanel(), gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.25;
        gbc.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.isdLabel, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.6;
        gbc.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.mobLabel, gbc);
        gbc.gridy = 1;
        gbc.gridx = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 0.4;
        mainPanel.add((Component)this.emailLabel, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.25;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add(this.comboCode, gbc);
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add((Component)this.mobNo, gbc);
        gbc.gridy = 2;
        gbc.gridx = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 0.75;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add((Component)this.emailField, gbc);
        gbc.gridy = 3;
        gbc.gridx = 0;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 10, 0, 0);
        mainPanel.add((Component)new JLabel("<html><p><i>An OTP will be sent to the above phone number as well as email id. Enter the email OTP in the email OTP field and mobile OTP in the mobile OTP field in the demographic screen.</i></p></html>"), gbc);
        return mainPanel;
    }

    private void initialise() {
        this.mobNo = new PlaceholderTextField();
        this.emailField = new PlaceholderTextField();
        this.comboCode = new JComboBox();
        this.mobLabel = new JLabel("Mobile Number");
        this.emailLabel = new JLabel("Email ID");
        this.isdLabel = new JLabel("ISD");
        this.mobLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.mobLabel.setForeground(Color.decode("#34495E"));
        this.mobNo.setName("mobile");
        this.isdLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.isdLabel.setForeground(Color.decode("#34495E"));
        this.emailLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.emailLabel.setForeground(Color.decode("#34495E"));
        this.emailField.setName("email");
        this.mobNo.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.mobNo.setPlaceholder("Enter Mobile Number");
        this.mobNo.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.mobNo.setPreferredSize(new Dimension(-1, 40));
        this.emailField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.emailField.setPlaceholder("Enter Email Id");
        this.emailField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.emailField.setPreferredSize(new Dimension(-1, 40));
        this.comboCode.setPreferredSize(new Dimension(-1, 40));
        this.comboCode.setName("isdCode");
        this.getMobileCodes();
        InlineValidations ilv = new InlineValidations(this.rbCtxt);
        new AutoSuggestDecorator((JTextField)this.emailField).name("email").delimiters("@");
        ilv.applyEmailILV(this.emailField);
        this.emailField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.emailField));
        ilv.applyMobileILV(this.mobNo, this.comboCode);
        this.mobNo.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.mobNo));
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        titleLabel.setForeground(Color.decode("#297FB8"));
        titleLabel.setText("Resident Contact Info");
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(titleLabel);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }

    private void getMobileCodes() {
        this.enrollmentService.getIsdService().getISDCodes().stream().filter(item -> item.getISDCode().contains("+91")).forEach(this.comboCode::addItem);
    }

    public void setEmailMandatory(boolean mandatory) {
        if (mandatory) {
            this.emailLabel.setText(CommonUtilsUC.setMandatoryText("Email ID"));
        } else {
            this.emailLabel.setText("Email ID");
        }
    }

    public void setEnable(boolean enable) {
        this.comboCode.setEnabled(enable);
        this.mobNo.setEnabled(enable);
        this.emailField.setEnabled(enable);
    }
}

