/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.residentInfo;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.RadioButtonCustom;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class EnrollmentTypePanel
implements IViewElementComposite {
    public RadioButtonCustom document;
    public RadioButtonCustom hof;
    @ExportViewElement(as="HofUid", using=StandardSwingElementFactory.class)
    public PlaceholderTextField hofUid;
    @ExportViewElement(as="HofRel", using=StandardSwingElementFactory.class)
    public JComboBox<RelationshipType> relationType;
    private ButtonGroup bttnGrp;
    protected IResourceBundleContext rbCtxt;

    public EnrollmentTypePanel(IResourceBundleContext rbCtxt) {
        this.rbCtxt = rbCtxt;
    }

    public JComponent create() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        this.initialise();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        GridBagConstraints gbcColumn1 = new GridBagConstraints();
        gbcColumn1.fill = 2;
        gbcColumn1.gridx = 0;
        gbcColumn1.gridwidth = 1;
        gbcColumn1.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gbcColumn2 = new GridBagConstraints();
        gbcColumn2.fill = 2;
        gbcColumn2.gridx = 1;
        gbcColumn2.gridwidth = 1;
        gbcColumn2.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gbcColumn3 = new GridBagConstraints();
        gbcColumn3.fill = 2;
        gbcColumn3.gridx = 2;
        gbcColumn3.gridwidth = 1;
        gbcColumn3.weightx = 0.5;
        gbcColumn3.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gbcColumn4 = new GridBagConstraints();
        gbcColumn4.fill = 2;
        gbcColumn4.gridx = 3;
        gbcColumn4.gridwidth = 1;
        gbcColumn4.weightx = 0.5;
        gbcColumn4.insets = new Insets(0, 10, 0, 10);
        gbc.gridy = 0;
        mainPanel.add((Component)this.createTitlePanel(), gbc);
        gbcColumn4.gridy = 1;
        gbcColumn3.gridy = 1;
        gbcColumn2.gridy = 1;
        gbcColumn1.gridy = 1;
        mainPanel.add((Component)this.document, gbcColumn1);
        mainPanel.add((Component)this.hof, gbcColumn2);
        mainPanel.add(this.relationType, gbcColumn3);
        mainPanel.add((Component)this.hofUid, gbcColumn4);
        return mainPanel;
    }

    private void initialise() {
        this.document = new RadioButtonCustom();
        this.hof = new RadioButtonCustom();
        this.hofUid = new PlaceholderTextField();
        this.bttnGrp = new ButtonGroup();
        this.bttnGrp.add(this.hof);
        this.bttnGrp.add(this.document);
        this.document.setBackground(Color.decode("#297FB8"));
        this.document.setForeground(Color.decode("#34495E"));
        this.document.setText("Document Based Enrollment");
        this.document.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.document.setSelected(true);
        this.document.setEnabled(false);
        this.hof.setBackground(Color.decode("#297FB8"));
        this.hof.setForeground(Color.decode("#34495E"));
        this.hof.setText("Head of Family Based Enrollment");
        this.hof.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.hof.setEnabled(false);
        this.hofUid.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.hofUid.setPlaceholder("Enter Head of Family UID");
        this.hofUid.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.hofUid.setPreferredSize(new Dimension(-1, 40));
        this.hofUid.setEnabled(false);
        this.hofUid.setName("HofUid");
        this.relationType = new JComboBox<RelationshipType>(new RelationshipType[]{RelationshipType.NOT_GIVEN, RelationshipType.FATHER, RelationshipType.MOTHER, RelationshipType.LEGAL_GUARDIAN});
        this.relationType.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.relationType.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.relationType.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.relationType.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.relationType.setPreferredSize(new Dimension(-1, 40));
        this.relationType.setEnabled(false);
        this.relationType.setName("HofRel");
        InlineValidations ilv = new InlineValidations(this.rbCtxt);
        ilv.applyAadhaarNumberILV(this.hofUid);
    }

    public void setEnable(boolean enable) {
        this.document.setEnabled(enable);
        this.hof.setEnabled(enable);
    }

    public void setDisable(boolean enable) {
        this.document.setEnabled(enable);
        this.hof.setEnabled(enable);
        this.hofUid.setEnabled(enable);
        RelationshipType selectedRelation = (RelationshipType)this.relationType.getSelectedItem();
        this.relationType.removeAllItems();
        this.relationType.addItem(selectedRelation);
        this.relationType.setSelectedItem(selectedRelation);
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        titleLabel.setForeground(Color.decode("#297FB8"));
        titleLabel.setText("Enrollment Type");
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(titleLabel);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }

    public void enableButtonGroupWithDefault(RadioButtonCustom button, boolean enable) {
        button.setSelected(true);
        Enumeration<AbstractButton> buttonGroupEnumeration = this.bttnGrp.getElements();
        while (buttonGroupEnumeration.hasMoreElements()) {
            buttonGroupEnumeration.nextElement().setEnabled(enable);
        }
    }

    public void enableHofFields(boolean enable) {
        this.hofUid.setText("");
        this.hofUid.setEnabled(enable);
        this.relationType.setEnabled(enable);
    }
}

