/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.residentUpdateInfo;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class UidUpdatePanel {
    @ExportViewElement(as="resUid", using=StandardSwingElementFactory.class)
    public PlaceholderTextField uidField;
    @ExportViewElement(as="hofUid", using=StandardSwingElementFactory.class)
    public PlaceholderTextField hofUidField;
    @ExportViewElement(as="hof_relation_dropdown", using=StandardSwingElementFactory.class)
    public JComboBox<RelationshipType> hofRelationDropdown;
    public JLabel uidLabel;
    public JLabel hofUidLabel;
    public JLabel hofRelationLabel;
    private EnrollmentService enrollmentService;
    private IResourceBundleContext rbCtxt;

    public UidUpdatePanel(IResourceBundleContext rbCtxt, EnrollmentService enrollmentService) {
        this.rbCtxt = rbCtxt;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        this.initialise();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        mainPanel.add((Component)this.createTitlePanel(), gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.uidLabel, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.2;
        gbc.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.hofRelationLabel, gbc);
        gbc.gridy = 1;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(5, 10, 0, 10);
        mainPanel.add((Component)this.hofUidLabel, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add((Component)this.uidField, gbc);
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.2;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add(this.hofRelationDropdown, gbc);
        gbc.gridy = 2;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(2, 10, 0, 10);
        mainPanel.add((Component)this.hofUidField, gbc);
        return mainPanel;
    }

    private void initialise() {
        InlineValidations ilv = new InlineValidations(this.rbCtxt);
        this.uidField = new PlaceholderTextField();
        this.hofUidField = new PlaceholderTextField();
        this.hofRelationDropdown = new JComboBox();
        this.uidLabel = new JLabel("UID");
        this.hofUidLabel = new JLabel("HoF UID");
        this.hofRelationLabel = new JLabel("HoF Relation");
        this.uidLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.uidLabel.setForeground(Color.decode("#34495E"));
        this.hofUidLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.hofUidLabel.setForeground(Color.decode("#34495E"));
        this.hofRelationLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.hofRelationLabel.setForeground(Color.decode("#34495E"));
        this.uidField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.uidField.setPlaceholder("Enter Uid");
        this.uidField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.uidField.setPreferredSize(new Dimension(-1, 40));
        ilv.applyAadhaarNumberILV(this.uidField);
        this.hofUidField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.hofUidField.setPlaceholder("Enter Hof Uid");
        this.hofUidField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.hofUidField.setPreferredSize(new Dimension(-1, 40));
        this.hofUidField.setEnabled(false);
        ilv.applyAadhaarNumberILV(this.hofUidField);
        this.hofRelationDropdown = new JComboBox<RelationshipType>(new RelationshipType[]{RelationshipType.NOT_GIVEN, RelationshipType.FATHER, RelationshipType.MOTHER, RelationshipType.LEGAL_GUARDIAN});
        this.hofRelationDropdown.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.hofRelationDropdown.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.hofRelationDropdown.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.hofRelationDropdown.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.hofRelationDropdown.setPreferredSize(new Dimension(-1, 40));
        this.hofRelationDropdown.setEnabled(true);
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        titleLabel.setForeground(Color.decode("#297FB8"));
        titleLabel.setText("Resident Uid Info");
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(titleLabel);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }
}

