/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.review;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.ShadowPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.StringWriter;
import java.io.Writer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class NewReviewPanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    private JFXPanel jfxPanel;
    private ShadowPanel mainPanel;
    private StringWriter writer;
    private VelocityContext context;
    private Template template;

    public NewReviewPanel(IResourceBundleContext enrolRbctx, EnrollmentService enrollmentService, JFXPanel jfxPanel) {
        this.enrolRbctx = enrolRbctx;
        this.jfxPanel = jfxPanel;
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
        this.context = new VelocityContext();
        this.writer = new StringWriter();
        this.template = enrollmentService.isNewEnrollmentUC() ? (enrollmentService.isForeignResident() ? ve.getTemplate("/res/foreign_review_panel_table.html") : (enrollmentService.isHofEnrollment() ? (enrollmentService.doesNriHaveForeignAddress() ? ve.getTemplate("/res/nri_foreign_address_hof_review_panel_table.html") : ve.getTemplate("/res/hof_review_panel_table.html")) : (enrollmentService.isNRIEnrolment() ? (enrollmentService.doesNriHaveForeignAddress() ? ve.getTemplate("/res/nri_foreign_address_review_panel_table.html") : ve.getTemplate("/res/local_review_panel_table.html")) : ve.getTemplate("/res/local_review_panel_table.html")))) : ve.getTemplate("/res/update_review_panel.html");
    }

    public JComponent create() {
        String[] listOfValues;
        this.mainPanel = new ShadowPanel();
        SwingUtilities.invokeLater(() -> {
            this.mainPanel.setBackground(java.awt.Color.WHITE);
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.jfxPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(1026, 660));
        });
        this.updateHtmlAt("APPOINTMENT_ID_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.APPOINTMENT.toString(), new Object[0]));
        this.updateHtmlAt("RESIDENT_TYPE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.RESIDENT_TYPE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_RESIDENT_TYPE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.resident.type").getText());
        this.updateHtmlAt("NAME_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NAME.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_NAME_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.name").getText());
        this.updateHtmlAt("GENDER_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.GENDER.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_GENDER_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.gender").getText());
        this.updateHtmlAt("AGE_DOB_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADD_AGEDOB.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_AGE_DOB_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.agedob").getText());
        this.updateHtmlAt("BRN_STATE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_STATE.toString(), new Object[0]));
        this.updateHtmlAt("BRN_NUMBER_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_NUMBER.toString(), new Object[0]));
        this.updateHtmlAt("FATHER_NAME_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.FATHER_NAME.toString(), new Object[0]));
        this.updateHtmlAt("FATHER_UID_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.FATHER_UID.toString(), new Object[0]));
        this.updateHtmlAt("MOTHER_NAME_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOTHER_NAME.toString(), new Object[0]));
        this.updateHtmlAt("MOTHER_UID_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.MOTHER_UID.toString(), new Object[0]));
        this.updateHtmlAt("GUARDIAN_NAME_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.GUARDIAN_NAME.toString(), new Object[0]));
        this.updateHtmlAt("GUARDIAN_UID_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.GUARDIAN_UID.toString(), new Object[0]));
        this.updateHtmlAt("CARE_OF_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CO.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_CARE_OF_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.careof").getText());
        this.updateHtmlAt("STREET_ROAD_LANE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.STREET.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_STREET_ROAD_LANE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.street").getText());
        this.updateHtmlAt("VILLAGE_TOWN_CITY_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.VILLAGE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_VILLAGE_TOWN_CITY_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.vtc").getText());
        this.updateHtmlAt("POSTOFFICE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.POSTOFFICE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_POSTOFFICE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.po").getText());
        this.updateHtmlAt("HOUSE_BUILDING_APARTMENT_NUMBER_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.HOUSE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_HOUSE_BUILDING_APARTMENT_NUMBER_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.house").getText());
        this.updateHtmlAt("LOCALITY_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.LOCALITY.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_LOCALITY_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.locality").getText());
        this.updateHtmlAt("DISTRICT_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DISTRICT.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_DISTRICT_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.district").getText());
        this.updateHtmlAt("STATE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.STATE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_STATE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.state").getText());
        this.updateHtmlAt("PINCODE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.PINCODE.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_PINCODE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.pincode").getText());
        this.updateHtmlAt("LANDMARK_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.LANDMARK.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_LANDMARK_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.landmark").getText());
        this.updateHtmlAt("ADDRESS_ONE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADDRESS_ONE.toString(), new Object[0]));
        this.updateHtmlAt("ADDRESS_TWO_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADDRESS_TWO.toString(), new Object[0]));
        this.updateHtmlAt("ADDRESS_THREE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADDRESS_THREE.toString(), new Object[0]));
        this.updateHtmlAt("ZIPCODE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ZIPCODE.toString(), new Object[0]));
        this.updateHtmlAt("COUNTRY_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.COUNTRY.toString(), new Object[0]));
        this.updateHtmlAt("LOCAL_ADDRESS_ONE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.address").getText() + " 1");
        this.updateHtmlAt("LOCAL_ADDRESS_TWO_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.address").getText() + " 2");
        this.updateHtmlAt("LOCAL_ADDRESS_THREE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.address").getText() + " 3");
        this.updateHtmlAt("LOCAL_ZIPCODE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.zipcode").getText());
        this.updateHtmlAt("LOCAL_COUNTRY_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:addr.country").getText());
        this.updateHtmlAt("PROOF_OF_BIRTH_KEY", "Birth Proof");
        this.updateHtmlAt("PROOF_OF_IDENTITY_KEY", "Identity Proof");
        this.updateHtmlAt("ADDITIONAL_DOCUMENT_KEY", "Additional Document");
        this.updateHtmlAt("PROOF_OF_ADDRESS_KEY", "Address Proof");
        this.updateHtmlAt("PROOF_OF_RELATION_KEY", "Relation Proof");
        this.updateHtmlAt("UPDATE_TYPE_KEY", "Type of Update");
        this.updateHtmlAt("AADHAAR_NUMBER_KEY", "Aadhaar Number");
        this.updateHtmlAt("UPDATED_NAME_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.NAME_NEW.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_NAME_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.name.new").getText());
        this.updateHtmlAt("UPDATED_AGE_DOB_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_DOB.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_AGE_DOB_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.updated.dob").getText());
        this.updateHtmlAt("UPDATED_ADDRESS_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_ADDRESS.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_ADDRESS_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.updated.address").getText());
        this.updateHtmlAt("UPDATED_GENDER_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_GENDER.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_GENDER_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.updated.gender").getText());
        this.updateHtmlAt("UPDATED_MOBILE_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_MOBILE.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_MOBILE_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.updated.mobile").getText());
        this.updateHtmlAt("UPDATED_EMAIL_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_EMAIL.toString(), new Object[0]));
        this.updateHtmlAt("UPDATED_LOCAL_EMAIL_KEY", new LocaleLabel(this.enrolRbctx, "label-tlit:demotab.updated.email").getText());
        this.updateHtmlAt("UPDATED_BIOMETRICS_KEY", this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.UPDATED_BIOMETRICS.toString(), new Object[0]));
        for (String value : listOfValues = new String[]{"APPOINTMENT_LABEL_VALUE", "RESIDENT_TYPE_VALUE", "LOCAL_RESIDENT_TYPE_VALUE", "NAME_VALUE", "LOCAL_NAME_VALUE", "GENDER_VALUE", "LOCAL_GENDER_VALUE", "AGE_DOB_VALUE", "LOCAL_AGE_DOB_VALUE", "BRN_STATE_VALUE", "BRN_NUMBER_VALUE", "FATHER_NAME_VALUE", "FATHER_UID_VALUE", "MOTHER_NAME_VALUE", "MOTHER_UID_VALUE", "GUARDIAN_NAME_VALUE", "GUARDIAN_UID_VALUE", "CARE_OF_VALUE", "LOCAL_CARE_OF_VALUE", "STREET_ROAD_LANE_VALUE", "LOCAL_STREET_ROAD_LANE_VALUE", "VILLAGE_TOWN_CITY_VALUE", "LOCAL_VILLAGE_TOWN_CITY_VALUE", "POSTOFFICE_VALUE", "LOCAL_POSTOFFICE_VALUE", "HOUSE_BUILDING_APARTMENT_NUMBER_VALUE", "LOCAL_HOUSE_BUILDING_APARTMENT_NUMBER_VALUE", "LOCALITY_VALUE", "LOCAL_LOCALITY_VALUE", "DISTRICT_VALUE", "LOCAL_DISTRICT_VALUE", "STATE_VALUE", "LOCAL_STATE_VALUE", "PINCODE_VALUE", "LOCAL_PINCODE_VALUE", "LANDMARK_VALUE", "LOCAL_LANDMARK_VALUE", "POB_DOCUMENT_VALUE", "POI_DOCUMENT_VALUE", "POF_DOCUMENT_VALUE", "POA_DOCUMENT_VALUE", "POR_DOCUMENT_VALUE", "ADDRESS_ONE_VALUE", "ADDRESS_TWO_VALUE", "ADDRESS_THREE_VALUE"}) {
            this.updateHtmlAt(value, "<i style=\"color: grey;\">Not Given</i>");
        }
        return this.mainPanel;
    }

    public void updateHtmlAt(String replace, Object put) {
        this.context.put(replace, put);
        this.writer.getBuffer().setLength(0);
        this.template.merge((Context)this.context, (Writer)this.writer);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            WebView webView = new WebView();
            Scene scene = new Scene((Parent)webView, (Paint)Color.ALICEBLUE);
            webView.getEngine().loadContent(this.writer.toString());
            this.jfxPanel.setScene(scene);
        });
    }
}

